<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investment_withdraws', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['Investor', 'Company'])->default('Company'); // kis type ka withdrawal hai
            $table->bigInteger('investor_id')->nullable(); // sirf investor ke liye
            $table->decimal('amount', 12, 2);
            $table->enum('payment_type', ['Cash', 'Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();
            $table->date('date');
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investment_withdraws');
    }
};
