<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->string('payment_type')->nullable(); // Cash or Bank
            $table->bigInteger('bank_id')->nullable(); 
            $table->decimal('amount', 15, 2)->default('0.00');
            $table->enum('transaction_type', ['deposit', 'withdraw']); // Add or Minus
            $table->string('source_type')->nullable();  // Sale, Purchase, Investment, Expense, etc.
            $table->bigInteger('source_id')->nullable(); // Sale ID, Purchase ID, etc.
            $table->string('description')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
