<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add Employee Ledger permissions
        $permissions = [
            ['group_name' => 'Employee Ledger', 'name' => 'view_employee_ledger', 'guard_name' => 'web'],
        ];

        foreach ($permissions as $permission) {
            // Check if permission already exists
            $exists = Permission::where('name', $permission['name'])->where('guard_name', $permission['guard_name'])->exists();
            
            if (!$exists) {
                Permission::create($permission);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove Employee Ledger permissions
        Permission::where('group_name', 'Employee Ledger')->delete();
    }
};
