<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expense_sub_categories', function (Blueprint $table) {
            $table->unsignedBigInteger('exp_cat_id')->nullable()->after('id');
            $table->foreign('exp_cat_id')->references('id')->on('expense_categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expense_sub_categories', function (Blueprint $table) {
            $table->dropForeign(['exp_cat_id']);
            $table->dropColumn('exp_cat_id');
        });
    }
};
