<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_bookers', function (Blueprint $table) {
            // Drop the old status column
            $table->dropColumn('status');
        });

        Schema::table('order_bookers', function (Blueprint $table) {
            // Add the new status column with updated values
            $table->enum('status', ['Pending', 'In Progress', 'Complete'])->default('Pending')->after('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_bookers', function (Blueprint $table) {
            // Drop the new status column
            $table->dropColumn('status');
        });

        Schema::table('order_bookers', function (Blueprint $table) {
            // Restore the old status column
            $table->enum('status', ['pending', 'approved', 'cancelled'])->default('pending')->after('is_active');
        });
    }
};
