<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * CRITICAL FIX: Update transaction_type from 'Sale Return' to 'Sale_return'
     * to match the ENUM definition in customer_ledgers table
     */
    public function up(): void
    {
        // Fix customer_ledgers table - update any existing 'Sale Return' records
        DB::statement("
            UPDATE customer_ledgers
            SET transaction_type = 'Sale_return'
            WHERE transaction_type LIKE '%Sale%Return%'
            OR transaction_type = 'Sale Return'
            OR adjustment = 'Sale Return'
        ");

        // Also update salesman_ledgers if it exists and has similar issue
        if (Schema::hasTable('salesman_ledgers')) {
            DB::statement("
                UPDATE salesman_ledgers
                SET transaction_type = 'Sale_return'
                WHERE transaction_type LIKE '%Sale%Return%'
                OR transaction_type = 'Sale Return'
                OR adjustment = 'Sale Return'
            ");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to 'Sale Return' if needed
        DB::statement("
            UPDATE customer_ledgers
            SET transaction_type = 'Sale Return'
            WHERE transaction_type = 'Sale_return'
        ");

        if (Schema::hasTable('salesman_ledgers')) {
            DB::statement("
                UPDATE salesman_ledgers
                SET transaction_type = 'Sale Return'
                WHERE transaction_type = 'Sale_return'
            ");
        }
    }
};
