<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     * This migration fixes existing customer_ledger entries for sale returns
     * where debit was incorrectly set to grand_total instead of paid amount.
     */
    public function up(): void
    {
        // Fix existing sale return entries in customer_ledgers
        // Update debit to match the actual paid/refund amount from sale_returns table
        DB::statement("
            UPDATE customer_ledgers cl
            INNER JOIN sale_returns sr ON cl.sale_return_id = sr.id
            SET cl.debit = sr.paid
            WHERE cl.adjustment = 'Sale Return'
            AND cl.sale_return_id IS NOT NULL
        ");
        
        // Log the fix
        \Log::info('Fixed customer_ledger debit values for sale returns to match actual paid/refund amounts');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to old behavior (set debit back to grand_total)
        // Note: This is for rollback purposes only
        DB::statement("
            UPDATE customer_ledgers cl
            INNER JOIN sale_returns sr ON cl.sale_return_id = sr.id
            SET cl.debit = sr.grand_total
            WHERE cl.adjustment = 'Sale Return'
            AND cl.sale_return_id IS NOT NULL
        ");
    }
};
