<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_booker_ledgers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_booker_id')->nullable();
            $table->unsignedBigInteger('created_by_user')->nullable();
            $table->date('invoice_date')->nullable();
            $table->string('detail')->nullable();
            $table->string('transaction_type')->nullable();
            $table->unsignedBigInteger('bank_id')->nullable();
            $table->decimal('order_amount', 15, 2)->default(0);
            $table->decimal('paid_amount', 15, 2)->default(0);
            $table->decimal('expense_amount', 15, 2)->default(0);
            $table->enum('status', ['pending', 'received', 'approved'])->nullable();
            $table->timestamp('received_at')->nullable();
            $table->unsignedBigInteger('received_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign keys
            $table->foreign('order_booker_id')->references('id')->on('order_bookers')->onDelete('cascade');
            $table->foreign('created_by_user')->references('id')->on('users')->onDelete('set null');
            $table->foreign('bank_id')->references('id')->on('banks')->onDelete('set null');
            $table->foreign('received_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_booker_ledgers');
    }
};
