<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * Update any existing Order Booker records with old lowercase status values
     * to the new capitalized format introduced in migration 2025_12_06_185945
     */
    public function up(): void
    {
        // Update old lowercase status values to new capitalized format

        // pending → Pending
        $pendingCount = DB::table('order_bookers')
            ->where('status', 'pending')
            ->update(['status' => 'Pending']);

        // approved → Complete
        $approvedCount = DB::table('order_bookers')
            ->where('status', 'approved')
            ->update(['status' => 'Complete']);

        // cancelled → Delete or set to Pending (we'll delete for now)
        $cancelledCount = DB::table('order_bookers')
            ->where('status', 'cancelled')
            ->count();

        if ($cancelledCount > 0) {
            // Optional: Set cancelled to Pending instead of deleting
            DB::table('order_bookers')
                ->where('status', 'cancelled')
                ->update(['status' => 'Pending']);
        }

        // Log the changes
        \Log::info('Order Booker status values migrated to capitalized format', [
            'pending_updated' => $pendingCount,
            'approved_updated' => $approvedCount,
            'cancelled_updated' => $cancelledCount
        ]);

        echo "Migration completed:\n";
        echo "- Updated {$pendingCount} records from 'pending' to 'Pending'\n";
        echo "- Updated {$approvedCount} records from 'approved' to 'Complete'\n";
        echo "- Updated {$cancelledCount} records from 'cancelled' to 'Pending'\n";
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to old lowercase format

        DB::table('order_bookers')
            ->where('status', 'Pending')
            ->update(['status' => 'pending']);

        DB::table('order_bookers')
            ->where('status', 'Complete')
            ->update(['status' => 'approved']);

        DB::table('order_bookers')
            ->where('status', 'In Progress')
            ->update(['status' => 'pending']); // Best guess for rollback

        \Log::info('Order Booker status values rolled back to lowercase format');
    }
};
