<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // Change is_active and is_deleted from enum to tinyInteger
            $table->tinyInteger('is_active')->default(1)->change();
            $table->tinyInteger('is_deleted')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // Revert back to enum if needed
            $table->enum('is_active', ['1', '0'])->default('1')->change();
            $table->enum('is_deleted', ['1', '0'])->default('0')->change();
        });
    }
};
