<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix all tables with enum([1, 0]) to tinyInteger
        $tables = [
            'users',
            'permission_groups',
            'sale_details',
            'expense_categories',
            'expenses',
            'invoices',
            'quotations',
            'order_bookers',
            'expense_sub_categories'
        ];

        foreach ($tables as $tableName) {
            if (Schema::hasTable($tableName)) {
                Schema::table($tableName, function (Blueprint $table) {
                    if (Schema::hasColumn($table->getTable(), 'is_active')) {
                        $table->tinyInteger('is_active')->default(1)->change();
                    }
                    if (Schema::hasColumn($table->getTable(), 'is_deleted')) {
                        $table->tinyInteger('is_deleted')->default(0)->change();
                    }
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to enum if needed
        $tables = [
            'users',
            'permission_groups',
            'sale_details',
            'expense_categories',
            'expenses',
            'invoices',
            'quotations',
            'order_bookers',
            'expense_sub_categories'
        ];

        foreach ($tables as $tableName) {
            if (Schema::hasTable($tableName)) {
                Schema::table($tableName, function (Blueprint $table) {
                    if (Schema::hasColumn($table->getTable(), 'is_active')) {
                        $table->enum('is_active', ['1', '0'])->default('1')->change();
                    }
                    if (Schema::hasColumn($table->getTable(), 'is_deleted')) {
                        $table->enum('is_deleted', ['1', '0'])->default('0')->change();
                    }
                });
            }
        }
    }
};
