<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customer_ledgers', function (Blueprint $table) {
            // Add bank column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'bank')) {
                $table->decimal('bank', 15, 2)->nullable()->after('credit');
            }

            // Add bank_id column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'bank_id')) {
                $table->unsignedBigInteger('bank_id')->nullable()->after('bank');
            }

            // Add created_by column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable();
            }

            // Add updated_by column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'updated_by')) {
                $table->unsignedBigInteger('updated_by')->nullable();
            }

            // Add return_amount column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'return_amount')) {
                $table->decimal('return_amount', 15, 2)->nullable();
            }

            // Add total column if it doesn't exist
            if (!Schema::hasColumn('customer_ledgers', 'total')) {
                $table->decimal('total', 15, 2)->nullable()->after('bank_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customer_ledgers', function (Blueprint $table) {
            $columns = ['bank', 'bank_id', 'created_by', 'updated_by', 'return_amount', 'total'];

            foreach ($columns as $column) {
                if (Schema::hasColumn('customer_ledgers', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
