<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_details', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_details', 'sale_price')) {
                $table->decimal('sale_price', 10, 2)->nullable()->after('purchase_price');
            }
            if (!Schema::hasColumn('purchase_details', 'batch_no')) {
                $table->string('batch_no')->nullable()->after('purchase_price');
            }
            if (!Schema::hasColumn('purchase_details', 'purchase_fright')) {
                $table->decimal('purchase_fright', 10, 2)->nullable()->after('purchase_price');
            }
            if (!Schema::hasColumn('purchase_details', 'purchase_tax')) {
                $table->decimal('purchase_tax', 10, 2)->nullable()->after('purchase_price');
            }
            if (!Schema::hasColumn('purchase_details', 'single_price')) {
                $table->decimal('single_price', 10, 2)->nullable()->after('purchase_price');
            }
            if (!Schema::hasColumn('purchase_details', 'pro_unit')) {
                $table->string('pro_unit')->nullable()->after('pro_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_details', function (Blueprint $table) {
            $columnsToCheck = ['sale_price', 'batch_no', 'purchase_fright', 'purchase_tax', 'single_price', 'pro_unit'];
            $columnsToDrop = [];

            foreach ($columnsToCheck as $column) {
                if (Schema::hasColumn('purchase_details', $column)) {
                    $columnsToDrop[] = $column;
                }
            }

            if (!empty($columnsToDrop)) {
                $table->dropColumn($columnsToDrop);
            }
        });
    }
};
