<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_returns', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('supplier_id')->nullable();
            $table->bigInteger('purchase_id')->nullable(); // Reference to original purchase if applicable
            $table->date('return_date')->nullable();
            $table->string('payment_type')->nullable(); // Cash or Bank
            $table->bigInteger('bank_id')->nullable();
            $table->text('detail')->nullable();
            $table->decimal('subtotal', 15, 2)->default(0);
            $table->decimal('grand_total', 15, 2)->default(0);
            $table->decimal('refund_amount', 15, 2)->default(0); // Amount refunded to us
            $table->decimal('adjustment_amount', 15, 2)->default(0); // Amount adjusted against supplier balance
            $table->tinyInteger('status')->default(0); // 0=pending, 1=approved, 2=rejected
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });

        Schema::create('purchase_return_details', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('purchase_return_id')->nullable();
            $table->bigInteger('pro_id')->nullable();
            $table->string('batch_no')->nullable();
            $table->decimal('purchase_price', 15, 2)->default(0);
            $table->decimal('pro_qty', 15, 2)->default(0);
            $table->decimal('total', 15, 2)->default(0);
            $table->timestamps();
        });

        // Add bank_id column to supplier_ledgers if it doesn't exist
        if (!Schema::hasColumn('supplier_ledgers', 'bank_id')) {
            Schema::table('supplier_ledgers', function (Blueprint $table) {
                $table->bigInteger('bank_id')->nullable()->after('transaction_type');
            });
        }

        // Add bank column to supplier_ledgers if it doesn't exist
        if (!Schema::hasColumn('supplier_ledgers', 'bank')) {
            Schema::table('supplier_ledgers', function (Blueprint $table) {
                $table->decimal('bank', 15, 2)->default(0)->after('bank_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_return_details');
        Schema::dropIfExists('purchase_returns');
    }
};
