<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create purchase return permissions
        $permissions = [
            ['group_name' => 'Purchase Return', 'name' => 'view_purchase_return', 'guard_name' => 'web'],
            ['group_name' => 'Purchase Return', 'name' => 'create_purchase_return', 'guard_name' => 'web'],
            ['group_name' => 'Purchase Return', 'name' => 'update_purchase_return', 'guard_name' => 'web'],
            ['group_name' => 'Purchase Return', 'name' => 'delete_purchase_return', 'guard_name' => 'web'],
        ];

        foreach ($permissions as $permission) {
            // Check if permission already exists
            $exists = Permission::where('name', $permission['name'])
                ->where('guard_name', $permission['guard_name'])
                ->exists();

            if (!$exists) {
                Permission::create($permission);
            }
        }

        // Assign permissions to Admin and Super Admin roles
        $adminRoles = ['Admin', 'Super Admin'];
        $permissionNames = array_column($permissions, 'name');

        foreach ($adminRoles as $roleName) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                $role->givePermissionTo($permissionNames);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove Purchase Return permissions
        Permission::where('group_name', 'Purchase Return')->delete();
    }
};
