<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add columns to repair_orders table
        Schema::table('repair_orders', function (Blueprint $table) {
            if (!Schema::hasColumn('repair_orders', 'material_cost')) {
                $table->decimal('material_cost', 12, 2)->default(0.00)->after('labour_cost');
            }
            if (!Schema::hasColumn('repair_orders', 'total_price')) {
                $table->decimal('total_price', 12, 2)->default(0.00)->after('material_cost');
            }
        });

        // Add columns to contracter_ledgers table
        Schema::table('contracter_ledgers', function (Blueprint $table) {
            if (!Schema::hasColumn('contracter_ledgers', 'material_cost')) {
                $table->decimal('material_cost', 12, 2)->default(0.00)->after('labour_cost');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'total_price')) {
                $table->decimal('total_price', 12, 2)->default(0.00)->after('material_cost');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'payment_type')) {
                $table->string('payment_type')->default('Cash')->after('total_price');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'payment_status')) {
                $table->string('payment_status')->default('Pending')->after('payment_type');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('repair_orders', function (Blueprint $table) {
            $table->dropColumn(['material_cost', 'total_price']);
        });

        Schema::table('contracter_ledgers', function (Blueprint $table) {
            $table->dropColumn(['material_cost', 'total_price', 'payment_type', 'payment_status']);
        });
    }
};
