<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contracter_ledgers', function (Blueprint $table) {
            // Add foreign key columns for repair orders and productions
            if (!Schema::hasColumn('contracter_ledgers', 'repair_order_id')) {
                $table->bigInteger('repair_order_id')->nullable()->after('contractor_id');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'production_id')) {
                $table->bigInteger('production_id')->nullable()->after('repair_order_id');
            }

            // Add product details columns
            if (!Schema::hasColumn('contracter_ledgers', 'pro_id')) {
                $table->bigInteger('pro_id')->nullable()->after('production_id');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'pro_qty')) {
                $table->integer('pro_qty')->default(0)->after('pro_id');
            }

            // Add status and cost columns
            if (!Schema::hasColumn('contracter_ledgers', 'status')) {
                $table->string('status')->nullable()->after('pro_qty');
            }
            if (!Schema::hasColumn('contracter_ledgers', 'cost')) {
                $table->decimal('cost', 15, 2)->default(0)->after('status');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contracter_ledgers', function (Blueprint $table) {
            $table->dropColumn([
                'repair_order_id',
                'production_id',
                'pro_id',
                'pro_qty',
                'status',
                'cost'
            ]);
        });
    }
};
