<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            // Add labour_cost field if it doesn't exist
            if (!Schema::hasColumn('productions', 'labour_cost')) {
                $table->decimal('labour_cost', 12, 2)->default(0.00)->after('total_cost');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            if (Schema::hasColumn('productions', 'labour_cost')) {
                $table->dropColumn('labour_cost');
            }
        });
    }
};
