<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Sync labour_cost from total_cost for existing production records
        // where labour_cost is 0 or null but total_cost has a value
        DB::statement('
            UPDATE productions
            SET labour_cost = total_cost
            WHERE (labour_cost = 0 OR labour_cost IS NULL)
            AND total_cost > 0
        ');

        // Also update contractor ledgers that have labour_cost = 0
        // but their production has total_cost
        DB::statement('
            UPDATE contracter_ledgers cl
            INNER JOIN productions p ON cl.production_id = p.id
            SET cl.labour_cost = p.labour_cost
            WHERE (cl.labour_cost = 0 OR cl.labour_cost IS NULL)
            AND p.labour_cost > 0
            AND cl.production_id IS NOT NULL
        ');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // No need to reverse data migration
        // If needed, you could set labour_cost back to 0
    }
};
