<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stocks', function (Blueprint $table) {
            $table->string('batch_no')->nullable()->after('pro_id');
        });

        Schema::table('saleman_stocks', function (Blueprint $table) {
            $table->string('batch_no')->nullable()->after('pro_id');
        });

        Schema::table('order_details', function (Blueprint $table) {
            $table->string('batch_no')->nullable()->after('product_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stocks', function (Blueprint $table) {
            $table->dropColumn('batch_no');
        });

        Schema::table('saleman_stocks', function (Blueprint $table) {
            $table->dropColumn('batch_no');
        });

        Schema::table('order_details', function (Blueprint $table) {
            $table->dropColumn('batch_no');
        });
    }
};