// Minimal, robust fix: mark container as manual toggle to disable auto-collapse on page clicks
// Nifty checks for '#container.manual-nav-toggle' to avoid auto-toggle on outside clicks.
$(function () {
    var $container = $('#container');
    if ($container.length) {
        $container.addClass('manual-nav-toggle');
    }

    // Disable Nifty's delegated body click handlers that auto-collapse the sidebar
    // We only want the sidebar to toggle via the explicit toggle button.
    $('body').off('clickortap click');
    // Also disable the backdrop auto-toggle if it was bound separately
    $('body').off('clickortap', '.mainnav-backdrop');

    // Keep dropdown cleanup on sidebar toggle events
    $('body').on('toggle.sidebar', function () {
        $('.dropdown.open').removeClass('open').trigger('hide.bs.dropdown');
    });

    // Force expanded sidebar by default and guard against unwanted class flips
    if ($container.length) {
        $container.removeClass('mainnav-sm').addClass('mainnav-lg');

        var allowProgrammaticToggle = false;
        $(document).on('click', '.mainnav-toggle', function () {
            allowProgrammaticToggle = true;
            setTimeout(function(){ allowProgrammaticToggle = false; }, 800);
        });

        // Observe class changes on #container and revert unintended collapses
        var lastClass = $container.attr('class');
        var observer = new MutationObserver(function(mutations){
            mutations.forEach(function(m){
                if (m.attributeName === 'class') {
                    var cls = $container.attr('class') || '';
                    var becameSmall = /(^|\s)mainnav-sm(\s|$)/.test(cls);
                    if (becameSmall && !allowProgrammaticToggle) {
                        $container.removeClass('mainnav-sm').addClass('mainnav-lg');
                    }
                    lastClass = cls;
                }
            });
        });
        try { observer.observe($container[0], { attributes: true, attributeFilter: ['class'] }); } catch(e) {}
    }
});
