@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <style>
        /* Dropify text size control */
        .dropify-wrapper .dropify-message p {
            font-size: 12px !important;  /* text chhota karne ke liye */
            color: #555 !important;      /* text color change karne ke liye */
            line-height: 16px;           /* line height adjust */
        }

        /* Heading jo "Drag and drop a file" hota hai */
        .dropify-wrapper .dropify-message span.file-icon {
            font-size: 20px !important;  /* icon ka size */
            color: #333 !important;
        }

    </style>

@endsection

   


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> Transaction Report</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Transaction Report</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div  class="col-md-6">
            <div id="counting_panel">
                {{-- <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div> --}}
                {{-- <div class="page-header counting round-corner-right">Total Investment <br> <b id="invested_amount">0</b></div> --}}
            </div>

        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        {{-- search by date  --}}
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>

                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_withdrawal'))
                        {{-- <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add Withdrawals  </button> --}}
                        @endif
                        {{-- @if (Auth::user()->can('print_teacher')) --}}
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Payment Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Bank</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Amount</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Transaction Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Source Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Description</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Date</a></li>
                            </ul>
                        </div>
                        {{-- @endif --}}

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="10px">Id</th>
                            <th width="50px">Payment Type</th>
                            <th width="50px">Bank</th>
                            <th width="50px">Amount</th>
                            <th width="50px">Transaction Type</th>
                            <th width="100px">Source Type</th>
                            <th width="100px">Description</th>
                            <th width="100px">Date</th>  


                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
   


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -83px;
                top: -500px;
                width: 800px;
            }
        }
        .center{
            text-align: center;
        }
        .mb{
            margin-bottom: 10px;
        }
        #std_table>tbody>tr>td{
            height: 35px;
            text-align: center;
        }
        #std_table>thead>tr>th{
            height: 35px;
            text-align: center;
        }
    </style>
 


    
@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

<script>
$(document).ready(function() {
    // By default hide bank area
    $('#bank_area').hide();
    $('#investor_area').hide();

    // On payment type change
    $('#payment_type').on('change', function() {
        if ($(this).val() === 'Bank') {
            $('#bank_area').show();
        } else {
            $('#bank_area').hide();
        }
    });

    // withdraw_type
    $('#withdraw_type').on('change', function() {
        if ($(this).val() === 'Investor') {
            $('#investor_area').show();
        } else {
            $('#investor_area').hide();
        }
    });
}); 


 
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
 

</script>

<script>
    $(document).ready(function(){

        $('.dropify').dropify();
        $('.select2').select2();

        //=========== Start Date Picker ===========//
        $('#dob').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#dob').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== Start Date Picker ===========//
        $('#joining_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#joining_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== add row  Ajax Request ===========//
       
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = 
                '<div class="row appended-row">' +
                    '<div class="col-sm-3 " >' +
                        '<div class="form-group">' +
                            '<select name="day[]" class="form-control selectpicker">' +
                                '<option value="Monday">Monday</option>' +
                                '<option value="Tuesday">Tuesday</option>' +
                                '<option value="Wednesday">Wednesday</option>' +
                                '<option value="Thursday">Thursday</option>' +
                                '<option value="Friday">Friday</option>' +
                                '<option value="Saturday">Saturday</option>' +
                                '<option value="Sunday">Sunday</option>' +
                            '</select>' +
                        '</div>' +
                    '</div>' +

                    '<div class="city-area-group">' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="city_id[]" class="select2 form-control cities" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="area_id[]" class="select2 form-control areas" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                    '</div>' +


                    '<div class="col-sm-1">' +
                        '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark"></i></button>' +
                    '</div>' +
            '</div>';

            var newRow = $(html);

            $("#append_area").append(newRow);

            // Initialize select2 for new row
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Option',
                allowClear: true,
                dropdownParent: newRow
            });

            // Get cities for new row
            get_cities(newRow.find('.cities'));
            get_areas(newRow.find('.areas'));


            // bootstrap-selectpicker refresh
            newRow.find('.selectpicker').selectpicker('refresh');
        });


        // Remove row
        $(document).on("click", ".remove_row", function(e) {
            e.preventDefault();
            $(this).closest(".appended-row").remove();
        });


        //=========== End add   row Ajax Request ===========//

        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    
                   
                    payment_type: {
                        required: true
                    },
                     
                    amount: {
                        required: true
                    },
                },
                messages: {
                    
                    payment_type: {
                        required: "Please Select Type",
                    },
                     
                    amount: {
                        required: "Please Enter Amount",
                    },
                    
                    
                },


        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                // $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_withdrawals") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Data Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Not enough balance to withdraw!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: 'edit_inv_investment/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#investment_id').val(response.data.id);
                    $('#invested_amount').val(response.data.invested_amount);
                    $('#remaining_amount').val(response.data.remaining_amount);

                    $('#profit_percentage').val(response.data.profit_percentage);
                    $('#u_investor_id').val(response.data.investor_id).trigger('change');
                    $('#u_pro_id').val(response.data.pro_id).trigger('change');
                    $('#u_bank_id').val(response.data.bank_id).trigger('change');
                    $('#u_payment_type').val(response.data.payment_type).trigger('change');


                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    
                    investor_id: {
                        required: true,
                    },
                    pro_id: {
                        required: true
                    },
                },
                messages: {
                    investor_id: {
                        required: "Please Enter Investor Name",
                    },
                    pro_id: {
                        required: "Please Enter Product Name",
                    },
                    
                },


        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_inv_investment") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                            $('#update_modal').modal('hide');
                            loadData();
                            total_investor_amount();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Update  Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: 'delete_inv_investment/'+id,
                            type : "GET",
                            success : function(response){
                                if (response.status == 200)
                                {
                                    toastr.success('Data Has Been Deleted Seccussfully!', 'Successfull!');
                                    loadData();
                                }else {
                                    Swal.fire({
                                                title: "Somthing Wrong!",
                                                text: "Sonthing Went Wrong Please Try Again!",
                                                type: "error",
                                                customClass: "sweet-alert",
                                            });
                                }
                            }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
        });
        //=========== End Lounch View Modal On Click View Btn ===========//


     

       

        // salesman 
        $('#bank_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#bank_id').parent() // Set to the parent element of the select box
        });
        $('#u_bank_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_bank_id').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#bank_id option[value="' + data[i].id + '"]').length == 0){
                        $('#bank_id').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_bank_id option[value="' + data[i].id + '"]').length == 0){
                        $('#u_bank_id').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================
        
     






        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_cash_bank_report") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "payment_type" },
                { data: "bank_name" },
                { data: "amount" }, 
                { data: "transaction_type" },
                { data: "source_type" },
                { data: "description" },
                { data: "date" },

                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1,4] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 4],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();
        //==========For Add===========//
        $('#image-input').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#uploaded-photo').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //==========For Update===========//
        $('#up_image').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#upload_teacher_image').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });
        //=========== End Custom Search Box ===========//

        
        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//



            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
            
                // alert(startdate+" "+enddate);

                // $('#main_table').DataTable().destroy();

                // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
                loadData($('#search').val(), startdate, enddate);

            
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
                //do something, like clearing an input
                $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
                //do something, like clearing an input
                $(datepickerid).val('');
                loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//




    });
</script>
@endsection