@extends('admin.layout.layout')

@section('page_head')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Customer Ledger</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li id="customer_name"></li>
            <li id="shop_name"></li>

            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Amount <br> <b id="total_amount">0</b></div>
                {{-- <div class="page-header counting round-corner-left">Total Debit <br> <b id="total_debit">0</b></div> --}}
                <div class="page-header counting">Total Credit <br> <b id="total_credit">0</b></div>
                {{-- <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div> --}}
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                        {{-- <div class="form-group">
                            <select id="payment_type_filter" class="demo_select2 form-control" style="width: 200px">
                                <option></option>
                                <option value="all">All</option>
                                <option value="Payment">Payment</option>
                                <option value="Sale">Sale</option>
                                <option value="Return">Return</option>
                            </select>
                        </div> --}}
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        {{-- <button id="add_modal_btn" class="btn btn-purple"><i class="demo-pli-add"></i> Add Payment</button> --}}
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">S.NO</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Transaction Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Transaction Details</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Transaction Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Total</a></li>

                                <li><a href="#" class="toggle-vis" data-column="5">Debit</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Credit</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Bank</a></li>
                                <li><a href="#" class="toggle-vis" data-column="8">Balance</a></li>
                                <li><a href="#" class="toggle-vis" data-column="9">Action</a></li>
                            </ul>
                        </div>

                        <button id="return_back_btn" onclick="window.history.back();" class="btn btn-success"><i class="fa-duotone fa-chevrons-left"></i> Back</button>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="10px">S.NO</th>
                            <th width="75px">T-Date</th>
                            <th width="200px">T-Details</th>
                            <th width="100px">T-Type</th>
                            {{-- <th width="100px">Add Old Balance</th> --}}
                            <th width="100px">Sale Id</th>
                            <th width="100px">Adjustment</th>
                            <th width="100px">Total</th>
                            <th width="50px">Debit</th>
                            <th width="50px">Credit</th>
                            <th width="50px">Bank</th>
                            <th width="50px">Balance</th>
                            <th width="75px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  

    <!--Start View Invoice Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->
                    <div class="panel print_invoice">
                        <div class="panel-body">
                            <div class="invoice-masthead">
                                <div class="invoice-text">
                                    <h3 class="h1 text-uppercase text-thin mar-no text-primary">INVOICE</h3>
                                </div>
                                <div class="invoice-brand" style="white-space:nowrap">
                                    <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
                                        <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
                                    </div>
                                </div>
                            </div>
                        
                            <div class="invoice-bill row">
                                <div class="col-sm-6 text-xs-center">
                                    <address>
                                        <span>Name: </span>
                                        <strong class="text-main" id="cus_name"></strong><br>
                                        <span id="company_name"></span><br>
                                        <span id="phone"></span><br>
                                        <span id="address"></span>
                                   </address>
                                </div>
                                <div class="col-sm-6 text-xs-center">
                                    <table class="invoice-details">
                                        <tbody>
                                            <tr>
                                                <td class="text-main text-bold">Invoice #</td>
                                                <td class="text-right text-info text-bold" id="invoice_no"></td>
                                            </tr>
                                            <tr>
                                                <td class="text-main text-bold">Billing Date</td>
                                                <td class="text-right" id="inv_date"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        
                            <div class="row">
                                <div class="col-lg-12 table-responsive">
                                    <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
                                        <thead>
                                            <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
                                                <th class="text-uppercase">Products</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
                                                <th class="min-col text-center text-uppercase">Qty</th>
                                                <th class="min-col text-center text-uppercase">Dis %</th>
                                                <th class="min-col text-center text-uppercase">Dis Amt</th>
                                                <th class="min-col text-right text-uppercase">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        
                            <div class="clearfix">
                                <table class="table invoice-total">
                                    <tbody>
                                        <tr>
                                            <td><strong>Subtotal :</strong></td>
                                            <td id="view_subtotal"></td>
                                        </tr>
                                        <tr>
                                            <td><strong id="view_dis_per">Discount :</strong></td>
                                            <td id="view_dis_amt"></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total :</strong></td>
                                            <td class="text-bold h4" id="view_total"></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Paid :</strong></td>
                                            <td id="view_paid"></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Due :</strong></td>
                                            <td id="view_due"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="text-center no-print">
                                <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Invoice Modal-->
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add Payment</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="transaction_date" id="transaction_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Payment Date</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="amount" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Amount</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="transaction_type" data-style="custom-select-style" id="payment_type">
                                        <option value="" selected disabled>Select Payment Type</option>
                                        <option value="credit">Credit</option>
                                        {{-- <option value="debit">Debit</option> --}}
                                        <option value="bank">Bank</option>

                                    </select>
                                </div>

                                <div class="col-sm-12" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="transaction_details" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Detail</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Payment</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="hidden" name="pay_id" id="u_pay_id" class="form-control textbox" placeholder=" ">
                                        <input type="text" name="transaction_date" id="u_transaction_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Payment Date</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="amount" id="u_amount" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Amount</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="transaction_type" id="u_transaction_type" data-style="custom-select-style">
                                        <option value="credit">Credit</option>
                                        {{-- <option value="debit">Debit</option> --}}
                                        <option value="bank">Bank</option>

                                    </select>
                                </div>

                                 <div class="col-sm-12" id="u_bank_area">
                                    <div class="form-group">
                                        <select id="u_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="transaction_details" id="u_transaction_details" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Detail</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    @endsection



    @push('script')

    <script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });

        $('#u_transaction_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#u_bank_area').show();
            } else {
                $('#u_bank_area').hide();
            }
        });






        // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================





    }); 
    </script>

    <script>
    $(document).ready(function(){

        function getIdFromUrl() {
            var pathArray = window.location.pathname.split('/');
            return pathArray[pathArray.length - 1]; // Assumes the ID is the last part of the URL
        }

        // Get the ID from the URL
        var cus_id = getIdFromUrl();


        $('#transaction_date').daterangepicker({
            // autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#transaction_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_transaction_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_transaction_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });



        $("#add_modal_btn").click(function(e){
            e.preventDefault();

            $("#add_modal").modal('show');

            // $('#cus_pay_id').val(cus_id);

        });


        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    sup_name: {
                        required: true,
                    },
                    phone_no: {
                        required: true,
                    },
                    
                },
                messages: {
                    sup_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_no: {
                        required: "Please enter Supplier Name",
                    },
                },

                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e) {
        e.preventDefault();
        
        if ($("#add_form").valid()) {
            $(this).prop('disabled', true).text('Saving..');

            // Get Data From Modal Form On Click Save Button
            var formData = new FormData($('#add_form')[0]);
            formData.append('cus_pay_id', cus_id);

            $.ajax({
                url: '{{ route("insert_customer_payment") }}',
                method: 'post',
                data: formData,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(response) {
                    console.log(response);
                    if (response.status == 200) {
                        toastr.success('Payment Saved Successfully!', 'Successful!');
                        $('#add_modal').find('form')[0].reset();
                        $('#add_btn').text('Save Payment').prop('disabled', false);
                        $('#add_modal').modal('hide');
                        loadData();
                    } else {
                        Swal.fire({
                            title: "Error!",
                            text: "Something went wrong!",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-success"
                            }
                        });
                        $('#add_btn').text('Save Payment').prop('disabled', false);
                    }
                },
                error: function(err) {
                    console.error(err);
                    Swal.fire({
                        title: "Error!",
                        text: "An unexpected error occurred.",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn fw-bold btn-success"
                        }
                    });
                    $('#add_btn').text('Save Payment').prop('disabled', false);
                }
            });
        }
    });

        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_customer_payment/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#u_pay_id').val(response.data.id);
                    $('#u_transaction_date').val(response.data.transaction_date);
                    if(response.data.credit > 0){
                        $('#u_amount').val(parseFloat(response.data.credit).toFixed(0));
                        $('#u_transaction_type').val('credit').trigger('change');
                    }else if(response.data.debit > 0){
                        $('#u_amount').val(parseFloat(response.data.debit).toFixed(0));
                        $('#u_transaction_type').val('debit').trigger('change');
                    }else{
                        // yahan ledger ka apna 'bank' column use karo
                        $('#u_amount').val(parseFloat(response.data.ledger_bank_amount).toFixed(0));

                        $('#u_transaction_type').val('bank').trigger('change');
                        $('#u_banks').val(response.data.bank_id).trigger('change');
                    }


                    $('#u_transaction_details').val(response.data.transaction_details);
                    
                    


                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    sup_name: {
                        required: true,
                    },
                    phone_no: {
                        required: true,
                    },
                    
                },
                messages: {
                    sup_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_no: {
                        required: "Please enter Supplier Name",
                    },
                },


                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_customer_payment") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Customer Payment Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_customer_payment/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Customer Payment Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//

        //=========== Launch View Invoice Modal On Click View Button ===========//
        $(document).on("click", '#view_sale_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var sale_id = $(this).data("sale_id");
            $.ajax({
                url: '/view_sale/' + sale_id,
                method: 'GET',
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    if (data.status === 200) {
                        $('#cus_name').text(data.sale.name || '');
                        $('#company_name').text(data.sale.shop_name || '');
                        $('#phone').text(data.sale.phone || '');
                        $('#address').text(data.sale.address || '');
                        $('#invoice_no').text(data.sale.id);
                        $('#inv_date').text(data.sale.invoice_date);
                        $('#view_subtotal').text(data.sale.subtotal || '0.00');
                        $('#view_dis_per').text("Discount : (" + (data.sale.dis_percent || 0) + " %)");
                        $('#view_dis_amt').text(data.sale.dis_amount || '0.00');
                        $('#view_total').text(data.sale.grand_total || '0.00');
                        $('#view_paid').text(data.sale.paid || '0.00');
                        $('#view_due').text(data.sale.due || '0.00');

                        var html = '';
                        $.each(data.products, function(i, item) {
                            html += '<tr>' +
                                '<td class="text-center">' + item.no + '</td>' +
                                '<td>' + item.pro_name + '</td>' +
                                '<td class="text-center">' + item.sale_price + '</td>' +
                                '<td class="text-center">' + item.pro_qty + '</td>' +
                                '<td class="text-center">' + item.dis_per + '</td>' +
                                '<td class="text-center">' + item.dis_amount + '</td>' +
                                '<td class="text-right">' + item.total + '</td>' +
                                '</tr>';
                        });

                        $("#invoice_table > tbody").empty().append(html);
                    } else {
                        toastr.error('Invoice not found', 'Error!');
                        $("#view_modal").modal('hide');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching invoice:', error);
                    toastr.error('Error loading invoice. Please try again.', 'Error!');
                    $("#view_modal").modal('hide');
                }
            });
        });
        //=========== End Launch View Invoice Modal ===========//

        //=========== Launch View Sale Return Modal On Click View Button ===========//
        $(document).on("click", '#view_sale_return_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var return_id = $(this).data("return_id");
            $.ajax({
                url: '/view_sale_return/' + return_id,
                method: 'GET',
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    if (data.status === 200) {
                        $('#cus_name').text(data.sale_return.name || '');
                        $('#company_name').text(data.sale_return.shop_name || '');
                        $('#phone').text(data.sale_return.phone || '');
                        $('#address').text(data.sale_return.address || '');
                        $('#invoice_no').text('SR-' + data.sale_return.id);
                        $('#inv_date').text(data.sale_return.invoice_date);
                        $('#view_subtotal').text(data.sale_return.subtotal || '0.00');
                        $('#view_dis_per').text("Discount : (" + (data.sale_return.dis_percent || 0) + " %)");
                        $('#view_dis_amt').text(data.sale_return.dis_amount || '0.00');
                        $('#view_total').text(data.sale_return.grand_total || '0.00');
                        $('#view_paid').text(data.sale_return.paid || '0.00');
                        $('#view_due').text(data.sale_return.due || '0.00');

                        var html = '';
                        $.each(data.products, function(i, item) {
                            html += '<tr>' +
                                '<td class="text-center">' + item.no + '</td>' +
                                '<td>' + item.pro_name + '</td>' +
                                '<td class="text-center">' + item.sale_price + '</td>' +
                                '<td class="text-center">' + item.pro_qty + '</td>' +
                                '<td class="text-center">' + item.dis_per + '</td>' +
                                '<td class="text-center">' + item.dis_amount + '</td>' +
                                '<td class="text-right">' + item.total + '</td>' +
                                '</tr>';
                        });

                        $("#invoice_table > tbody").empty().append(html);
                    } else {
                        toastr.error('Sale Return not found', 'Error!');
                        $("#view_modal").modal('hide');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching sale return:', error);
                    toastr.error('Error loading sale return. Please try again.', 'Error!');
                    $("#view_modal").modal('hide');
                }
            });
        });
        //=========== End Launch View Sale Return Modal ===========//

        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_customer_ledger") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", cus_id: cus_id, _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "invoice_date" },
                { data: "transaction_details" },
                { data: "transaction_type" },
                { data: "sale_id" },
                { data: "adjustment" },
                { data: "total" },
                { data: "debit" },
                { data: "credit" },
                { data: "bank" },
                { data: "balance" },
                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 3, 4, 5, 6, 7] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 3, 4, 5, 6, 7],
            order: [1, 'ASC'],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();

                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);

                var totals = api.ajax.json().totals;

                $('#total_amount').text(totals.total_amount);
                $('#total_debit').text(totals.total_debit);
                $('#total_credit').text(totals.total_credit);
                $('#total_balance').text(totals.total_balance);
                $('#customer_id').text(totals.customer_id);
                $('#customer_name').text(totals.customer_name);
                $('#shop_name').text(totals.shop_name);

            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { search: search, startdate: startDate, enddate: endDate, type: type, _token: csrf._token }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });
        //=========== End Custom Search Box ===========//

        $("#payment_type_filter").select2({
            placeholder: "Search By Type",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });

        //=========== Start Custom Status Dropdown ===========//
        $('#payment_type_filter').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }

        });
        //=========== End Custom Status Dropdown ===========//


        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//



            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
            
                // alert(startdate+" "+enddate);

                // $('#main_table').DataTable().destroy();

                // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
                loadData($('#search').val(), startdate, enddate);

            
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
            //do something, like clearing an input
                $(datepickerid).val('');
                loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//



        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_customer_payment/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Customer Ledger Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//




    });
</script>

    <script>
        $(document).ready(function(){

            $('[data-toggle="tooltip"]').tooltip();
            
            $('.textboxlabel').click(function() {
                $(this).prev('.textbox').focus();
            });

            toastr.options = {
	          "closeButton": true,
	          "debug": false,
	          "newestOnTop": false,
	          "progressBar": true,
	          "positionClass": "toast-top-right",
	          "preventDuplicates": false,
	          "onclick": null,
	          "showDuration": "300",
	          "hideDuration": "1000",
	          "timeOut": "5000",
	          "extendedTimeOut": "1000",
	          "showEasing": "swing",
	          "hideEasing": "linear",
	          "showMethod": "fadeIn",
	          "hideMethod": "fadeOut"
	        };


            // Start Colvis Show Active on Click ===========//
            $(".toggle-vis").click(function(){
            $(this).toggleClass("colvischecked");
            });
            // End Colvis Show Active on Click ===========//


            $('a.toggle-vis').on('click', function (e) {
                e.preventDefault();
        
                // Get the column API object
                // var column = $('#main_table').DataTable().column($(this).val());

                //with anchor tag
                // <a class="toggle-vis" data-column="0">Name</a>


                var column = $('#main_table').DataTable().column($(this).attr('data-column'));


        
                // Toggle the visibility
                column.visible(!column.visible());
            });
            //=========== End Custom Colvis ===========//

            //=========== Start Custom PDF Export Btn ===========//
            $("#pdf").on("click", function() {
            $(".buttons-pdf").trigger("click");
            });
            //=========== End Custom PDF Export Btn ===========//

            //=========== Start Custom Excel Export Btn ===========//
            $("#excel").on("click", function() {
            $(".buttons-excel").trigger("click");
            });
            //=========== End Custom Excel Export Btn ===========//

            //=========== Start Custom CSV Export Btn ===========//
            $("#csv").on("click", function() {
            $(".buttons-csv").trigger("click");
            });
            //=========== End Custom CSV Export Btn ===========//

            //=========== Start Custom Print Export Btn ===========//
            $("#print").on("click", function() {
            $(".buttons-print").trigger("click");
            });
            //=========== End Custom Print Export Btn ===========//


        });
    </script>

@endpush