@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <style>
        /* Dropify text size control */
        .dropify-wrapper .dropify-message p {
            font-size: 12px !important;  /* text chhota karne ke liye */
            color: #555 !important;      /* text color change karne ke liye */
            line-height: 16px;           /* line height adjust */
        }

        /* Heading jo "Drag and drop a file" hota hai */
        .dropify-wrapper .dropify-message span.file-icon {
            font-size: 20px !important;  /* icon ka size */
            color: #333 !important;
        }

    </style>

@endsection

   


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">
                    @if (Auth::user()->hasRole('Employee'))
                        My Ledger
                    @else
                        Employee
                    @endif
                </h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
                @if (Auth::user()->hasRole('Employee'))
                    <li id="employee_name">Employee Ledger</li>
                @else
                    <li>Manage All Employee ( Add - Update - Delete )</li>
                @endif
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            @if (Auth::user()->hasRole('Employee') && isset($employee_id))
                <div id="counting_panel">
                    <div class="page-header counting round-corner-left">Total Advance <br> <b id="total_advance">0</b></div>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('page_content')
    @if (Auth::user()->hasRole('Employee'))
        @if (isset($employee_id) && $employee_id)
            {{-- Show Employee Ledger for Employee Role --}}
            <div class="panel">
                <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
                    <div class="form-inline">
                        <div class="row">
                            <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                                <div class="form-group">
                                    <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                                </div>
                                <div class="form-group">
                                    <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                                    <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                                </div>
                            </div>
                            <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                                <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                                <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                                <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover custom-table" id="main_table">
                            <thead>
                                <tr>
                                    <th width="10px">Id</th>
                                    <th width="75px">Month</th> 
                                    <th width="75px">Date</th> 
                                    <th width="100px">Salary Per Day</th> 
                                    <th width="50px">Working Days</th>
                                    <th width="50px">Advance</th> 
                                    <th width="50px">Net Salary</th>
                                    <th width="50px">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            {{-- Employee record not found message --}}
            <div class="panel">
                <div class="panel-body text-center" style="padding: 50px;">
                    <div class="alert alert-warning">
                        <h3>Employee Record Not Found</h3>
                        <p class="text-muted">Your employee record is not linked to your user account.</p>
                        <p>Please contact the administrator to link your employee record to your account.</p>
                        <hr>
                        <p><strong>Your Details:</strong></p>
                        <p><small>Email: {{ Auth::user()->email }}</small><br>
                        <small>User ID: {{ Auth::id() }}</small><br>
                        <small>Name: {{ Auth::user()->name ?? 'N/A' }}</small></p>
                        <hr>
                        <p><strong>Available Employee Records:</strong></p>
                        @php
                            $allEmployees = \App\Models\Employee::all();
                        @endphp
                        @if($allEmployees->count() > 0)
                            <ul class="list-unstyled">
                                @foreach($allEmployees as $emp)
                                    <li><small>ID: {{ $emp->id }} - {{ $emp->emp_name }} (Email: {{ $emp->email ?? 'N/A' }})</small></li>
                                @endforeach
                            </ul>
                        @else
                            <p><small>No employee records found in the system.</small></p>
                        @endif
                    </div>
                </div>
            </div>
        @endif
    @else
        {{-- Show Employee List for Other Roles --}}
        <div class="panel">
            <!--Data Table-->
            <!--===================================================-->
            <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
                <div class="form-inline">
                    <div class="row">
                        <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                            <div class="form-group">
                                <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                            </div>
                            
                        </div>
                        <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                            @if (Auth::user()->can('create_employee'))
                            <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Employee</button>
                            @endif
                            <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                            <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                            <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                            <div class="btn-group dropdown">
                                <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                    Columns
                                    <span class="caret"></span>
                                </button>
                                <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                    <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                    <li><a href="#" class="toggle-vis" data-column="1">Name</a></li>  
                                    <li><a href="#" class="toggle-vis" data-column="2">Phone</a></li> 
                                    <li><a href="#" class="toggle-vis" data-column="3">Cnic</a></li>
                                    <li><a href="#" class="toggle-vis" data-column="4">Image</a></li>
                                    <li><a href="#" class="toggle-vis" data-column="5">Buttons</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover custom-table" id="main_table">
                        <thead>
                            <tr>
                                <th width="10px">Id</th>
                                <th width="50px">Name</th> 
                                <th width="100px">Phone</th> 
                                <th width="100px">Cnic</th>
                                <th width="100px">Image</th>
                                <th width="100px" class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--===================================================-->
            <!--End Data Table-->
        </div>
    @endif  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Employee</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_form" type="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">

                                    <div class="col-md-8" style="padding: 0px">
 
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="emp_name" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Employee Name</label>
                                            </div>
                                        </div>
                                         <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="father_name" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Father Name</label>
                                            </div>
                                        </div>
                                         <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="email" name="email" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Email</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="phone" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Phone</label>
                                            </div>
                                        </div>
                                       
                                        
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="cnic" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">CNIC</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="emergency_contact" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Emergency Contact</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="designation" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Designation</label>
                                            </div>
                                        </div>
                                           <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="monthly_salary" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Monthly Salary</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" name="annual_increment" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Annual Increment</label>
                                            </div>
                                        </div>
                                      
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <input type="text" name="address" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Address</label>
                                            </div>
                                        </div>
                                        
                                       
                                      
                                      
                                    </div>

                                    <div class="col-md-4" style="padding: 0px">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <input type="file" name="emp_image" class="form-control textbox dropify">
                                                <label class="control-label textboxlabel">Image</label>
                                            </div>
                                        </div>
                                    </div> 

                                    
                                       
                                    

                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" type="button" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Data</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">

                                    <div class="col-md-12">

                                        <div class="col-md-8" style="padding: 0px">

                                           

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="hidden" id="emp_id" name="emp_id" class="form-control textbox" placeholder=" ">
                                                    <input type="text" id="emp_name" name="emp_name" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Employee Name</label>
                                                </div>
                                            </div>
                                             <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="father_name" name="father_name" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Father Name</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="cnic" name="cnic" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">CNIC</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="phone" name="phone" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Phone</label>
                                                </div>
                                            </div> 
                                             <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="email" name="email" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Email</label>
                                                </div>
                                            </div> 
                                             <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="emergency_contact" name="emergency_contact" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Emergency Contact</label>
                                                </div>
                                            </div>
                                             <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="monthly_salary" name="monthly_salary" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Monthly Salary  </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="designation" name="designation" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Designation</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <input type="text" id="address" name="address" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel"> Address</label>
                                                </div>
                                            </div>
                                        

                                        </div>

                                        <div class="col-md-4" style="padding: 0px">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <input type="file" id="emp_image" name="emp_image" class="form-control textbox dropify" >
                                                    <label class="control-label textboxlabel"> Image</label>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -83px;
                top: -500px;
                width: 800px;
            }
        }
        .center{
            text-align: center;
        }
        .mb{
            margin-bottom: 10px;
        }
        #std_table>tbody>tr>td{
            height: 35px;
            text-align: center;
        }
        #std_table>thead>tr>th{
            height: 35px;
            text-align: center;
        }
    </style>

    <!--Start View Modal-->
    <!--===================================================-->
    <div  class="modal fade" id="view_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true" style="padding-top: 10px;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Form</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body p-0" >
                    <div class="panel print_invoice">
					    <div class="panel-body p-0">
                            <div class="invoice-brand" style="white-space:nowrap">
                                <div class="invoice-logo">
                                    <img src="{{ asset('uploads/letterhead.jpg') }}" width="100%">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h2 class="center">JOINING FORM</h2>
                                            <h5 class="center">Joining in which department is sought________</h5>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="invoice-bill row" style="padding: 0 20px; margin: 5px 0">
                                <h6>For Office Use Only</h6>
                                <div class="row">
                                    <div class="col-md-10">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Registration No______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Date Of Joning ______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Joning in Department ______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="">Teacher's Name</label>
                                            <input class="form-control mb" type="text">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="gender" class="form-label">Gender</label>
                                            <select id="gender" name="gender" class="form-control">
                                                <option value="male" selected>Male</option>
                                                <option value="female">Female</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="center" style="border: 1px solid #7a878e;">
                                            <img src="uploads/test.jpg" alt="" height="100px" width="100px">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Date Of Birth:</label>
                                        <input class="form-control mb" type="date" id="day" name="day" size="2">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Cast:</label>
                                        <input class="form-control mb" type="text" id="" name="">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Nationality:</label>
                                        <input class="form-control mb" type="text"  id="" name="">
                                    </div> 
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's Name:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's Profession:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's CNIC NO:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Qualification</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Work Shift</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Mobile NO.</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Home (Tel.)</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Present Address:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Previous School (If Any):</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <h5 style="margin-left: 10px;">I have read the scool prospectus and agree to abide by the School rules.</h5>
                                    <h5 style="margin-left: 10px;">Attached Documents:</h5>
                                    <ul>
                                        <li>Degree's</li>
                                        <li>Birth Certificate / B Form</li>
                                        <li>Copy Of Father's / Guardian's CNIC</li>
                                        <li>2 Photographs (Passport Size)</li>
                                    </ul>
                                    <div class="col-md-12">
                                        <label for="">Reference:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>

                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <div class="text-center no-print">
                        <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i> Print</a>
                        <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End View Modal-->


    
@endsection



@section('javascript_code')

    <script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

    @if (Auth::user()->hasRole('Employee') && isset($employee_id) && $employee_id)
    {{-- Ledger Scripts for Employee Role --}}
    <script>
    $(document).ready(function(){
        // Use employee_id from controller
        var emp_id = {{ $employee_id }};
        
        console.log('Employee ID:', emp_id);
        
        if (!emp_id) {
            console.error('Employee ID is not set!');
            return;
        }
        
        // Get monthly advance
        getMonthlyAdvance(emp_id);
        function getMonthlyAdvance(empId) {
            $.ajax({
                url: "/getMonthlyAdvance/" + empId,
                type: "GET",
                success: function(data) {
                    $("#total_advance").text(data.totalAdvance || 0);
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    $("#total_advance").text("0");
                }
            });
        }
        
        // Define default options for DataTable - exactly match the working employee_ledger.blade.php format
        var csrf = $('meta[name="csrf-token"]').attr('content');
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_employee_ledger") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "", type: "", emp_id: emp_id, _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "month" },
                { data: "date" },
                { data: "salary_per_day" },
                { data: "working_days" },
                { data: "advance" },
                { data: "net_salary" },
                { data: "status" },
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1,2,3] },
            ],
            centeredColumnsOnPrintPdf: [1,2,3,4,5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var totals = api.ajax.json().totals;
                if (totals && totals.employee_name) {
                    $('#employee_name').text(totals.employee_name);
                }
            }
        };
        
        // Function to load data - exactly match the working employee_ledger.blade.php format
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            console.log('Loading data with emp_id:', emp_id);
            if (!emp_id) {
                console.error('Employee ID is not set!');
                return;
            }
            
            // CRITICAL: Ensure we always use the correct employee_id for Employee role users
            // The server-side will enforce this, but we send the correct ID anyway
            var requestEmpId = emp_id;
            console.log('Request will use emp_id:', requestEmpId);
            
            // Merge the default options with the updated dates - exactly like employee_ledger.blade.php
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { search: search, startdate: startDate, enddate: endDate, type: type, emp_id: requestEmpId, _token: csrf._token }
                }
            });
            console.log('Calling load_data with options:', options);
            // Call the load_data function with the updated options
            load_data(options);
        }

        // Initialize DataTable - exactly like employee_ledger.blade.php
        loadData();
        
        // Search functionality - exactly like employee_ledger.blade.php
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", "");
        });
        
        // Date range picker - use the same function as employee_ledger.blade.php
        search_by_date("#search_by_date");
        
        // Search by date function - exactly like employee_ledger.blade.php
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//

            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker) {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
                loadData($('#search').val(), startdate, enddate);
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
                //do something, like clearing an input
                $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
                //do something, like clearing an input
                $(datepickerid).val('');
                loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//
    });
    </script>
    @else
    {{-- Employee List Scripts for Other Roles --}}
    <script>
    $(document).ready(function(){

        $('.dropify').dropify();
        $('.select2').select2();

        //=========== Start Date Picker ===========//
        $('#dob').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#dob').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== Start Date Picker ===========//
        $('#joining_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#joining_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== add row  Ajax Request ===========//
       
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = 
                '<div class="row appended-row">' +
                    '<div class="col-sm-3 " >' +
                        '<div class="form-group">' +
                            '<select name="day[]" class="form-control selectpicker">' +
                                '<option value="Monday">Monday</option>' +
                                '<option value="Tuesday">Tuesday</option>' +
                                '<option value="Wednesday">Wednesday</option>' +
                                '<option value="Thursday">Thursday</option>' +
                                '<option value="Friday">Friday</option>' +
                                '<option value="Saturday">Saturday</option>' +
                                '<option value="Sunday">Sunday</option>' +
                            '</select>' +
                        '</div>' +
                    '</div>' +

                    '<div class="city-area-group">' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="city_id[]" class="select2 form-control cities" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="area_id[]" class="select2 form-control areas" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                    '</div>' +


                    '<div class="col-sm-1">' +
                        '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark"></i></button>' +
                    '</div>' +
            '</div>';

            var newRow = $(html);

            $("#append_area").append(newRow);

            // Initialize select2 for new row
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Option',
                allowClear: true,
                dropdownParent: newRow
            });

            // Get cities for new row
            get_cities(newRow.find('.cities'));
            get_areas(newRow.find('.areas'));


            // bootstrap-selectpicker refresh
            newRow.find('.selectpicker').selectpicker('refresh');
        });


        // Remove row
        $(document).on("click", ".remove_row", function(e) {
            e.preventDefault();
            $(this).closest(".appended-row").remove();
        });


        //=========== End add   row Ajax Request ===========//

        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    
                    emp_name: {
                        required: true,
                    },
                    
                    
                    phone: {
                        required: true
                    },
                },
                messages: {
                    emp_name: {
                        required: "Please Enter Employee Name",
                    },
                    phone: {
                        required: "Please Enter Phone",
                    },
                    
                    
                },


        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_employee") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Data Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else if (response.status == "name_Exist") {
                            Swal.fire({ 
                                    title: "Data Exist!",
                                    text: "This Data Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: 'edit_employee/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#emp_id').val(response.data.id);
                    $('#emp_name').val(response.data.emp_name);
                    $('#father_name').val(response.data.father_name);
                    $('#email').val(response.data.email);
                    $('#cnic').val(response.data.cnic);
                    $('#phone').val(response.data.phone); 
                    $('#designation').val(response.data.designation); 
                    $('#emergency_contact').val(response.data.emergency_contact); 
                    $('#address').val(response.data.address); 
                    $('#monthly_salary').val(response.data.monthly_salary); 

                    //  image 
                    if (response.data.emp_image && response.data.emp_image !== "") {
                        var newFile = 'uploads/emp_image/' + response.data.emp_image;
                    } else {
                        var newFile = 'uploads/no_image.png';
                    }
                    // Destroy Dropify instance if it's a file input
                    var dropifyElement = $('#emp_image').dropify();
                    dropifyElement = dropifyElement.data('dropify');
                    dropifyElement.destroy();
                    // Update the data-default-file attribute with the new image
                    $('#emp_image').attr('data-default-file', newFile);
                    // Reinitialize Dropify
                    $('#emp_image').dropify({
                        defaultFile: newFile
                    });
                    // Optionally reset and show the preview
                    dropifyElement.resetPreview();
                    dropifyElement.clearElement();
                    dropifyElement.settings.defaultFile = newFile;
                    dropifyElement.init();

                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    
                    name: {
                        required: true,
                    },
                    phone: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter First Name",
                    },
                    phone: {
                        required: "Please Enter Phone",
                    },
                    
                },


        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_employee") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else if (response.status == "cnic_Exist") {
                            Swal.fire({ 
                                    title: "Data Exist!",
                                    text: "This Data Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Data');
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Update  Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: 'delete_employee/'+id,
                            type : "GET",
                            success : function(response){
                                if (response.status == 200)
                                {
                                    toastr.success('Data Has Been Deleted Seccussfully!', 'Successfull!');
                                    loadData();
                                }else {
                                    Swal.fire({
                                                title: "Somthing Wrong!",
                                                text: "Sonthing Went Wrong Please Try Again!",
                                                type: "error",
                                                customClass: "sweet-alert",
                                            });
                                }
                            }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
        });
        //=========== End Lounch View Modal On Click View Btn ===========//


      
         
        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_employees") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "emp_name" },
                { data: "phone" },
                { data: "cnic" },
                { data: "emp_image" },

                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1,4,5] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 4, 7, 9],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();
        //==========For Add===========//
        $('#image-input').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#uploaded-photo').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //==========For Update===========//
        $('#up_image').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#upload_teacher_image').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });
        //=========== End Custom Search Box ===========//




    });
</script>
    @endif
@endsection