@extends('admin.main_layout')

@section('css_code')
    {{-- <link rel="stylesheet" href="{{ asset('backend/css/pos_bill.css') }}"> --}}
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Invoice</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Invoice ( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            {{-- <div id="counting_panel">
                <div class="page-header counting round-corner-left">Subtotal <br> <b>50005</b></div>
                <div class="page-header counting">Paid <br> <b>300005</b></div>
                <div class="page-header counting">Pending <br> <b>20000</b></div>
                <div class="page-header counting round-corner-right">Total <br> <b>300050</b></div>
            </div> --}}
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>
@endsection

@section('page_content')

    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        {{-- <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                        <div class="form-group">
                            <select id="status" class="select2 form-control" style="width: 200px">
                                
                                <option value="all">All</option>
                                <option value="Waiting" selected>Waiting</option>
                                <option value="Delivered">Delivered</option>
                                <option value="Cancelled">Cancelled</option>
                            </select>
                        </div> --}}
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_invoice'))
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Invoice</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Token #</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Token Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Patient Name</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Doctor Name</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Doctor Fee</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Buttons</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Invoice Date</th>
                            <th width="10%">Customer</th>
                            <th width="10%">Salesman</th>
                            <th width="10%">Subtotal</th>
                            <th width="5%">Dis %</th>
                            <th width="5%">Dis Amt</th>
                            <th width="10%">Total</th>
                            <th width="10%">Paid</th>
                            <th width="10%">Due</th>
                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-lg" style="width: 80%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Invoice</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">

                                @if (Auth::user()->hasRole('Super Admin'))
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <select id="users" name="salesman_id" class="select2 form-control" style="width: 100%">
                                                <option></option>
                                            </select>
                                        </div>
                                    </div>
                                @endif


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <div style="display: flex">
                                            <select id="customers" name="cus_id" class="select2 form-control" style="width: 100%;">
                                                <option></option>
                                            </select>
                                            {{-- <button id="add_customer_btn1" data-toggle="tooltip" title="Add New Customer" style="margin-left: 5px;" class="btn btn-success btn-icon"><i class="fa-duotone fa-circle-plus"></i></button> --}}
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash" selected>Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>

                              
                                <div class="col-sm-4" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <input type="hidden" id="invoice_date" name="invoice_date" value="{{ date('d-m-Y') }}">
                                   
                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <input type="text" name="detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Note:</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="product_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 20%">Product Name</th>
                                                <th style="width: 10%" class="text-center">SKU</th>
                                                <th style="width: 10%" class="text-center">Batch No</th>

                                                <th style="width: 10%" class="text-center">Price</th>
                                                <th style="width: 10%" class="text-center">Stock</th>
                                                <th style="width: 10%" class="text-center">Qty</th>
                                                <th style="width: 10%" class="text-center">Discount (%)</th>
                                                <th style="width: 10%" class="text-center">Discount(AMT)</th>
                                                <th style="width: 15%" class="text-center">Total</th>
                                                <th style="width: 5%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <select id="products" name="pro_id[]" class="select2 form-control products" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_sku[]" class="form-control text-center pro_sku" placeholder=" " readonly>
                                                </td>
                                                <td>
                                                    <select id="batch_no" name="batch_no[]" class="select2 form-control batch_no" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                   
                                                </td>
                                                <td class="text-center">
                                                    <input type="hidden" name="pro_cost[]" class="form-control text-center pro_cost" placeholder=" ">
                                                    <input type="text" name="pro_sale[]" class="form-control text-center pro_sale" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="dis_percent[]" id="dis_percent" class="form-control text-center dis_percent" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                   <input type="text" name="dis_amt[]" id="dis_amt" class="form-control text-center dis_amt" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="7">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Subtotal:
                                                    <input type="hidden" name="subtotal" id="subtotal" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="subtotal_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="6">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Discount (%) (AMT):
                                                </td>
                                                <td class="text-center" id="total_rate" style="font-weight: bold">
                                                    <div style="display: flex">
                                                        <input type="text" name="total_dis_per" id="total_dis_per" class="form-control text-center" placeholder=" " value="0" style="margin-right: 5px">
                                                        <input type="text" name="total_dis_amt" id="total_dis_amt" class="form-control text-center" placeholder=" " value="0">
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="6">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Grand Total:
                                                    <input type="hidden" name="grand_total" id="grand_total" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="grand_total_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="6">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Paid:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="number" name="paid" id="paid" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="6">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Due:
                                                    <input type="hidden" name="due" id="due" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="due_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save Sale</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-lg" style="width: 90%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Sale</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">

                                @if (Auth::user()->hasRole('Super Admin'))
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <select id="u_users" name="salesman_id" class="select2 form-control" style="width: 100%">
                                                <option></option>
                                            </select>
                                        </div>
                                    </div>
                                @endif


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_customers" name="cus_id" class="select2 form-control" style="width: 100%;">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="hidden" id="u_invoice_id" name="invoice_id" class="form-control textbox" placeholder=" ">
                                        <input type="text" id="u_invoice_date" name="invoice_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Sale Date:</label>
                                    </div>
                                </div>
                              

                                  <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash" selected>Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>

                              
                                <div class="col-sm-4" id="u_bank_area">
                                    <div class="form-group">
                                        <select id="u_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                @if (Auth::user()->can('issue_invoice'))
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="invoice_status" name="status" class="form-control selectpicker">
                                            <option value="pending">Pending</option>
                                            <option value="approved">Approved</option>
                                        </select>
                                    </div>
                                </div>
                                @endif

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="detail" name="detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Note:</label>
                                    </div>
                                </div>


                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_product_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 25%">Product Name</th>
                                                <th style="width: 10%" class="text-center">SKU</th>
                                                <th style="width: 10%" class="text-center">Batch No</th>

                                                <th style="width: 10%" class="text-center">Sale</th>
                                                {{-- <th style="width: 10%" class="text-center">Stock</th> --}}
                                                <th style="width: 10%" class="text-center">Qty</th>
                                                <th style="width: 10%" class="text-center">Discount (%)</th>
                                                <th style="width: 10%" class="text-center">Discount(AMT)</th>
                                                <th style="width: 15%" class="text-center">Total</th>
                                                <th style="width: 5%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Subtotal:
                                                    <input type="hidden" name="subtotal" id="u_subtotal" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_subtotal_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Discount (%) (AMT):
                                                </td>
                                                <td class="text-center" id="total_rate" style="font-weight: bold">
                                                    <div style="display: flex">
                                                        <input type="text" name="total_dis_per" id="u_total_dis_per" class="form-control text-center" placeholder=" " value="0" style="margin-right: 5px">
                                                        <input type="text" name="total_dis_amt" id="u_total_dis_amt" class="form-control text-center" placeholder=" " value="0">
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Grand Total:
                                                    <input type="hidden" name="grand_total" id="u_grand_total" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_grand_total_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Paid:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="text" name="paid" id="u_paid" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Due:
                                                    <input type="hidden" name="due" id="u_due" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_due_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                   
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -30px;
                top: -500px;
            }
        }
    </style>

    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1"  >
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->

                    <div class="panel print_invoice">
					    <div class="panel-body">
					        <div class="invoice-masthead">
					            <div class="invoice-text">
					                <h3 class="h1 text-uppercase text-thin mar-no text-primary">INVOICE</h3>
					            </div>
					            <div class="invoice-brand" style="white-space:nowrap">
					                <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
					                    <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
					                </div>
					            </div>
					        </div>
					
					        <div class="row" style="margin-bottom: 20px; border-bottom: 2px solid #e0e0e0; padding-bottom: 15px;">
					            <div class="col-sm-12">
					                <div>
					                    <strong style="font-size: 16px; color: #333;">Company Information</strong><br>
					                    <span style="font-size: 14px; color: #666;"><i class="fa fa-map-marker"></i> Lumisun Tower Comm, 36 Civic Center Jinnah Garden Islamabad</span><br>
					                    <span style="font-size: 14px; color: #666;"><i class="fa fa-phone"></i> +92 3335170817</span>
					                </div>
					            </div>
					        </div>

					        <div class="invoice-bill row">
					            <div class="col-sm-6 text-xs-center">
					                <address>
                                        <span >Customer Name: </span>
					                    <strong class="text-main" id="cus_name"></strong><br>

					                    <span id="company_name"></span><br>
					                    <span id="phone"></span><br>
					                    <span id="address"></span>
					               </address>
					            </div>
					            <div class="col-sm-6 text-xs-center">
					                <table class="invoice-details">
					                    <tbody>
					                        <tr>
					                            <td class="text-main text-bold">Invoice #</td>
					                            <td class="text-right text-info text-bold" id="invoice_no"></td>
					                        </tr>
                                            <tr>
					                            <td class="text-main text-bold">Billing Date</td>
					                            <td class="text-right" id="inv_date"></td>
					                        </tr>

					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					
					        <div class="row">
					            <div class="col-lg-12 table-responsive">
					                <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
					                    <thead>
					                        <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
					                            <th class="text-uppercase">Products</th>
                                                <th class="min-col text-center text-uppercase">Batch No</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
					                            <th class="min-col text-center text-uppercase">Qty</th>
					                            <th class="min-col text-center text-uppercase">Dis %</th>
					                            <th class="min-col text-center text-uppercase">Dis Amt</th>
					                            <th class="min-col text-right text-uppercase">Total</th>
					                        </tr>
					                    </thead>
					                    <tbody>
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					        <div class="clearfix">
					            <table class="table invoice-total">
					                <tbody>
					                    <tr>
					                        <td><strong>Subtotal :</strong></td>
					                        <td id="view_subtotal"></td>
					                    </tr>
                                        <tr>
					                        <td><strong id="view_dis_per">Discount :</strong></td>
					                        <td id="view_dis_amt"></td>
					                    </tr>
                                        <tr>
					                        <td><strong>Total :</strong></td>
					                        <td class="text-bold h4" id="view_total"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Paid :</strong></td>
					                        <td id="view_paid"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Due :</strong></td>
					                        <td  id="view_due"></td>
					                    </tr>
					                </tbody>
					            </table>
					        </div>

                            <div class="text-center no-print">
					            <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
					        </div>
					
					    </div>
					</div>
                        
                    </div>
                    <!--end::Scroll-->
                
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->


    <!--Start cus Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_customer_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Customer</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_customer_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="cus_name" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Customer Name</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="company_name" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Company Name</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="phone_1" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Phone No</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="email" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Email</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="perm_address" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Address</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_customer_btn">Save Customer</button>
                    <button data-dismiss="modal" class="btn btn-default close_customer_modal" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->




@endsection



@section('javascript_code')
<script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });
    }); 
</script>


<script>
    $(document).ready(function(){

        $('.select2').select2();


        $('#invoice_date').daterangepicker({
            // autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#invoice_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_invoice_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_invoice_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });


        //=========== Insert Data Ajax Request ===========//
        $("#add_customer_btn1").click(function(e){
            e.preventDefault();
            $("#add_modal").modal('hide');
            $("#add_customer_modal").modal('show');
            
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Data Ajax Request ===========//
        $(".close_customer_modal").click(function(e){
            e.preventDefault();
            $("#add_modal").modal('show');
            $("#add_customer_modal").modal('hide');
            
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Insert Form Validation ===========//
        $("#add_customer_form").validate({
                rules: {
                    cus_name: {
                        required: true,
                    },
                    phone_1: {
                        required: true,
                    },
                    
                },
                messages: {
                    cus_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_1: {
                        required: "Please enter Supplier Name",
                    },
                },

                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_customer_btn").click(function(e){
            e.preventDefault();
            if($("#add_customer_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_customer_form')[0]);

                $.ajax({
                    url: '{{ route("insert_customer") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Customer Saved Successfully!', 'Successfull!');
                            $('#add_customer_modal').find('form')[0].reset();
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                            $("#add_modal").modal('show');
                            $("#add_customer_modal").modal('hide');
                        }else if (response.status == "customerExist") {
                            Swal.fire({ 
                                    title: "Customer Exist!",
                                    text: "This Customer Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select id="products" name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td>'+
                                '<select name="batch_no[]" class="select2 form-control batch_no" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="hidden" name="pro_cost[]" class="form-control text-center pro_cost" placeholder=" ">'+
                                '<input type="text" name="pro_sale[]" class="form-control text-center pro_sale" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="dis_percent[]" id="dis_percent" class="form-control text-center dis_percent" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="dis_amt[]" id="dis_amt" class="form-control text-center dis_amt" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#product_table > tbody:last").append(newRow);

            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Agar batch_no bhi select2 hai to yaha initialize karo
            newRow.find('.batch_no').select2({
                width: '100%',
                placeholder: 'Select Batch',
                allowClear: true,
                dropdownParent: $('#add_modal')
            });

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#add_modal');
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select id="products" name="pro_id[]" class="demo_select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td>'+
                                '<select name="batch_no[]" class="select2 form-control batch_no" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="hidden" name="pro_cost[]" class="form-control text-center pro_cost" placeholder=" ">'+
                                '<input type="text" name="pro_sale[]" class="form-control text-center pro_sale" placeholder=" ">'+
                            '</td>'+
                            // '<td class="text-center">'+
                            //     '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" ">'+
                            // '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="dis_percent[]" id="dis_percent" class="form-control text-center dis_percent" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="dis_amt[]" id="dis_amt" class="form-control text-center dis_amt" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_product_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#update_modal');
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Remove Row Button ===========//
        // Delegate event to remove row
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalRate();
            updatecalculateTotalRate();
        });
        //=========== End Remove Row Button ===========//

        //=========== Get Lab Tests On Load ===========//
        get_products($('#products'), '#add_modal');
        get_products($('#uproducts'), '#update_modal');
        get_customers($('#u_customers'), '#update_modal');

           
        $('.products').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('.products').parent() // Set to the parent element of the select box
        });
        $('#u_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('#u_pro_id').parent() // Set to the parent element of the select box
        });
        get_products();
        // =======================get ===============================
        function get_products(selectElement = $('.products'), selectedValue = null) {
            $.ajax({
                url: '/get_products',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                    selectElement.each(function() {
                        var $this = $(this);
                        $this.empty(); // Clear existing options
                        $this.append('<option></option>'); // Add an empty default option

                        // Append fetched products to the select element
                        $.each(data, function(i, item) {
                            $this.append($('<option>', {
                                value: item.id,
                                text: item.pro_name
                            }));
                        });

                        // Set the selected value if provided
                        if (selectedValue) {
                            $this.val(selectedValue).trigger('change'); 
                        }
                    });
                }
            });
        }
        // =======================get ===============================
        //=========== End Get Patients On Load ===========//

        //=========== Start Custom Status Dropdown ===========//

        $(document).on('change', '.products', function() {
            var id = $(this).val();
            var tr = $(this).closest('tr');

            // Check modal context
            var salesman_id;
            if ($(this).closest('#add_modal').length) {
                salesman_id = $('#users').val(); // Add modal
            } else if ($(this).closest('#update_modal').length) {
                salesman_id = $('#u_users').val(); // Update modal
            } else {
                salesman_id = $('#users').val(); // Default fallback
            }

            $.ajax({
                url: '/edit_saleman_product/' + id,
                method: 'GET',
                data: { salesman_id: salesman_id },
                dataType: "json",
                success: function(data) {
                    tr.find('.pro_sku').val(data.data.sku);
                    tr.find('.pro_cost').val(data.total_cost);
                    tr.find('.pro_sale').val(data.data.sale_price);
                    tr.find('.pro_stock').val(data.total_qty);
                    tr.find('.pro_qty').val(1);
                    tr.find('.dis_percent').val(0);
                    tr.find('.dis_amt').val(0);
                    tr.find('.total').val(data.data.sale_price);

                    // 👉 Batch select per-row
                    var batchSelect = tr.find('.batch_no');
                    batchSelect.empty().append('<option></option>');

                    if (data.batches) {
                        $.each(data.batches, function(key, value) {
                            batchSelect.append('<option value="' + value.id + '">' + value.batch_no + '</option>');
                        });
                    }

                    // Re-initialize select2 only for this row
                    batchSelect.select2({
                        width: '100%',
                        placeholder: 'Select Batch',
                        allowClear: true,
                        dropdownParent: tr.closest('table') // ya modal context me
                    });

                    batchSelect.trigger('change');

                    loadpdata(tr, id);

                    calculateTotalRate();
                    updatecalculateTotalRate();
                }
            });
        });

        function loadpdata(tr, prodid) {
            $.ajax({
                url: "/get-sale-product", // Laravel route
                method: "POST",
                data: {
                    prodid: prodid,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    var batchSelect = tr.find('.batch_no');
                    batchSelect.empty().append('<option></option>'); // clear first

                    $.each(data, function(i, item) {
                        batchSelect.append($('<option>', {
                            value: item.batch,
                            text: item.batch,
                            selected: (i === 0) // 👈 first batch selected by default
                        }));
                    });

                    tr.find(".pro_cost").val(data[0]["purchase_price"]);
                    tr.find(".pro_sale").val(data[0]["sale_price"]);
                    tr.find(".total").val(tr.find(".pro_sale").val() * tr.find(".pro_qty").val());

                    calculateTotalRate();
                    updatecalculateTotalRate()
                },
                error: function(xhr) {
                    alert(xhr.responseJSON.message || "Error fetching data");
                }
            });
        }


        $(document.body).on('change', '.batch_no', function(e) {

            var batch = this.value;
            var tr = $(this).closest('tr'); // same as parent().parent()

            $.ajax({
                url: "/getBatchData",  // Laravel route
                method: 'POST',
                data: {
                    batch: batch,
                    _token: $('meta[name="csrf-token"]').attr('content') // CSRF token
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);

                    tr.find(".pro_sale").val(data.sale_price);
                    tr.find(".pro_cost").val(data.purchase_price);
                    // tr.find(".pro_stock").val(data.stock);
                    tr.find(".total").val(tr.find(".pro_sale").val() * tr.find(".pro_qty").val());

                    calculateTotalRate();
                    updatecalculateTotalRate()
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });

        });
        //=========== End Custom Status Dropdown ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste click', '.pro_qty', function() {
            var qty = $(this).val();
            var tr = $(this).closest('tr');

            var pro_sale = qty * tr.find('.pro_sale').val();
            var dis_per = tr.find('.dis_percent').val();

            var dis_amt = pro_sale / 100 * dis_per;

            tr.find('.dis_amt').val(dis_amt);

            tr.find('.total').val(parseFloat((qty * tr.find('.pro_sale').val())-(tr.find('.dis_amt').val())).toFixed(0));
            

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//


        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '.dis_percent', function() {
            var dis_per = $(this).val();
            var tr = $(this).closest('tr');

            var pro_sale = tr.find('.pro_qty').val() * tr.find('.pro_sale').val();

            var dis_amt = pro_sale / 100 * dis_per;

            tr.find('.dis_amt').val(dis_amt);

            tr.find('.total').val(parseFloat((tr.find('.pro_qty').val() * tr.find('.pro_sale').val())-tr.find('.dis_amt').val()).toFixed(0));
            

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '.dis_amt', function() {
            var dis_amt = $(this).val();
            var tr = $(this).closest('tr');

            var pro_sale = tr.find('.pro_qty').val() * tr.find('.pro_sale').val();

            var dis_per = dis_amt / pro_sale * 100;

            tr.find('.dis_percent').val(dis_per);

            tr.find('.total').val(parseFloat((tr.find('.pro_qty').val() * tr.find('.pro_sale').val())-tr.find('.dis_amt').val()).toFixed(0));
            

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#total_dis_per', function() {
            var dis_per = $(this).val();

            var subtotal = $('#subtotal').val();

            var dis_amt = subtotal / 100 * dis_per;

            $('#total_dis_amt').val(dis_amt);

            calculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#total_dis_amt', function() {
            var dis_amt = $(this).val();

            var subtotal = $('#subtotal').val();

            var dis_per = dis_amt / subtotal * 100;

            $('#total_dis_per').val(dis_per);

            calculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_total_dis_per', function() {
            var dis_per = $(this).val();

            var subtotal = $('#u_subtotal').val();

            var dis_amt = subtotal / 100 * dis_per;

            $('#u_total_dis_amt').val(dis_amt);

            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_total_dis_amt', function() {
            var dis_amt = $(this).val();

            var subtotal = $('#u_subtotal').val();

            var dis_per = dis_amt / subtotal * 100;

            $('#u_total_dis_per').val(dis_per);

            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_paid', function() {

            calculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_paid', function() {

            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '.pro_sale', function() {
            var pro_sale = $(this).val();
            var tr = $(this).closest('tr');

            var pro_sale = tr.find('.pro_qty').val() * tr.find('.pro_sale').val();
            var dis_per = tr.find('.dis_percent').val();

            var dis_amt = pro_sale / 100 * dis_per;

            tr.find('.dis_amt').val(dis_amt);

            tr.find('.total').val(parseFloat((tr.find('.pro_qty').val() * pro_sale)-tr.find('.dis_amt').val()).toFixed(0));
            

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#paid', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ============//


        function calculateTotalRate() {
            var subtotal = 0;

            $('#product_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    subtotal += rate;
                }
            });
            $('#subtotal_text').text(subtotal.toFixed(0));
            $('#subtotal').val(subtotal.toFixed(0));

            $('#grand_total_text').text((subtotal - $('#total_dis_amt').val()).toFixed(0));
            $('#grand_total').val((subtotal - $('#total_dis_amt').val()).toFixed(0));

            $('#due_text').text(($('#grand_total').val() - $('#paid').val()).toFixed(0));
            $('#due').val(($('#grand_total').val() - $('#paid').val()).toFixed(0));

        }

        
        function updatecalculateTotalRate() {
            var subtotal = 0;

            $('#update_product_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    subtotal += rate;
                }
            });
            $('#u_subtotal_text').text(subtotal.toFixed(0));
            $('#u_subtotal').val(subtotal.toFixed(0));

            $('#u_grand_total_text').text((subtotal - $('#u_total_dis_amt').val()).toFixed(0));
            $('#u_grand_total').val((subtotal - $('#u_total_dis_amt').val()).toFixed(0));

            $('#u_due_text').text(($('#u_grand_total').val() - $('#u_paid').val()).toFixed(0));
            $('#u_due').val(($('#u_grand_total').val() - $('#u_paid').val()).toFixed(0));

        }

        // customers 
        $('#customers').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#customers').parent() // Set to the parent element of the select box
        });
        $('#u_customers').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#u_customers').parent() // Set to the parent element of the select box
        });
        get_customers();
        function get_customers(){
            $.ajax({
            url:'/get_customers',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                  

                    $.each(data,function(i,item){
                    if($('#u_customers option[value="' + data[i].id + '"]').length == 0){
                        $('#u_customers').append($('<option>',{
                        value: data[i].id,
                        text: data[i].name,
                        }));
                    }
                    });
                    
                }
            });
        };

        @if (Auth::user()->hasRole('Super Admin'))
            // Super Admin: salesman select kare, phir customers laayen
            $('#users').on('change', function() {
                var salesman_id = $(this).val();
                $('#customers').empty().append('<option></option>');
                if (salesman_id) {
                    $.ajax({
                        url: '/get_customers_by_salesman/' + salesman_id,
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            $.each(data, function(i, item) {
                                $('#customers').append($('<option>', {
                                    value: item.id,
                                    text: item.company_name || item.shop_name || item.name
                                }));
                            });
                            $('#customers').trigger('change');

                        }
                    });
                }
            });

        @else

            // Baaki users: apne related customers laayen (page load par)
            $.ajax({
                url: '/get_customers_by_salesman/{{ Auth::id() }}',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#customers').empty().append('<option></option>');
                    $.each(data, function(i, item) {
                        $('#customers').append($('<option>', {
                            value: item.id,
                            text: item.company_name ? item.company_name : item.name
                        }));
                    });
                    $('#customers').trigger('change');
                }
            });
        @endif
        // =======================get ===============================

          // salesman 
        $('#users').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select SaleMan',
            allowClear: true,
            dropdownParent: $('#users').parent() // Set to the parent element of the select box
        });
        $('#u_users').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select SaleMan',
            allowClear: true,
            dropdownParent: $('#u_users').parent() // Set to the parent element of the select box
        });
        get_users();
        // =======================get ===============================
        function get_users(){
            $.ajax({
            url:'/get_users',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#users option[value="' + data[i].id + '"]').length == 0){
                        $('#users').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                        if($('#u_users option[value="' + data[i].id + '"]').length == 0){
                            $('#u_users').append($('<option>',{
                            value: data[i].id,
                            text: data[i].name,
                            }));
                        }
                    });
                    
                }
            });
        };
        // =======================get ===============================

        // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================


        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
            rules: {
                cus_id: {
                    required: true,
                    minlength: 1
                },
                invoice_date: {
                    required: true
                },
                payment_type: {
                    required: true
                }
            },
            messages: {
                cus_id: {
                    required: "Please Select Customer",
                },
                invoice_date: {
                    required: "Please enter Invoice Date",
                },
                 payment_type: {
                    required: "Please select Payment Type",
                },
                
            },

            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_invoice") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Invoice Saved Successfully!', 'Successfull!');
                            
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Invoice');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            // invoice_print();
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save Sale');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
       
        $(document).on("click", '#edit_btn', function(event) {
            event.preventDefault();
            $("#update_modal").modal('show');

            var salesman_id = $('#u_users').val();

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_invoice/' + id,
                method: 'GET',
                data: { salesman_id: salesman_id },
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    if (data.status === 200) {
                        // Populate sale details
                        $('#u_invoice_id').val(data.sale.id);
                        $('#u_invoice_date').val(data.sale.invoice_date);
                        $('#detail').val(data.sale.detail);
                        $('#u_total_dis_per').val(data.sale.dis_percent || 0);
                        $('#u_total_dis_amt').val(data.sale.dis_amount || 0);
                        $('#u_subtotal').val(data.sale.subtotal);
                        $('#u_grand_total').val(data.sale.grand_total);
                        $('#u_paid').val(data.sale.paid);
                        $('#u_due').val(data.sale.due);
                        $('#invoice_status').val(data.sale.status).trigger('change');

                       
                        $('#u_users').empty();
                        var option = new Option(data.sale.salesman_name, data.sale.saleman_id, true, true);
                        $('#u_users').append(option).trigger('change');

                        console.log('salesman salesman_id:', $('#u_users').val());

                        $('#u_customers').empty();
                        var option = new Option(data.sale.customer_name, data.sale.cus_id, true, true);
                        $('#u_customers').append(option).trigger('change');

                        $('#u_banks').val(data.sale.bank_id).trigger('change');
                        $('#u_payment_type').val(data.sale.Payment_type).trigger('change');

                        // stock comment 
                        // <td class="text-center">
                        //     <input type="text" name="pro_stock[]" class="form-control text-center pro_stock" value="${item.pro_stock || 0}" readonly>
                        // </td>


                        // Populate product details
                        var html = '';
                        $.each(data.products, function(i, item) {
                            html += `
                                <tr>
                                    <td>
                                        <select name="pro_id[]" class="demo_select2 form-control products" style="width: 100%;">
                                            <option value="${item.pro_id}">${item.pro_name}</option>
                                        </select>

                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="pro_sku[]" class="form-control text-center pro_sku" value="${item.pro_sku || 0}" readonly>
                                    </td>
                                     <td class="text-center">
                                        <input type="number" name="batch_no[]" class="form-control text-center batch_no" value="${item.batch_no || 0}" readonly>
                                    </td>
                                    <td class="text-center">
                                        <input type="hidden" name="pro_cost[]" class="form-control text-center pro_cost" value="${item.cost || 0}">
                                        <input type="text" name="pro_sale[]" class="form-control text-center pro_sale" value="${item.sale_price || 0}">
                                    </td>
                                    
                                    <td class="text-center">
                                        <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" value="${item.pro_qty || 0}" required>
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="dis_percent[]" class="form-control text-center dis_percent" value="${item.dis_per || 0}">
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="dis_amt[]" class="form-control text-center dis_amt" value="${item.dis_amount || 0}">
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="total[]" class="form-control text-center total" value="${item.total || 0}">
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove">
                                            <i class="fa-solid fa-xmark-large"></i>
                                        </button>
                                    </td>
                                </tr>`;
                        });

                        $("#update_product_table > tbody").empty();
                        $("#update_product_table > tbody:last").append(html);

                        // Reinitialize Select2 for new rows
                        // get_products($("#update_product_table .products"), '#update_modal');
                        $("#update_product_table .demo_select2 ").select2({
                            placeholder: "Select Product",
                            allowClear: true
                        });


                        updatecalculateTotalRate();
                    } else {
                        alert(data.message || "Error fetching data");
                    }

                }
            });
        });

        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                status:{
                    required: true,
                    equalToApproved: true // custom rule
                }
            },
            messages: {
                status: {
                    required: "Please select data",
                    equalToApproved: "You must select 'Approved' to update."
                }
            },


            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        // Custom validation method
        $.validator.addMethod("equalToApproved", function(value, element) {
            return value === "approved";
        }, "You must select 'Approved' to update.");
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_invoice") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Data');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Data');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_invoice/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#cus_name').text(data.sale.name);
                    // $('#company_name').text(data.sale.company_name);
                    $('#phone').text(data.sale.phone_1);
                    $('#address').text(data.sale.perm_address);
                    $('#invoice_no').text(data.sale.id);
                    $('#inv_date').text(data.sale.invoice_date);
                    $('#view_subtotal').text(data.sale.subtotal);
                    $('#view_dis_per').text("Discount : (" + data.sale.dis_percent+" %)");
                    $('#view_dis_amt').text(data.sale.dis_amount);
                    $('#view_total').text(data.sale.grand_total);
                    $('#view_paid').text(data.sale.paid);
                    $('#view_due').text(data.sale.due);

                    var html = '';

                    $.each(data.products, function(i, item) {

                        html += '<tr>'+
                                    '<td class="text-center">'+
                                        data.products[i].no +
                                    '</td>'+
                                    '<td>'+
                                        data.products[i].pro_name +
                                    '</td>'+
                                    '<td class="text-center">'+
                                        data.products[i].batch_no +
                                    '</td>'+
                                    '<td class="text-center">'+
                                    data.products[i].sale_price +
                                    '</td>'+
                                    '<td class="text-center">'+
                                      data.products[i].pro_qty +
                                    '</td>'+
                                    '<td class="text-center">'+
                                        data.products[i].dis_per +
                                    '</td>'+
                                    '<td class="text-center">'+
                                       data.products[i].dis_amount +
                                    '</td>'+
                                    '<td class="text-right">'+
                                        data.products[i].total+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#invoice_table > tbody").empty();
                    $("#invoice_table > tbody:last").append(newRow);

                }
            });
        });

        //=========== View Order Booker Record from Invoice Section ===========//
        $(document).on("click", '#view_ob_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_order_booker/'+id,
                method: 'GET',
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#cus_name').text(data.sale.name);
                    $('#phone').text(data.sale.phone_1);
                    $('#address').text(data.sale.perm_address);
                    $('#invoice_no').text('OB-' + data.sale.id);
                    $('#inv_date').text(data.sale.invoice_date);
                    $('#view_subtotal').text(data.sale.subtotal);
                    $('#view_dis_per').text("Discount : (" + data.sale.dis_percent+" %)");
                    $('#view_dis_amt').text(data.sale.dis_amount);
                    $('#view_total').text(data.sale.grand_total);
                    $('#view_paid').text(data.sale.paid);
                    $('#view_due').text(data.sale.due);

                    var html = '';

                    $.each(data.products, function(i, item) {

                        html += '<tr>'+
                                    '<td class="text-center">'+
                                        data.products[i].no +
                                    '</td>'+
                                    '<td>'+
                                        data.products[i].pro_name +
                                    '</td>'+
                                    '<td class="text-center">-</td>'+
                                    '<td class="text-center">'+
                                    data.products[i].sale_price +
                                    '</td>'+
                                    '<td class="text-center">'+
                                      data.products[i].pro_qty +
                                    '</td>'+
                                    '<td class="text-center">'+
                                        data.products[i].dis_per +
                                    '</td>'+
                                    '<td class="text-center">'+
                                       data.products[i].dis_amount +
                                    '</td>'+
                                    '<td class="text-right">'+
                                        data.products[i].total+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#invoice_table > tbody").empty();
                    $("#invoice_table > tbody:last").append(newRow);

                }
            });
        });
        //=========== End View Order Booker Record ===========//


        function invoice_print() {
            $("#view_modal").modal('show');
            $.ajax({
                url: '{{ route("invoice_print") }}',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data.status === 200) {
                        // Populate modal fields
                        
                    $('#invoice_no').text(" " + data.sale.id);
                    $('#cus_name').text(" " + data.sale.customer_name);
                    $('#inv_date').text(" " + data.sale.invoice_date);
                    $('#view_subtotal').text(data.sale.subtotal);
                    $('#view_dis_per').text("Discount : (" + data.sale.dis_percent+" %)");
                    $('#view_dis_amt').text(data.sale.dis_amount);
                    $('#view_total').text(data.sale.grand_total);
                    $('#view_paid').text(data.sale.paid);
                    $('#view_due').text(data.sale.due);

                        var html = '';

                        // Populate products table
                        $.each(data.products, function(i, item) {
                            html += '<tr>'+
                                        '<td class="text-center">'+ item.no +'</td>'+
                                        '<td>'+ item.pro_name +'</td>'+
                                        '<td class="text-center">'+ item.batch_no +'</td>'+
                                        '<td class="text-center">'+ item.sale_price +'</td>'+
                                        '<td class="text-center">'+ item.pro_qty +'</td>'+
                                        '<td class="text-center">'+ item.dis_per +'</td>'+
                                        '<td class="text-center">'+ item.dis_amount +'</td>'+
                                        '<td class="text-right">'+ item.total +'</td>'+
                                    '</tr>';
                        });

                        $("#invoice_table > tbody").empty().append(html);
                    } else {
                        console.error('Sale not found');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching invoice:', error);
                }
            });
        }

        //=========== End Lounch View Modal On Click View Btn ===========//


        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_invoice/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Data Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_invoices") }}',
                type: 'post',
                data: { _token: csrf._token, startdate: "", enddate: "", search: "", type: "" }
            },
            columns: [
                { data: "id" },
                { data: "invoice_date" },
                { data: "cus_name" },
                { data: "saleman_name" },
                { data: "subtotal" },
                { data: "dis_percent" },
                { data: "dis_amount" },
                { data: "grand_total" },
                { data: "paid" },
                { data: "due" },
                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 3, 4, 5, 6, 7, 8, 9] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 3, 4, 5, 6, 7, 8, 9],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

    
        // Example usage: Call the function with updated dates
        loadData("", "", "", );

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val());
        });
        //=========== End Custom Search Box ===========//

        $("#status").select2({
            placeholder: "Filter By Status",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });


        //=========== Start Custom Status Dropdown ===========//
        $('#status').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }
            
        });
        //=========== End Custom Status Dropdown ===========//


        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
        	//=========== Start Date Range Picker ===========//
    	    var start = moment().subtract(29, 'days');
    	    var end = moment();

    	    function cb(start, end) {
    	        $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
    	    }

    	    $(datepickerid).daterangepicker({
    	    	autoUpdateInput: false,
    	        format: 'DD-MM-YYYY',
    	        startDate: start,
    	        endDate: end,
    	        showCustomRangeLabel: false,
    	        alwaysShowCalendars: true,
    	        ranges: {
    	           'Today': [moment(), moment()],
    	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    	           'This Month': [moment().startOf('month'), moment().endOf('month')],
    	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    	        }
    	    }, cb);

    	    cb(start, end);
    	    //=========== End Date Range Picker ===========//



    	    //=========== Start Date Range On Apply ===========//
    	    //Filter the datatable on the datepicker apply event
    		$(datepickerid).on('apply.daterangepicker', function(ev, picker)
    		{
    		    startdate=picker.startDate.format('DD-MM-YYYY');
    		    enddate=picker.endDate.format('DD-MM-YYYY');
    		    $(datepickerid).val(startdate + ' To ' + enddate);
    		 
    		    // alert(startdate+" "+enddate);

    		    // $('#main_table').DataTable().destroy();

    		    // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
    		    loadData($('#search').val(), startdate, enddate);

    		 
    		});

    		//Click on cancel Button
    		$(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
    		  //do something, like clearing an input
    		  $(datepickerid).val('');
    		});
    		//=========== End Date Range On Apply ===========//

    		//Click on Refresh Data
    		$('#refresh_data').on('click', function() {
    		  //do something, like clearing an input
    		  $(datepickerid).val('');
    		  loadData("", today_Date, today_Date );
    		});
    		//=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//





    });
</script>
@endsection