@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
    .custom-dropify .dropify-wrapper {
        max-width: 200px;  
        height: 70px;  
    }

     
    .custom-dropify .dropify-wrapper .dropify-message p {
        font-size: 12px;  
    }
    
    </style>


@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> All Reports Data - Main Stock</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Reports</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        {{-- <div class="col-md-6"> 
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div>
                <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div>
            </div> 
        </div> --}}
    </div>
@endsection

@section('page_content')

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>

                        {{-- search by date  --}}
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        {{-- <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New  Stock</button> --}}
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Product </a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">SKU </a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Date  </a></li>


                                <li><a href="#" class="toggle-vis" data-column="5">In qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Out qty</a></li>

                                <li><a href="#" class="toggle-vis" data-column="7">Adjustment</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Product </th>
                            <th width="10%">SKU </th>
                            <th width="10%">Date</th>
                            <th width="10%">In qty</th>
                            <th width="10%">Out qty</th>
                            <th width="15%">Adjustment</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
   


@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

{{-- today date function  --}}
<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("pur_date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>

<script>


    $(document).ready(function(){

        $('.select2').select2();


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_main_stock_report") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "pro_name" },
                { data: "sku" },
                { data: "created_at" },
                { data: "stock_in_qty" },
                { data: "stock_out_qty" }, 

                { data: "adjustment" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                // { className: 'text-center td-30', targets: [3, 5] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });

        
        //=========== End Custom Search Box ===========//

        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//



            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
            
                // alert(startdate+" "+enddate);

                // $('#main_table').DataTable().destroy();

                // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
                loadData($('#search').val(), startdate, enddate);

            
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
                //do something, like clearing an input
                $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
                //do something, like clearing an input
                $(datepickerid).val('');
                loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//



    });



</script>






@endsection