@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
    .custom-dropify .dropify-wrapper {
        max-width: 200px;  
        height: 70px;  
    }

     
    .custom-dropify .dropify-wrapper .dropify-message p {
        font-size: 12px;  
    }
    
    </style>


@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">SalesMan Order Return For Stock</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Orders Return( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                {{-- <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div> --}}
                {{-- <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div> --}}
            </div>
      
        </div>
    </div>
@endsection

@section('page_content')

    {{-- datatable  --}}
    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_order_return'))
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Order Return</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Sale Man</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Description</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Status </a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Buttons</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Sale Man</th>
                            <th width="10%">Description</th>
                            <th width="10%">Status </th>
                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Order Return</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">

                                   @if (Auth::user()->hasAnyRole(['Super Admin']))
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <select id="users" name="salesman_id" class="select2 form-control" style="width: 100%">
                                                    <option></option>
                                                </select>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <input type="date" name="date" class="form-control textbox" value="{{ date('Y-m-d') }}">
                                            <label class="control-label textboxlabel">Date:</label>
                                        </div>
                                    </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" id="" name="description" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Description:</label>
                                    </div>
                                </div>

                            </div>

                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>

                                                <th style="width: 50%">Product Name</th>
                                                <th style="width: 25%" class="text-center">Product Stock</th>
 
                                                <th style="width: 25%" class="text-center">Qty</th> 
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                           
                                              
                                                <td>
                                                    <select id="pro_id" name="pro_id[]" class=" select2 form-control products " style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>
                                                </td> 
                                                <td class="text-center">
                                                    <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">
                                                </td> 
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">
                                                    
                                                </td>
                                                <td>
                                                    
                                                </td> 
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                          
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Order</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">

                            <input type="hidden" id="u_order_return_id" name="order_return_id">

                            <div class="col-sm-12 plr-0">
                               

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_users" name="salesman_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="date" id="date" name="date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Date:</label>
                                    </div>
                                </div>

                                @if (Auth::user()->can('issue_order'))
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="order_status" name="order_status" class="form-control selectpicker">
                                            <option value="pending">Pending</option>
                                            <option value="approved">Approved</option>
                                        </select>
                                    </div>
                                </div>
                                @endif

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" id="description" name="description" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Description:</label>
                                    </div>
                                </div>

                            </div>

                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 50%">Product Name</th>
                                                <th style="width: 25%" class="text-center">Stock</th>
 
                                                <th style="width: 25%" class="text-center">Qty</th> 
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- data in javascript --}}
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">
                                                    
                                                </td>
                                                <td>
                                                    
                                                </td>
                                                
                                                <td class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                           
                                            </tr>
                                            
                                        </tfoot>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    @if (Auth::user()->can('update_order'))
                    <button class="btn btn-primary" id="update_btn">Update </button>
                    @endif 

                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->

    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -30px;
                top: -500px;
            }
        }
    </style>


    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->

                    <div class="panel print_invoice">
					    <div class="panel-body">
					        <div class="invoice-masthead">
					            <div class="invoice-text">
					                <h3 class="h1 text-uppercase text-thin mar-no text-primary">INVOICE</h3>
					            </div>
					            <div class="invoice-brand" style="white-space:nowrap">
					                <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
					                    <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
					                </div>
					            </div>
					        </div>
					
					        <div class="invoice-bill row">
					            <div class="col-sm-6 text-xs-center">
					                <address>
                                        <strong class="text-main">Customer: </strong>
					                    <strong class="text-main" id="cus_name"></strong><br>
                                        <strong class="text-main">Sale Man: </strong>
					                    <strong class="text-main" id="salesman_name"></strong><br>

					                    <span id="company_name"></span><br>
					                    <span id="phone"></span><br>
					                    <span id="address"></span>
					               </address>
					            </div>
					            <div class="col-sm-6 text-xs-center">
					                <table class="invoice-details">
					                    <tbody>
					                        <tr>
					                            <td class="text-main text-bold">Invoice #</td>
					                            <td class="text-right text-info text-bold" id="invoice_no"></td>
					                        </tr>
                                            <tr>
					                            <td class="text-main text-bold"> Date:</td>
					                            <td class="text-right" id="inv_date"></td>
					                        </tr>
					                        
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					
					        <div class="row">
					            <div class="col-lg-12 table-responsive">
					                <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
					                    <thead>
					                        <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
					                            <th class="text-uppercase">Product</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
					                            <th class="min-col text-center text-uppercase">Qty</th>
					                            <th class="min-col text-right text-uppercase">Total</th>
					                        </tr>
					                    </thead>
					                    <tbody>
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					        <div class="clearfix">
					            <table class="table invoice-total">
					                <tbody>
					                    <tr>
					                        <td><strong>Total :</strong></td>
					                        <td class="text-bold h4" id="view_total"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Paid :</strong></td>
					                        <td id="view_paid"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Due :</strong></td>
					                        <td  id="view_due"></td>
					                    </tr>
					                </tbody>
					            </table>
					        </div>

                            <div class="text-center no-print">
					            <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
					        </div>
					
					    </div>
					</div>
                        
                    </div>
                    <!--end::Scroll-->
                
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->

    <!--Start sus Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_customer_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Customer</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_customer_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="cus_name" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Customer Name</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="shop_name" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Shop Name</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="phone" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Phone No</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="cnic" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >CNIC</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="perm_address" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Address</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_customer_btn">Save Customer</button>
                    <button data-dismiss="modal" class="btn btn-default close_customer_modal" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->


@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

{{-- today date function  --}}
<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>
<script>
    // $(document).ready(function () {
    //     // Default hide
    //     $("#approved_btn").hide();

    //     // On change
    //     $("#order_status").on("change", function () {
    //         if ($(this).val() === "approved") {
    //             $("#approved_btn").show();
    //         } else {
    //             $("#approved_btn").hide();
    //         }
    //     });
    // });

</script>


<script>



    $(document).ready(function(){

        $('.select2').select2();


        //=========== Insert Data Ajax Request ===========//
        $("#add_customer_btn1").click(function(e){
            e.preventDefault();
            $("#add_modal").modal('hide');
            $("#add_customer_modal").modal('show');
            
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Data Ajax Request ===========//
        $(".close_customer_modal").click(function(e){
            e.preventDefault();
            $("#add_modal").modal('show');
            $("#add_customer_modal").modal('hide');
            
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Form Validation ===========//
        $("#add_customer_form").validate({
                rules: {
                    cus_name: {
                        required: true,
                    },
                    phone: {
                        required: true,
                    },
                    
                },
                messages: {
                    cus_name: {
                        required: "Please enter  Name",
                    },
                    phone: {
                        required: "Please enter phone",
                    },
                },

                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_customer_btn").click(function(e){
            e.preventDefault();
            if($("#add_customer_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_customer_form')[0]);

                $.ajax({
                    url: '{{ route("insert_customer") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Customer Saved Successfully!', 'Successfull!');
                            $('#add_customer_modal').find('form')[0].reset();
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                            $("#add_modal").modal('show');
                            $("#add_customer_modal").modal('hide');
                            get_customers();
                        }else if (response.status == "cnic_Exist") {
                            Swal.fire({ 
                                    title: "Customer Exist!",
                                    text: "This Customer Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_customer_btn').text('Save Customer');
                            $('#add_customer_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        // customers 
        $('#customers').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#customers').parent() // Set to the parent element of the select box
        });
        $('#u_customers').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#u_customers').parent() // Set to the parent element of the select box
        });
        get_customers();
        // =======================get ===============================
        function get_customers(){
            $.ajax({
            url:'/get_customers',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#customers option[value="' + data[i].id + '"]').length == 0){
                        $('#customers').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_customers option[value="' + data[i].id + '"]').length == 0){
                        $('#u_customers').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });
                }
            });
        };

        // salesman 
        $('#users').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Saleman',
            allowClear: true,
            dropdownParent: $('#users').parent() // Set to the parent element of the select box
        });
        $('#u_users').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Saleman',
            allowClear: true,
            dropdownParent: $('#u_users').parent() // Set to the parent element of the select box
        });
        get_users();
        // =======================get ===============================
        function get_users(){
            $.ajax({
            url:'/get_users',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#users option[value="' + data[i].id + '"]').length == 0){
                        $('#users').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_users option[value="' + data[i].id + '"]').length == 0){
                        $('#u_users').append($('<option>',{
                        value: data[i].id,
                        text: data[i].name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================
        
        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            // '<td class="text-center">'+
                            //     '<input type="text" name="pro_price[]" class="form-control text-center sale_price" placeholder=" ">'+
                            // '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            // '<td class="text-center">'+
                            //     '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            // '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#labtest_table > tbody:last").append(newRow);

            // get_products(newRow.find('.products'), '#add_modal');
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Fetch products for the new select element
            get_products(newRow.find('.products'), '#add_modal');
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            // '<td class="text-center">'+
                            //     '<input type="text" name="pro_price[]" class="form-control text-center sale_price" placeholder=" ">'+
                            // '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            // '<td class="text-center">'+
                            //     '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            // '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_labtest_table > tbody:last").append(newRow);

            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#update_modal');
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Remove Row Button ===========//
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalRate();
            updatecalculateTotalRate();
        });
        //=========== End Remove Row Button ===========//


        //=========== Start Custom Status Dropdown ===========//
   
        $(document).on('change', '.products', function() {
            var id = $(this).val();
            var tr = $(this).closest('tr');

            // Detect modal context
            var salesman_id = null;
            if ($(this).closest('#add_modal').length) {
                salesman_id = $('#users').val(); // Add modal
            } else if ($(this).closest('#update_modal').length) {
                salesman_id = $('#u_users').val(); // Update modal
            }

            // Agar salesman_id empty hua to default fallback
            if (!salesman_id) {
                salesman_id = $('#users').val();
            }

            // Debug check
            console.log("Sending salesman_id:", salesman_id);

            $.ajax({
                url: '/edit_saleman_product/' + id,
                method: 'GET',
                data: { salesman_id: salesman_id },  // ✅ ab hamesha value milegi
                dataType: "json",
                success: function(data) {
                    tr.find('.pro_stock').val(data.total_qty);
                    tr.find('.pro_qty').val(1);

                    calculateTotalRate();
                    updatecalculateTotalRate();
                }
            });
        });

        //=========== End Custom Status Dropdown ===========//


        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste click', '.pro_qty', function() {
            var qty = $(this).val();
            var tr = $(this).closest('tr');

            tr.find('.total').val(parseFloat(qty * tr.find('.sale_price').val()).toFixed(0));

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//


        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#paid', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_paid', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        function calculateTotalRate() {
            var total = 0;
            var paid = parseFloat($('#paid').val());

            $('#labtest_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    total += rate;
                }
            });
            $('#total_rate').text(total.toFixed(0));
            $('#grand_total').val(total.toFixed(0));

            var due = total - paid;

            $('#due').val(due);
            $('#due_text').text(due);
        }


        function updatecalculateTotalRate() {
            var update_total = 0;
            var paid = parseFloat($('#u_paid').val());
            $('#update_labtest_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    update_total += rate;
                }
            });

            $('#update_total_rate').text(update_total.toFixed(0));
            $('#u_grand_total').val(update_total.toFixed(0));

            var due = update_total - paid;

            $('#u_due').val(due);
            $('#u_due_text').text(due);
        }



        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
            rules: {
                
                cus_id: {
                    required: true, 
                },
            },
            messages: {
                
                cus_id: {
                    required: "Please select data",
                },
            },

           
            highlight: function(element) {
             
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },
 
            unhighlight: function(element) {
               
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_order_return") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Order Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Order');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save Order');
                            $('#add_btn').prop('disabled', false);
                        }
                        
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//



        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_order_return/' + id,
                method: 'GET',
                dataType: "json",
                success: function(data) {
                    console.log(data);
                    

                    // Set basic data
                    $('#u_order_return_id').val(data.data.id);
                    $('#description').val(data.data.description);
                    $('#date').val(data.data.date);

                    $('#order_status').val(data.data.status).trigger('change');
                    $('#u_users').val(data.data.salesman_id).trigger('change');

                    // status div area 
                    if (data.data.status === 'approved') {
                        $('#update_btn').hide(); // یا .hide()
                     
                    } else {
                        $('#update_btn').show();
                    }
                        

                    var salesman_id = data.data.salesman_id;
                    console.log("Salesman ID:", salesman_id);

                    // Ab dusra ajax call salesman stock ke liye
                    $.ajax({
                        url: '/get_salesman_stock',
                        method: 'POST',
                        data: {
                            salesman_id: salesman_id,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        dataType: "json",
                        success: function(stockData) {
                            console.log("Salesman stock:", stockData);

                            // Stock ko object me convert karna
                            var stockMap = {};
                            stockData.forEach(function(item) {
                                stockMap[item.pro_id] = item.available_stock;
                            });

                            // Clear and populate table
                            var tableBody = $("#update_labtest_table > tbody");
                            tableBody.empty();

                            data.order_details.forEach(function(detail) {
                                // Ab stockMap se stock nikalna hai
                                var stock = stockMap[detail.pro_id] ?? 0;

                                var html = 
                                    '<tr>' +
                                        '<td>' +
                                            '<select name="pro_id[]" class="select2 form-control products" style="width: 100%">' +
                                                '<option value="' + detail.pro_id + '" selected>' + detail.pro_name + '</option>' +
                                            '</select>' +
                                        '</td>' +
                                        '<td class="text-center">' +
                                            '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" value="' + stock + '">' +
                                        '</td>' +
                                        '<td class="text-center">' +
                                            '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" value="' + detail.quantity + '">' +
                                        '</td>' +
                                        '<td class="text-center">' +
                                            '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove">' +
                                                '<i class="fa-solid fa-xmark-large"></i>' +
                                            '</button>' +
                                        '</td>' +
                                    '</tr>';

                                tableBody.append(html);
                            });

                            // Reinitialize Select2
                            $("#update_labtest_table tbody .select2").select2({
                                width: '100%',
                                placeholder: 'Select Product',
                                allowClear: true,
                                dropdownParent: $("#update_modal")
                            });

                            // Calculate totals if necessary
                            updatecalculateTotalRate();
                        },
                        error: function(xhr) {
                            console.log("Stock error:", xhr.responseText);
                        }
                    });
                }
            });
        });
        //=========== Launch Update Modal On Click Edit Btn ===========//


        //=========== End Lounch Update Modal On Click Edit Btn ===========//


        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                
                customer_id: {
                    required: true, 
                },
                salesman_id: {
                    required: true,
                },
                order_status:{
                    required: true,
                    equalToApproved: true // custom rule
                }
                
            },
            messages: {
                
                customer_id: {
                    required: "Please select data",
                },
                salesman_id: {
                    required: "Please enter data",
                },
                order_status: {
                    required: "Please select data",
                    equalToApproved: "You must select 'Approved' to update."
                }
            },


            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        // Custom validation method
        $.validator.addMethod("equalToApproved", function(value, element) {
            return value === "approved";
        }, "You must select 'Approved' to update.");
        //=========== End Update Form Validation ===========//


        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_order_return") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Order Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Order');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Order');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== approved Data Ajax Request ===========//
        $("#approved_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Approving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("approved_order") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Order Approved Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#approved_btn').prop('disabled', false);
                            $('#approved_btn').text('Approved Order');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#approved_btn').prop('disabled', false);
                            $('#approved_btn').text('Approved Order');
                        }
                    }

                });
            }
        });
        //=========== End approved Data Ajax Request ===========//



        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_order_return/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Order Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//


        
        $('.products').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('.products').parent() // Set to the parent element of the select box
        });
        $('#u_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('#u_pro_id').parent() // Set to the parent element of the select box
        });
        get_products();
        // =======================get ===============================
        function get_products(selectElement = $('.products'), selectedValue = null) {
            $.ajax({
                url: '/get_products',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                    selectElement.each(function() {
                        var $this = $(this);
                        $this.empty(); // Clear existing options
                        $this.append('<option></option>'); // Add an empty default option

                        // Append fetched products to the select element
                        $.each(data, function(i, item) {
                            $this.append($('<option>', {
                                value: item.id,
                                text: item.pro_name
                            }));
                        });

                        // Set the selected value if provided
                        if (selectedValue) {
                            $this.val(selectedValue).trigger('change'); 
                        }
                    });
                }
            });
        }
        // =======================get ===============================


         //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_order/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#cus_name').text(data.order.cus_name);
                    $('#salesman_name').text(data.order.salesman_name);

                    $('#phone').text(data.order.phone);
                    $('#address').text(data.order.address);
                    $('#invoice_no').text(data.order.id);
                    let createdAt = new Date(data.order.created_at);
                    // Convert to Pakistani format (e.g., 06-August-2025 04:20 PM)
                    let options = {
                        day: '2-digit',
                        month: 'long',
                        year: 'numeric',
                        hour: '2-digit',
                        minute: '2-digit',
                        hour12: true,
                        timeZone: 'Asia/Karachi'
                    };
                    let formattedDate = createdAt.toLocaleString('en-PK', options);
                    // Set in the HTML
                    $('#inv_date').text(formattedDate);
                    $('#view_total').text(data.order.total_amount);
                    $('#view_paid').text(data.order.paid_amount);
                    $('#view_due').text(data.order.remain_amount);


                    var html = '';
                    $.each(data.products, function(i, item) {
                        
                        html += '<tr>'+
                                    '<td class="text-center">'+
                                        data.products[i].no +
                                    '</td>'+
                                    '<td>'+
                                        data.products[i].pro_name +
                                    '</td>'+
                                    '<td class="text-center">'+
                                    data.products[i].pro_price +
                                    '</td>'+
                                    '<td class="text-center">'+
                                      data.products[i].pro_qty +
                                    '</td>'+
                                    '<td class="text-right">'+
                                        data.products[i].total+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#invoice_table > tbody").empty();
                    $("#invoice_table > tbody:last").append(newRow);

                }
            });
        });

        


        // totalorders();
        // function totalorders() {
        //     $.ajax({
        //         url: "/totalorders",
        //         type: "GET",
        //         success: function(data) {
        //             $("#total_balance").text(data.total_purchase);
        //         }
        //     });
        // }




        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_order_return") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "salesman_id" },
                { data: "description" },
                { data: "status" },
                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [3, 4] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });

        
        //=========== End Custom Search Box ===========//






    });



</script>


<script>
    const mobileCheckbox = document.getElementById('mobileCheckbox');
    const bikeCheckbox = document.getElementById('bikeCheckbox');
    const mobileFields = document.getElementById('mobileFields');
    const bikeFields = document.getElementById('bikeFields');

    // Add event listeners to make checkboxes mutually exclusive
    mobileCheckbox.addEventListener('change', function() {
        if (this.checked) {
            bikeCheckbox.checked = false;
            mobileFields.style.display = 'block';
            bikeFields.style.display = 'none';
        } else {
            mobileFields.style.display = 'none';
        }
    });

    bikeCheckbox.addEventListener('change', function() {
        if (this.checked) {
            mobileCheckbox.checked = false;
            bikeFields.style.display = 'block';
            mobileFields.style.display = 'none';
        } else {
            bikeFields.style.display = 'none';
        }
    });
</script>



@endsection