@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
        .custom-dropify .dropify-wrapper {
            max-width: 200px;  
            height: 70px;  
        }

     
        .custom-dropify .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
    </style>


@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> Purchases</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Purchases ( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                {{-- <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div> --}}
                {{-- <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div> --}}
            </div>
      
        </div>
    </div>
@endsection

@section('page_content')

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_purchase'))
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Purchase</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Supplier </a></li>
                                {{-- <li><a href="#" class="toggle-vis" data-column="1">Product </a></li> --}}

                                <li><a href="#" class="toggle-vis" data-column="2">Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Total</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Paid</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Remain</a></li>

                                <li><a href="#" class="toggle-vis" data-column="7">Buttons</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">S.No</th>
                            <th width="10%">Date</th>
                            <th width="10%">Comapany Name </th>
                            <th width="10%">Supplier Name</th>
                            <th width="10%">Invoice Total Amount</th>
                            <th width="10%">Paid</th>
                            <th width="10%">Remaining</th>
                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" >
        <div class="modal-dialog modal-lg" style="width: 90%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New  Purchase</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="supplier_id" name="supplier_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash" selected>Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="product_type" name="product_type" class="form-control selectpicker">
                                            <option value="Product" selected>Product</option>
                                            <option value="Asset">Asset</option>
                                        </select>
                                    </div>
                                </div>

                              
                                <div class="col-sm-4" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="pur_date" name="date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Purchase Date:</label>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="pur_detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Purchase Detail:</label>
                                    </div>
                                </div>
                           

                            </div>

                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>

                                                <th style="width: 15%">Product Name</th>
                                                <th style="width: 10%" class="text-center"> Unit</th>
                                                <th style="width: 10%" class="text-center">Pur Price Rs</th>
                                                <th style="width: 10%" class="text-center">Sale Price</th>
                                                <th style="width: 10%" class="text-center">Batch No</th>
                                                <th style="width: 10%" class="text-center">Fright</th>
                                                <th style="width: 10%" class="text-center">Tax</th>
                                                <th style="width: 5%" class="text-center">Qty</th>
                                                <th style="width: 10%" class="text-center">Unit Price</th>

                                                <th style="width: 10%" class="text-center">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                           
                                              
                                                <td>
                                                    <select id="pro_id" name="pro_id[]" class=" select2 form-control products " style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_unit[]" class="form-control text-center pro_unit" readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="sale_price[]" class="form-control text-center sale_price" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="batch_no[]" class="form-control text-center batch_no" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="purchase_fright[]" class="form-control text-center purchase_fright" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="purchase_tax[]" class="form-control text-center purchase_tax" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="single_price[]" id="single_price" class="form-control text-center single_price" readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold"> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>

                                                <td class="text-right" style="font-weight: bold">
                                                    Grand Total:
                                                    <input type="hidden" name="grand_total" id="grand_total" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="total_rate" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold"> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                              
                                                <td class="text-right" style="font-weight: bold">
                                                    Paid Amount:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="text" name="paid_amount" id="paid" class="form-control text-center" placeholder=" " value="0">
                                                    <input type="hidden" name="remain_amount" id="due" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold"> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Remain Amount:
                                                </td>
                                                <td class="text-center" id="due_text" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal">
        <div class="modal-dialog modal-lg" style="width: 90%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Purchase</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">


                            <div class="col-sm-12 plr-0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="hidden" id="u_pur_id" name="pur_id">

                                        <select id="u_supplier_id" name="supplier_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="u_pur_date" name="date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Purchase Date:</label>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="u_detail" name="pur_detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Purchase Detail:</label>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash">Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_product_type" name="product_type" class="form-control selectpicker">
                                            <option value="Product" selected>Product</option>
                                            <option value="Asset">Asset</option>
                                        </select>
                                    </div>
                                </div>

                              
                                <div class="col-sm-4" id="bank_area">
                                    <div class="form-group">
                                        <select id="u_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>


                            </div>


                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 10%">Product Name</th>
                                                <th style="width: 10%" class="text-center">Unit</th>
                                                <th style="width: 10%" class="text-center">Pur Price Rs</th>
                                                <th style="width: 10%" class="text-center">Sale Price</th>
                                                <th style="width: 10%" class="text-center">Batch No</th>
                                                <th style="width: 10%" class="text-center">Fright</th>
                                                <th style="width: 10%" class="text-center">Tax</th>
                                                <th style="width: 10%" class="text-center">Qty</th>
                                                <th style="width: 10%" class="text-center">Unit Price</th>
                                                <th style="width: 10%" class="text-center">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- data in javascript --}}
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">  </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>

                                                <td class="text-right" style="font-weight: bold">
                                                    Total:
                                                    <input type="hidden" name="grand_total" id="u_grand_total" class="form-control text-center" placeholder=" ">
                                                </td>
                                                <td class="text-center" id="update_total_rate" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                           
                                            </tr>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold"> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>

                                                <td class="text-right" style="font-weight: bold">
                                                    Paid:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="text" name="paid_amount" id="u_paid" class="form-control text-center" placeholder=" " value="0">
                                                    <input type="hidden" name="remain_amount" id="u_due" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">  </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>
                                                <td> </td>

                                                <td class="text-right" style="font-weight: bold">
                                                    Remain:
                                                </td>
                                                <td class="text-center" id="u_due_text" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update Purchase</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->

    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -30px;
                top: -500px;
            }
        }
    </style>


    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->

                    <div class="panel print_invoice">
					    <div class="panel-body">
					        <div class="invoice-masthead">
					            <div class="invoice-text">
					                <h3 class="h1 text-uppercase text-thin mar-no text-primary">INVOICE</h3>
					            </div>
					            <div class="invoice-brand" style="white-space:nowrap">
					                <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
					                    <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
					                </div>
					            </div>
					        </div>
					
					        <div class="invoice-bill row">
					            <div class="col-sm-6 text-xs-center">
					                <address>
                                        <strong class="text-main">Supplier: </strong>
					                    <strong class="text-main" id="sup_name"></strong><br>
					                    <span id="company_name"></span><br>
					                    <span id="phone"></span><br>
					                    <span id="address"></span>
					               </address>
					            </div>
					            <div class="col-sm-6 text-xs-center">
					                <table class="invoice-details">
					                    <tbody>
					                        <tr>
					                            <td class="text-main text-bold">Invoice #</td>
					                            <td class="text-right text-info text-bold" id="invoice_no"></td>
					                        </tr>
                                            <tr>
					                            <td class="text-main text-bold">Billing Date</td>
					                            <td class="text-right" id="inv_date"></td>
					                        </tr>
					                        
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					
					        <div class="row">
					            <div class="col-lg-12 table-responsive">
					                <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
					                    <thead>
					                        <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
					                            <th class="text-uppercase">Description</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
					                            <th class="min-col text-center text-uppercase">Qty</th>
					                            <th class="min-col text-right text-uppercase">Total</th>
					                        </tr>
					                    </thead>
					                    <tbody>
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					        <div class="clearfix">
					            <table class="table invoice-total">
					                <tbody>
					                    <tr>
					                        <td><strong>Total :</strong></td>
					                        <td class="text-bold h4" id="view_total"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Paid :</strong></td>
					                        <td id="view_paid"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Due :</strong></td>
					                        <td  id="view_due"></td>
					                    </tr>
					                </tbody>
					            </table>
					        </div>

                            <div class="text-center no-print">
					            <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
					        </div>
					
					    </div>
					</div>
                        
                    </div>
                    <!--end::Scroll-->
                
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->


@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

{{-- today date function  --}}
<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("pur_date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>
<script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });
    }); 
</script>

<script>


    $(document).ready(function(){

        $('.select2').select2();


        
        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_unit[]" class="form-control text-center pro_unit" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="sale_price[]" class="form-control text-center sale_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="batch_no[]" class="form-control text-center batch_no" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_fright[]" class="form-control text-center purchase_fright" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_tax[]" class="form-control text-center purchase_tax" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="single_price[]" class="form-control text-center single_price" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#labtest_table > tbody:last").append(newRow);

            // get_products(newRow.find('.products'), '#add_modal');
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Fetch products for the new select element
            get_products(newRow.find('.products'), '#add_modal');
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_unit[]" class="form-control text-center pro_unit" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="sale_price[]" class="form-control text-center sale_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="batch_no[]" class="form-control text-center batch_no" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_fright[]" class="form-control text-center purchase_fright" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_tax[]" class="form-control text-center purchase_tax" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="single_price[]" class="form-control text-center single_price" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_labtest_table > tbody:last").append(newRow);

            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#update_modal');
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Remove Row Button ===========//
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalRate();
            updatecalculateTotalRate();
        });
        //=========== End Remove Row Button ===========//


        //=========== Start Custom Status Dropdown ===========//
        $(document).on('change', '.products', function() {
            var id = $(this).val();
            var tr = $(this).closest('tr');
            $.ajax({
                url: '/edit_product/' + id,
                method: 'GET',
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    tr.find('.pro_unit').val(data.data.unit_name);
                    tr.find('.purchase_price').val(0.00);
                    tr.find('.sale_price').val(0.00);
                    const batchNumber = Math.floor(100000 + Math.random() * 900000);
                    tr.find('.batch_no').val(batchNumber);
                    tr.find('.purchase_fright').val(0.00);
                    tr.find('.purchase_tax').val(0.00);
                    tr.find('.pro_qty').val(1);
                    tr.find('.single_price').val(0.00);
                    tr.find('.total').val(0.00);

                    calculateTotalRate();
                    updatecalculateTotalRate();
                }
            });
        });
        //=========== End Custom Status Dropdown ===========//


        //=========== Start Qty Change ============//
      
        $(document).on('keyup change paste click', '.pro_qty, .purchase_price, .purchase_fright, .purchase_tax', function() {
            var tr = $(this).closest('tr');

            var qty = parseFloat(tr.find('.pro_qty').val()) || 0;
            var price = parseFloat(tr.find('.purchase_price').val()) || 0;
            var freight = parseFloat(tr.find('.purchase_fright').val()) || 0;
            var tax = parseFloat(tr.find('.purchase_tax').val()) || 0;

            // Base total
            var total = (qty * price) + freight + tax;
            tr.find('.total').val(total.toFixed(2));

            // Single product purchase price
            var single_price = qty > 0 ? (total / qty) : 0;
            tr.find('.single_price').val(single_price.toFixed(2)); // <-- yahan column me show hoga

            calculateTotalRate();
            updatecalculateTotalRate();
        });



        //=========== End Qty Change ===========//



        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#paid', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste', '#u_paid', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        function calculateTotalRate() {
            var total = 0;
            var paid = parseFloat($('#paid').val());

            $('#labtest_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    total += rate;
                }
            });
            $('#total_rate').text(total.toFixed(2));
            $('#grand_total').val(total.toFixed(2));

            var due = total - paid;

            $('#due').val(due);
            $('#due_text').text(due);
        }


        function updatecalculateTotalRate() {
            var update_total = 0;
            var paid = parseFloat($('#u_paid').val());
            $('#update_labtest_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    update_total += rate;
                }
            });

            $('#update_total_rate').text(update_total.toFixed(2));
            $('#u_grand_total').val(update_total.toFixed(2));

            var due = update_total - paid;

            $('#u_due').val(due);
            $('#u_due_text').text(due);
        }



        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
            rules: {

                supplier_id: {
                    required: true, 
                }, 
            
                toatl: {
                    required: true,
                },
                paid_amount: {
                    required: true,
                },
                remain_amount: {
                    required: true,
                },
            },
            messages: {

                supplier_id: {
                    required: "Please select data",
                }, 

            
                toatl: {
                    required: "Please enter data",
                },
                paid_amount: {
                    required: "Please enter data",
                },
                remain_amount: {
                    required: "Please enter data",
                },
            },


            highlight: function(element) {

            $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
            $(element).css('background-repeat', 'no-repeat');
            $(element).css('background-position', '97%');
            },

            unhighlight: function(element) {

            $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
            $(element).css('background-repeat', 'no-repeat');
            $(element).css('background-position', '97%');
            }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Reset Add Modal On Open ===========//
        $('#add_modal').on('show.bs.modal', function() {
            // Reset form
            $('#add_form')[0].reset();
            
            // Clear all text inputs
            $('#add_form').find('input[type="text"], input[type="number"], input[type="email"], textarea').val('');
            
            // Set today's date
            var today = new Date();
            var day = String(today.getDate()).padStart(2, '0');
            var month = String(today.getMonth() + 1).padStart(2, '0');
            var year = today.getFullYear();
            var todayFormatted = day + '-' + month + '-' + year;
            $('#pur_date').val(todayFormatted);
            
            // Reset Select2 dropdowns
            $('#supplier_id').val(null).trigger('change');
            $('#banks').val(null).trigger('change');
            
            // Reset Bootstrap-Select dropdowns
            $('#payment_type').val('Cash');
            if ($('#payment_type').data('selectpicker')) {
                $('#payment_type').selectpicker('refresh');
            }
            $('#product_type').val('Product');
            if ($('#product_type').data('selectpicker')) {
                $('#product_type').selectpicker('refresh');
            }
            
            // Hide bank area
            $('#bank_area').hide();
            
            // Rebuild product table with a single clean row (prevents double product selects)
            var rowHtml = ''+
                '<tr>'+
                    '<td>'+
                        '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="pro_unit[]" class="form-control text-center pro_unit" readonly>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="sale_price[]" class="form-control text-center sale_price" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="batch_no[]" class="form-control text-center batch_no" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="purchase_fright[]" class="form-control text-center purchase_fright" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="purchase_tax[]" class="form-control text-center purchase_tax" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="single_price[]" class="form-control text-center single_price" readonly>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center"></td>'+
                '</tr>';
            $('#labtest_table tbody').html(rowHtml);

            // Initialize Select2 on the fresh row
            $('#labtest_table tbody .products').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: $('#add_modal')
            });
            get_products($('#labtest_table tbody .products'), '#add_modal');
            
            // Reset totals
            $('#grand_total').val('0');
            $('#total_rate').text('0');
            $('#paid').val('0');
            $('#due').val('0');
            $('#due_text').text('0');
            
            // Clear validation states
            $('#add_form').find('.form-group').removeClass('has-error');
            $('#add_form').find('.form-control').removeClass('is-invalid');
            $('#add_form').find('.invalid-feedback, .error').remove();
        });

        $('#add_modal').on('hidden.bs.modal', function() {
            // Additional cleanup when modal is closed
            $('#add_form')[0].reset();
            $('#add_form').find('input[type="text"], input[type="number"], input[type="email"], textarea').val('');
            $('#supplier_id').val(null).trigger('change');
            $('#banks').val(null).trigger('change');
            $('#payment_type').val('Cash');
            $('#product_type').val('Product');
            if ($('#payment_type').data('selectpicker')) {
                $('#payment_type').selectpicker('refresh');
            }
            if ($('#product_type').data('selectpicker')) {
                $('#product_type').selectpicker('refresh');
            }
            $('#bank_area').hide();
        });
        //=========== End Reset Add Modal On Open ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_purchase") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Purchase Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Purchase');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save Purchase');
                            $('#add_btn').prop('disabled', false);
                        }
                        
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//



        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_purchase/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    // Set basic data
                    $('#u_pur_id').val(data.data.id);
                    $('#u_pur_date').val(data.data.date);
             
                    $('#u_detail').val(data.data.pur_detail);
                    $('#u_paid').val(data.data.paid_amount);
                    $('#u_paid_text').text(data.data.paid_amount);
                    $('#u_due').text(data.data.remain_amount);
                  

                    // Set supplier dropdown
                    var option = new Option(data.data.sup_name, data.data.supplier_id, true, true);
                    $('#u_supplier_id').append(option).trigger('change');

                    $('#u_banks').val(data.data.bank_id).trigger('change');
                    $('#u_payment_type').val(data.data.payment_type).trigger('change');

                    // Clear and populate table
                    var tableBody = $("#update_labtest_table > tbody");
                    tableBody.empty();

                    data.purchase_details.forEach(function(detail) {
                        var html = 
                            '<tr>' +
                                '<td>' +
                                    '<select name="pro_id[]" class="select2 form-control products" style="width: 100%">' +
                                        '<option value="' + detail.pro_id + '" selected>' + detail.pro_name + '</option>' +
                                    '</select>' +
                                '</td>' +
                               '<td class="text-center">' +
                                    '<input type="text" name="pro_unit[]" class="form-control text-center pro_unit" value="' + detail.pro_unit + '" readonly>' +
                                '</td>' +

                                '<td class="text-center">' +
                                    '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" value="' + detail.purchase_price + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="text" name="sale_price[]" class="form-control text-center sale_price" value="' + detail.sale_price + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="text" name="batch_no[]" class="form-control text-center batch_no" value="' + detail.batch_no + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="text" name="purchase_fright[]" class="form-control text-center purchase_fright" value="' + detail.purchase_fright + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="text" name="purchase_tax[]" class="form-control text-center purchase_tax" value="' + detail.purchase_tax + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" value="' + detail.pro_qty + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="number" name="single_price[]" class="form-control text-center single_price" value="' + detail.single_price + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<input type="text" name="total[]" class="form-control text-center total" value="' + (detail.total_amount) + '">' +
                                '</td>' +
                                '<td class="text-center">' +
                                    '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove">' +
                                        '<i class="fa-solid fa-xmark-large"></i>' +
                                    '</button>' +
                                '</td>'

                              
                            '</tr>';

                        tableBody.append(html);
                    });

                    // Reinitialize Select2
                    $("#update_labtest_table tbody .select2").select2({
                        width: '100%',
                        placeholder: 'Select Product',
                        allowClear: true,
                        dropdownParent: $("#update_modal")
                    });

                    // Calculate totals if necessary
                    updatecalculateTotalRate();
                }

            });
        });
        //=========== Launch Update Modal On Click Edit Btn ===========//


        //=========== End Lounch Update Modal On Click Edit Btn ===========//


        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                
                supplier_id: {
                    required: true, 
                },
                date: {
                    required: true,
                },
                toatl: {
                    required: true,
                },
                paid_amount: {
                    required: true,
                },
                remain_amount: {
                    required: true,
                },
            },
            messages: {
                
                supplier_id: {
                    required: "Please select data",
                },
                date: {
                    required: "Please enter data",
                },
                toatl: {
                    required: "Please enter data",
                },
                paid_amount: {
                    required: "Please enter data",
                },
                remain_amount: {
                    required: "Please enter data",
                },
            },


            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        //=========== End Update Form Validation ===========//


        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_purchase") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Purchase Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Purchase');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Purchase');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

         //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_purchase/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#sup_name').text(data.purchase.sup_name);
                    // $('#company_name').text(data.purchase.company_name);
                    // $('#phone').text(data.purchase.phone_1);
                    // $('#address').text(data.purchase.perm_address);
                    $('#invoice_no').text(data.purchase.id);
                    $('#inv_date').text(data.purchase.date);
                    $('#view_subtotal').text(data.purchase.subtotal);
                    $('#view_total').text(data.purchase.grand_total);
                    $('#view_paid').text(data.purchase.paid_amount);
                    $('#view_due').text(data.purchase.remain_amount);

                    var html = '';

                    $.each(data.products, function(i, item) {
                        
                        html += '<tr>'+
                                    '<td class="text-center">'+
                                        data.products[i].no +
                                    '</td>'+
                                    '<td>'+
                                        data.products[i].pro_name +
                                    '</td>'+
                                    '<td class="text-center">'+
                                    data.products[i].purchase_price +
                                    '</td>'+
                                    '<td class="text-center">'+
                                      data.products[i].pro_qty +
                                    '</td>'+
                                   
                                    '<td class="text-right">'+
                                        data.products[i].total_amount+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#invoice_table > tbody").empty();
                    $("#invoice_table > tbody:last").append(newRow);

                }
            });
        });



        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_purchase/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Purchase Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//


        
        $('.products').select2({
        width: '100%', // Adjust width as needed
        placeholder: 'Select Product',
        allowClear: true,
        dropdownParent: $('.products').parent() // Set to the parent element of the select box
        });
        $('#u_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('#u_pro_id').parent() // Set to the parent element of the select box
        });
        get_products();
        // =======================get ===============================
        function get_products(selectElement = $('.products'), selectedValue = null) {
        $.ajax({
        url: '/get_products',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
        console.log(data);
        selectElement.each(function() {
            var $this = $(this);
            $this.empty(); // Clear existing options
            $this.append('<option></option>'); // Add an empty default option

            // Append fetched products to the select element
            $.each(data, function(i, item) {
                $this.append($('<option>', {
                    value: item.id,
                    text: item.pro_name
                }));
            });

            // Set the selected value if provided
            if (selectedValue) {
                $this.val(selectedValue).trigger('change'); 
            }
        });
        }
        });
        }
        // =======================get ===============================



        $('#supplier_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Supplier',
            allowClear: true,
            dropdownParent: $('#supplier_id').parent() // Set to the parent element of the select box
        });
        $('#u_supplier_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Supplier',
            allowClear: true,
            dropdownParent: $('#u_supplier_id').parent() // Set to the parent element of the select box
        });
        get_suppliers();
        // =======================get ===============================
        function get_suppliers(){
            $.ajax({
            url:'/get_suppliers',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#supplier_id option[value="' + data[i].id + '"]').length == 0){
                        $('#supplier_id').append($('<option>',{
                        value:data[i].id,
                        text:data[i].company_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_supplier_id option[value="' + data[i].id + '"]').length == 0){
                        $('#u_supplier_id').append($('<option>',{
                        value:data[i].id,
                        text:data[i].company_name,
                        }));
                    }
                    });
                }
            });
        };
        // =======================get ===============================

            // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================


        // totalpurchase();
        // function totalpurchase() {
        //     $.ajax({
        //         url: "/totalpurchase",
        //         type: "GET",
        //         success: function(data) {
        //             $("#total_balance").text(data.total_purchase);
        //         }
        //     });
        // }













        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_purchase") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "date" },
                { data: "company_name" },
                { data: "sup_name" },
                { data: "grand_total" },
                { data: "paid_amount" },
                { data: "remain_amount" },

                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [6] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });

        
        //=========== End Custom Search Box ===========//






    });



</script>


<script>
    const mobileCheckbox = document.getElementById('mobileCheckbox');
    const bikeCheckbox = document.getElementById('bikeCheckbox');
    const mobileFields = document.getElementById('mobileFields');
    const bikeFields = document.getElementById('bikeFields');

    // Add event listeners to make checkboxes mutually exclusive
    mobileCheckbox.addEventListener('change', function() {
        if (this.checked) {
            bikeCheckbox.checked = false;
            mobileFields.style.display = 'block';
            bikeFields.style.display = 'none';
        } else {
            mobileFields.style.display = 'none';
        }
    });

    bikeCheckbox.addEventListener('change', function() {
        if (this.checked) {
            mobileCheckbox.checked = false;
            bikeFields.style.display = 'block';
            mobileFields.style.display = 'none';
        } else {
            bikeFields.style.display = 'none';
        }
    });
</script>



@endsection