@extends('admin.main_layout')

@section('css_code')
    {{-- <link rel="stylesheet" href="{{ asset('backend/css/pos_bill.css') }}"> --}}
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Purchase Return</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Purchase Return( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            {{-- <div id="counting_panel">
                <div class="page-header counting round-corner-left">Subtotal <br> <b>50005</b></div>
                <div class="page-header counting">Paid <br> <b>300005</b></div>
                <div class="page-header counting">Pending <br> <b>20000</b></div>
                <div class="page-header counting round-corner-right">Total <br> <b>300050</b></div>
            </div> --}}
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_purchase_return'))
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Purchase Return</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>

                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Supplier</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Subtotal</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Total</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Buttons</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="8%">Date</th>
                            <th width="15%">Supplier Name</th>
                            <th width="8%">Qty</th>
                            <th width="10%">Updated By</th>
                            <th width="10%">Subtotal</th>
                            <th width="10%">Total</th>
                            <th width="10%">Refund Amount</th>
                            <th width="10%">Adjustment Amount</th>
                            <th width="8%">Status</th>
                            <th width="12%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>

    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-lg" style="width: 90%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Purchase Return</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <div style="display: flex">
                                            <select id="suppliers" name="supplier_id" class="select2 form-control" style="width: 100%;">
                                                <option></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="return_date" name="return_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel"> Date:</label>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash">Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-sm-4" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>



                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <input type="text" name="detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Note:</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="product_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 25%">Product Name</th>
                                                <th style="width: 10%" class="text-center">SKU</th>
                                                <th style="width: 10%" class="text-center">Batch</th>
                                                <th style="width: 10%" class="text-center">Purchase Price</th>
                                                <th style="width: 10%" class="text-center">Stock</th>
                                                <th style="width: 10%" class="text-center">Qty</th>
                                                <th style="width: 15%" class="text-center">Total</th>
                                                <th style="width: 10%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <select id="products" name="pro_id[]" class="select2 form-control products" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_sku[]" class="form-control text-center pro_sku" placeholder=" " readonly>
                                                </td>
                                                <td>
                                                    <select id="batch_no" name="batch_no[]" class="select2 form-control batch_no" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="5">

                                                </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Subtotal:
                                                    <input type="hidden" name="subtotal" id="subtotal" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="subtotal_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Grand Total:
                                                    <input type="hidden" name="grand_total" id="grand_total" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="grand_total_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Refund Amount:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="text" name="refund_amount" id="refund_amount" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Adjustment Amount:
                                                    <input type="hidden" name="adjustment_amount" id="adjustment_amount" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="adjustment_amount_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal"  >
        <div class="modal-dialog modal-lg" style="width: 90%">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Purchase Return</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_suppliers" name="supplier_id" class="select2 form-control" style="width: 100%;">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="hidden" id="u_purchase_return_id" name="purchase_return_id" class="form-control textbox" placeholder=" ">
                                        <input type="text" id="u_return_date" name="return_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel"> Date:</label>
                                    </div>
                                </div>



                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="u_payment_type" name="payment_type" class="form-control selectpicker">
                                            <option value="Cash">Cash</option>
                                            <option value="Bank">Bank</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-sm-4" id="u_bank_area">
                                    <div class="form-group">
                                        <select id="u_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="text" id="detail" name="detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Note:</label>
                                    </div>
                                </div>


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <select id="order_status" name="order_status" class="form-control selectpicker">
                                            <option value="0">Pending</option>
                                            @if (Auth::user()->can('approved'))
                                            <option value="1">Approved</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>

                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_product_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 25%">Product Name</th>
                                                <th style="width: 10%" class="text-center">SKU</th>
                                                <th style="width: 10%" class="text-center">Batch No</th>
                                                <th style="width: 10%" class="text-center">Purchase Price</th>
                                                <th style="width: 10%" class="text-center">Stock</th>
                                                <th style="width: 10%" class="text-center">Qty</th>
                                                <th style="width: 15%" class="text-center">Total</th>
                                                <th style="width: 10%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="5">

                                                </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Subtotal:
                                                    <input type="hidden" name="subtotal" id="u_subtotal" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_subtotal_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Grand Total:
                                                    <input type="hidden" name="grand_total" id="u_grand_total" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_grand_total_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Refund Amount:
                                                </td>
                                                <td class="text-center" style="font-weight: bold">
                                                    <input type="text" name="refund_amount" id="u_refund_amount" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td class="text-right" style="font-weight: bold" colspan="2">
                                                    Adjustment Amount:
                                                    <input type="hidden" name="adjustment_amount" id="u_adjustment_amount" class="form-control text-center" placeholder=" " value="0">
                                                </td>
                                                <td class="text-center" id="u_adjustment_amount_text" style="font-weight: bold">
                                                    0
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -30px;
                top: -500px;
            }
        }
    </style>

    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1"  >
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->

                    <div class="panel print_invoice">
					    <div class="panel-body">
					        <div class="invoice-masthead">
					            <div class="invoice-text">
					                <h3 class="h1 text-uppercase text-thin mar-no text-primary">PURCHASE RETURN</h3>
					            </div>
					            <div class="invoice-brand" style="white-space:nowrap">
					                <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
					                    <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
					                </div>
					            </div>
					        </div>

					        <div class="invoice-bill row">
					            <div class="col-sm-6 text-xs-center">
					                <address>
                                        <span >Supplier: </span>
					                    <strong class="text-main" id="supplier_name"></strong><br>

					                    <span id="company_name"></span><br>
					                    <span id="phone"></span><br>
					                    <span id="address"></span>
					               </address>
					            </div>
					            <div class="col-sm-6 text-xs-center">
					                <table class="invoice-details">
					                    <tbody>
					                        <tr>
					                            <td class="text-main text-bold">Return #</td>
					                            <td class="text-right text-info text-bold" id="return_no"></td>
					                        </tr>
                                            <tr>
					                            <td class="text-main text-bold">Return Date</td>
					                            <td class="text-right" id="return_date"></td>
					                        </tr>

					                    </tbody>
					                </table>
					            </div>
					        </div>


					        <div class="row">
					            <div class="col-lg-12 table-responsive">
					                <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
					                    <thead>
					                        <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
					                            <th class="text-uppercase">Products</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
					                            <th class="min-col text-center text-uppercase">Qty</th>
					                            <th class="min-col text-right text-uppercase">Total</th>
					                        </tr>
					                    </thead>
					                    <tbody>
					                    </tbody>
					                </table>
					            </div>
					        </div>

					        <div class="clearfix">
					            <table class="table invoice-total">
					                <tbody>
					                    <tr>
					                        <td><strong>Subtotal :</strong></td>
					                        <td id="view_subtotal"></td>
					                    </tr>
                                        <tr>
					                        <td><strong>Total :</strong></td>
					                        <td class="text-bold h4" id="view_total"></td>
					                    </tr>
					                </tbody>
					            </table>
					        </div>

                            <div class="text-center no-print">
					            <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
					        </div>

					    </div>
					</div>

                    </div>
                    <!--end::Scroll-->

                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->

@endsection



@section('javascript_code')
<script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();
        $('#u_bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });

        $('#u_payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#u_bank_area').show();
            } else {
                $('#u_bank_area').hide();
            }
        });
    });
</script>


<script>
    $(document).ready(function(){

        $('.select2').select2();


        $('#return_date').daterangepicker({
            // autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#return_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_return_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_return_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });


        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();


            var html = '<tr>'+
                            '<td>'+
                                '<select id="products" name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td>'+
                                '<select name="batch_no[]" class="select2 form-control batch_no" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#product_table > tbody:last").append(newRow);

            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Initialize batch_no select2
            newRow.find('.batch_no').select2({
                width: '100%',
                placeholder: 'Select Batch',
                allowClear: true,
                dropdownParent: $('#add_modal')
            });

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#add_modal');
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();


            var html = '<tr>'+
                            '<td>'+
                                '<select id="products" name="pro_id[]" class="demo_select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td>'+
                                '<select name="batch_no[]" class="select2 form-control batch_no" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_product_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            get_products(newRow.find('.products'), '#update_modal');
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Remove Row Button ===========//
        // Delegate event to remove row
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalRate();
            updatecalculateTotalRate();
        });
        //=========== End Remove Row Button ===========//

        //=========== Get Products On Load ===========//
        get_products($('#products'), '#add_modal');
        get_products($('#uproducts'), '#update_modal');
        get_suppliers($('#u_suppliers'), '#update_modal');


        $('.products').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('.products').parent() // Set to the parent element of the select box
        });
        $('#u_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('#u_pro_id').parent() // Set to the parent element of the select box
        });
        get_products();
        // =======================get ===============================
        function get_products(selectElement = $('.products'), selectedValue = null) {
            $.ajax({
                url: '/get_products',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                    selectElement.each(function() {
                        var $this = $(this);
                        $this.empty(); // Clear existing options
                        $this.append('<option></option>'); // Add an empty default option

                        // Append fetched products to the select element
                        $.each(data, function(i, item) {
                            $this.append($('<option>', {
                                value: item.id,
                                text: item.pro_name
                            }));
                        });

                        // Set the selected value if provided
                        if (selectedValue) {
                            $this.val(selectedValue).trigger('change');
                        }
                    });
                }
            });
        }
        // =======================get ===============================
        //=========== End Get Products On Load ===========//

        //=========== Start Product Selection ===========//
        $(document).on('change', '.products', function() {
            var id = $(this).val();
            var tr = $(this).closest('tr');

            var supplier_id;

            if ($(this).closest('#add_modal').length) {
                supplier_id = $('#suppliers').val();
            } else if ($(this).closest('#update_modal').length) {
                supplier_id = $('#u_suppliers').val();
            } else {
                supplier_id = $('#suppliers').val();
            }

            $.ajax({
                url: '/edit_product/' + id,
                method: 'GET',
                data: {
                    supplier_id: supplier_id
                },
                dataType: "json",
                success: function(data) {
                    tr.find('.pro_sku').val(data.data.sku);
                    tr.find('.purchase_price').val(data.data.purchase_price);
                    tr.find('.pro_stock').val(data.total_qty);
                    tr.find('.pro_qty').val(1);
                    tr.find('.total').val(data.data.purchase_price);

                    // Batch select per-row
                    var batchSelect = tr.find('.batch_no');
                    batchSelect.empty().append('<option></option>');

                    if (data.batches) {
                        $.each(data.batches, function(key, value) {
                            batchSelect.append('<option value="' + value.batch_no + '">' + value.batch_no + '</option>');
                        });
                    }

                    // Re-initialize select2 only for this row
                    batchSelect.select2({
                        width: '100%',
                        placeholder: 'Select Batch',
                        allowClear: true,
                        dropdownParent: tr.closest('table')
                    });

                    batchSelect.trigger('change');

                    loadpdata(tr, id);

                    calculateTotalRate();
                    updatecalculateTotalRate();
                }
            });
        });


        function loadpdata(tr, prodid) {
            var supplier_id = $('#suppliers').val() || $('#u_suppliers').val();

            $.ajax({
                url: "/get-purchase-product", // Laravel route
                method: "POST",
                data: {
                    prodid: prodid,
                    supplier_id: supplier_id,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    var batchSelect = tr.find('.batch_no');
                    batchSelect.empty().append('<option></option>');

                    $.each(data, function(i, item) {
                        batchSelect.append($('<option>', {
                            value: item.batch,
                            text: item.batch,
                            selected: (i === 0)
                        }));
                    });

                    if (data.length > 0) {
                        tr.find(".purchase_price").val(data[0]["purchase_price"]);
                        tr.find(".pro_stock").val(data[0]["stock_qty"]);
                        tr.find(".total").val(tr.find(".purchase_price").val() * tr.find(".pro_qty").val());
                    }

                    calculateTotalRate();
                    updatecalculateTotalRate()
                },
                error: function(xhr) {
                    alert(xhr.responseJSON.message || "Error fetching data");
                }
            });
        }


        $(document.body).on('change', '.batch_no', function(e) {

            var batch = this.value;
            var tr = $(this).closest('tr');

            $.ajax({
                url: "/getBatchData",  // Laravel route
                method: 'POST',
                data: {
                    batch: batch,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);

                    tr.find(".purchase_price").val(data.purchase_price);
                    tr.find(".pro_stock").val(data.stock);
                    tr.find(".total").val(tr.find(".purchase_price").val() * tr.find(".pro_qty").val());

                    calculateTotalRate();
                    updatecalculateTotalRate()
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });

        });
        //=========== End Product Selection ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste click', '.pro_qty', function() {
            var qty = $(this).val();
            var tr = $(this).closest('tr');

            var purchase_price = tr.find('.purchase_price').val();

            tr.find('.total').val(parseFloat(qty * purchase_price).toFixed(0));

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//

        //=========== Start Price Change ===========//
        $(document).on('keyup change paste', '.purchase_price', function() {
            var price = $(this).val();
            var tr = $(this).closest('tr');

            var qty = tr.find('.pro_qty').val();

            tr.find('.total').val(parseFloat(qty * price).toFixed(0));

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Price Change ===========//

        //=========== Start Refund Amount Change ===========//
        $(document).on('keyup change paste', '#refund_amount', function() {
            calculateTotalRate();
        });
        //=========== End Refund Amount Change ===========//

        //=========== Start Refund Amount Change ===========//
        $(document).on('keyup change paste', '#u_refund_amount', function() {
            updatecalculateTotalRate();
        });
        //=========== End Refund Amount Change ===========//


        function calculateTotalRate() {
            var subtotal = 0;

            $('#product_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    subtotal += rate;
                }
            });
            $('#subtotal_text').text(subtotal.toFixed(0));
            $('#subtotal').val(subtotal.toFixed(0));

            $('#grand_total_text').text(subtotal.toFixed(0));
            $('#grand_total').val(subtotal.toFixed(0));

            var refund = parseFloat($('#refund_amount').val()) || 0;
            var adjustment = subtotal - refund;

            $('#adjustment_amount_text').text(adjustment.toFixed(0));
            $('#adjustment_amount').val(adjustment.toFixed(0));

        }


        function updatecalculateTotalRate() {
            var subtotal = 0;

            $('#update_product_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    subtotal += rate;
                }
            });
            $('#u_subtotal_text').text(subtotal.toFixed(0));
            $('#u_subtotal').val(subtotal.toFixed(0));

            $('#u_grand_total_text').text(subtotal.toFixed(0));
            $('#u_grand_total').val(subtotal.toFixed(0));

            var refund = parseFloat($('#u_refund_amount').val()) || 0;
            var adjustment = subtotal - refund;

            $('#u_adjustment_amount_text').text(adjustment.toFixed(0));
            $('#u_adjustment_amount').val(adjustment.toFixed(0));

        }

        // suppliers
        $('#suppliers').select2({
            width: '100%',
            placeholder: 'Select Supplier',
            allowClear: true,
            dropdownParent: $('#suppliers').parent()
        });
        $('#u_suppliers').select2({
            width: '100%',
            placeholder: 'Select Supplier',
            allowClear: true,
            dropdownParent: $('#u_suppliers').parent()
        });
        get_suppliers();
        function get_suppliers(){
            $.ajax({
            url:'/get_suppliers',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log(data);


                    $.each(data,function(i,item){
                    if($('#suppliers option[value="' + data[i].id + '"]').length == 0){
                        $('#suppliers').append($('<option>',{
                        value: data[i].id,
                        text: data[i].shop_name || data[i].company_name || data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_suppliers option[value="' + data[i].id + '"]').length == 0){
                        $('#u_suppliers').append($('<option>',{
                        value: data[i].id,
                        text: data[i].shop_name || data[i].company_name || data[i].name,
                        }));
                    }
                    });

                }
            });
        };
        // =======================get ===============================

        // banks
        $('#banks').select2({
            width: '100%',
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent()
        });
        $('#u_banks').select2({
            width: '100%',
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent()
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });

                }
            });
        };
        // =======================get ===============================


        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
            rules: {
                supplier_id: {
                    required: true,
                    minlength: 1
                },
                return_date: {
                    required: true,
                }
            },
            messages: {
                supplier_id: {
                    required: "Please Select Supplier",
                },
                return_date: {
                    required: "Please enter Return Date",
                },

            },

            //Called when the element is invalid:
            highlight: function(element) {
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Reset Add Modal On Open ===========//
        $('#add_modal').on('show.bs.modal', function() {
            // Reset form
            $('#add_form')[0].reset();

            // Clear all text inputs
            $('#add_form').find('input[type="text"], input[type="number"], input[type="email"], textarea').val('');

            // Set today's date
            var today = new Date();
            var day = String(today.getDate()).padStart(2, '0');
            var month = String(today.getMonth() + 1).padStart(2, '0');
            var year = today.getFullYear();
            var todayFormatted = day + '-' + month + '-' + year;
            $('#return_date').val(todayFormatted);

            // Reset Select2 dropdowns
            $('#suppliers').val(null).trigger('change');
            $('#banks').val(null).trigger('change');

            // Reset Bootstrap-Select dropdowns
            $('#payment_type').val('Cash');
            if ($('#payment_type').data('selectpicker')) {
                $('#payment_type').selectpicker('refresh');
            }

            // Hide bank area
            $('#bank_area').hide();

            // Rebuild product table with a single clean row
            var rowHtml = ''+
                '<tr>'+
                    '<td>'+
                        '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" placeholder=" " readonly>'+
                    '</td>'+
                    '<td>'+
                        '<select name="batch_no[]" class="select2 form-control batch_no" style="width: 100%"><option></option></select>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="purchase_price[]" class="form-control text-center purchase_price" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="pro_stock[]" class="form-control text-center pro_stock" placeholder=" " readonly>'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="number" name="pro_qty[]" class="form-control text-center pro_qty" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center">'+
                        '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                    '</td>'+
                    '<td class="text-center"></td>'+
                '</tr>';
            $('#product_table tbody').html(rowHtml);

            // Initialize Select2 on the fresh row
            $('#product_table tbody .products').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: $('#add_modal')
            });
            $('#product_table tbody .batch_no').select2({
                width: '100%',
                placeholder: 'Select Batch',
                allowClear: true,
                dropdownParent: $('#add_modal')
            });
            get_products($('#product_table tbody .products'), '#add_modal');

            // Reset totals
            $('#subtotal').val('0');
            $('#subtotal_text').text('0');
            $('#grand_total').val('0');
            $('#grand_total_text').text('0');
            $('#refund_amount').val('0');
            $('#adjustment_amount').val('0');
            $('#adjustment_amount_text').text('0');

            // Clear validation states
            $('#add_form').find('.form-group').removeClass('has-error');
            $('#add_form').find('.form-control').removeClass('is-invalid');
            $('#add_form').find('.invalid-feedback, .error').remove();
        });

        $('#add_modal').on('hidden.bs.modal', function() {
            // Additional cleanup when modal is closed
            $('#add_form')[0].reset();
            $('#add_form').find('input[type="text"], input[type="number"], input[type="email"], textarea').val('');
            $('#suppliers').val(null).trigger('change');
            $('#banks').val(null).trigger('change');
            $('#payment_type').val('Cash');
            if ($('#payment_type').data('selectpicker')) {
                $('#payment_type').selectpicker('refresh');
            }
            $('#bank_area').hide();
        });
        //=========== End Reset Add Modal On Open ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_purchase_return") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Purchase Return Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {

                            Swal.fire({
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error",
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: {
                                        confirmButton: "btn fw-bold btn-success"
                                        }
                                    });
                            $('#add_btn').text('Save');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Launch Update Modal On Click Edit Btn ===========//

        $(document).on("click", '#edit_btn', function(event) {
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_purchase_return/' + id,
                method: 'GET',
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    if (data.status === 200) {
                        // Populate purchase return details
                        $('#u_purchase_return_id').val(data.purchase_return.id);
                        $('#u_return_date').val(data.purchase_return.return_date);
                        $('#detail').val(data.purchase_return.detail);
                        $('#u_subtotal').val(data.purchase_return.subtotal);
                        $('#u_grand_total').val(data.purchase_return.grand_total);
                        $('#u_refund_amount').val(data.purchase_return.refund_amount);
                        $('#u_adjustment_amount').val(data.purchase_return.adjustment_amount);

                        $('#order_status').val(data.purchase_return.status).trigger('change');

                        // Hide update button if approved
                        if (data.purchase_return.status == 1) {
                            $('#update_btn').hide();
                        } else {
                            $('#update_btn').show();
                        }


                        $('#u_suppliers').empty();
                        var option = new Option(data.purchase_return.supplier_business_name, data.purchase_return.supplier_id, true, true);
                        $('#u_suppliers').append(option).trigger('change');

                        $('#u_banks').val(data.purchase_return.bank_id).trigger('change');
                        $('#u_payment_type').val(data.purchase_return.payment_type).trigger('change');

                        // Show/hide bank area based on payment type
                        if (data.purchase_return.payment_type === 'Bank') {
                            $('#u_bank_area').show();
                        } else {
                            $('#u_bank_area').hide();
                        }


                        // Populate product details
                        var html = '';
                        $.each(data.products, function(i, item) {
                            html += `
                                <tr>
                                    <td>
                                        <select name="pro_id[]" class="demo_select2 form-control products" style="width: 100%;">
                                            <option value="${item.pro_id}">${item.pro_name}</option>
                                        </select>

                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="pro_sku[]" class="form-control text-center pro_sku" value="${item.pro_sku || ''}" readonly>
                                    </td>
                                     <td class="text-center">
                                        <input type="text" name="batch_no[]" class="form-control text-center batch_no" value="${item.batch_no || ''}" readonly>
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="purchase_price[]" class="form-control text-center purchase_price" value="${item.purchase_price || 0}">
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="pro_stock[]" class="form-control text-center pro_stock" value="${item.pro_stock || 0}" readonly>
                                    </td>
                                    <td class="text-center">
                                        <input type="number" name="pro_qty[]" class="form-control text-center pro_qty" value="${item.pro_qty || 0}" required>
                                    </td>
                                    <td class="text-center">
                                        <input type="text" name="total[]" class="form-control text-center total" value="${item.total || 0}">
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove">
                                            <i class="fa-solid fa-xmark-large"></i>
                                        </button>
                                    </td>
                                </tr>`;
                        });

                        $("#update_product_table > tbody").empty();
                        $("#update_product_table > tbody:last").append(html);

                        // Reinitialize Select2 for new rows
                        $("#update_product_table .demo_select2").select2({
                            placeholder: "Select Product",
                            allowClear: true
                        });


                        updatecalculateTotalRate();
                    } else {
                        alert(data.message || "Error fetching data");
                    }

                }
            });
        });

        //=========== End Launch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                order_status:{
                    required: true,
                    equalToApproved: true // custom rule
                }
            },
            messages: {
               order_status: {
                    required: "Please select status",
                    equalToApproved: "You must select 'Approved' to update."
                }
            },


            //Called when the element is invalid:
            highlight: function(element) {
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        // Custom validation method
        $.validator.addMethod("equalToApproved", function(value, element) {
            return value == "1"; // 1 = approved
        }, "You must select 'Approved' to update.");
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_purchase_return") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                            $('#update_modal').modal('hide');
                            loadData();

                        }else {

                            Swal.fire({
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error",
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: {
                                        confirmButton: "btn fw-bold btn-success"
                                        }
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Launch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_purchase_return/'+id,
                method: 'GET',
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#supplier_name').text(data.purchase_return.supplier_business_name);
                    $('#phone').text(data.purchase_return.phone);
                    $('#address').text(data.purchase_return.address);
                    $('#return_no').text(data.purchase_return.id);
                    $('#return_date').text(data.purchase_return.return_date);
                    $('#view_subtotal').text(data.purchase_return.subtotal);
                    $('#view_total').text(data.purchase_return.grand_total);

                    var html = '';

                    $.each(data.products, function(i, item) {

                        html += '<tr>'+
                                    '<td class="text-center">'+
                                        data.products[i].no +
                                    '</td>'+
                                    '<td>'+
                                        data.products[i].pro_name +
                                    '</td>'+
                                    '<td class="text-center">'+
                                    data.products[i].purchase_price +
                                    '</td>'+
                                    '<td class="text-center">'+
                                      data.products[i].pro_qty +
                                    '</td>'+
                                    '<td class="text-right">'+
                                        data.products[i].total+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#invoice_table > tbody").empty();
                    $("#invoice_table > tbody:last").append(newRow);

                }
            });
        });

        //=========== End Launch View Modal On Click View Btn ===========//


        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_purchase_return/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Purchase Return Has Been Deleted Successfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Something Wrong!",
                                            text: "Something Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_purchase_return") }}',
                type: 'post',
                data: { _token: csrf._token, startdate: "", enddate: "", search: "", type: "" }
            },
            columns: [
                { data: "id" },
                { data: "date" },
                { data: "shop_name" },
                { data: "total_qty" },
                { data: "updated_by" },
                { data: "subtotal" },
                { data: "grand_total" },
                { data: "refund_amount" },
                { data: "adjustment_amount" },
                { data: "status" },
                { data: "btn" },
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 3, 5, 6, 7, 8, 9] },
            ],
            centeredColumnsOnPrintPdf: [1, 3, 5, 6, 7, 8, 9],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }


        // Example usage: Call the function with updated dates
        loadData("", "", "", );

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val());
        });
        //=========== End Custom Search Box ===========//

        $("#status").select2({
            placeholder: "Filter By Status",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });


        //=========== Start Custom Status Dropdown ===========//
        $('#status').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }

        });
        //=========== End Custom Status Dropdown ===========//


        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
        	//=========== Start Date Range Picker ===========//
    	    var start = moment().subtract(29, 'days');
    	    var end = moment();

    	    function cb(start, end) {
    	        $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
    	    }

    	    $(datepickerid).daterangepicker({
    	    	autoUpdateInput: false,
    	        format: 'DD-MM-YYYY',
    	        startDate: start,
    	        endDate: end,
    	        showCustomRangeLabel: false,
    	        alwaysShowCalendars: true,
    	        ranges: {
    	           'Today': [moment(), moment()],
    	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    	           'This Month': [moment().startOf('month'), moment().endOf('month')],
    	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    	        }
    	    }, cb);

    	    cb(start, end);
    	    //=========== End Date Range Picker ===========//



    	    //=========== Start Date Range On Apply ===========//
    	    //Filter the datatable on the datepicker apply event
    		$(datepickerid).on('apply.daterangepicker', function(ev, picker)
    		{
    		    startdate=picker.startDate.format('DD-MM-YYYY');
    		    enddate=picker.endDate.format('DD-MM-YYYY');
    		    $(datepickerid).val(startdate + ' To ' + enddate);

    		    // alert(startdate+" "+enddate);

    		    // $('#main_table').DataTable().destroy();

    		    // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
    		    loadData($('#search').val(), startdate, enddate);


    		});

    		//Click on cancel Button
    		$(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
    		  //do something, like clearing an input
    		  $(datepickerid).val('');
    		});
    		//=========== End Date Range On Apply ===========//

    		//Click on Refresh Data
    		$('#refresh_data').on('click', function() {
    		  //do something, like clearing an input
    		  $(datepickerid).val('');
    		  loadData("", today_Date, today_Date );
    		});
    		//=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//





    });

</script>
@endsection
