@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
        .custom-dropify .dropify-wrapper {
            max-width: 200px;  
            height: 70px;  
        }

     
        .custom-dropify .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
        .price-summary {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-top: 15px;
        }
        .price-summary .price-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            border-bottom: 1px dashed #dee2e6;
        }
        .price-summary .price-row:last-child {
            border-bottom: none;
        }
        .price-summary .price-row.total {
            font-weight: bold;
            font-size: 16px;
            color: #28a745;
            border-top: 2px solid #28a745;
            margin-top: 10px;
            padding-top: 10px;
        }
    </style>


@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> Repair Orders</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Repair Orders( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                {{-- <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div> --}}
                {{-- <div class="page-header counting round-corner-right">Total Bom <br> <b id="total_bom">0</b></div> --}}
            </div>
      
        </div>
    </div>
@endsection

@section('page_content')

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (Auth::user()->can('create_order_return') || Auth::user()->hasRole('Production Manager'))
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Contractor</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Product</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Price</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Labour Cost</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Material Cost</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Total Price</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="8">Buttons</a></li>

                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="12%">Contractor</th>
                            <th width="12%">Product</th>
                            <th width="10%">Price</th>
                            <th width="10%">Labour Cost</th>
                            <th width="10%">Material Cost</th>
                            <th width="12%">Total Price</th>
                            <th width="10%">Status</th>

                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Repair Order</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">
                               
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <select id="contractor" name="contractor_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div> 

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="text" id="date" name="date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel"> Date  :</label>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <select id="nonservice_pro_id" name="nonservice_pro_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div> 

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="text" name="pro_qty" id="pro_qty" class="form-control textbox" placeholder=" " value="1">
                                        <label class="control-label textboxlabel">Pro Qty  :</label>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="text" name="advance" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Advance  :</label>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="number" name="batch_number" id="batch_number" class="form-control textbox" placeholder=" " readonly>
                                        <label class="control-label textboxlabel">Batch Number:</label>
                                        <button type="button" id="add_batch" data-toggle="tooltip" title="Generate Batch" style="margin-left: 5px;" class="btn btn-success btn-icon"><i class="fa-duotone fa-circle-plus"></i></button>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="number" name="price" id="product_price" class="form-control textbox" placeholder=" " readonly>
                                        <label class="control-label textboxlabel">Production Price (Per Unit):</label>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="number" name="labour_cost" id="labour_cost" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Labour Cost:</label>
                                    </div>
                                </div>

                            </div>

                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>

                                                <th style="width: 45%">Repair Material (Product)</th>
                                                <th style="width: 20%" class="text-center">SKU</th>
                                                <th style="width: 15%" class="text-center">Price</th>

                                                <th style="width: 15%" class="text-center">Qty</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>


                                                <td>
                                                    <select id="pro_id" name="pro_id[]" class=" select2 form-control products " style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number" name="pro_price[]" class="form-control text-center pro_price" readonly>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number" name="item_qty[]" class="form-control text-center item_qty" placeholder=" ">
                                                </td>
                                                <td class="text-center">

                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="2" class="text-right" style="font-weight: bold">
                                                    Total Material Cost:
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" id="total_material_cost" name="material_cost" class="form-control text-center" value="0.00" readonly style="font-weight: bold; background-color: #f0f0f0;">
                                                </td>
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>

                                        </tfoot>
                                    </table>
                                </div>
                            </div>

                            <!-- Price Summary Section -->
                            <div class="col-sm-12">
                                <div class="price-summary">
                                    <h5 style="margin-bottom: 15px; color: #333;"><i class="fa-duotone fa-calculator"></i> Price Calculation Summary</h5>
                                    <div class="price-row">
                                        <span>Production Price (Per Unit):</span>
                                        <span id="summary_production_price">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row">
                                        <span>Labour Cost:</span>
                                        <span id="summary_labour_cost">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row">
                                        <span>Material Cost:</span>
                                        <span id="summary_material_cost">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row total">
                                        <span>Total Price:</span>
                                        <span id="summary_total_price">Rs. 0.00</span>
                                    </div>
                                    <input type="hidden" name="total_price" id="total_price" value="0">
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Repair Order</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">

 
                            <input type="hidden" id="order_id" name="order_id">

                             
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <select id="u_contractor" name="contractor_id" class="select2 form-control" style="width: 100%">
                                        <option></option>
                                    </select>
                                </div>
                            </div> 

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="text" id="u_date" name="date" class="form-control textbox" placeholder=" ">
                                    <label class="control-label textboxlabel"> Date  :</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <select id="u_nonservice_pro_id" name="nonservice_pro_id" class="select2 form-control" style="width: 100%">
                                        <option></option>
                                    </select>
                                </div>
                            </div> 

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="text" id="u_pro_qty" name="pro_qty" class="form-control textbox" placeholder=" ">
                                    <label class="control-label textboxlabel">Pro Qty  :</label>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="u_batch_number" name="batch_number" class="form-control textbox" placeholder=" " readonly>
                                    <label class="control-label textboxlabel">Batch Number:</label>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="u_product_price" name="price" class="form-control textbox" placeholder=" " readonly>
                                    <label class="control-label textboxlabel">Production Price (Per Unit):</label>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="u_labour_cost" name="labour_cost" class="form-control textbox" placeholder=" ">
                                    <label class="control-label textboxlabel">Labour Cost:</label>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <select id="status" name="status" class="form-control selectpicker">
                                        <option value="Pending">Pending</option>
                                        @if (Auth::user()->can('repair_order_complete'))
                                        <option value="Completed">Completed</option>
                                        @endif
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="advance" name="advance" class="form-control textbox" >
                                    <label class="control-label textboxlabel">Advance  :</label>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="repair_cost" name="repair_cost" class="form-control textbox" >
                                    <label class="control-label textboxlabel">Repair Cost  :</label>
                                </div>
                            </div>


                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_labtest_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 45%">Repair Material (Product)</th>
                                                <th style="width: 20%" class="text-center">SKU</th>
                                                <th style="width: 15%" class="text-center">Price</th>

                                                <th style="width: 15%" class="text-center">Qty</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- data in javascript --}}
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="2" class="text-right" style="font-weight: bold">
                                                    Total Material Cost:
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" id="update_total_material_cost" name="material_cost" class="form-control text-center" value="0.00" readonly style="font-weight: bold; background-color: #f0f0f0;">
                                                </td>
                                                <td colspan="2" class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>

                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>

                            <!-- Price Summary Section for Update Modal -->
                            <div class="col-sm-12">
                                <div class="price-summary">
                                    <h5 style="margin-bottom: 15px; color: #333;"><i class="fa-duotone fa-calculator"></i> Price Calculation Summary</h5>
                                    <div class="price-row">
                                        <span>Production Price (Per Unit):</span>
                                        <span id="u_summary_production_price">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row">
                                        <span>Labour Cost:</span>
                                        <span id="u_summary_labour_cost">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row">
                                        <span>Material Cost:</span>
                                        <span id="u_summary_material_cost">Rs. 0.00</span>
                                    </div>
                                    <div class="price-row total">
                                        <span>Total Price:</span>
                                        <span id="u_summary_total_price">Rs. 0.00</span>
                                    </div>
                                    <input type="hidden" name="total_price" id="u_total_price" value="0">
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update  </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->

    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -30px;
                top: -500px;
            }
        }
    </style>


    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-md">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body p-0">
                    <!--begin::Scroll-->

                    <div class="panel print_invoice">
					    <div class="panel-body">
					        <div class="invoice-masthead">
					            <div class="invoice-text">
					                <h3 class="h1 text-uppercase text-thin mar-no text-primary">INVOICE</h3>
					            </div>
					            <div class="invoice-brand" style="white-space:nowrap">
					                <div class="invoice-logo">
                                        @php
                                            $setting = App\Models\Setting::find(1);
                                        @endphp
					                    <img src="{{ asset('uploads/' . $setting->logo) }}" height="50px">
					                </div>
					            </div>
					        </div>
					
					        <div class="invoice-bill row">
					            <div class="col-sm-6 text-xs-center">
					                <address>
                                        <strong class="text-main">Supplier: </strong>
					                    <strong class="text-main" id="sup_name"></strong><br>
					                    <span id="company_name"></span><br>
					                    <span id="phone"></span><br>
					                    <span id="address"></span>
					               </address>
					            </div>
					            <div class="col-sm-6 text-xs-center">
					                <table class="invoice-details">
					                    <tbody>
					                        <tr>
					                            <td class="text-main text-bold">Invoice #</td>
					                            <td class="text-right text-info text-bold" id="invoice_no"></td>
					                        </tr>
                                            <tr>
					                            <td class="text-main text-bold">Billing Date</td>
					                            <td class="text-right" id="inv_date"></td>
					                        </tr>
					                        
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					
					        <div class="row">
					            <div class="col-lg-12 table-responsive">
					                <table class="table table-bordered invoice-summary" id="invoice_table" style="margin-bottom: 10px">
					                    <thead>
					                        <tr class="bg-trans-dark">
                                                <th class="min-col text-center text-uppercase">No</th>
					                            <th class="text-uppercase">Description</th>
                                                <th class="min-col text-center text-uppercase">Price</th>
					                            <th class="min-col text-center text-uppercase">Qty</th>
					                            <th class="min-col text-right text-uppercase">Total</th>
					                        </tr>
					                    </thead>
					                    <tbody>
					                    </tbody>
					                </table>
					            </div>
					        </div>
					
					        <div class="clearfix">
					            <table class="table invoice-total">
					                <tbody>
					                    <tr>
					                        <td><strong>Total :</strong></td>
					                        <td class="text-bold h4" id="view_total"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Paid :</strong></td>
					                        <td id="view_paid"></td>
					                    </tr>
					                    <tr>
					                        <td><strong>Due :</strong></td>
					                        <td  id="view_due"></td>
					                    </tr>
					                </tbody>
					            </table>
					        </div>

                            <div class="text-center no-print">
					            <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                                <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
					        </div>
					
					    </div>
					</div>
                        
                    </div>
                    <!--end::Scroll-->
                
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->


@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>

{{-- today date function  --}}
<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>
<script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });
    }); 
</script>

<script>


    $(document).ready(function(){

        $('.select2').select2();

        // Reset total when add modal is opened
        $('#add_modal').on('shown.bs.modal', function() {
            $('#total_material_cost').val('0.00');
            calculateAddTotalPrice();
        });

        // Reset total when add modal is closed
        $('#add_modal').on('hidden.bs.modal', function() {
            $('#total_material_cost').val('0.00');
            $('#product_price').val('');
            $('#labour_cost').val('');
            $('#total_price').val('0');
            $('#summary_production_price').text('Rs. 0.00');
            $('#summary_labour_cost').text('Rs. 0.00');
            $('#summary_material_cost').text('Rs. 0.00');
            $('#summary_total_price').text('Rs. 0.00');
        });


        
        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_price[]" class="form-control text-center pro_price" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="item_qty[]" class="form-control text-center item_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#labtest_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Fetch all products with price for the new select element
            get_all_products_with_price(newRow.find('.products'), '#add_modal');

            // Recalculate total
            calculateTotalMaterialCost();
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="pro_price[]" class="form-control text-center pro_price" readonly>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="number" name="item_qty[]" class="form-control text-center item_qty" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_labtest_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Product',
                allowClear: true,
                dropdownParent: newRow.find('.select2').parent()
            });

            // Fetch all products with price for the new select element
            get_all_products_with_price(newRow.find('.products'), '#update_modal');

            // Recalculate total
            updateCalculateTotalMaterialCost();
        });
        //=========== End Insert Data Ajax Request ===========//


        //=========== Remove Row Button ===========//
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalMaterialCost();
            updateCalculateTotalMaterialCost();
        });
        //=========== End Remove Row Button ===========//


        //=========== Start Custom Status Dropdown ===========//
        $(document).on('change', '.products', function() {
            var id = $(this).val();
            var tr = $(this).closest('tr');
            var selectedOption = $(this).find('option:selected');

            // Get data from option attributes
            var sku = selectedOption.data('sku') || '';
            var purchasePrice = selectedOption.data('purchase-price') || 0;
            var availableQty = selectedOption.data('available-qty') || 0;

            // Set the values in the current row
            tr.find('.pro_sku').val(sku);
            tr.find('.pro_price').val(purchasePrice);
            tr.find('.item_qty').val(1);

            // If available_qty is provided, you can add a max attribute or validation
            if (availableQty > 0) {
                tr.find('.item_qty').attr('max', availableQty);
            }

            // Recalculate total when product changes
            var tableId = tr.closest('table').attr('id');
            if (tableId === 'labtest_table') {
                calculateTotalMaterialCost();
            } else if (tableId === 'update_labtest_table') {
                updateCalculateTotalMaterialCost();
            }
        });
        //=========== End Custom Status Dropdown ===========//

        //=========== Calculate Total Material Cost (Add Modal) ===========//
        function calculateTotalMaterialCost() {
            var total = 0;
            $('#labtest_table tbody tr').each(function() {
                var price = parseFloat($(this).find('.pro_price').val()) || 0;
                var qty = parseFloat($(this).find('.item_qty').val()) || 0;
                total += (price * qty);
            });
            $('#total_material_cost').val(total.toFixed(2));
            calculateAddTotalPrice();
        }
        //=========== End Calculate Total Material Cost ===========//

        //=========== Calculate Total Material Cost (Update Modal) ===========//
        function updateCalculateTotalMaterialCost() {
            var total = 0;
            $('#update_labtest_table tbody tr').each(function() {
                var price = parseFloat($(this).find('.pro_price').val()) || 0;
                var qty = parseFloat($(this).find('.item_qty').val()) || 0;
                total += (price * qty);
            });
            $('#update_total_material_cost').val(total.toFixed(2));
            calculateUpdateTotalPrice();
        }
        //=========== End Calculate Total Material Cost ===========//

        //=========== Calculate Total Price (Add Modal) ===========//
        function calculateAddTotalPrice() {
            var productionPrice = parseFloat($('#product_price').val()) || 0;
            var labourCost = parseFloat($('#labour_cost').val()) || 0;
            var materialCost = parseFloat($('#total_material_cost').val()) || 0;
            
            var totalPrice = productionPrice + labourCost + materialCost;
            
            // Update summary
            $('#summary_production_price').text('Rs. ' + productionPrice.toFixed(2));
            $('#summary_labour_cost').text('Rs. ' + labourCost.toFixed(2));
            $('#summary_material_cost').text('Rs. ' + materialCost.toFixed(2));
            $('#summary_total_price').text('Rs. ' + totalPrice.toFixed(2));
            $('#total_price').val(totalPrice.toFixed(2));
        }
        //=========== End Calculate Total Price (Add Modal) ===========//

        //=========== Calculate Total Price (Update Modal) ===========//
        function calculateUpdateTotalPrice() {
            var productionPrice = parseFloat($('#u_product_price').val()) || 0;
            var labourCost = parseFloat($('#u_labour_cost').val()) || 0;
            var materialCost = parseFloat($('#update_total_material_cost').val()) || 0;
            
            var totalPrice = productionPrice + labourCost + materialCost;
            
            // Update summary
            $('#u_summary_production_price').text('Rs. ' + productionPrice.toFixed(2));
            $('#u_summary_labour_cost').text('Rs. ' + labourCost.toFixed(2));
            $('#u_summary_material_cost').text('Rs. ' + materialCost.toFixed(2));
            $('#u_summary_total_price').text('Rs. ' + totalPrice.toFixed(2));
            $('#u_total_price').val(totalPrice.toFixed(2));
        }
        //=========== End Calculate Total Price (Update Modal) ===========//

        //=========== Trigger calculation on quantity change ===========//
        $(document).on('input', '.item_qty', function() {
            var tableId = $(this).closest('table').attr('id');
            if (tableId === 'labtest_table') {
                calculateTotalMaterialCost();
            } else if (tableId === 'update_labtest_table') {
                updateCalculateTotalMaterialCost();
            }
        });
        //=========== End Trigger calculation ===========//

        //=========== Trigger calculation on price change ===========//
        $(document).on('input', '.pro_price', function() {
            var tableId = $(this).closest('table').attr('id');
            if (tableId === 'labtest_table') {
                calculateTotalMaterialCost();
            } else if (tableId === 'update_labtest_table') {
                updateCalculateTotalMaterialCost();
            }
        });
        //=========== End Trigger calculation ===========//

        //=========== Trigger calculation on labour cost change (Add Modal) ===========//
        $('#labour_cost').on('input', function() {
            calculateAddTotalPrice();
        });
        //=========== End Trigger calculation ===========//

        //=========== Trigger calculation on labour cost change (Update Modal) ===========//
        $('#u_labour_cost').on('input', function() {
            calculateUpdateTotalPrice();
        });
        //=========== End Trigger calculation ===========//


        

        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
            rules: {

                contractor_id: {
                    required: true, 
                }, 
                
            
            },
            messages: {

                contractor_id: {
                    required: "Please Enter data",
                }, 
                
            },


            highlight: function(element) {

            $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
            $(element).css('background-repeat', 'no-repeat');
            $(element).css('background-position', '97%');
            },

            unhighlight: function(element) {

            $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
            $(element).css('background-repeat', 'no-repeat');
            $(element).css('background-position', '97%');
            }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_repair_order") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Data Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Data');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {

                            Swal.fire({
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error",
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: {
                                        confirmButton: "btn fw-bold btn-success"
                                        }
                                    });
                            $('#add_btn').text('Save');
                            $('#add_btn').prop('disabled', false);
                        }

                    },
                    error: function(xhr, status, error) {
                        console.error('Error:', xhr.responseText);
                        Swal.fire({
                            title: "Error!",
                            text: "Server Error: " + (xhr.responseJSON ? xhr.responseJSON.message : error),
                            icon: "error",
                            buttonsStyling: !1,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-success"
                            }
                        });
                        $('#add_btn').text('Save');
                        $('#add_btn').prop('disabled', false);
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//



        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_repair_order/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    // Set basic data
                    $('#order_id').val(data.data.id);
                    $('#u_date').val(data.data.repair_date);
                    $('#u_contractor').val(data.data.contractor_id).trigger('change');
                    $('#u_nonservice_pro_id').val(data.data.pro_id).trigger('change');
                    $('#status').val(data.data.status).trigger('change');
                    $('#u_pro_qty').val(data.data.pro_qty);
                    $('#repair_cost').val(data.data.repair_cost);
                    $('#advance').val(data.data.advance);
                    $('#u_batch_number').val(data.data.batch_number);
                    $('#u_product_price').val(data.data.price);
                    $('#u_labour_cost').val(data.data.labour_cost);


                    if (data.data.status === 'Completed') {
                        // Hide update button
                        $("#update_btn").hide();
                    } else {
                        // Show update button
                        $("#update_btn").show();
                    }

                  
 

                    // Clear and populate table
                    var tableBody = $("#update_labtest_table > tbody");
                    tableBody.empty();

                    // Fetch all products with prices first
                    $.ajax({
                        url: '/get_all_products_with_price',
                        method: 'GET',
                        async: false,
                        dataType: "json",
                        success: function(response) {
                            if (response.status === 200) {
                                var productsMap = {};
                                response.products.forEach(function(product) {
                                    productsMap[product.id] = product;
                                });

                                data.repair_order_details.forEach(function(detail) {
                                    // Get product details from the map
                                    var product = productsMap[detail.pro_id] || {};
                                    var productPrice = product.purchase_price || 0;
                                    var productSku = detail.pro_sku || product.sku || '';

                                    var html =
                                           '<tr>' +
                                            '<td>' +
                                                '<select name="pro_id[]" class="select2 form-control products" style="width: 100%">' +
                                                    '<option value="' + detail.pro_id + '" selected>' + detail.pro_name + '</option>' +
                                                '</select>' +
                                            '</td>' +
                                            '<td class="text-center">' +
                                                '<input type="text" name="pro_sku[]" class="form-control text-center pro_sku" value="' + productSku + '" readonly>' +
                                            '</td>' +
                                            '<td class="text-center">' +
                                                '<input type="number" name="pro_price[]" class="form-control text-center pro_price" value="' + productPrice + '" readonly>' +
                                            '</td>' +
                                            '<td class="text-center">' +
                                                '<input type="number" name="item_qty[]" class="form-control text-center item_qty" value="' + detail.qty + '">' +
                                            '</td>' +
                                            '<td class="text-center">' +
                                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove">' +
                                                    '<i class="fa-solid fa-xmark-large"></i>' +
                                                '</button>' +
                                            '</td>'


                                        '</tr>';

                                    tableBody.append(html);
                                });
                            }
                        }
                    });

                    // Reinitialize Select2
                    $("#update_labtest_table tbody .select2").select2({
                        width: '100%',
                        placeholder: 'Select Product',
                        allowClear: true,
                        dropdownParent: $("#update_modal")
                    });

                    // Calculate total after loading data
                    updateCalculateTotalMaterialCost();

                }

            });
        });
        //=========== Launch Update Modal On Click Edit Btn ===========//


        //=========== End Lounch Update Modal On Click Edit Btn ===========//


        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                
                contractor_id: {
                    required: true, 
                }, 
                status:{
                    required: true,
                    equalToCompleted: true // custom rule
                }
            },
            messages: {
                
                contractor_id: {
                    required: "Please enter BOM Name",
                }, 
                status: {
                    required: "Please select data",
                    equalToCompleted: "You must select 'Completed' to update."
                }
            },


            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
        // Custom validation method
        $.validator.addMethod("equalToCompleted", function(value, element) {
            return value === "Completed";
        }, "You must select 'Completed' to update.");
        //=========== End Update Form Validation ===========//


        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_repair_order") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Data');
                            $('#update_modal').modal('hide');
                            loadData();
                            non_service_products();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');
        });
        //=========== End Lounch View Modal On Click View Btn ===========//


        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();
            var delete_id = $(this).data("did");

            Swal.fire({
                text: "Are you sure you want to delete?",
                icon: "warning",
                showCancelButton: !0,
                buttonsStyling: !1,
                confirmButtonText: "Yes, delete!",
                cancelButtonText: "No, cancel",
                customClass: {
                    confirmButton: "btn fw-bold btn-danger",
                    cancelButton: "btn fw-bold btn-active-light-primary"
                }
            }).then((function(t) {
                if(t.isConfirmed){
                    $.ajax({
                        url: '/delete_repair_order/'+delete_id,
                        method: 'get',
                        dataType: "json",
                        success:function(data){
                            console.log(data);

                            if (data.status == 200) {
                                toastr.success('Data Deleted Successfully!', 'Successfull!');
                                loadData();
                            }else {

                                Swal.fire({
                                        title: "Error!",
                                        text: "Something went wrong!",
                                        icon: "error",
                                        buttonsStyling: !1,
                                        confirmButtonText: "Ok, got it!",
                                        customClass: {
                                            confirmButton: "btn fw-bold btn-success"
                                            }
                                        });
                            }

                        }
                    });
                }
            }
            ))
        });
        //=========== End Delete Data Ajax Request ===========//


        //=========== Get All Products with Price ===========//
        function get_all_products_with_price(selectElement, modalId) {
            $.ajax({
                url: '/get_all_products_with_price',
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status === 200) {
                        selectElement.empty();
                        selectElement.append('<option value="">Select Product</option>');

                        response.products.forEach(function(product) {
                            selectElement.append(
                                '<option value="' + product.id + '" ' +
                                'data-sku="' + (product.sku || '') + '" ' +
                                'data-purchase-price="' + (product.purchase_price || 0) + '" ' +
                                'data-available-qty="' + (product.available_qty || 0) + '">' +
                                product.pro_name + ' (Qty: ' + (product.available_qty || 0) + ')' +
                                '</option>'
                            );
                        });

                        // Reinitialize Select2
                        selectElement.select2({
                            width: '100%',
                            placeholder: 'Select Product',
                            allowClear: true,
                            dropdownParent: $(modalId)
                        });
                    }
                }
            });
        }
        //=========== End Get All Products with Price ===========//


        // Initialize products for the first row in add modal
        get_all_products_with_price($('#labtest_table tbody tr:first .products'), '#add_modal');

        // product
       // Non Service Products
       $('#nonservice_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Non Service Product',
            allowClear: true,
            dropdownParent: $('#nonservice_pro_id').parent() // Set to the parent element of the select box
        });
        $('#u_nonservice_pro_id').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Non Service Product',
            allowClear: true,
            dropdownParent: $('#u_nonservice_pro_id').parent() // Set to the parent element of the select box
        });
        non_service_products();
        // =======================get ===============================
        function non_service_products(){
        $.ajax({
            url:'/non_service_products',
            type:'GET',
            dataType:'json',
            success:function(data){
            console.log(data);
            $('#nonservice_pro_id').empty().append('<option value="">Select Non Service Product</option>');
            $('#u_nonservice_pro_id').empty().append('<option value="">Select Non Service Product</option>');

                $.each(data,function(i,item){
                if($('#nonservice_pro_id option[value="' + data[i].id + '"]').length == 0){
                    $('#nonservice_pro_id').append($('<option>',{
                    value:data[i].id,
                    text:data[i].pro_name + ' (Qty: ' + data[i].total_qty + ')',
                    }));
                }
                });

                $.each(data,function(i,item){
                if($('#u_nonservice_pro_id option[value="' + data[i].id + '"]').length == 0){
                    $('#u_nonservice_pro_id').append($('<option>',{
                    value: data[i].id,
                    text: data[i].pro_name + ' (Qty: ' + data[i].total_qty + ')',
                    }));
                }
                });
                
            }
        });
        }
        // =======================get ===============================


       // contractor 
        $('#contractor').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Contractor',
            allowClear: true,
            dropdownParent: $('#contractor').parent() // Set to the parent element of the select box
        });
        $('#u_contractor').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Contractor',
            allowClear: true,
            dropdownParent: $('#u_contractor').parent() // Set to the parent element of the select box
        });
        get_contractor();
        // =======================get ===============================
        function get_contractor(){
            $.ajax({
            url:'/get_contractor',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#contractor option[value="' + data[i].id + '"]').length == 0){
                        $('#contractor').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_contractor option[value="' + data[i].id + '"]').length == 0){
                        $('#u_contractor').append($('<option>',{
                        value: data[i].id,
                        text: data[i].name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================





        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_repair_order") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "contractor_name" },
                { data: "pro_name" },
                { data: "price" },
                { data: "labour_cost" },
                { data: "material_cost" },
                { data: "total_price" },
                { data: "status" },

                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [3,4,5,6,7] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });


        //=========== End Custom Search Box ===========//


        // Batch Number Auto Generation
        $('#add_batch').on('click', function(e) {
            e.preventDefault();
            var randomNumber = Math.floor(10000000 + Math.random() * 90000000);
            $('#batch_number').val(randomNumber);
        });

        // Load Production Price when Non-Serviceable Product is selected (Add Modal)
        $('#nonservice_pro_id').on('change', function() {
            var productId = $(this).val();

            if (productId) {
                $.ajax({
                    url: '/get_production_price_by_product/' + productId,
                    method: 'GET',
                    dataType: "json",
                    success: function(response) {
                        if (response.status === 200) {
                            $('#product_price').val(response.price || 0);
                            // Also set batch number if available
                            if (response.batch_number) {
                                $('#batch_number').val(response.batch_number);
                            }
                            calculateAddTotalPrice();
                        } else {
                            $('#product_price').val(0);
                            calculateAddTotalPrice();
                        }
                    },
                    error: function() {
                        $('#product_price').val(0);
                        calculateAddTotalPrice();
                    }
                });
            } else {
                $('#product_price').val(0);
                calculateAddTotalPrice();
            }
        });

        // Load Production Price when Non-Serviceable Product is selected (Update Modal)
        $('#u_nonservice_pro_id').on('change', function() {
            var productId = $(this).val();

            if (productId) {
                $.ajax({
                    url: '/get_production_price_by_product/' + productId,
                    method: 'GET',
                    dataType: "json",
                    success: function(response) {
                        if (response.status === 200) {
                            $('#u_product_price').val(response.price || 0);
                            calculateUpdateTotalPrice();
                        } else {
                            $('#u_product_price').val(0);
                            calculateUpdateTotalPrice();
                        }
                    },
                    error: function() {
                        $('#u_product_price').val(0);
                        calculateUpdateTotalPrice();
                    }
                });
            } else {
                $('#u_product_price').val(0);
                calculateUpdateTotalPrice();
            }
        });


    });



</script>
 


@endsection