@extends('admin.main_layout')

@section('css_code')
<style>
    .panel-summary {
        text-align: center;
        padding: 20px;
        color: white;
        border-radius: 5px;
        margin-bottom: 20px;
    }
    .bg-profit { background-color: #26a69a; } /* Green/Teal */
    .bg-loss { background-color: #ef5350; } /* Red */
    .bg-info-custom { background-color: #42a5f5; }
    .bg-warning-custom { background-color: #ffa726; }
    
    .summary-title { font-size: 14px; text-transform: uppercase; font-weight: 600; opacity: 0.9; }
    .summary-value { font-size: 24px; font-weight: bold; margin-top: 5px; }

    .table-detail th { background-color: #f5f5f5; }
    .nav-tabs > li > a { font-weight: 600; }
</style>
@endsection

@section('page_head')
    <div id="page-title">
        <h1 class="page-header text-overflow">Cash Flow & Profit/Loss Report</h1>
    </div>
    <ol class="breadcrumb">
        <li><a href="{{ route('dashboard') }}">Home</a></li>
        <li>Reports</li>
        <li class="active">Cash Flow & P&L</li>
    </ol>
@endsection

@section('page_content')
<div class="panel">
    <div class="panel-body">
        
        <div class="row mar-btm">
            <div class="col-md-4">
                <div class="input-group">
                    <input type="text" class="form-control" id="start_date" name="start_date" placeholder="Start Date" autocomplete="off">
                    <span class="input-group-addon">to</span>
                    <input type="text" class="form-control" id="end_date" name="end_date" placeholder="End Date" autocomplete="off">
                </div>
            </div>
            <div class="col-md-4">
                <button class="btn btn-primary" id="btn-filter">Filter Report</button>
                <button class="btn btn-dark" id="btn-print" style="margin-left: 10px;"><i class="fa fa-print"></i> Print / PDF</button>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-3">
                <div class="panel-summary bg-info-custom">
                    <div class="summary-title">Total Sales Revenue</div>
                    <div class="summary-value" id="val_sales">0.00</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-warning-custom">
                    <div class="summary-title">Total Expenses & Cost</div>
                    <div class="summary-value" id="val_expenses">0.00</div>
                    <small>Purchases, Salaries, Ops</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-profit" id="profit_panel">
                    <div class="summary-title">Net Profit / Loss</div>
                    <div class="summary-value" id="val_profit">0.00</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-primary">
                    <div class="summary-title">Net Cash Flow</div>
                    <div class="summary-value" id="val_cash_flow">0.00</div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-bordered panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title">Income & Inflow Details</h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-striped table-detail">
                            <tbody>
                                <tr>
                                    <td>Total Sales</td>
                                    <td class="text-right text-bold" id="d_sales">0.00</td>
                                </tr>
                                <tr>
                                    <td>Investments Received</td>
                                    <td class="text-right text-bold" id="d_investments">0.00</td>
                                </tr>
                                <tr>
                                    <td>Purchase Returns (Refunds)</td>
                                    <td class="text-right text-bold" id="d_purch_ret">0.00</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-bordered panel-danger">
                    <div class="panel-heading">
                        <h3 class="panel-title">Expenses & Outflow Details</h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-striped table-detail">
                            <tbody>
                                <tr>
                                    <td>Purchases (Accrual)</td>
                                    <td class="text-right text-bold" id="d_purchases">0.00</td>
                                </tr>
                                <tr>
                                    <td>Production Labour Cost</td>
                                    <td class="text-right text-bold" id="d_labour">0.00</td>
                                </tr>
                                <tr>
                                    <td>Employee Salaries</td>
                                    <td class="text-right text-bold" id="d_salaries">0.00</td>
                                </tr>
                                <tr>
                                    <td>General Expenses</td>
                                    <td class="text-right text-bold" id="d_gen_expenses">0.00</td>
                                </tr>
                                <tr>
                                    <td>Salesman Expenses</td>
                                    <td class="text-right text-bold" id="d_sales_expenses">0.00</td>
                                </tr>
                                <tr>
                                    <td>Sale Returns (Refunds)</td>
                                    <td class="text-right text-bold" id="d_sale_ret">0.00</td>
                                </tr>
                                <tr>
                                    <td>Investment Withdrawals</td>
                                    <td class="text-right text-bold" id="d_withdrawals">0.00</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tab-base">
                    <ul class="nav nav-tabs">
                        <li class="active"><a data-toggle="tab" href="#tab-banks">Bank Transactions</a></li>
                        <li><a data-toggle="tab" href="#tab-cash">Cash In Hand</a></li>
                        <li><a data-toggle="tab" href="#tab-sales">Sales</a></li>
                        <li><a data-toggle="tab" href="#tab-purchases">Purchases</a></li>
                        <li><a data-toggle="tab" href="#tab-expenses">Expense Breakdown</a></li>
                        <li><a data-toggle="tab" href="#tab-contractor">Contractor Labour</a></li>
                        <li><a data-toggle="tab" href="#tab-salaries">Salaries</a></li>
                        <li><a data-toggle="tab" href="#tab-investments">Investments</a></li>
                        <li><a data-toggle="tab" href="#tab-withdrawals">Withdrawals</a></li>
                        <li><a data-toggle="tab" href="#tab-returns">Returns</a></li>
                    </ul>
        
                    <div class="tab-content">
                        <div id="tab-banks" class="tab-pane fade active in">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Bank Name</th>
                                        <th class="text-right">Total Deposits</th>
                                        <th class="text-right">Total Withdrawals</th>
                                        <th class="text-right">Net Movement</th>
                                    </tr>
                                </thead>
                                <tbody id="table_banks"></tbody>
                            </table>
                        </div>

                        <div id="tab-cash" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Cash Source / Type</th>
                                        <th class="text-right">Cash In</th>
                                        <th class="text-right">Cash Out</th>
                                        <th class="text-right">Net Movement</th>
                                    </tr>
                                </thead>
                                <tbody id="table_cash"></tbody>
                            </table>
                        </div>

                        <div id="tab-sales" class="tab-pane fade">
                             <table class="table table-hover table-vcenter table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer</th>
                                        <th>Payment Type</th>
                                        <th class="text-right">Total Amount</th>
                                        <th class="text-right">Paid</th>
                                    </tr>
                                </thead>
                                <tbody id="table_sales"></tbody>
                            </table>
                        </div>

                         <div id="tab-purchases" class="tab-pane fade">
                             <table class="table table-hover table-vcenter table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Supplier</th>
                                        <th>Product</th>
                                        <th>Qty</th>
                                        <th class="text-right">Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_purchases"></tbody>
                            </table>
                        </div>

                        <div id="tab-expenses" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Category Name</th>
                                        <th class="text-right">Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_expenses"></tbody>
                            </table>
                        </div>

                        <div id="tab-contractor" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Contractor Name</th>
                                        <th>Order Number</th>
                                        <th class="text-right">Labour Cost</th>
                                    </tr>
                                </thead>
                                <tbody id="table_contractor"></tbody>
                            </table>
                        </div>

                        <div id="tab-salaries" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Employee Name</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th class="text-right">Total Salary</th>
                                    </tr>
                                </thead>
                                <tbody id="table_salaries"></tbody>
                            </table>
                        </div>

                         <div id="tab-investments" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Investor Name</th>
                                        <th>Type</th>
                                        <th class="text-right">Invested Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_investments"></tbody>
                            </table>
                        </div>

                         <div id="tab-withdrawals" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Investor / Company</th>
                                        <th>Type</th>
                                        <th class="text-right">Withdrawn Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_withdrawals"></tbody>
                            </table>
                        </div>

                         <div id="tab-returns" class="tab-pane fade">
                            <table class="table table-hover table-vcenter table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Supplier Name</th>
                                        <th>Product</th>
                                        <th>Qty</th>
                                        <th class="text-right">Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_returns"></tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('javascript_code')
<script>
$(document).ready(function() {
    
    // Store report data globally for printing
    var currentReportData = null;

    // Set default date (This Month)
    var date = new Date();
    var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
    
    // Initialize Daterangepicker
    $('#start_date').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        startDate: firstDay,
        locale: { format: 'YYYY-MM-DD' }
    });

    $('#end_date').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        startDate: lastDay,
        locale: { format: 'YYYY-MM-DD' }
    });

    // Load initial data
    loadReportData();

    $('#btn-filter').click(function() {
        loadReportData();
    });

    $('#btn-print').click(function() {
        printReport();
    });

    function loadReportData() {
        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();

        $.ajax({
            url: "{{ route('cash_flow_data') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                start_date: start_date,
                end_date: end_date
            },
            success: function(response) {
                if(response.status == 200) {
                    currentReportData = response; 
                    updateDashboard(response.summary);
                    updateTables(response.breakdowns, response.details);
                }
            },
            error: function(xhr) {
                console.log(xhr.responseText);
            }
        });
    }

    function updateDashboard(summary) {
        $('#val_sales').text(summary.total_sales);
        
        var total_exp_display = parseFloat(summary.total_purchases.replace(/,/g, '')) + 
                                parseFloat(summary.total_salaries.replace(/,/g, '')) +
                                parseFloat(summary.total_expenses.replace(/,/g, ''));
        
        $('#val_expenses').text(number_format(total_exp_display, 2));
        $('#val_profit').text(summary.net_profit);
        $('#val_cash_flow').text(summary.net_cash_flow);

        var profitVal = parseFloat(summary.net_profit.replace(/,/g, ''));
        if(profitVal < 0) {
            $('#profit_panel').removeClass('bg-profit').addClass('bg-loss');
        } else {
            $('#profit_panel').removeClass('bg-loss').addClass('bg-profit');
        }

        $('#d_sales').text(summary.total_sales);
        $('#d_investments').text(summary.total_investments);
        $('#d_purch_ret').text(summary.total_sale_returns); 

        $('#d_purchases').text(summary.total_purchases);
        $('#d_labour').text(summary.total_labour_cost);
        $('#d_salaries').text(summary.total_salaries);
        $('#d_gen_expenses').text(summary.total_expenses);
        $('#d_sales_expenses').text(summary.total_salesman_expenses);
        $('#d_sale_ret').text(summary.total_sale_returns);
        $('#d_withdrawals').text(summary.total_withdrawals);
    }

    function updateTables(breakdowns, details) {
        // Banks
        var bankHtml = '';
        if(breakdowns.banks.length > 0) {
            $.each(breakdowns.banks, function(i, item){
                var net = parseFloat(item.total_in) - parseFloat(item.total_out);
                bankHtml += '<tr><td>'+item.bank_name+'</td><td class="text-right">'+number_format(item.total_in,2)+'</td><td class="text-right">'+number_format(item.total_out,2)+'</td><td class="text-right text-bold">'+number_format(net,2)+'</td></tr>';
            });
        } else {
            bankHtml = '<tr><td colspan="4" class="text-center">No bank transactions found.</td></tr>';
        }
        $('#table_banks').html(bankHtml);

        // Cash In Hand Summary
        var cashHtml = '';
        if(breakdowns.cash_in_hand.length > 0) {
            $.each(breakdowns.cash_in_hand, function(i, item){
                var net = parseFloat(item.in) - parseFloat(item.out);
                // Only show rows with non-zero activity
                if(item.in != 0 || item.out != 0) {
                    cashHtml += '<tr><td>'+item.name+'</td><td class="text-right">'+number_format(item.in,2)+'</td><td class="text-right">'+number_format(item.out,2)+'</td><td class="text-right text-bold">'+number_format(net,2)+'</td></tr>';
                }
            });
        } else {
             cashHtml = '<tr><td colspan="4" class="text-center">No cash activity found.</td></tr>';
        }
        $('#table_cash').html(cashHtml);

        // Sales
        var salesHtml = '';
        if(details && details.sales && details.sales.length > 0) {
             $.each(details.sales, function(i, item){
                salesHtml += '<tr><td>'+item.invoice_date+'</td><td>'+item.customer_name+'</td><td>'+(item.Payment_type || '-')+'</td><td class="text-right">'+number_format(item.grand_total,2)+'</td><td class="text-right">'+number_format(item.paid,2)+'</td></tr>';
             });
        } else {
             salesHtml = '<tr><td colspan="5" class="text-center">No sales found.</td></tr>';
        }
        $('#table_sales').html(salesHtml);

         // Purchases
        var purchHtml = '';
        if(details && details.purchase_products && details.purchase_products.length > 0) {
             $.each(details.purchase_products, function(i, item){
                purchHtml += '<tr><td>'+item.date+'</td><td>'+item.sup_name+'</td><td>'+item.pro_name+'</td><td>'+item.pro_qty+'</td><td class="text-right">'+number_format(item.total_amount,2)+'</td></tr>';
             });
        } else {
             purchHtml = '<tr><td colspan="5" class="text-center">No purchases found.</td></tr>';
        }
        $('#table_purchases').html(purchHtml);

        // Expenses
        var expHtml = '';
        if(breakdowns.expenses.length > 0) {
            $.each(breakdowns.expenses, function(i, item){
                expHtml += '<tr><td>'+item.name+'</td><td class="text-right">'+number_format(item.total,2)+'</td></tr>';
            });
        } else {
            expHtml = '<tr><td colspan="2" class="text-center">No expenses found.</td></tr>';
        }
        $('#table_expenses').html(expHtml);

        // Contractor
        var contHtml = '';
        if(details && details.contractor_labour && details.contractor_labour.length > 0) {
            $.each(details.contractor_labour, function(i, item){
                contHtml += '<tr><td>'+item.start_date+'</td><td>'+item.name+'</td><td>'+(item.order_number || '-')+'</td><td class="text-right">'+number_format(item.labour_cost,2)+'</td></tr>';
            });
        } else {
            contHtml = '<tr><td colspan="4" class="text-center">No contractor data found.</td></tr>';
        }
        $('#table_contractor').html(contHtml);

        // Salaries
        var salHtml = '';
        if(details && details.salaries && details.salaries.length > 0) {
            $.each(details.salaries, function(i, item){
                salHtml += '<tr><td>'+item.month+'</td><td>'+item.emp_name+'</td><td>'+item.status+'</td><td>'+item.payment_type+'</td><td class="text-right">'+number_format(item.total_salary,2)+'</td></tr>';
            });
        } else {
            salHtml = '<tr><td colspan="5" class="text-center">No salary data found.</td></tr>';
        }
        $('#table_salaries').html(salHtml);

        // Investments
        var invHtml = '';
        if(details && details.investments && details.investments.length > 0) {
            $.each(details.investments, function(i, item){
                invHtml += '<tr><td>'+item.date+'</td><td>'+item.name+'</td><td>'+item.payment_type+'</td><td class="text-right">'+number_format(item.invested_amount,2)+'</td></tr>';
            });
        } else {
            invHtml = '<tr><td colspan="4" class="text-center">No investment data found.</td></tr>';
        }
        $('#table_investments').html(invHtml);

        // Withdrawals
        var wHtml = '';
        if(details && details.withdrawals && details.withdrawals.length > 0) {
            $.each(details.withdrawals, function(i, item){
                wHtml += '<tr><td>'+item.date+'</td><td>'+item.name+'</td><td>'+item.payment_type+'</td><td class="text-right">'+number_format(item.amount,2)+'</td></tr>';
            });
        } else {
            wHtml = '<tr><td colspan="4" class="text-center">No withdrawal data found.</td></tr>';
        }
        $('#table_withdrawals').html(wHtml);

         // Returns
        var retHtml = '';
        if(details && details.purchase_returns && details.purchase_returns.length > 0) {
            $.each(details.purchase_returns, function(i, item){
                retHtml += '<tr><td>'+item.return_date+'</td><td>'+item.sup_name+'</td><td>'+item.pro_name+'</td><td>'+item.pro_qty+'</td><td class="text-right">'+number_format(item.return_amount,2)+'</td></tr>';
            });
        } else {
            retHtml = '<tr><td colspan="5" class="text-center">No return data found.</td></tr>';
        }
        $('#table_returns').html(retHtml);
    }

    function printReport() {
        if(!currentReportData) {
            alert('Please filter data first to print.');
            return;
        }

        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();
        var summary = currentReportData.summary;

        // Determine Profit/Loss Label
        var profitVal = parseFloat(summary.net_profit.replace(/,/g, ''));
        var profitClass = profitVal < 0 ? 'text-danger' : 'text-success';

        var printWindow = window.open('', 'PRINT', 'height=800,width=1000');

        var html = '<html><head><title>Cash Flow & P/L Report</title>';
        html += '<style>';
        html += 'body { font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; padding: 20px; color: #333; }';
        html += '.header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #333; padding-bottom: 10px; }';
        html += '.header h1 { margin: 0; font-size: 20px; text-transform: uppercase; }';
        html += '.header p { margin: 5px 0 0; font-size: 12px; color: #666; }';
        
        html += '.summary-container { display: flex; justify-content: space-between; margin-bottom: 20px; gap: 10px; }';
        html += '.summary-box { flex: 1; border: 1px solid #ddd; border-radius: 4px; padding: 10px; text-align: center; background: #f9f9f9; }';
        html += '.summary-box h3 { margin: 0 0 5px; font-size: 11px; text-transform: uppercase; color: #777; }';
        html += '.summary-box .value { font-size: 16px; font-weight: bold; color: #333; }';
        html += '.text-success { color: #28a745 !important; }';
        html += '.text-danger { color: #dc3545 !important; }';

        html += '.section-title { font-size: 14px; font-weight: bold; border-bottom: 1px solid #ccc; padding-bottom: 3px; margin-top: 15px; margin-bottom: 5px; text-transform: uppercase; }';

        html += 'table { width: 100%; border-collapse: collapse; font-size: 10px; margin-bottom: 10px; }';
        html += 'th, td { border: 1px solid #ddd; padding: 5px; text-align: left; }';
        html += 'th { background-color: #f2f2f2; font-weight: bold; }';
        html += '.text-right { text-align: right; }';
        html += '.text-center { text-align: center; }';
        html += '.text-bold { font-weight: bold; }';
        
        html += '@media print { body { -webkit-print-color-adjust: exact; } }';
        html += '</style></head><body>';

        // Header
        html += '<div class="header">';
        html += '<h1>Cash Flow & Profit/Loss Report</h1>';
        html += '<p>Report Period: ' + start_date + ' to ' + end_date + '</p>';
        html += '</div>';

        // Summary Boxes
        html += '<div class="summary-container">';
        html += '<div class="summary-box"><h3>Sales Revenue</h3><div class="value">' + summary.total_sales + '</div></div>';
        html += '<div class="summary-box"><h3>Net Profit/Loss</h3><div class="value ' + profitClass + '">' + summary.net_profit + '</div></div>';
        html += '<div class="summary-box"><h3>Net Cash Flow</h3><div class="value" style="color:#007bff;">' + summary.net_cash_flow + '</div></div>';
        html += '</div>';

        // Add details to print via a helper function to avoid code duplication
        function addTableToPrint(title, tableId) {
             var content = $('#'+tableId).html();
             if(content) {
                 html += '<div class="section-title">'+title+'</div>';
                 // Reconstruct table with headers
                 var headers = $('#'+tableId).parent().find('thead').html();
                 html += '<table><thead>'+headers+'</thead><tbody>'+content+'</tbody></table>';
             }
        }

        addTableToPrint("Bank Transactions", "table_banks");
        addTableToPrint("Cash In Hand Details", "table_cash");
        addTableToPrint("Sales", "table_sales");
        addTableToPrint("Purchases", "table_purchases");
        addTableToPrint("Expenses", "table_expenses");
        addTableToPrint("Salaries", "table_salaries");
        addTableToPrint("Contractor Labour", "table_contractor");
        addTableToPrint("Investments", "table_investments");
        addTableToPrint("Withdrawals", "table_withdrawals");
        addTableToPrint("Returns", "table_returns");

        html += '</body></html>';

        printWindow.document.write(html);
        printWindow.document.close();
        printWindow.focus();
        
        setTimeout(function() {
            printWindow.print();
            printWindow.close();
        }, 500);
    }

    function number_format(number, decimals) {
        number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
        var n = !isFinite(+number) ? 0 : +number,
            prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
            sep = ',',
            dec = '.',
            s = '',
            toFixedFix = function (n, prec) {
                var k = Math.pow(10, prec);
                return '' + Math.round(n * k) / k;
            };
        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
        if (s[0].length > 3) {
            s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
        return s.join(dec);
    }
});
</script>
@endsection