@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Non-Serviceable Stock Report</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Non-Serviceable Stock Report</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Filter Type</label>
                            <select id="filter_type" class="form-control">
                                <option value="all">All</option>
                                <option value="product_sale_return">Product wise Sale Return</option>
                                <option value="salesman_sale_return">Salesman wise Sale Return</option>
                                <option value="product_repair">Product wise Repair</option>
                                <option value="contractor_repair">Contractor wise Repair</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3" id="product_filter_div" style="display: none;">
                        <div class="form-group">
                            <label>Product</label>
                            <select id="product_filter" class="form-control">
                                <option value="">Select Product</option>
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}">{{ $product->pro_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3" id="salesman_filter_div" style="display: none;">
                        <div class="form-group">
                            <label>Salesman</label>
                            <select id="salesman_filter" class="form-control">
                                <option value="">Select Salesman</option>
                                @foreach($salesmen as $salesman)
                                    <option value="{{ $salesman->id }}">{{ $salesman->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3" id="contractor_filter_div" style="display: none;">
                        <div class="form-group">
                            <label>Contractor</label>
                            <select id="contractor_filter" class="form-control">
                                <option value="">Select Contractor</option>
                                @foreach($contractors as $contractor)
                                    <option value="{{ $contractor->id }}">{{ $contractor->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Apply Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info" title="Print">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success" title="Export to Excel">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                    <button id="pdf_btn" class="btn btn-danger" title="Export to PDF">
                        <i class="fa fa-file-pdf-o"></i> PDF
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="non_serviceable_report_table">
                    <thead>
                        <tr style="background-color: #f5f5f5;">
                            <th width="5%">S.No</th>
                            <th width="20%">Product</th>
                            <th width="10%">SKU</th>
                            <th width="10%">Batch #</th>
                            <th width="10%">Quantity</th>
                            <th width="12%">Date</th>
                            <th width="15%">Source</th>
                            <th width="18%">Related Person</th>
                        </tr>
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="8" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading report...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Handle filter type change
        $('#filter_type').on('change', function() {
            var filterType = $(this).val();

            // Hide all filter divs
            $('#product_filter_div').hide();
            $('#salesman_filter_div').hide();
            $('#contractor_filter_div').hide();

            // Show relevant filter div
            if (filterType === 'product_sale_return' || filterType === 'product_repair') {
                $('#product_filter_div').show();
            } else if (filterType === 'salesman_sale_return') {
                $('#salesman_filter_div').show();
            } else if (filterType === 'contractor_repair') {
                $('#contractor_filter_div').show();
            }
        });

        // Filter button click
        $('#filter_btn').on('click', function() {
            loadReport();
        });

        // Load report on page load
        loadReport();

        // Function to load report
        function loadReport() {
            var filterType = $('#filter_type').val();
            var productId = $('#product_filter').val();
            var salesmanId = $('#salesman_filter').val();
            var contractorId = $('#contractor_filter').val();

            $.ajax({
                url: '{{ route("non_serviceable_stock_report_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    filter_type: filterType,
                    product_id: productId,
                    salesman_id: salesmanId,
                    contractor_id: contractorId
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="8" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        var data = response.data;
                        var html = '';

                        if (data.length === 0) {
                            html = '<tr><td colspan="8" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(data, function(index, item) {
                                html += '<tr>';
                                html += '<td>' + item.sno + '</td>';
                                html += '<td>' + item.product_name + '</td>';
                                html += '<td>' + item.sku + '</td>';
                                html += '<td>' + item.batch_no + '</td>';
                                html += '<td>' + item.quantity + '</td>';
                                html += '<td>' + item.date + '</td>';
                                html += '<td>' + item.source + '</td>';
                                html += '<td>' + item.related_person + '</td>';
                                html += '</tr>';
                            });
                        }

                        $('#report_tbody').html(html);
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load report', 'error');
                }
            });
        }

        // Print functionality
        $('#print_btn').on('click', function() {
            window.print();
        });

        // Excel export
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('non_serviceable_report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'non_serviceable_stock_report_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });

        // PDF export placeholder
        $('#pdf_btn').on('click', function() {
            swal('Info', 'PDF export feature will be implemented with a PDF library', 'info');
        });
    });
</script>
@endsection
