@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .totals-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .totals-card .total-item {
            text-align: center;
            padding: 10px;
        }
        .totals-card .total-label {
            font-size: 12px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        .totals-card .total-value {
            font-size: 20px;
            font-weight: bold;
        }
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Order Booker Order Report</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Order Booker Order Report</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="text" id="start_date" class="form-control datepicker" placeholder="From Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="text" id="end_date" class="form-control datepicker" placeholder="To Date" autocomplete="off">
                        </div>
                    </div>
                    @if (Auth::user()->hasRole(['Admin', 'Super Admin']))
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Order Booker</label>
                            <select id="order_booker_filter" class="form-control">
                                <option value="all">All Order Bookers</option>
                                @foreach($order_bookers as $order_booker)
                                    <option value="{{ $order_booker->id }}">{{ $order_booker->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>View Type</label>
                            <select id="view_type" class="form-control">
                                <option value="detailed">Detailed</option>
                                <option value="daily">Daily Summary</option>
                                <option value="monthly">Monthly Summary</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Apply Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Totals Card -->
            <div class="totals-card" id="totals_card" style="display: none;">
                <div class="row">
                    <div class="col-md-2 total-item">
                        <div class="total-label">Total Orders</div>
                        <div class="total-value" id="total_orders">0</div>
                    </div>
                    <div class="col-md-2 total-item">
                        <div class="total-label">Total Subtotal</div>
                        <div class="total-value" id="total_subtotal">Rs. 0</div>
                    </div>
                    <div class="col-md-2 total-item">
                        <div class="total-label">Total Discount</div>
                        <div class="total-value" id="total_discount">Rs. 0</div>
                    </div>
                    <div class="col-md-2 total-item">
                        <div class="total-label">Grand Total</div>
                        <div class="total-value" id="total_grand">Rs. 0</div>
                    </div>
                    <div class="col-md-2 total-item">
                        <div class="total-label">Total Paid</div>
                        <div class="total-value" id="total_paid">Rs. 0</div>
                    </div>
                    <div class="col-md-2 total-item">
                        <div class="total-label">Total Due</div>
                        <div class="total-value" id="total_due">Rs. 0</div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info" title="Print">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success" title="Export to Excel">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="report_table">
                    <thead id="table_head">
                        <!-- Dynamic thead will be inserted here -->
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="12" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading report...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Initialize date pickers
        $('#start_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: { format: 'DD-MM-YYYY' }
        });
        $('#start_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#end_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: { format: 'DD-MM-YYYY' }
        });
        $('#end_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#filter_btn').on('click', function() { loadReport(); });
        $('#view_type').on('change', function() { loadReport(); });
        loadReport();

        function loadReport() {
            $.ajax({
                url: '{{ route("order_booker_order_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    start_date: $('#start_date').val(),
                    end_date: $('#end_date').val(),
                    order_booker_id: $('#order_booker_filter').val(),
                    view_type: $('#view_type').val()
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="12" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        if ($('#view_type').val() === 'detailed') {
                            renderDetailedView(response);
                        } else {
                            renderSummaryView(response);
                        }
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load report', 'error');
                }
            });
        }

        function renderDetailedView(response) {
            var data = response.data;
            var totals = response.totals;
            var thead = '<tr style="background-color: #f5f5f5;">';
            thead += '<th>S.No</th><th>Date</th><th>Order ID</th><th>Order Booker</th><th>Customer</th>';
            thead += '<th>Subtotal</th><th>Discount</th><th>Grand Total</th><th>Paid</th><th>Due</th><th>Status</th>';
            thead += '</tr>';
            $('#table_head').html(thead);

            var html = '';
            if (data.length === 0) {
                html = '<tr><td colspan="11" class="text-center">No records found</td></tr>';
            } else {
                $.each(data, function(index, item) {
                    html += '<tr>';
                    html += '<td>' + item.sno + '</td>';
                    html += '<td>' + item.invoice_date + '</td>';
                    html += '<td>' + item.order_id + '</td>';
                    html += '<td>' + item.order_booker_name + '</td>';
                    html += '<td>' + item.customer_name + '</td>';
                    html += '<td>Rs. ' + item.subtotal + '</td>';
                    html += '<td>Rs. ' + item.discount + '</td>';
                    html += '<td>Rs. ' + item.grand_total + '</td>';
                    html += '<td>Rs. ' + item.paid + '</td>';
                    html += '<td>Rs. ' + item.due + '</td>';
                    html += '<td>' + item.status_badge + '</td>';
                    html += '</tr>';
                });
            }

            $('#report_tbody').html(html);
            $('#total_orders').text(totals.total_orders);
            $('#total_subtotal').text('Rs. ' + totals.total_subtotal);
            $('#total_discount').text('Rs. ' + totals.total_discount);
            $('#total_grand').text('Rs. ' + totals.total_grand);
            $('#total_paid').text('Rs. ' + totals.total_paid);
            $('#total_due').text('Rs. ' + totals.total_due);
            $('#totals_card').fadeIn();
        }

        function renderSummaryView(response) {
            var summary = response.summary;
            var thead = '<tr style="background-color: #f5f5f5;">';
            thead += '<th>Period</th><th>Total Orders</th><th>Total Subtotal</th><th>Total Amount</th>';
            thead += '</tr>';
            $('#table_head').html(thead);

            var html = '';
            if (summary.length === 0) {
                html = '<tr><td colspan="4" class="text-center">No records found</td></tr>';
            } else {
                $.each(summary, function(index, item) {
                    html += '<tr>';
                    html += '<td>' + item.period + '</td>';
                    html += '<td>' + item.total_orders + '</td>';
                    html += '<td>Rs. ' + item.total_subtotal + '</td>';
                    html += '<td>Rs. ' + item.total_amount + '</td>';
                    html += '</tr>';
                });
            }

            $('#report_tbody').html(html);
            $('#totals_card').fadeIn();
        }

        $('#print_btn').on('click', function() { window.print(); });
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'order_booker_order_report_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });
    });
</script>
@endsection
