@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .totals-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .totals-card .total-item {
            text-align: center;
            padding: 10px;
        }
        .totals-card .total-label {
            font-size: 12px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        .totals-card .total-value {
            font-size: 20px;
            font-weight: bold;
        }
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Repairing Order Report</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Repairing Order Report</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Contractor</label>
                            <select id="contractor_filter" class="form-control">
                                <option value="all">All Contractors</option>
                                @foreach($contractors as $contractor)
                                    <option value="{{ $contractor->id }}">{{ $contractor->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="text" id="start_date" class="form-control datepicker" placeholder="From Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="text" id="end_date" class="form-control datepicker" placeholder="To Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Totals Card -->
            <div class="totals-card" id="totals_card" style="display: none;">
                <div class="row">
                    <div class="col-md-3 total-item">
                        <div class="total-label">Total Price</div>
                        <div class="total-value" id="total_price">Rs. 0</div>
                    </div>
                    <div class="col-md-3 total-item">
                        <div class="total-label">Total Labour Cost</div>
                        <div class="total-value" id="total_labour_cost">Rs. 0</div>
                    </div>
                    <div class="col-md-3 total-item">
                        <div class="total-label">Total Material Cost</div>
                        <div class="total-value" id="total_material_cost">Rs. 0</div>
                    </div>
                    <div class="col-md-3 total-item">
                        <div class="total-label">Grand Total</div>
                        <div class="total-value" id="total_total_price">Rs. 0</div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info" title="Print">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success" title="Export to Excel">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                    <button id="pdf_btn" class="btn btn-danger" title="Export to PDF">
                        <i class="fa fa-file-pdf-o"></i> PDF
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="repairing_order_report_table">
                    <thead>
                        <tr style="background-color: #f5f5f5;">
                            <th width="5%">S.No</th>
                            <th width="5%">ID</th>
                            <th width="15%">Contractor</th>
                            <th width="20%">Product</th>
                            <th width="12%">Price</th>
                            <th width="12%">Labour Cost</th>
                            <th width="12%">Material Cost</th>
                            <th width="12%">Total Price</th>
                            <th width="10%">Status</th>
                        </tr>
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="9" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading report...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Initialize date pickers
        $('#start_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#start_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#end_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#end_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        // Filter button click
        $('#filter_btn').on('click', function() {
            loadReport();
        });

        // Load report on page load
        loadReport();

        // Function to load report
        function loadReport() {
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            var contractorId = $('#contractor_filter').val();

            $.ajax({
                url: '{{ route("repairing_order_report_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    start_date: startDate,
                    end_date: endDate,
                    contractor_id: contractorId
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="9" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        var data = response.data;
                        var totals = response.totals;
                        var html = '';

                        if (data.length === 0) {
                            html = '<tr><td colspan="9" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(data, function(index, item) {
                                html += '<tr>';
                                html += '<td>' + item.sno + '</td>';
                                html += '<td>' + item.id + '</td>';
                                html += '<td>' + item.contractor_name + '</td>';
                                html += '<td>' + item.product_name + '</td>';
                                html += '<td>Rs. ' + item.price + '</td>';
                                html += '<td>Rs. ' + item.labour_cost + '</td>';
                                html += '<td>Rs. ' + item.material_cost + '</td>';
                                html += '<td>Rs. ' + item.total_price + '</td>';
                                html += '<td>' + item.status + '</td>';
                                html += '</tr>';
                            });
                        }

                        $('#report_tbody').html(html);

                        // Update totals
                        $('#total_price').text('Rs. ' + totals.total_price);
                        $('#total_labour_cost').text('Rs. ' + totals.total_labour_cost);
                        $('#total_material_cost').text('Rs. ' + totals.total_material_cost);
                        $('#total_total_price').text('Rs. ' + totals.total_total_price);
                        $('#totals_card').fadeIn();
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load report', 'error');
                }
            });
        }

        // Print functionality
        $('#print_btn').on('click', function() {
            window.print();
        });

        // Excel export
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('repairing_order_report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'repairing_order_report_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });

        // PDF export placeholder
        $('#pdf_btn').on('click', function() {
            swal('Info', 'PDF export feature will be implemented with a PDF library', 'info');
        });
    });
</script>
@endsection
