@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .summary-section {
            margin-bottom: 30px;
        }
        .summary-title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
            color: #333;
            border-bottom: 2px solid #f5576c;
            padding-bottom: 10px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Sale Return Summary</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Sale Return Summary</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="text" id="start_date" class="form-control datepicker" placeholder="From Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="text" id="end_date" class="form-control datepicker" placeholder="To Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>View Type</label>
                            <select id="view_type" class="form-control">
                                <option value="daily">Daily</option>
                                <option value="monthly">Monthly</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Apply Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                </div>
            </div>

            <!-- Product-wise Return Summary -->
            <div class="summary-section">
                <div class="summary-title">Product-wise Sale Return Summary (Most Returned Products)</div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered" id="product_summary_table">
                        <thead>
                            <tr style="background-color: #f5f5f5;">
                                <th width="10%">S.No</th>
                                <th width="50%">Product Name</th>
                                <th width="20%">Total Quantity Returned</th>
                                <th width="20%">Total Return Amount</th>
                            </tr>
                        </thead>
                        <tbody id="product_tbody">
                            <tr>
                                <td colspan="4" class="text-center">
                                    <p style="padding: 30px 0;"><i class="fa fa-spinner fa-spin"></i> Loading complete summary...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Date-wise Return Summary -->
            <div class="summary-section">
                <div class="summary-title" id="date_summary_title">Daily Sale Return Summary</div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered" id="date_summary_table">
                        <thead>
                            <tr style="background-color: #f5f5f5;">
                                <th width="10%">S.No</th>
                                <th width="30%">Date/Month</th>
                                <th width="20%">Total Returns</th>
                                <th width="20%">Total Quantity</th>
                                <th width="20%">Total Amount</th>
                            </tr>
                        </thead>
                        <tbody id="date_tbody">
                            <tr>
                                <td colspan="5" class="text-center">
                                    <p style="padding: 30px 0;"><i class="fa fa-spinner fa-spin"></i> Loading complete summary...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Initialize date pickers with daterangepicker
        $('#start_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#start_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#end_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#end_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        // Leave date fields empty to load all data by default
        // Users can select dates and apply filter to narrow down results

        // View type change
        $('#view_type').on('change', function() {
            var viewType = $(this).val();
            if (viewType === 'monthly') {
                $('#date_summary_title').text('Monthly Sale Return Summary');
            } else {
                $('#date_summary_title').text('Daily Sale Return Summary');
            }
        });

        // Filter button click
        $('#filter_btn').on('click', function() {
            loadSummary();
        });

        // Load complete summary on page load (all data, no date filter)
        loadSummary();

        // Function to load summary
        function loadSummary() {
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            var viewType = $('#view_type').val();

            $.ajax({
                url: '{{ route("sale_return_summary_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    start_date: startDate,
                    end_date: endDate,
                    view_type: viewType
                },
                beforeSend: function() {
                    $('#product_tbody').html('<tr><td colspan="4" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                    $('#date_tbody').html('<tr><td colspan="5" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        // Product summary
                        var productData = response.product_summary;
                        var productHtml = '';

                        if (productData.length === 0) {
                            productHtml = '<tr><td colspan="4" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(productData, function(index, item) {
                                productHtml += '<tr>';
                                productHtml += '<td>' + (index + 1) + '</td>';
                                productHtml += '<td>' + item.pro_name + '</td>';
                                productHtml += '<td>' + parseFloat(item.total_qty).toLocaleString() + '</td>';
                                productHtml += '<td>Rs. ' + parseFloat(item.total_amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2}) + '</td>';
                                productHtml += '</tr>';
                            });
                        }

                        $('#product_tbody').html(productHtml);

                        // Date summary
                        var dateData = response.date_summary;
                        var dateHtml = '';

                        if (dateData.length === 0) {
                            dateHtml = '<tr><td colspan="5" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(dateData, function(index, item) {
                                dateHtml += '<tr>';
                                dateHtml += '<td>' + (index + 1) + '</td>';
                                dateHtml += '<td>' + item.period + '</td>';
                                dateHtml += '<td>' + item.total_returns + '</td>';
                                dateHtml += '<td>' + item.total_qty + '</td>';
                                dateHtml += '<td>Rs. ' + item.total_amount + '</td>';
                                dateHtml += '</tr>';
                            });
                        }

                        $('#date_tbody').html(dateHtml);
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load summary', 'error');
                }
            });
        }

        // Print functionality
        $('#print_btn').on('click', function() {
            window.print();
        });

        // Excel export
        $('#excel_btn').on('click', function() {
            var productTable = document.getElementById('product_summary_table');
            var dateTable = document.getElementById('date_summary_table');
            var html = '<h2>Product-wise Sale Return Summary</h2>' + productTable.outerHTML + '<br><h2>Date-wise Sale Return Summary</h2>' + dateTable.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'sale_return_summary_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });
    });
</script>
@endsection
