@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .totals-card {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .totals-card .total-item {
            text-align: center;
            padding: 10px;
        }
        .totals-card .total-label {
            font-size: 12px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        .totals-card .total-value {
            font-size: 20px;
            font-weight: bold;
        }
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .status-counts {
            margin-bottom: 20px;
        }
        .status-count-item {
            background: white;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-align: center;
        }
        .status-count-item .count {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .status-count-item .label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Salesman Order Report</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Salesman Order Report</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="text" id="start_date" class="form-control datepicker" placeholder="From Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="text" id="end_date" class="form-control datepicker" placeholder="To Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Status Filter</label>
                            <select id="status_filter" class="form-control">
                                <option value="all">All Status</option>
                                <option value="pending">Pending</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Apply Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Status Counts -->
            <div class="status-counts" id="status_counts" style="display: none;">
                <div class="row">
                    <div class="col-md-3">
                        <div class="status-count-item">
                            <div class="count" id="pending_count">0</div>
                            <div class="label">Pending Orders</div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="status-count-item">
                            <div class="count" id="completed_count">0</div>
                            <div class="label">Completed Orders</div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="status-count-item">
                            <div class="count" id="cancelled_count">0</div>
                            <div class="label">Cancelled Orders</div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="status-count-item">
                            <div class="count" id="total_orders_count">0</div>
                            <div class="label">Total Orders</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Totals Card -->
            <div class="totals-card" id="totals_card" style="display: none;">
                <div class="row">
                    <div class="col-md-12 total-item">
                        <div class="total-label">Total Quantity Ordered</div>
                        <div class="total-value" id="total_quantity">0</div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                    <button id="pdf_btn" class="btn btn-danger">
                        <i class="fa fa-file-pdf-o"></i> PDF
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="order_report_table">
                    <thead>
                        <tr style="background-color: #f5f5f5;">
                            <th width="5%">S.No</th>
                            <th width="12%">Date</th>
                            <th width="15%">Order ID</th>
                            <th width="35%">Item Name</th>
                            <th width="12%">Qty</th>
                            <th width="15%">Status</th>
                        </tr>
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="6" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading complete report...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Initialize date pickers with daterangepicker
        $('#start_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#start_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#end_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
        $('#end_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        // Leave date fields empty to load all data by default
        // Users can select dates and apply filter to narrow down results

        // Filter button click
        $('#filter_btn').on('click', function() {
            loadReport();
        });

        // Load complete report on page load (all data, no date filter)
        loadReport();

        // Function to load report
        function loadReport() {
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            var statusFilter = $('#status_filter').val();

            $.ajax({
                url: '{{ route("salesman_order_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    start_date: startDate,
                    end_date: endDate,
                    status_filter: statusFilter
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="6" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        var data = response.data;
                        var totals = response.totals;
                        var html = '';

                        if (data.length === 0) {
                            html = '<tr><td colspan="6" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(data, function(index, item) {
                                html += '<tr>';
                                html += '<td>' + item.sno + '</td>';
                                html += '<td>' + item.order_date + '</td>';
                                html += '<td>' + item.order_id + '</td>';
                                html += '<td>' + item.pro_name + '</td>';
                                html += '<td>' + item.quantity + '</td>';
                                html += '<td>' + item.status_badge + '</td>';
                                html += '</tr>';
                            });
                        }

                        $('#report_tbody').html(html);

                        // Update totals
                        $('#total_quantity').text(totals.total_quantity);
                        $('#total_orders_count').text(totals.total_orders);
                        $('#pending_count').text(totals.pending_count);
                        $('#completed_count').text(totals.completed_count);
                        $('#cancelled_count').text(totals.cancelled_count);

                        $('#totals_card').fadeIn();
                        $('#status_counts').fadeIn();
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load report', 'error');
                }
            });
        }

        // Print functionality
        $('#print_btn').on('click', function() {
            window.print();
        });

        // Excel export
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('order_report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'salesman_order_report_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });

        // PDF export placeholder
        $('#pdf_btn').on('click', function() {
            swal('Info', 'PDF export feature will be implemented with a PDF library', 'info');
        });
    });
</script>
@endsection
