@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <style>
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
@endsection

@section('page_head')
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Storeman Sale Return Summary</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Storeman Sale Return Summary</li>
            </ol>
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="text" id="start_date" class="form-control datepicker" placeholder="From Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="text" id="end_date" class="form-control datepicker" placeholder="To Date" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Salesman</label>
                            <select id="salesman_filter" class="form-control">
                                <option value="all">All Salesmen</option>
                                @foreach($salesmen as $salesman)
                                    <option value="{{ $salesman->id }}">{{ $salesman->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Customer</label>
                            <select id="customer_filter" class="form-control">
                                <option value="all">All Customers</option>
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->display_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Product</label>
                            <select id="product_filter" class="form-control">
                                <option value="all">All Products</option>
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}">{{ $product->pro_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>View Type</label>
                            <select id="view_type" class="form-control">
                                <option value="product">By Product</option>
                                <option value="customer">By Customer</option>
                                <option value="salesman">By Salesman</option>
                                <option value="daily">Daily Summary</option>
                                <option value="monthly">Monthly Summary</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <button id="filter_btn" class="btn btn-primary btn-block">
                                <i class="fa fa-filter"></i> Apply Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info" title="Print">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success" title="Export to Excel">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="report_table">
                    <thead>
                        <tr style="background-color: #f5f5f5;">
                            <th width="60%">Group</th>
                            <th width="20%">Total Quantity</th>
                            <th width="20%">Total Amount</th>
                        </tr>
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="3" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading summary...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('javascript_code')
<script src="{{ asset('backend/my_plugins/timepicker/timepicker.min.js') }}"></script>

<script>
    $(document).ready(function() {
        $('#start_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: { format: 'DD-MM-YYYY' }
        });
        $('#start_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#end_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: { format: 'DD-MM-YYYY' }
        });
        $('#end_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#filter_btn').on('click', function() { loadReport(); });
        $('#view_type').on('change', function() { loadReport(); });
        loadReport();

        function loadReport() {
            $.ajax({
                url: '{{ route("storeman_sale_return_summary_data") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    start_date: $('#start_date').val(),
                    end_date: $('#end_date').val(),
                    salesman_id: $('#salesman_filter').val(),
                    customer_id: $('#customer_filter').val(),
                    product_id: $('#product_filter').val(),
                    view_type: $('#view_type').val()
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="3" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        var summary = response.summary;
                        var html = '';

                        if (summary.length === 0) {
                            html = '<tr><td colspan="3" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(summary, function(index, item) {
                                html += '<tr>';
                                html += '<td>' + item.group_name + '</td>';
                                html += '<td>' + item.total_qty + '</td>';
                                html += '<td>Rs. ' + item.total_amount + '</td>';
                                html += '</tr>';
                            });
                        }

                        $('#report_tbody').html(html);
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load summary', 'error');
                }
            });
        }

        $('#print_btn').on('click', function() { window.print(); });
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'storeman_sale_return_summary_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });
    });
</script>
@endsection
