@extends('admin.main_layout')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/dropify/css/dropify.min.css') }}">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
    .custom-dropify .dropify-wrapper {
        max-width: 200px;  
        height: 70px;  
    }

     
    .custom-dropify .dropify-wrapper .dropify-message p {
        font-size: 12px;  
    }
    
    </style>


@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">SaleMan Stock</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage SaleMan Stock  </li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        {{-- <div class="col-md-6"> 
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Payable <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Receivable <br> <b id="total_credit">0</b></div>
                <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div>
            </div> 
        </div> --}}
    </div>
@endsection

@section('page_content')

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        @if (!Auth::user()->hasRole('Sales Man'))
                        <div class="form-group">
                            <select id="search_by_salesman" class="demo_select2 form-control" style="width: 200px">
                                <option></option>
                            </select>
                        </div>
                        @endif


                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        {{-- <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New  Stock</button> --}}
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Product </a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">SKU </a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Total qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Sale qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Order Return qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Balance</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Prodcut </th>
                            <th width="10%">SKU </th>
                            <th width="10%">Total qty</th>
                            <th width="10%">Sale qty</th>
                            <th width="10%">Order Return qty</th>

                            <th width="15%">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
   


@endsection



@section('javascript_code')

<script src="{{ asset('backend/my_plugins/dropify/js/dropify.min.js') }}"></script>



<script>


    $(document).ready(function(){

        $('.select2').select2();


        


        $("#search_by_salesman").select2({
            placeholder: "Search By Salesman",
            allowClear: true,
        });

        get_users();
        // =======================get ===============================
        function get_users(){
            $.ajax({
            url:'/get_users',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#search_by_salesman option[value="' + data[i].id + '"]').length == 0){
                        $('#search_by_salesman').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });
                    
                }
            });
        };



        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_saleman_stock") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "pro_name" },
                { data: "sku" },

                { data: "total_stock_in_qty" },
                { data: "total_sales_qty" },
                { data: "total_return_qty" },                

                { data: "balance" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                // { className: 'text-center td-30', targets: [3, 5] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "", search_by_salesman = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type, search_by_salesman: search_by_salesman }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });

        
        //=========== End Custom Search Box ===========//

        //=========== Start Custom Status Dropdown ===========//
        $('#search_by_salesman').on('change', function(){

            var search_by_salesman = $(this).val();

            if(search_by_salesman == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", "", search_by_salesman);
            }

        });
        //=========== End Custom Status Dropdown ===========//






    });



</script>





@endsection