@extends('admin.layout.layout')

@section('page_head')

@section('css_code')
    <link rel="stylesheet" href="{{ asset('backend/my_plugins/timepicker/timepicker.min.css') }}">
@endsection


@section('page_head')
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Supplier Ledger</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li id="supplier_name"></li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Debit <br> <b id="total_debit">0</b></div>
                <div class="page-header counting">Total Credit Pay<br> <b id="total_credit">0</b></div>
                <div class="page-header counting round-corner-right">Total Balance <br> <b id="total_balance">0</b></div>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>
@endsection

@section('page_content')
    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                        <div class="form-group">
                            <select id="payment_type_filter" class="demo_select2 form-control" style="width: 200px">
                                <option></option>
                                <option value="all">All</option>
                                <option value="Payment">Payment</option>
                                <option value="Purchase">Purchase</option>
                                <option value="Return">Return</option>
                            </select>
                        </div>
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        @if (!Auth::user()->hasRole('Supplier'))
                            <button id="add_modal_btn" class="btn btn-purple"><i class="demo-pli-add"></i> Add Payment</button>
                        @endif
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Detail</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Trn Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Debit</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Credit Pay</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Bank Pay</a></li>

                                <li><a href="#" class="toggle-vis" data-column="7">Balance</a></li>
                                @if (!Auth::user()->hasRole('Supplier'))
                                <li><a href="#" class="toggle-vis" data-column="8">Buttons</a></li>
                                @endif
                            </ul>
                        </div>

                        <button id="return_back_btn" onclick="window.history.back();" class="btn btn-success"><i class="fa-duotone fa-chevrons-left"></i> Back</button>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="10px">Id</th>
                            <th width="75px">Date</th>
                            <th width="180px">Detail</th>
                            <th width="100px">Trn Type</th>
                            <th width="50px">Debit</th>
                            <th width="80px">Credit Pay</th>
                            <th width="80px">Bank Pay</th>

                            <th width="50px">Balance</th>
                            @if (!Auth::user()->hasRole('Supplier'))
                            <th width="75px">Action</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add Payment</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="hidden" name="sup_pay_id" id="sup_pay_id" class="form-control textbox" placeholder=" ">
                                        <input type="text" name="payment_date" id="payment_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Payment Date</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="amount" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Amount</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="trn_type" data-style="custom-select-style" id="payment_type">
                                        <option value="" selected disabled>Select Payment Type</option>
                                        <option value="credit">Credit</option>
                                        <option value="debit">Debit</option>
                                        <option value="bank">Bank</option>

                                    </select>
                                </div>
                                <div class="col-sm-12" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="detail" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Detail</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Payment</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="hidden" name="pay_id" id="u_pay_id" class="form-control textbox" placeholder=" ">
                                        <input type="text" name="payment_date" id="u_payment_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Payment Date</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="amount" id="u_amount" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Amount</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="payment_type" id="u_payment_type" data-style="custom-select-style">
                                        <option value="credit">Credit</option>
                                        <option value="debit">Debit</option>
                                        <option value="bank">Bank</option>

                                    </select>
                                </div>
                                <div class="col-sm-12" id="u_bank_area">
                                    <div class="form-group">
                                        <select id="u_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="detail" id="u_detail" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Detail</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->

    @endsection



    @push('script')

    <script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });

        $('#u_transaction_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#u_bank_area').show();
            } else {
                $('#u_bank_area').hide();
            }
        });



        // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================





    }); 
    </script>

    <script>
    $(document).ready(function(){

        function getIdFromUrl() {
            var pathArray = window.location.pathname.split('/');
            return pathArray[pathArray.length - 1]; // Assumes the ID is the last part of the URL
        }

        // Get the ID from the URL
        var sup_id = getIdFromUrl();


        $('#payment_date').daterangepicker({
            // autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#payment_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_payment_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_payment_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });



        $("#add_modal_btn").click(function(e){
            e.preventDefault();

            $("#add_modal").modal('show');

            $('#sup_pay_id').val(sup_id);

        });


        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    sup_name: {
                        required: true,
                    },
                    phone_no: {
                        required: true,
                    },
                    
                },
                messages: {
                    sup_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_no: {
                        required: "Please enter Supplier Name",
                    },
                },

                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '{{ route("insert_supplier_payment") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Payment Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Payment');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save Payment');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_supplier_payment/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#u_pay_id').val(response.data.id);
                    $('#u_payment_date').val(response.data.date);
                    if(response.data.pay > 0){
                        $('#u_amount').val(parseFloat(response.data.pay).toFixed(0)); 
                        $('#u_payment_type').val('credit').trigger('change');
                    }else if(response.data.pending > 0){
                        $('#u_amount').val(parseFloat(response.data.pending).toFixed(0));
                        $('#u_payment_type').val('debit').trigger('change');
                    }
                    else if(response.data.bank > 0){
                        $('#u_amount').val(parseFloat(response.data.bank).toFixed(0));
                        $('#u_payment_type').val('bank').trigger('change');
                        $('#u_banks').val(response.data.bank_id).trigger('change');
                    }
                    $('#u_detail').val(response.data.trn_detail);

                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    sup_name: {
                        required: true,
                    },
                    phone_no: {
                        required: true,
                    },
                    
                },
                messages: {
                    sup_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_no: {
                        required: "Please enter Supplier Name",
                    },
                },


                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/delete.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url({{ asset("backend/my_plugins/validate/apply.png")}})');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '{{ route("update_supplier_payment") }}',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Supplier Payment Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_supplier_payment/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Supplier Ledger Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//

        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '{{ route("load_supplier_ledger") }}',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", sup_id: sup_id, _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "date" },
                { data: "detail" },
                { data: "transaction_type" },
                { data: "debit" },
                { data: "credit" },
                { data: "bank" },
                { data: "balance" },
                @if (!Auth::user()->hasRole('Supplier'))
                { data: "btn" },
                @endif
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 3, 4, 5, 6] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 3, 4, 5, 6],
            order: [1, 'ASC'],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();

                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);

                var totals = api.ajax.json().totals;

                $('#total_debit').text(totals.total_debit);
                $('#total_credit').text(totals.total_credit);
                $('#total_balance').text(totals.total_balance);
                $('#supplier_name').text(totals.supplier_name);

            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { search: search, startdate: startDate, enddate: endDate, type: type, _token: csrf._token }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });
        //=========== End Custom Search Box ===========//

        $("#payment_type_filter").select2({
            placeholder: "Search By Type",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });

        //=========== Start Custom Status Dropdown ===========//
        $('#payment_type_filter').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }

        });
        //=========== End Custom Status Dropdown ===========//


        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//



            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
            
                // alert(startdate+" "+enddate);

                // $('#main_table').DataTable().destroy();

                // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
                loadData($('#search').val(), startdate, enddate);

            
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
            //do something, like clearing an input
                $(datepickerid).val('');
                loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//




    });
</script>
@endpush