@extends('admin.main_layout')
<title>{{ $settings->school_name }} | Dashboard</title>

@section('page_head')

    <div class="pad-all text-center">
        <h3>Welcome {{ Auth::user()->name }} to {{ $settings->school_name }}</h3>

        <p1>{{ $settings->camp_name }}<p>
        </p1>
    </div>
@endsection

@section('page_content')
    <div class="row">
        <div class="col-lg-12">
            <div class="row">

                @if (Auth::user()->can('view_bank'))
                <div class="col-sm-2 col-lg-2">

                    <div class="panel panel-success panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                              <i class="fa-solid fa-rupee-sign icon-3x icon-fw"></i>

                            </div>
                            <div class="media-body">
                                <span>Hand Cash</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-warning mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            Hand Cash: <span class="text-semibold">{{ $hand_cash}}</span>
                        </div>
                    </div>
                    
                </div>
                @foreach($banks as $bank)
                <div class="col-sm-2 col-lg-2">

                    
                    <div class="panel panel-success panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                              <i class="fa-solid fa-rupee-sign icon-3x icon-fw"></i>

                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">10</p> --}}
                                <span>{{ $bank->bank_name }}</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-warning mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            {{ $bank->bank_name }}: <span class="text-semibold">{{ $bank->bank_balance }}</span>
                        </div>
                    </div>
                    

                </div>
                @endforeach
                @endif
                
            </div>					
        </div>

        <div class="col-lg-12">
            <div class="row">

                @if (Auth::user()->can('view_customer'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-warning panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-duotone fa-user-graduate icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">10</p> --}}
                                <span>Customer</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-warning mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            Total Customers: <span class="text-semibold">{{ $customer }}</span>
                        </div>
                    </div>

                </div>
                @endif
                @if (Auth::user()->can('view_sales'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-success panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-duotone fa-receipt icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">1000</p> --}}
                                <span>Sales</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-success mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            <div>Total Sales: <span class="text-semibold">{{ number_format($totalSales) }}</span></div>
                            <div style="font-size: 0.9em; margin-top: 4px;">
                                <span>Orders:</span> <b>{{ number_format($sales_count) }}</b> •
                                <span>Received:</span> <b>{{ number_format($sales_paid) }}</b> •
                                <span>Receivable:</span> <b>{{ number_format($sales_receivable) }}</b>
                            </div>
                        </div>
                    </div>

                </div>
                @endif
                @if (Auth::user()->can('view_sale_return'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-info panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-solid fa-money-bill-trend-up icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">0000</p> --}}
                                <span>Sale Return</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-info mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            <div>Total Sale Return: <span class="text-semibold">{{ number_format($sale_return) }}</span></div>
                            <div style="font-size: 0.9em; margin-top: 4px;">
                                <span>Count:</span> <b>{{ number_format($sale_return_count) }}</b> •
                                <span>Pending:</span> <b>{{ number_format($sale_return_pending) }}</b>
                            </div>
                        </div>
                    </div>

                </div>
                @endif
                @if (Auth::user()->can('view_expense'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-purple panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-duotone fa-circle-dollar icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">0000</p> --}}
                                <span>@if (Auth::user()->hasRole('Production Manager')) Labour Cost @else Expense @endif</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-purple mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            Total @if (Auth::user()->hasRole('Production Manager')) Labour Cost @else Expense @endif: <span class="text-semibold">{{ $expense }}</span>
                        </div>
                    </div>

                </div>
                @endif
                @if (Auth::user()->can('view_purchases'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-danger panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-duotone fa-circle-dollar icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">0000</p> --}}
                                <span> Purchase</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-light mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            <div>Total Purchase: <span class="text-semibold">{{ number_format($totalPurchases) }}</span></div>
                            <div style="font-size: 0.9em; margin-top: 4px;">
                                <span>Count:</span> <b>{{ number_format($purchases_count) }}</b> •
                                <span>Paid:</span> <b>{{ number_format($purchase_paid_total) }}</b> •
                                <span>Payable:</span> <b>{{ number_format($purchase_payable) }}</b>
                            </div>
                        </div>
                    </div>
                
                </div>
                @endif

                @if (Auth::user()->can('view_orders'))
                <div class="col-sm-3 col-lg-2">

                    <div class="panel panel-mint panel-colorful">
                        <div class="pad-all media">
                            <div class="media-left">
                                <i class="fa-duotone fa-circle-dollar icon-3x icon-fw"></i>
                            </div>
                            <div class="media-body">
                                {{-- <p class="text-2x mar-no media-heading">0000</p> --}}
                                <span> Sale Man Order</span>
                            </div>
                        </div>
                        <div class="progress progress-xs progress-light mar-no">
                            <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                        </div>
                        <div class="pad-all" style="font-size: 1.2em">
                            <div>Total Orders: <span class="text-semibold">{{ number_format($order) }}</span></div>
                            <div style="font-size: 0.9em; margin-top: 4px;">
                                <span>Pending:</span> <b>{{ number_format($orders_pending) }}</b> •
                                <span>Approved:</span> <b>{{ number_format($orders_approved ?? 0) }}</b>
                            </div>
                        </div>
                    </div>
                
                </div>
                @endif

                
             
                
            </div>					
        </div>
    </div>

    {{-- Storeman Production Statistics --}}
    @if (Auth::user()->hasRole('Store man'))
    <div class="row">
        <div class="col-md-12">
            <h4 class="text-main text-bold" style="margin-left: 15px; margin-bottom: 15px;">Production Statistics</h4>
        </div>

        {{-- Total Production Items --}}
        <div class="col-md-3">
            <div class="panel panel-primary panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-box icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Total Production Items</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-primary mar-no">
                    <div role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 100%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    Total: <span class="text-semibold">{{ number_format($production_total) }}</span>
                </div>
            </div>
        </div>

        {{-- Pending Items --}}
        <div class="col-md-3">
            <div class="panel panel-warning panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-clock icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Pending Items</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-warning mar-no">
                    <div role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 70%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    Pending: <span class="text-semibold">{{ number_format($production_pending) }}</span>
                </div>
            </div>
        </div>

        {{-- Issued Items --}}
        <div class="col-md-3">
            <div class="panel panel-info panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-check-circle icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Items Issued</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-info mar-no">
                    <div role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 80%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    Issued: <span class="text-semibold">{{ number_format($production_issue) }}</span>
                </div>
            </div>
        </div>

        {{-- Completed Items --}}
        <div class="col-md-3">
            <div class="panel panel-success panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-check-double icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Completed Items</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-success mar-no">
                    <div role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 90%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    Completed: <span class="text-semibold">{{ number_format($production_completed) }}</span>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row">

        {{-- order return / Total BOM (role-aware data; visible to all) --}}
        <div class="col-md-2">
            <div class="panel panel-info panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        @if (Auth::user()->hasRole('Production Manager'))
                            <i class="fa-duotone fa-list-check icon-3x icon-fw"></i>
                        @else
                            <i class="fa-duotone fa-rotate-left icon-3x icon-fw"></i>
                        @endif
                    </div>
                    <div class="media-body">
                        <span>@if (Auth::user()->hasRole('Production Manager')) Total BOM @else Order Return @endif</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-info mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    @if (Auth::user()->hasRole('Production Manager'))
                        <div>Total BOM: <span class="text-semibold">{{ number_format($total_bom ?? 0) }}</span></div>
                    @else
                        <div>Total: <span class="text-semibold">{{ number_format($order_return) }}</span></div>
                        <div style="font-size: 0.9em; margin-top: 4px;">
                            <span>Pending:</span> <b>{{ number_format($order_return_pending ?? 0) }}</b>
                        </div>
                        <div style="font-size: 0.9em; margin-top: 4px;">
                            <span>Approved:</span> <b>{{ number_format($order_return_approved ?? 0) }}</b>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        {{-- Invoice --}}
        @if (Auth::user()->can('view_invoice'))
        <div class="col-md-2">
            <div class="panel panel-info panel-colorful media middle pad-all">
                <div class="media-left">
                    <div class="pad-hor">
                        <i class="fa-duotone fa-user icon-3x"></i>
                    </div>
                </div>
                <div class="media-body">
                    <p class="text-2x mar-no text-semibold">{{ $invoice }}</p>
                    <p class="mar-no">Total Invoice</p>
                </div>
            </div>
        </div>
        @endif

        {{-- Order Booker (Admin/Super Admin/Order Booker) --}}
        @if (Auth::user()->hasRole(['Super Admin','Admin','Order Booker']))
        <div class="col-md-2">
            <div class="panel panel-mint panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-clipboard-list icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Order Booker</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-mint mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    <div>Total: <span class="text-semibold">{{ number_format($order_booker_total ?? 0) }}</span></div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Pending:</span> <b>{{ number_format($order_booker_pending ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Complete:</span> <b>{{ number_format($order_booker_approved ?? 0) }}</b>
                    </div>
                </div>
            </div>
        </div>
        @endif
        
        {{-- Advance Amount KPIs (Order Booker only) --}}
        @if (Auth::user()->hasRole('Order Booker'))
        <div class="col-md-2">
            <div class="panel panel-warning panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-solid fa-money-bill-wave icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Advance Amount</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-warning mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    <div style="font-size: 0.9em;">
                        <span>Pending:</span> <b>{{ number_format($order_booker_advance_pending ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Received:</span> <b>{{ number_format($order_booker_advance_received ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Approved:</span> <b>{{ number_format($order_booker_advance_approved ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Balance:</span> <b>{{ number_format($order_booker_advance_balance ?? 0) }}</b>
                    </div>
                </div>
            </div>
        </div>
        @endif
        {{-- Investment (Admin/Super Admin only) --}}
        @if (Auth::user()->hasRole(['Super Admin','Admin']))
        <div class="col-md-2">
            <div class="panel panel-purple panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-solid fa-rupee-sign icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Investment</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-purple mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    <div>Total: <span class="text-semibold">{{ number_format($total_investment ?? 0) }}</span></div>
                    <div style="font-size:.9em; margin-top:4px;">
                        Company: <b>{{ number_format($company_investment ?? 0) }}</b> •
                        Investor: <b>{{ number_format($investor_investment ?? 0) }}</b>
                    </div>
                    <div style="font-size:.9em; margin-top:4px;">
                        Withdraw: <b>{{ number_format($total_withdraw ?? 0) }}</b>
                        <span style="opacity:.8">(C: {{ number_format($company_withdraw ?? 0) }}, I: {{ number_format($investor_withdraw ?? 0) }})</span>
                    </div>
                    <div style="font-size:.9em; margin-top:4px;">
                        Balance: <b>{{ number_format($investment_balance ?? 0) }}</b>
                    </div>
                </div>
            </div>
        </div>
        @endif
        {{-- Quotations KPI - Show for users with permission or Order Booker --}}
        @if (Auth::user()->can('view_quotation') || Auth::user()->hasRole('Order Booker'))
        <div class="col-md-2">
            <div class="panel panel-danger panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-file-contract icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Quotations</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-danger mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.2em">
                    <div>Total: <span class="text-semibold">{{ number_format($quotations_total ?? 0) }}</span></div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Pending:</span> <b>{{ number_format($quotations_pending ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Approved:</span> <b>{{ number_format($quotations ?? 0) }}</b>
                    </div>
                    <div style="font-size: 0.9em; margin-top: 4px;">
                        <span>Convert Sale:</span> <b>{{ number_format($quotations_convert_sale ?? 0) }}</b>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @if (Auth::user()->can('view_products'))
        <div class="col-md-2">
            <div class="panel panel-success panel-colorful media middle pad-all">
                <div class="media-left">
                    <div class="pad-hor">
                        <i class="fa-duotone fa-user-graduate icon-3x"></i>
                    </div>
                </div>
                <div class="media-body">
                    <p class="text-2x mar-no text-semibold">{{ $all_products }}</p>
                    <p class="mar-no">All Products</p>
                </div>
            </div>
        </div>
        @endif   
        @if (Auth::user()->can('view_supplier'))
        <div class="col-md-2">
            <div class="panel panel-mint panel-colorful media middle pad-all">
                <div class="media-left">
                    <div class="pad-hor">
                        <i class="fa-duotone fa-user-graduate icon-3x"></i>
                    </div>
                </div>
                <div class="media-body">
                    <p class="text-2x mar-no text-semibold">{{ $all_suppliers }}</p>
                    <p class="mar-no">Supplier</p>
                </div>
            </div>
        </div>   
        @endif             


    </div>

    {{-- Order Booker Section for Sales Man --}}
    @if (Auth::user()->hasRole('Sales Man'))
    <div class="row" style="margin-top: 20px;">
        <div class="col-lg-12">
            <h4 class="text-main" style="margin-bottom: 15px; padding-left: 15px;">
                <i class="fa-duotone fa-clipboard-list"></i> My Order Booker Orders
            </h4>
        </div>
    </div>

    <div class="row">
        {{-- Total Orders Card --}}
        <div class="col-md-3">
            <div class="panel panel-primary panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-clipboard-list icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Total Orders</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-primary mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.5em; text-align: center;">
                    <span class="text-semibold">{{ number_format($order_booker_total ?? 0) }}</span>
                </div>
            </div>
        </div>

        {{-- Pending Orders Card --}}
        <div class="col-md-3">
            <div class="panel panel-warning panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-clock icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Pending Orders</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-warning mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.5em; text-align: center;">
                    <span class="text-semibold">{{ number_format($order_booker_pending ?? 0) }}</span>
                </div>
            </div>
        </div>

        {{-- In Progress Orders Card --}}
        <div class="col-md-3">
            <div class="panel panel-info panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-spinner icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>In Progress</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-info mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.5em; text-align: center;">
                    <span class="text-semibold">{{ number_format($order_booker_in_progress ?? 0) }}</span>
                </div>
            </div>
        </div>

        {{-- Complete Orders Card --}}
        <div class="col-md-3">
            <div class="panel panel-success panel-colorful">
                <div class="pad-all media">
                    <div class="media-left">
                        <i class="fa-duotone fa-check-circle icon-3x icon-fw"></i>
                    </div>
                    <div class="media-body">
                        <span>Complete Orders</span>
                    </div>
                </div>
                <div class="progress progress-xs progress-success mar-no">
                    <div role="progressbar" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-light" style="width: 30%"></div>
                </div>
                <div class="pad-all" style="font-size: 1.5em; text-align: center;">
                    <span class="text-semibold">{{ number_format($order_booker_approved ?? 0) }}</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Recent Orders Table --}}
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading" style="display: flex; justify-content: space-between; align-items: center;">
                    <h3 class="panel-title">Recent Order Booker Orders</h3>
                    <a href="{{ route('order_booker') }}" class="btn btn-sm btn-primary">
                        <i class="fa fa-list"></i> View All Orders
                    </a>
                </div>
                <div class="panel-body">
                    @if($recentOrderBookerOrders && $recentOrderBookerOrders->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 80px;">#</th>
                                    <th class="text-center" style="width: 120px;">Order ID</th>
                                    <th>Customer Name</th>
                                    <th class="text-center" style="width: 120px;">Invoice Date</th>
                                    <th class="text-right" style="width: 130px;">Total Amount</th>
                                    <th class="text-center" style="width: 120px;">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentOrderBookerOrders as $index => $order)
                                <tr>
                                    <td class="text-center">{{ $index + 1 }}</td>
                                    <td class="text-center">
                                        <strong>OB-{{ str_pad($order->id, 4, '0', STR_PAD_LEFT) }}</strong>
                                    </td>
                                    <td>
                                        <i class="fa fa-user text-info"></i>
                                        {{ $order->customer ? $order->customer->name : 'N/A' }}
                                    </td>
                                    <td class="text-center">
                                        {{ \Carbon\Carbon::parse($order->invoice_date)->format('d-M-Y') }}
                                    </td>
                                    <td class="text-right">
                                        <strong>{{ number_format($order->grand_total, 2) }}</strong>
                                    </td>
                                    <td class="text-center">
                                        @if($order->status == 'Pending')
                                            <span class="label label-warning">
                                                <i class="fa fa-clock"></i> Pending
                                            </span>
                                        @elseif($order->status == 'In Progress')
                                            <span class="label label-info">
                                                <i class="fa fa-spinner"></i> In Progress
                                            </span>
                                        @elseif($order->status == 'Complete')
                                            <span class="label label-success">
                                                <i class="fa fa-check-circle"></i> Complete
                                            </span>
                                        @else
                                            <span class="label label-default">{{ $order->status }}</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center" style="padding: 40px;">
                        <i class="fa fa-inbox fa-3x text-muted" style="opacity: 0.3;"></i>
                        <h4 class="text-muted" style="margin-top: 15px;">No Order Booker orders yet</h4>
                        <p class="text-muted">Your recent Order Booker orders will appear here</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif


    <div class="row">

        {{-- Low Stock Products --}}
        @if (Auth::user()->can('view_main_stock'))
        <div class="col-lg-4">

            <div class="panel">

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Low Stock Products</h3>
                    </div>

                    <!--Bordered Table-->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dashboard">
                                <thead>
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th>Product Name</th>
                                        <th class="text-center">Qty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($low_stock_products as $index => $pro)

                                    <tr>
                                        <td class="text-center">{{ $index+1 }}</td>
                                        <td class="text-info">{{ $pro->pro_name }}</td>
                                       
                                        @if ($pro->total_qty >= 0 && $pro->total_qty <= 5)
                                            <td class="text-center"><span class="label label-danger">{{ number_format($pro->total_qty) }}</span></td>
                                        @elseif($pro->total_qty > 5 && $pro->total_qty <= 10)
                                            <td class="text-center"><span class="label label-warning">{{ number_format($pro->total_qty) }}</span></td>
                                        @elseif($pro->total_qty >= 11 && $pro->total_qty <= 15)
                                            <td class="text-center"><span class="label label-purple">{{ number_format($pro->total_qty) }}</span></td>
                                        @elseif($pro->total_qty < 0)
                                            <td class="text-center"><span class="label label-danger">{{ number_format($pro->total_qty) }}</span></td>
                                        @endif

                                        
                                    </tr>

                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!--End Bordered Table-->

                </div>

            </div>

        </div>
        @endif

        {{-- Production Orders --}}
        @if (Auth::user()->can('view_production'))
        <div class="col-lg-4">

            <div class="panel">

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Production Orders</h3>
                    </div>

                    <!--Bordered Table-->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dashboard">
                           
                                <tbody>

                                    <tr>
                                        <td class="text-info">Total</td>
                                        <td class="text-center">
                                            <span class="label label-danger">{{ $production_total }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-info">Pending</td>
                                        <td class="text-center">
                                            <span class="label label-warning">{{ $production_pending }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                         <td class="text-info">Completed</td>
                                        <td class="text-center">
                                            <span class="label label-success">{{ $production_completed }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                         <td class="text-info">Production</td>
                                        <td class="text-center">
                                            <span class="label label-purple">{{ $production }}</span>
                                        </td>
                                    </tr>
                                    @if (Auth::user()->hasRole('Store man'))
                                    <tr>
                                         <td class="text-info">Item Issue</td>
                                        <td class="text-center">
                                            <span class="label label-info">{{ $production_issue }}</span>
                                        </td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!--End Bordered Table-->

                </div>

            </div>

        </div>
        @endif

        {{-- Top Selling Products --}}
        @if (Auth::user()->can('view_products'))
        <div class="col-lg-4">

            <div class="panel">

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Top Selling Products</h3>
                    </div>

                    <!--Bordered Table-->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table ">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th class="text-center">Total Sold</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($topProducts as $product)
                                    <tr>
                                        <td class="text-info">{{ $product->pro_name }}</td>
                                        <td class="text-center">
                                            <span class="label label-success">{{ $product->total_sold }}</span>
                                            
                                        </td>

                                     
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!--End Bordered Table-->

                </div>

            </div>

        </div>
        @endif

        {{-- Top Salesman: --}}
        @if (Auth::user()->hasRole('Super Admin'))
        <div class="col-lg-4">

            <div class="panel">

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Top Salesman:</h3>
                    </div>

                    <!--Bordered Table-->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dashboard">
                           
                                <tbody>

                                    <tr>
                                        @if($topSalesman)
                                        <td class="text-info">{{ $topSalesman->name }}</td>
                                        <td class="text-center">
                                            <span class="label label-success">({{ $topSalesman->total_sales }})</span>
                                        </td>
                                        @else
                                            <h4>No  data found</h4>
                                        @endif
                                    </tr>
                                

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!--End Bordered Table-->

                </div>

            </div>

        </div>
        @endif

        {{-- Top Customer: --}}
        @if (Auth::user()->hasRole('Super Admin'))
        <div class="col-lg-4">

            <div class="panel">

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Top Customer:</h3>
                    </div>

                    <!--Bordered Table-->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dashboard">
                           
                                <tbody>

                                    <tr>
                                        @if($topCustomer)
                                        <td class="text-info">{{ $topCustomer->name }}</td>
                                        <td class="text-center">
                                            <span class="label label-success">({{ number_format($topCustomer->total_spent) }})</span>
                                        </td>
                                        @else
                                            <h4>No  data found</h4>
                                        @endif
                                    </tr>
                                

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!--End Bordered Table-->

                </div>

            </div>

        </div>
        @endif

    </div>


    


    


@endsection



@section('javascript_code')
    <script src="{{ asset('backend/plugins\flot-charts\jquery.flot.min.js') }}"></script>
    <script src="{{ asset('backend/plugins\flot-charts\jquery.flot.resize.min.js') }}"></script>
    <script src="{{ asset('backend/plugins\flot-charts\jquery.flot.tooltip.min.js') }}"></script>
    {{-- <script src="{{ asset('backend/js\demo\dashboard.js') }}"></script> --}}

<script>
    
</script>
@endsection