<?php

use App\Http\Controllers\AreaController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\BomController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CompanyInvestmentController;
use App\Http\Controllers\ContracterController;
use App\Http\Controllers\ContractorController;
use App\Http\Controllers\CustomerController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ExchangeRateController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ExpenseSubCategoryController;
use App\Http\Controllers\HandCashController;
use App\Http\Controllers\InvestmentController;
use App\Http\Controllers\InvestorController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\NonServiceStockController;
use App\Http\Controllers\OrderBookerController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\OrderReturnController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductionController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\PurchaseReturnController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\RepairOrderController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\SaleReturnController;
use App\Http\Controllers\SalesmanController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\WithdrawalController;
use App\Http\Controllers\ReportController;
use App\Http\Middleware\CheckDomain;

// Route::get('/', function () {
//     return view('auth.login');
// });

Route::middleware([CheckDomain::class])->group(function () {
    Route::get('/', function () {
        return view('auth.login');
    });

    // باقی routes یہاں
});

Route::get('/dashboard', [DashboardController::class, 'dashboard'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth', 'role:Super Admin|Admin|Sales Man|Cashier|Investor|Store man|Production Manager|Customer|Supplier|Employee|Order Booker')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');


    // All Settings Routes
    Route::get('/settings', [SettingController::class, 'load_settings'])->name('settings');
    Route::post('/update_setting', [SettingController::class, 'update_setting'])->name('update_setting');
    Route::post('/update_bill', [SettingController::class, 'update_bill'])->name('update_bill');
    Route::get('/delete_setting/{delete_val}', [SettingController::class, 'delete_setting'])->name('delete_setting');
    

    // < ====================================================================== >

    // All Permission Routes
    Route::view('/all_permission_groups', 'admin.roles_and_permissions.all_permission_groups')->name('all_permission_groups');
    Route::post('/load_permission_groups', [RoleController::class, 'load_permission_groups'])->name('load_permission_groups');
    Route::post('/insert_permission_group', [RoleController::class, 'insert_permission_group'])->name('insert_permission_group');
    Route::get('/edit_permission_group/{id}', [RoleController::class, 'edit_permission_group'])->name('edit_permission_group');
    Route::post('/update_permission_group', [RoleController::class, 'update_permission_group'])->name('update_permission_group');
    Route::get('/delete_permission_group/{id}', [RoleController::class, 'delete_permission_group'])->name('delete_permission_group');
    Route::get('/get_permission_groups', [RoleController::class, 'get_permission_groups'])->name('get_permission_groups');

        
    // All Permission Routes
    Route::view('/all_permissions', 'admin.roles_and_permissions.all_permissions')->name('all_permissions');
    Route::post('/get_all_permissions', [RoleController::class, 'load_permissions'])->name('get_all_permissions');
    Route::post('/insert_permission', [RoleController::class, 'insert_permission'])->name('insert_permission');
    Route::get('/edit_permission/{permission_id}', [RoleController::class, 'edit_permission'])->name('edit_permission');
    Route::post('/update_permission', [RoleController::class, 'update_permission'])->name('update_permission');
    Route::get('/delete_permission/{permission_id}', [RoleController::class, 'delete_permission'])->name('delete_permission');



    // All Roles Routes
    Route::view('/all_roles', 'admin.roles_and_permissions.all_roles')->name('all_roles');
    Route::post('/get_all_roles', [RoleController::class, 'load_roles'])->name('get_all_roles');
    Route::post('/insert_role', [RoleController::class, 'insert_role'])->name('insert_role');
    Route::get('/edit_role/{role_id}', [RoleController::class, 'edit_role'])->name('edit_role');
    Route::post('/update_role', [RoleController::class, 'update_role'])->name('update_role');
    Route::get('/delete_role/{role_id}', [RoleController::class, 'delete_role'])->name('delete_role');
    Route::get('/get_roles', [RoleController::class, 'get_roles'])->name('get_roles');

    
    // All Assign Permission Routes
    Route::view('/roles_and_permissions', 'admin.roles_and_permissions.roles_and_permissions')->name('roles_and_permissions');
    Route::post('/get_roles_and_permissions', [RoleController::class, 'load_roles_and_permissions'])->name('get_roles_and_permissions');
    Route::get('/add_permissions', [RoleController::class, 'add_permissions'])->name('add_permissions');
    Route::post('/insert_role_permission', [RoleController::class, 'insert_role_permission'])->name('insert_role_permission');
    Route::get('/edit_permissions/{role_id}', [RoleController::class, 'edit_permissions'])->name('edit_permissions');
    Route::post('/update_role_permission', [RoleController::class, 'update_role_permission'])->name('update_role_permission');

    
    // All Users Routes
    Route::view('/users', 'admin.users')->name('users');
    Route::post('/get_all_users', [UserController::class, 'load_users'])->name('get_all_users');
    Route::post('/insert_user', [UserController::class, 'insert_user'])->name('insert_user');
    Route::get('/edit_user/{user_id}', [UserController::class, 'edit_user'])->name('edit_user');
    Route::post('/update_user', [UserController::class, 'update_user'])->name('update_user');
    Route::get('/delete_user/{user_id}', [UserController::class, 'delete_user'])->name('delete_user');
    Route::post('/update_user_status', [UserController::class, 'update_user_status'])->name('update_user_status');
    Route::get('/user_profile/{user_id}', [UserController::class, 'user_profile'])->name('user_profile');
    Route::post('/update_profile_photo', [UserController::class, 'update_profile_photo'])->name('update_profile_photo');
    Route::post('/change_password', [UserController::class, 'change_password'])->name('change_password');
    Route::post('/change_password_from_admin', [UserController::class, 'change_password_from_admin'])->name('change_password_from_admin');
        
    Route::get('/get_users', [UserController::class, 'get_users'])->name('get_users');
    

    // < ====================================================================== >

    // All customers
    Route::get('/customers', [CustomerController::class, 'customer'])->name('customers');
    Route::post('/load_customers', [CustomerController::class, 'load_customers'])->name('load_customers');
    Route::post('/insert_customer', [CustomerController::class, 'insert_customer'])->name('insert_customer');
    Route::get('/edit_customer/{id}', [CustomerController::class, 'edit_customer'])->name('edit_customer');
    Route::post('/update_customer', [CustomerController::class, 'update_customer'])->name('update_customer');
    Route::get('/delete_customer/{id}', [CustomerController::class, 'delete_customer'])->name('delete_customer');
    Route::get('/get_customers', [CustomerController::class, 'get_customers'])->name('get_customers');
    Route::get('/get_customers_by_salesman/{salesman_id}', [CustomerController::class, 'getCustomersBySalesman'])->name('getCustomersBySalesman');
    Route::get('/get_customer_balance/{customerId}', [SalesmanController::class, 'getCustomerBalance'])->name('getCustomerBalance');


    // All Customer Ledger Routes
    Route::get('/customer_ledger/{id}', [CustomerController::class, 'show_customer_ledger'])->name('customer_ledger');
    Route::post('/load_customer_ledger', [CustomerController::class, 'load_customer_ledger'])->name('load_customer_ledger');
    Route::post('/insert_customer_payment', [CustomerController::class, 'insert_customer_payment'])->name('insert_customer_payment');
    Route::get('/edit_customer_payment/{id}', [CustomerController::class, 'edit_customer_payment'])->name('edit_customer_payment');
    Route::post('/update_customer_payment', [CustomerController::class, 'update_customer_payment'])->name('update_customer_payment');
    Route::get('/delete_customer_payment/{id}', [CustomerController::class, 'delete_customer_payment'])->name('delete_customer_payment');
    

    // All salesman
    Route::view('/salesman', 'admin.salesman')->name('salesman');
    Route::post('/load_salesman', [SalesmanController::class, 'load_salesman'])->name('load_salesman');
    Route::post('/insert_salesman', [SalesmanController::class, 'insert_salesman'])->name('insert_salesman');
    Route::get('/edit_salesman/{id}', [SalesmanController::class, 'edit_salesman'])->name('edit_salesman');
    Route::post('/update_salesman', [SalesmanController::class, 'update_salesman'])->name('update_salesman');
    Route::get('/delete_salesman/{id}', [SalesmanController::class, 'delete_salesman'])->name('delete_salesman');
    Route::get('/get_salesman', [SalesmanController::class, 'get_salesman'])->name('get_salesman');
    

    // All salesman Ledger Routes
    Route::view('/all_salesman_ledger', 'admin.all_salesman_ledger')->name('all_salesman_ledger');
    Route::post('/load_all_salesman_ledger', [SalesmanController::class, 'load_all_salesman_ledger'])->name('load_all_salesman_ledger');
    Route::view('/salesman_ledger/{id}', 'admin.salesman_ledger')->name('salesman_ledger');
    Route::post('/load_salesman_ledger', [SalesmanController::class, 'load_salesman_ledger'])->name('load_salesman_ledger');
    Route::post('/insert_salesman_payment', [SalesmanController::class, 'insert_salesman_payment'])->name('insert_salesman_payment');
    Route::get('/edit_salesman_payment/{id}', [SalesmanController::class, 'edit_salesman_payment'])->name('edit_salesman_payment');
    Route::post('/update_salesman_payment', [SalesmanController::class, 'update_salesman_payment'])->name('update_salesman_payment');
    Route::get('/delete_salesman_payment/{id}', [SalesmanController::class, 'delete_salesman_payment'])->name('delete_salesman_payment');
    // inser cashier payment
    Route::post('/send_to_cashier', [SalesmanController::class, 'send_to_cashier'])->name('send_to_cashier');
    Route::get('/check-salesman-can-send-to-cashier', [SalesmanController::class, 'check_can_send_to_cashier'])->name('check_salesman_can_send_to_cashier');


    // All orders
    Route::view('/orders', 'admin.orders')->name('orders');
    Route::post('/load_orders', [OrderController::class, 'load_orders'])->name('load_orders');
    Route::post('/insert_order', [OrderController::class, 'insert_order'])->name('insert_order');
    Route::get('/edit_order/{id}', [OrderController::class, 'edit_order'])->name('edit_order');
    Route::post('/update_order', [OrderController::class, 'update_order'])->name('update_order');
    Route::get('/delete_order/{id}', [OrderController::class, 'delete_order'])->name('delete_order');
    Route::get('/get_orders', [OrderController::class, 'get_orders'])->name('get_orders');
    Route::get('/view_order/{id}', [OrderController::class, 'view_order'])->name('view_order');
    Route::post('/approved_order', [OrderController::class, 'approved_order'])->name('approved_order');
    Route::post('/getOrderProductBatches', [OrderController::class, 'getOrderProductBatches'])->name('getOrderProductBatches');
    Route::post('/getBatchDataOrder', [OrderController::class, 'getBatchData'])->name('getBatchDataOrder');
   

    // All orders return
    Route::view('/order_return', 'admin.order_return')->name('order_return');
    Route::post('/load_order_return', [OrderReturnController::class, 'load_order_return'])->name('load_order_return');
    Route::post('/insert_order_return', [OrderReturnController::class, 'insert_order_return'])->name('insert_order_return');
    Route::get('/edit_order_return/{id}', [OrderReturnController::class, 'edit_order_return'])->name('edit_order_return');
    Route::post('/update_order_return', [OrderReturnController::class, 'update_order_return'])->name('update_order_return');
    Route::get('/delete_order_return/{id}', [OrderReturnController::class, 'delete_order_return'])->name('delete_order_return');
    Route::get('/get_order_return', [OrderReturnController::class, 'get_order_return'])->name('get_order_return');
    Route::get('/view_order_return/{id}', [OrderReturnController::class, 'view_order_return'])->name('view_order_return');

    

    // All products
    Route::view('/products', 'admin.products')->name('products');
    Route::post('/load_products', [ProductController::class, 'load_products'])->name('load_products');
    Route::post('/insert_product', [ProductController::class, 'insert_product'])->name('insert_product');
    Route::get('/edit_product/{id}', [ProductController::class, 'edit_product'])->name('edit_product');
    Route::get('/edit_saleman_product/{id}', [ProductController::class, 'edit_saleman_product'])->name('edit_saleman_product');

    Route::post('/update_product', [ProductController::class, 'update_product'])->name('update_product');
    Route::get('/delete_product/{id}', [ProductController::class, 'delete_product'])->name('delete_product');
    Route::get('/get_products', [ProductController::class, 'get_products'])->name('get_products');
    Route::get('/get_products_excluding_sdk_cdk', [ProductController::class, 'get_products_excluding_sdk_cdk'])->name('get_products_excluding_sdk_cdk');
    

    // All supplier
    Route::get('/supplier', [SupplierController::class, 'supplier'])->name('supplier');
    Route::post('/load_suppliers', [SupplierController::class, 'load_suppliers'])->name('load_suppliers');
    Route::post('/insert_supplier', [SupplierController::class, 'insert_supplier'])->name('insert_supplier');
    Route::get('/edit_supplier/{id}', [SupplierController::class, 'edit_supplier'])->name('edit_supplier');
    Route::post('/update_supplier', [SupplierController::class, 'update_supplier'])->name('update_supplier');
    Route::get('/delete_supplier/{id}', [SupplierController::class, 'delete_supplier'])->name('delete_supplier');
    Route::get('/get_suppliers', [SupplierController::class, 'get_suppliers'])->name('get_suppliers');
    Route::get('/get_suppliers_with_purchases', [SupplierController::class, 'get_suppliers_with_purchases'])->name('get_suppliers_with_purchases');

        
    // All Supplier Ledger Routes
    Route::get('/supplier_ledger/{id}', [SupplierController::class, 'show_supplier_ledger'])->name('supplier_ledger');
    Route::post('/load_supplier_ledger', [SupplierController::class, 'load_supplier_ledger'])->name('load_supplier_ledger');
    Route::post('/insert_supplier_payment', [SupplierController::class, 'insert_supplier_payment'])->name('insert_supplier_payment');
    Route::get('/edit_supplier_payment/{id}', [SupplierController::class, 'edit_supplier_payment'])->name('edit_supplier_payment');
    Route::post('/update_supplier_payment', [SupplierController::class, 'update_supplier_payment'])->name('update_supplier_payment');
    Route::get('/delete_supplier_payment/{id}', [SupplierController::class, 'delete_supplier_payment'])->name('delete_supplier_payment');


    

    // All purchase
    Route::view('/purchase', 'admin.purchase')->name('purchase');
    Route::post('/load_purchase', [PurchaseController::class, 'load_purchase'])->name('load_purchase');
    Route::post('/insert_purchase', [PurchaseController::class, 'insert_purchase'])->name('insert_purchase');
    Route::get('/edit_purchase/{id}', [PurchaseController::class, 'edit_purchase'])->name('edit_purchase');
    Route::post('/update_purchase', [PurchaseController::class, 'update_purchase'])->name('update_purchase');
    Route::get('/delete_purchase/{id}', [PurchaseController::class, 'delete_purchase'])->name('delete_purchase');
    Route::get('/view_purchase/{id}', [PurchaseController::class, 'view_purchase'])->name('view_purchase');

    // ================================================================
    // PURCHASE RETURN ROUTES
    // ================================================================
    // All Purchase Return Routes
    Route::view('/purchase_return', 'admin.purchase_return')->name('purchase_return');
    Route::post('/load_purchase_return', [PurchaseReturnController::class, 'load_purchase_return'])->name('load_purchase_return');
    Route::post('/insert_purchase_return', [PurchaseReturnController::class, 'insert_purchase_return'])->name('insert_purchase_return');
    Route::get('/edit_purchase_return/{id}', [PurchaseReturnController::class, 'edit_purchase_return'])->name('edit_purchase_return');
    Route::post('/update_purchase_return', [PurchaseReturnController::class, 'update_purchase_return'])->name('update_purchase_return');
    Route::get('/view_purchase_return/{id}', [PurchaseReturnController::class, 'view_purchase_return'])->name('view_purchase_return');
    Route::get('/delete_purchase_return/{id}', [PurchaseReturnController::class, 'delete_purchase_return'])->name('delete_purchase_return');
    Route::get('/get_supplier_products/{supplier_id}', [PurchaseReturnController::class, 'get_supplier_products'])->name('get_supplier_products');
    Route::post('/get-purchase-product', [PurchaseReturnController::class, 'getPurchaseProduct'])->name('get.purchase.product');

    // All category
    Route::view('/category', 'admin.category')->name('category');
    Route::post('/load_categories', [CategoryController::class, 'load_categories'])->name('load_categories');
    Route::post('/insert_category', [CategoryController::class, 'insert_category'])->name('insert_category');
    Route::get('/edit_category/{id}', [CategoryController::class, 'edit_category'])->name('edit_category');
    Route::post('/update_category', [CategoryController::class, 'update_category'])->name('update_category');
    Route::get('/delete_category/{id}', [CategoryController::class, 'delete_category'])->name('delete_category');
    Route::get('/get_categories', [CategoryController::class, 'get_categories'])->name('get_categories');
    // routes/web.php OR routes/api.php
    Route::get('/get-usd-to-pkr-rate', [ExchangeRateController::class, 'getRate'])->name('getRate');


    // All sales
    Route::view('/sales', 'admin.sales')->name('sales');
    Route::post('/load_sales', [SaleController::class, 'load_sales'])->name('load_sales');
    Route::post('/insert_sale', [SaleController::class, 'insert_sale'])->name('insert_sale');
    Route::get('/edit_sale/{id}', [SaleController::class, 'edit_sale'])->name('edit_sale');
    Route::post('/update_sale', [SaleController::class, 'update_sale'])->name('update_sale');
    Route::get('/view_sale/{id}', [SaleController::class, 'view_sale'])->name('view_sale');
    Route::get('/delete_sale/{id}', [SaleController::class, 'delete_sale'])->name('delete_sale');
    Route::get('/invoice_print', [SaleController::class, 'invoice_print'])->name('invoice_print');
    Route::post('/get-sale-product', [SaleController::class, 'getSaleProduct'])->name('get.sale.product');
    Route::post('/getBatchData', [SaleController::class, 'getBatchData'])->name('getBatchData');


    // All sales return
    Route::view('/sale_return', 'admin.sale_return')->name('sale_return');
    Route::post('/load_sale_return', [SaleReturnController::class, 'load_sale_return'])->name('load_sale_return');
    Route::post('/insert_sale_return', [SaleReturnController::class, 'insert_sale_return'])->name('insert_sale_return');
    Route::get('/edit_sale_return/{id}', [SaleReturnController::class, 'edit_sale_return'])->name('edit_sale_return');
    Route::post('/update_sale_return', [SaleReturnController::class, 'update_sale_return'])->name('update_sale_return');
    Route::get('/view_sale_return/{id}', [SaleReturnController::class, 'view_sale_return'])->name('view_sale_return');
    Route::get('/delete_sale_return/{id}', [SaleReturnController::class, 'delete_sale_return'])->name('delete_sale_return');
    Route::get('/invoice_print', [SaleReturnController::class, 'invoice_print'])->name('invoice_print');


    // All bank
    Route::view('/banks', 'admin.banks')->name('banks');
    Route::post('/load_banks', [BankController::class, 'load_banks'])->name('load_banks');
    Route::post('/insert_bank', [BankController::class, 'insert_bank'])->name('insert_bank');
    Route::get('/edit_bank/{id}', [BankController::class, 'edit_bank'])->name('edit_bank');
    Route::post('/update_bank', [BankController::class, 'update_bank'])->name('update_bank');
    Route::get('/delete_bank/{id}', [BankController::class, 'delete_bank'])->name('delete_bank');
    Route::post('/withdraw_bank/{id}', [BankController::class, 'withdraw_bank'])->name('withdraw_bank');
    Route::get('/get_banks', [BankController::class, 'get_banks'])->name('get_banks');

    // All units
    Route::view('/units', 'admin.units')->name('units');
    Route::post('/load_units', [UnitController::class, 'load_units'])->name('load_units');
    Route::post('/insert_unit', [UnitController::class, 'insert_unit'])->name('insert_unit');
    Route::get('/edit_unit/{id}', [UnitController::class, 'edit_unit'])->name('edit_unit');
    Route::post('/update_unit', [UnitController::class, 'update_unit'])->name('update_unit');
    Route::get('/delete_unit/{id}', [UnitController::class, 'delete_unit'])->name('delete_unit');
    Route::get('/get_units', [UnitController::class, 'get_units'])->name('get_units');

    // All Cash
    Route::view('/hand_cash', 'admin.hand_cash')->name('hand_cash');
    Route::post('/load_hand_cash', [HandCashController::class, 'load_hand_cash'])->name('load_hand_cash');
    Route::post('/insert_hand_cash', [HandCashController::class, 'insert_hand_cash'])->name('insert_hand_cash');
    Route::get('/edit_hand_cash/{id}', [HandCashController::class, 'edit_hand_cash'])->name('edit_hand_cash');
    Route::post('/update_hand_cash', [HandCashController::class, 'update_hand_cash'])->name('update_hand_cash');
    Route::get('/delete_hand_cash/{id}', [HandCashController::class, 'delete_hand_cash'])->name('delete_hand_cash');
    Route::get('/totalcash', [HandCashController::class, 'totalcash'])->name('totalcash');

    // All city
    Route::view('/city', 'admin.city')->name('city');
    Route::post('/load_cities', [CityController::class, 'load_cities'])->name('load_cities');
    Route::post('/insert_city', [CityController::class, 'insert_city'])->name('insert_city');
    Route::get('/edit_city/{id}', [CityController::class, 'edit_city'])->name('edit_city');
    Route::post('/update_city', [CityController::class, 'update_city'])->name('update_city');
    Route::get('/delete_city/{id}', [CityController::class, 'delete_city'])->name('delete_city');
    Route::get('/get_cities', [CityController::class, 'get_cities'])->name('get_cities');

    // All Areas
    Route::view('/area', 'admin.area')->name('area');
    Route::post('/load_areas', [AreaController::class, 'load_areas'])->name('load_areas');
    Route::post('/insert_area', [AreaController::class, 'insert_area'])->name('insert_area');
    Route::get('/edit_area/{id}', [AreaController::class, 'edit_area'])->name('edit_area');
    Route::post('/update_area', [AreaController::class, 'update_area'])->name('update_area');
    Route::get('/delete_area/{id}', [AreaController::class, 'delete_area'])->name('delete_area');
    Route::get('/get_areas', [AreaController::class, 'get_areas'])->name('get_areas');
 

    // All investor
    Route::view('/investor', 'admin.investor')->name('investor');
    Route::post('/load_investor', [InvestorController::class, 'load_investor'])->name('load_investor');
    Route::post('/insert_investor', [InvestorController::class, 'insert_investor'])->name('insert_investor');
    Route::get('/edit_investor/{id}', [InvestorController::class, 'edit_investor'])->name('edit_investor');
    Route::post('/update_investor', [InvestorController::class, 'update_investor'])->name('update_investor');
    Route::post('/update_status', [InvestorController::class, 'update_status'])->name('update_status');
    Route::get('/delete_investor/{id}', [InvestorController::class, 'delete_investor'])->name('delete_investor');
    Route::get('/get_investor', [InvestorController::class, 'get_investor'])->name('get_investor');


    // All investor investments
    Route::view('/investor_investments', 'admin.investor_investments')->name('investor_investments');
    Route::post('/load_inv_investments', [InvestmentController::class, 'load_inv_investments'])->name('load_inv_investments');
    Route::post('/insert_inv_investment', [InvestmentController::class, 'insert_inv_investment'])->name('insert_inv_investment');
    Route::get('/edit_inv_investment/{id}', [InvestmentController::class, 'edit_inv_investment'])->name('edit_inv_investment');
    Route::post('/update_inv_investment', [InvestmentController::class, 'update_inv_investment'])->name('update_inv_investment');
    Route::get('/delete_inv_investment/{id}', [InvestmentController::class, 'delete_inv_investment'])->name('delete_inv_investment');
    Route::get('/get_inv_investment', [InvestmentController::class, 'get_inv_investment'])->name('get_inv_investment');
    Route::get('/total_investor_amount', [InvestmentController::class, 'total_investor_amount'])->name('total_investor_amount');

    // All investor Ledger Routes
    Route::view('/investor_ledger/{id}', 'admin.investor_ledger')->name('investor_ledger');
    Route::post('/load_investor_ledger', [InvestorController::class, 'load_investor_ledger'])->name('load_investor_ledger');
    Route::post('/insert_investor_payment', [InvestorController::class, 'insert_investor_payment'])->name('insertinvestorr_payment');
    Route::get('/edit_investor_payment/{id}', [InvestorController::class, 'edit_investor_payment'])->name('edit_investor_payment');
    Route::post('/update_investor_payment', [InvestorController::class, 'update_investor_payment'])->name('update_investor_payment');
    Route::get('/delete_investor_payment/{id}', [InvestorController::class, 'delete_investor_payment'])->name('delete_investor_payment');



    // All company investments
    Route::view('/company_investment', 'admin.company_investment')->name('company_investment');
    Route::post('/load_company_investments', [CompanyInvestmentController::class, 'load_company_investments'])->name('load_company_investments');
    Route::post('/insert_company_investment', [CompanyInvestmentController::class, 'insert_company_investment'])->name('insert_company_investment');
    Route::get('/edit_company_investment/{id}', [CompanyInvestmentController::class, 'edit_company_investment'])->name('edit_company_investment');
    Route::post('/update_company_investment', [CompanyInvestmentController::class, 'update_company_investment'])->name('update_company_investment');
    Route::get('/delete_company_investment/{id}', [CompanyInvestmentController::class, 'delete_company_investment'])->name('delete_company_investment');
    Route::get('/get_company_investment', [CompanyInvestmentController::class, 'get_company_investment'])->name('get_company_investment');
    Route::get('/total_company_invested_amount', [CompanyInvestmentController::class, 'total_company_invested_amount'])->name('total_company_invested_amount');

    // All  investments withdrawals
    Route::view('/withdrawals', 'admin.investment_withdrawals')->name('withdrawals');
    Route::post('/load_withdrawals', [WithdrawalController::class, 'load_withdrawals'])->name('load_withdrawals');
    Route::post('/insert_withdrawals', [WithdrawalController::class, 'insert_withdrawals'])->name('insert_withdrawals');
    Route::get('/edit_withdrawals/{id}', [WithdrawalController::class, 'edit_withdrawals'])->name('edit_withdrawals');
    Route::post('/update_withdrawals', [WithdrawalController::class, 'update_withdrawals'])->name('update_withdrawals');
    Route::get('/delete_withdrawals/{id}', [WithdrawalController::class, 'delete_withdrawals'])->name('delete_withdrawals');
    


    // All contractor
    Route::view('/contractor', 'admin.contractor')->name('contractor');
    Route::post('/load_contractor', [ContractorController::class, 'load_contractor'])->name('load_contractor');
    Route::post('/insert_contractor', [ContractorController::class, 'insert_contractor'])->name('insert_contractor');
    Route::get('/edit_contractor/{id}', [ContractorController::class, 'edit_contractor'])->name('edit_contractor');
    Route::post('/update_contractor', [ContractorController::class, 'update_contractor'])->name('update_contractor');
    Route::post('/update_status', [ContractorController::class, 'update_status'])->name('update_status');
    Route::get('/delete_contractor/{id}', [ContractorController::class, 'delete_contractor'])->name('delete_contractor');
    Route::get('/get_contractor', [ContractorController::class, 'get_contractor'])->name('get_contractor');
    Route::get('/edit_payment/{id}', [ContractorController::class, 'edit_payment'])->name('edit_payment');
    Route::post('/update_payment', [ContractorController::class, 'update_payment'])->name('update_payment');


    // All BOM
    Route::view('/bom', 'admin.bom')->name('bom');
    Route::post('/load_bom', [BomController::class, 'load_bom'])->name('load_bom');
    Route::post('/insert_bom', [BomController::class, 'insert_bom'])->name('insert_bom');
    Route::get('/edit_bom/{id}', [BomController::class, 'edit_bom'])->name('edit_bom');
    Route::post('/update_bom', [BomController::class, 'update_bom'])->name('update_bom');
    Route::post('/update_status', [BomController::class, 'update_status'])->name('update_status');
    Route::get('/delete_bom/{id}', [BomController::class, 'delete_bom'])->name('delete_bom');
    Route::get('/get_bom', [BomController::class, 'get_bom'])->name('get_bom');
    Route::get('/get_bom_price/{id}', [BomController::class, 'get_bom_price'])->name('get_bom_price');

    // All Production
    Route::view('/production', 'admin.production')->name('production');
    Route::post('/load_production', [ProductionController::class, 'load_production'])->name('load_production');
    Route::post('/insert_production', [ProductionController::class, 'insert_production'])->name('insert_production');
    Route::get('/edit_production/{id}', [ProductionController::class, 'edit_production'])->name('edit_production');
    Route::post('/update_production', [ProductionController::class, 'update_production'])->name('update_production');
    Route::post('/update_status', [ProductionController::class, 'update_status'])->name('update_status');
    Route::get('/delete_production/{id}', [ProductionController::class, 'delete_production'])->name('delete_production');
    Route::get('/get_production', [ProductionController::class, 'get_production'])->name('get_production');
    Route::get('/get_bom_products/{bom_id}', [ProductionController::class, 'get_bom_products'])->name('get_bom_products');
    Route::get('/get_product_balance/{product_id}', [ProductionController::class, 'get_product_balance'])->name('get_product_balance');

    // Production Labour Cost Payment Route
    Route::post('/production/pay-labour-cost', [ProductionController::class, 'pay_labour_cost'])->name('pay_labour_cost');

    // All Expense Categories Routes
    Route::view('/expense_categories', 'admin.expense_categories')->name('expense_categories');
    Route::post('/load_expense_categories', [ExpenseCategoryController::class, 'load_expense_categories'])->name('load_expense_categories');
    Route::post('/insert_expense_category', [ExpenseCategoryController::class, 'insert_expense_category'])->name('insert_expense_category');
    Route::get('/edit_expense_category/{id}', [ExpenseCategoryController::class, 'edit_expense_category'])->name('edit_expense_category');
    Route::post('/update_expense_category', [ExpenseCategoryController::class, 'update_expense_category'])->name('update_expense_category');
    Route::get('/delete_expense_category/{id}', [ExpenseCategoryController::class, 'delete_expense_category'])->name('delete_expense_category');
    Route::get('/get_expense_categories', [ExpenseCategoryController::class, 'get_expense_categories'])->name('get_expense_categories');
   
    // All sub Expense Categories Routes
    Route::view('/expense_sub_categories', 'admin.expense_sub_categories')->name('expense_sub_categories');
    Route::post('/load_expense_sub_categories', [ExpenseSubCategoryController::class, 'load_expense_sub_categories'])->name('load_expense_sub_categories');
    Route::post('/insert_expense_sub_category', [ExpenseSubCategoryController::class, 'insert_expense_sub_category'])->name('insert_expense_sub_category');
    Route::get('/edit_expense_sub_category/{id}', [ExpenseSubCategoryController::class, 'edit_expense_sub_category'])->name('edit_expense_sub_category');
    Route::post('/update_expense_sub_category', [ExpenseSubCategoryController::class, 'update_expense_sub_category'])->name('update_expense_sub_category');
    Route::get('/delete_expense_sub_category/{id}', [ExpenseSubCategoryController::class, 'delete_expense_sub_category'])->name('delete_expense_sub_category');
    Route::get('/get_expense_sub_categories', [ExpenseSubCategoryController::class, 'get_expense_sub_categories'])->name('get_expense_sub_categories');
   
    
    // All Expense Routes
    Route::view('/expenses', 'admin.expenses')->name('expenses');
    Route::post('/load_expenses', [ExpenseController::class, 'load_expenses'])->name('load_expenses');
    Route::post('/insert_expense', [ExpenseController::class, 'insert_expense'])->name('insert_expense');
    Route::get('/edit_expense/{id}', [ExpenseController::class, 'edit_expense'])->name('edit_expense');
    Route::post('/update_expense', [ExpenseController::class, 'update_expense'])->name('update_expense');
    Route::get('/delete_expense/{id}', [ExpenseController::class, 'delete_expense'])->name('delete_expense');
    Route::get('/view_expense/{id}', [ExpenseController::class, 'view_expense'])->name('view_expense');
    Route::get('/get_total_expense', [ExpenseController::class, 'get_total_expense'])->name('get_total_expense');


    // All employee Routes
    Route::get('/employee', [EmployeeController::class, 'employee'])->name('employee');
    Route::post('/load_employees', [EmployeeController::class, 'load_employees'])->name('load_employees');
    Route::post('/insert_employee', [EmployeeController::class, 'insert_employee'])->name('insert_employee');
    Route::get('/edit_employee/{id}', [EmployeeController::class, 'edit_employee'])->name('edit_employee');
    Route::post('/update_employee', [EmployeeController::class, 'update_employee'])->name('update_employee');
    Route::get('/delete_employee/{id}', [EmployeeController::class, 'delete_employee'])->name('delete_employee');
    Route::get('/get_employee', [EmployeeController::class, 'get_employee'])->name('get_employee');

    // All employee Ledger Routes
    Route::get('/employee_ledger/{id}', [EmployeeController::class, 'show_employee_ledger'])->name('employee_ledger');
    Route::post('/load_employee_ledger', [EmployeeController::class, 'load_employee_ledger'])->name('load_employee_ledger');
    Route::post('/insert_employee_payment', [EmployeeController::class, 'insert_employee_payment'])->name('insert_employee_payment');
    Route::post('/insert_employee_advance', [EmployeeController::class, 'insert_employee_advance'])->name('insert_employee_advance');

    Route::get('/edit_employee_payment/{id}', [EmployeeController::class, 'edit_employee_payment'])->name('edit_employee_payment');
    Route::post('/update_employee_payment', [EmployeeController::class, 'update_employee_payment'])->name('update_employee_payment');
    Route::get('/delete_employee_payment/{id}', [EmployeeController::class, 'delete_employee_payment'])->name('delete_employee_payment');

    Route::get('/getMonthlyAdvance/{id}', [EmployeeController::class, 'getMonthlyAdvance'])
        ->name('getMonthlyAdvance');
    Route::get('/getEmployeePaymentData/{id}', [EmployeeController::class, 'getEmployeePaymentData'])
        ->name('getEmployeePaymentData');
    // all_employee_ledger
    Route::view('/all_employee_ledger', 'admin.all_employee_ledger')->name('all_employee_ledger');
    Route::post('/load_all_employee_ledger', [EmployeeController::class, 'load_all_employee_ledger'])->name('load_all_employee_ledger');
    

    // All invoice Routes
    Route::view('/invoice', 'admin.invoice')->name('invoice');
    Route::post('/load_invoices', [InvoiceController::class, 'load_invoices'])->name('load_invoices');
    Route::post('/insert_invoice', [InvoiceController::class, 'insert_invoice'])->name('insert_invoice');
    Route::get('/edit_invoice/{id}', [InvoiceController::class, 'edit_invoice'])->name('edit_invoice');
    Route::post('/update_invoice', [InvoiceController::class, 'update_invoice'])->name('update_invoice');
    Route::get('/delete_invoice/{id}', [InvoiceController::class, 'delete_invoice'])->name('delete_invoice');
    Route::get('/view_invoice/{id}', [InvoiceController::class, 'view_invoice'])->name('view_invoice');
    Route::get('/get_invoice', [InvoiceController::class, 'get_invoice'])->name('get_invoice');

    // All quotation Routes
    Route::view('/quotation', 'admin.quotation')->name('quotation');
    Route::post('/load_quotations', [QuotationController::class, 'load_quotations'])->name('load_quotations');
    Route::post('/insert_quotation', [QuotationController::class, 'insert_quotation'])->name('insert_quotation');
    Route::get('/edit_quotation/{id}', [QuotationController::class, 'edit_quotation'])->name('edit_quotation');
    Route::post('/update_quotation', [QuotationController::class, 'update_quotation'])->name('update_quotation');
    Route::get('/delete_quotation/{id}', [QuotationController::class, 'delete_quotation'])->name('delete_quotation');
    Route::get('/view_quotation/{id}', [QuotationController::class, 'view_quotation'])->name('view_quotation');
    Route::post('/convert_quotation_to_sale', [QuotationController::class, 'convert_quotation_to_sale'])->name('convert_quotation_to_sale');
    

    // All orderbooker Routes
    Route::view('/order_booker', 'admin.order_booker')->name('order_booker');
    Route::post('/load_order_booker', [OrderBookerController::class, 'load_order_booker'])->name('load_order_booker');
    Route::post('/insert_order_booker', [OrderBookerController::class, 'insert_order_booker'])->name('insert_order_booker');
    Route::get('/edit_order_booker/{id}', [OrderBookerController::class, 'edit_order_booker'])->name('edit_order_booker');
    Route::post('/update_order_booker', [OrderBookerController::class, 'update_order_booker'])->name('update_order_booker');
    Route::get('/delete_order_booker/{id}', [OrderBookerController::class, 'delete_order_booker'])->name('delete_order_booker');
    Route::get('/view_order_booker/{id}', [OrderBookerController::class, 'view_order_booker'])->name('view_order_booker');
    Route::post('/update_order_status', [OrderBookerController::class, 'update_status'])->name('update_order_status');
    Route::get('/getSalesmenByArea', [OrderBookerController::class, 'getSalesmenByArea'])->name('getSalesmenByArea');
    Route::get('/getCustomersByArea', [OrderBookerController::class, 'getCustomersByArea'])->name('getCustomersByArea');

    // Order Booker Cashier Routes
    Route::view('/order_booker_cashier', 'admin.order_booker_cashier')->name('order_booker_cashier');
    Route::post('/load_order_booker_cashier', [OrderBookerController::class, 'load_order_booker_cashier'])->name('load_order_booker_cashier');
    Route::get('/get-pending-order-booker-balances', [OrderBookerController::class, 'getPendingOrderBookerBalances'])->name('get_pending_order_booker_balances');
    Route::get('/check-can-send-to-cashier', [OrderBookerController::class, 'check_can_send_to_cashier'])->name('check_can_send_to_cashier');
    Route::post('/send-order-booker-to-cashier', [OrderBookerController::class, 'send_order_booker_to_cashier'])->name('send_order_booker_to_cashier');

    // NEW: Order Booker Expense and Submission Routes
    Route::post('/add-order-booker-expense', [OrderBookerController::class, 'add_order_booker_expense'])->name('add_order_booker_expense');
    Route::post('/receive-order-booker-submission', [OrderBookerController::class, 'receive_order_booker_submission'])->name('receive_order_booker_submission');
    Route::post('/approve-order-booker-submission', [OrderBookerController::class, 'approve_order_booker_submission'])->name('approve_order_booker_submission');

    // All repairing routes
    Route::view('/repair_order', 'admin.repair_order')->name('repair_order');
    Route::post('/load_repair_order', [RepairOrderController::class, 'load_repair_order'])->name('load_repair_order');
    Route::post('/insert_repair_order', [RepairOrderController::class, 'insert_repair_order'])->name('insert_repair_order');
    Route::get('/edit_repair_order/{id}', [RepairOrderController::class, 'edit_repair_order'])->name('edit_repair_order');
    Route::post('/update_repair_order', [RepairOrderController::class, 'update_repair_order'])->name('update_repair_order');
    Route::get('/delete_repair_order/{id}', [RepairOrderController::class, 'delete_repair_order'])->name('delete_repair_order');
    Route::get('/non_service_products', [RepairOrderController::class, 'non_service_products'])->name('non_service_products');
    Route::get('/get_production_price_by_batch/{batch_number}', [RepairOrderController::class, 'get_production_price_by_batch'])->name('get_production_price_by_batch');
    Route::get('/get_production_price_by_product/{product_id}', [RepairOrderController::class, 'get_production_price_by_product'])->name('get_production_price_by_product');
    Route::get('/get_all_products_with_price', [RepairOrderController::class, 'get_all_products_with_price'])->name('get_all_products_with_price');

    // contracter orders 
    Route::view('/contracter_orders', 'admin.contracter_orders')->name('contracter_orders');
    Route::post('/load_contracter_order', [ContracterController::class, 'load_contracter_order'])->name('load_contracter_order');
    Route::get('/edit_contracter_order/{id}', [ContracterController::class, 'edit_contracter_order'])->name('edit_contracter_order');
    Route::post('/update_contracter_order', [ContracterController::class, 'update_contracter_order'])->name('update_contracter_order');
    

    // stock 
    Route::view('/main_stock', 'admin.stock')->name('main_stock');
    Route::post('/load_stock', [StockController::class, 'load_stock'])->name('load_stock');
    // saleman stock 
    Route::view('/saleman_stock', 'admin.saleman_stock')->name('saleman_stock');
    Route::post('/load_saleman_stock', [StockController::class, 'load_saleman_stock'])->name('load_saleman_stock');
    // non serviceable stock 
    Route::view('/non_serviceable_stock', 'admin.non_serviceable_stock')->name('non_serviceable_stock');
    Route::post('/load_non_serviceable_stock', [StockController::class, 'load_non_serviceable_stock'])->name('load_non_serviceable_stock');
    // get saleman stock 
    Route::post('/get_salesman_stock', [StockController::class, 'getSalesmanStock'])->name('getSalesmanStock');


    // Reports
    Route::view('/main_stock_report', 'admin.main_stock_report')->name('main_stock_report');
    Route::post('/load_main_stock_report', [StockController::class, 'load_main_stock_report'])->name('load_main_stock_report');

    Route::view('/non_serviceable_stock_report', 'admin.non_serviceable_stock_report')->name('non_serviceable_stock_report');
    Route::post('/load_non_serviceable_stock_report', [StockController::class, 'load_non_serviceable_stock_report'])->name('load_non_serviceable_stock_report');

    Route::view('/investor_investments_report', 'admin.investor_investments_report')->name('investor_investments_report');
    Route::post('/load_inv_investments', [InvestmentController::class, 'load_inv_investments'])->name('load_inv_investments');
    
    Route::view('/company_investment_report', 'admin.company_investment_report')->name('company_investment_report');
    Route::post('/load_company_investments', [CompanyInvestmentController::class, 'load_company_investments'])->name('load_company_investments');
    
    Route::view('/withdrawals_report', 'admin.withdrawals_report')->name('withdrawals_report');
    Route::post('/load_withdrawals', [WithdrawalController::class, 'load_withdrawals'])->name('load_withdrawals');

    Route::view('/cash_bank_report', 'admin.cash_bank_report')->name('cash_bank_report');
    Route::post('/load_cash_bank_report', [TransactionController::class, 'load_cash_bank_report'])->name('load_cash_bank_report');

    Route::view('/profit_report', 'admin.profit_report')->name('profit_report');
    Route::post('/load_profit_report', [StockController::class, 'load_profit_report'])->name('load_profit_report');

    // New Sales & Returns Reports
    Route::get('/reports/sales', [ReportController::class, 'sale_report'])->name('sale_report');
    Route::post('/reports/sales/data', [ReportController::class, 'sale_report_data'])->name('sale_report_data');

    Route::get('/reports/sale-summary', [ReportController::class, 'sale_summary'])->name('sale_summary');
    Route::post('/reports/sale-summary/data', [ReportController::class, 'sale_summary_data'])->name('sale_summary_data');

    Route::get('/reports/sale-returns', [ReportController::class, 'sale_return_report'])->name('sale_return_report');
    Route::post('/reports/sale-returns/data', [ReportController::class, 'sale_return_data'])->name('sale_return_data');

    Route::get('/reports/sale-return-summary', [ReportController::class, 'sale_return_summary'])->name('sale_return_summary');
    Route::post('/reports/sale-return-summary/data', [ReportController::class, 'sale_return_summary_data'])->name('sale_return_summary_data');

    Route::get('/reports/salesman-orders', [ReportController::class, 'salesman_order_report'])->name('salesman_order_report');
    Route::post('/reports/salesman-orders/data', [ReportController::class, 'salesman_order_data'])->name('salesman_order_data');

    // Salesman Order Summary
    Route::get('/reports/salesman-order-summary', [ReportController::class, 'salesman_order_summary'])->name('salesman_order_summary');
    Route::post('/reports/salesman-order-summary/data', [ReportController::class, 'salesman_order_summary_data'])->name('salesman_order_summary_data');

    // Salesman Order Return Report
    Route::get('/reports/salesman-order-return', [ReportController::class, 'salesman_order_return_report'])->name('salesman_order_return_report');
    Route::post('/reports/salesman-order-return/data', [ReportController::class, 'salesman_order_return_data'])->name('salesman_order_return_data');

    // Salesman Order Return Summary
    Route::get('/reports/salesman-order-return-summary', [ReportController::class, 'salesman_order_return_summary'])->name('salesman_order_return_summary');
    Route::post('/reports/salesman-order-return-summary/data', [ReportController::class, 'salesman_order_return_summary_data'])->name('salesman_order_return_summary_data');

    // Order Booker Report
    Route::get('/reports/order-booker', [ReportController::class, 'order_booker_report'])->name('order_booker_report');
    Route::post('/reports/order-booker/data', [ReportController::class, 'order_booker_data'])->name('order_booker_data');

    // Salesman Ledger Report
    Route::get('/reports/salesman-ledger', [ReportController::class, 'salesman_ledger_report'])->name('salesman_ledger_report');
    Route::post('/reports/salesman-ledger/data', [ReportController::class, 'salesman_ledger_data'])->name('salesman_ledger_data');

    // Salesman Expense Report
    Route::get('/reports/salesman-expense', [ReportController::class, 'salesman_expense_report'])->name('salesman_expense_report');
    Route::post('/reports/salesman-expense/data', [ReportController::class, 'salesman_expense_data'])->name('salesman_expense_data');

    // Order Booker Cashier Report
    Route::get('/reports/order-booker-cashier', [ReportController::class, 'order_booker_cashier_report'])->name('order_booker_cashier_report');
    Route::post('/reports/order-booker-cashier/data', [ReportController::class, 'order_booker_cashier_data'])->name('order_booker_cashier_data');

    // Order Booker Order Report
    Route::get('/reports/order-booker-order', [ReportController::class, 'order_booker_order_report'])->name('order_booker_order_report');
    Route::post('/reports/order-booker-order/data', [ReportController::class, 'order_booker_order_data'])->name('order_booker_order_data');

    // Storeman Order for Stock Report
    Route::get('/reports/storeman-order-stock', [ReportController::class, 'storeman_order_stock_report'])->name('storeman_order_stock_report');
    Route::post('/reports/storeman-order-stock/data', [ReportController::class, 'storeman_order_stock_data'])->name('storeman_order_stock_data');

    // Storeman Order for Stock Summary
    Route::get('/reports/storeman-order-stock-summary', [ReportController::class, 'storeman_order_stock_summary'])->name('storeman_order_stock_summary');
    Route::post('/reports/storeman-order-stock-summary/data', [ReportController::class, 'storeman_order_stock_summary_data'])->name('storeman_order_stock_summary_data');

    // Storeman Sale Return Report
    Route::get('/reports/storeman-sale-return', [ReportController::class, 'storeman_sale_return_report'])->name('storeman_sale_return_report');
    Route::post('/reports/storeman-sale-return/data', [ReportController::class, 'storeman_sale_return_data'])->name('storeman_sale_return_data');

    // Storeman Sale Return Summary
    Route::get('/reports/storeman-sale-return-summary', [ReportController::class, 'storeman_sale_return_summary'])->name('storeman_sale_return_summary');
    Route::post('/reports/storeman-sale-return-summary/data', [ReportController::class, 'storeman_sale_return_summary_data'])->name('storeman_sale_return_summary_data');

    // Production Report
    Route::get('/reports/production', [ReportController::class, 'production_report'])->name('production_report');
    Route::post('/reports/production/data', [ReportController::class, 'production_report_data'])->name('production_report_data');

    // Contractor Order Report
    Route::get('/reports/contractor-order', [ReportController::class, 'contractor_order_report'])->name('contractor_order_report');
    Route::post('/reports/contractor-order/data', [ReportController::class, 'contractor_order_report_data'])->name('contractor_order_report_data');

    // Non-Serviceable Stock Report
    Route::get('/reports/non-serviceable-stock', [ReportController::class, 'non_serviceable_stock_report_new'])->name('non_serviceable_stock_report_new');
    Route::post('/reports/non-serviceable-stock/data', [ReportController::class, 'non_serviceable_stock_report_data'])->name('non_serviceable_stock_report_data');

    // Repairing Order Report
    Route::get('/reports/repairing-order', [ReportController::class, 'repairing_order_report'])->name('repairing_order_report');
    Route::post('/reports/repairing-order/data', [ReportController::class, 'repairing_order_report_data'])->name('repairing_order_report_data');

    // Salaries Report
    Route::get('/reports/salaries', [ReportController::class, 'salaries_report'])->name('salaries_report');
    Route::post('/reports/salaries/data', [ReportController::class, 'salaries_report_data'])->name('salaries_report_data');

    // Purchase Report
    Route::get('/reports/purchase', [ReportController::class, 'purchase_report'])->name('purchase_report');
    Route::post('/reports/purchase/data', [ReportController::class, 'purchase_report_data'])->name('purchase_report_data');

    // Purchase Return Report
    Route::get('/reports/purchase-return', [ReportController::class, 'purchase_return_report'])->name('purchase_return_report');
    Route::post('/reports/purchase-return/data', [ReportController::class, 'purchase_return_report_data'])->name('purchase_return_report_data');

    // Purchase Qty Report
    Route::get('/reports/purchase-qty', [ReportController::class, 'purchase_qty_report'])->name('purchase_qty_report');
    Route::post('/reports/purchase-qty/data', [ReportController::class, 'purchase_qty_report_data'])->name('purchase_qty_report_data');

    // Purchase Return Qty Report
    Route::get('/reports/purchase-return-qty', [ReportController::class, 'purchase_return_qty_report'])->name('purchase_return_qty_report');
    Route::post('/reports/purchase-return-qty/data', [ReportController::class, 'purchase_return_qty_report_data'])->name('purchase_return_qty_report_data');

    // CASH FLOW & P&L REPORT
    Route::get('/reports/cash-flow', [ReportController::class, 'cash_flow_report'])->name('cash_flow_report');
    Route::post('/reports/cash-flow/data', [ReportController::class, 'cash_flow_data'])->name('cash_flow_data');

    // get pending payment of saleman
    // web.php
    Route::get('/get-pending-balances', [SalesmanController::class, 'getPendingBalances']);
    Route::get('/get-received-payments', [SalesmanController::class, 'getReceivedPayments']);
    Route::get('/get-submission-details/{salesman_id}/{date}', [SalesmanController::class, 'getSubmissionDetails']);
    Route::post('/receive-submission', [SalesmanController::class, 'receiveSubmission']);
    Route::post('/approve-submission', [SalesmanController::class, 'approveSubmission']);



});

require __DIR__.'/auth.php';