<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <style>
        .summary-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .summary-card h5 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 15px;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 8px;
        }
        .summary-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed #dee2e6;
        }
        .summary-item:last-child {
            border-bottom: none;
        }
        .summary-item .label {
            color: #6c757d;
            font-weight: 500;
        }
        .summary-item .value {
            font-weight: 600;
            color: #212529;
        }
        .summary-item .value.positive {
            color: #28a745;
        }
        .summary-item .value.negative {
            color: #dc3545;
        }
        .total-row {
            background: #e9ecef;
            padding: 12px;
            border-radius: 5px;
            margin-top: 10px;
        }
        .total-row .label {
            font-size: 16px;
            font-weight: 700;
        }
        .total-row .value {
            font-size: 18px;
            font-weight: 700;
            color: #007bff;
        }
        .counting {
            min-width: 140px;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_head'); ?>

    <div class="row">
        <div class="col-md-2 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Order Booker Cashier</h1>
            </div>
            <ol class="breadcrumb">
                <li>Track your orders, credits and expenses</li>
            </ol>
            </div>
        <div class="col-md-10">
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Orders<br> <b id="total_orders">0</b></div>
                <div class="page-header counting">Total Credit<br> <b id="total_credit" class="text-success">0</b></div>
                <div class="page-header counting">Total Expense<br> <b id="total_expense" class="text-danger">0</b></div>
                <div class="page-header counting">Net Amount<br> <b id="net_amount" class="text-primary">0</b></div>
                <div class="page-header counting round-corner-right">Total Balance<br> <b id="total_balance" class="text-warning">0</b></div>
            </div>
            </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>

    <div class="row">
        <div class="col-xs-12">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <?php if(Auth::user()->hasRole('Order Booker')): ?>
                        <button id="send_to_cashier_btn" class="btn btn-success"><i class="fa-duotone fa-paper-plane"></i> Send to Cashier</button>
                        <?php endif; ?>
                        <button id="refresh_cashier_btn" class="btn btn-primary"><i class="fa-duotone fa-refresh"></i> Refresh</button>
                    </div>
                    <h3 class="panel-title">
                        <?php if(Auth::user()->hasRole('Order Booker')): ?>
                            Your Transactions
                        <?php elseif(Auth::user()->hasRole('Cashier')): ?>
                            Order Booker Submissions - Pending Receipt
                        <?php else: ?>
                            Order Booker Submissions - All
                        <?php endif; ?>
                    </h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Date Range</label>
                                <input type="text" id="search_by_date" class="form-control" placeholder="Select Date Range">
                            </div>
                        </div>
                    </div>

                    <table id="cashier_table" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>Detail</th>
                                <th>Order Amount</th>
                                <th>Paid (Credit)</th>
                                <th>Expense</th>
                                <th>Running Credit</th>
                                <th>Running Balance</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Send to Cashier Modal -->
    <div class="modal fade" id="sendToCashierModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-success">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" style="color: white;">Send to Cashier</h4>
                </div>
                <form id="send_cashier_form">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Date Range</label>
                            <input type="text" id="cashier_date" name="cashier_date" class="form-control" readonly>
                        </div>

                        <div class="summary-card">
                            <h5>Summary</h5>
                            <div class="summary-item">
                                <span class="label">Total Order Amount:</span>
                                <span class="value" id="summary_order_amount">0.00</span>
                            </div>
                            <div class="summary-item">
                                <span class="label">Total Credit (Collected):</span>
                                <span class="value positive" id="summary_credit">0.00</span>
                            </div>
                            <div class="summary-item">
                                <span class="label">Total Expenses:</span>
                                <span class="value negative" id="summary_expense">0.00</span>
                            </div>
                            <div class="summary-item">
                                <span class="label">Total Balance (Due from Customers):</span>
                                <span class="value" style="color: #ff9800;" id="summary_balance">0.00</span>
                            </div>
                            <div class="total-row summary-item">
                                <span class="label">Net Amount to Submit:</span>
                                <span class="value" id="summary_net">0.00</span>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <i class="fa-duotone fa-info-circle"></i>
                            <strong>Note:</strong> Net Amount = Total Credit - Total Expenses<br>
                            Balance amount is customer dues and will be collected later.
                        </div>

                        <input type="hidden" name="start_date" id="hidden_start_date">
                        <input type="hidden" name="end_date" id="hidden_end_date">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Submit to Cashier</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var cashierTable;

        // Set today's date as default
        var today = moment();
        var todayFormatted = today.format('DD-MM-YYYY');

        // Set the input value to display today's date
        $('#search_by_date').val(todayFormatted + ' - ' + todayFormatted);

        // Initialize date range picker for search with today's date
        $('#search_by_date').daterangepicker({
            autoApply: true,
            startDate: today,
            endDate: today,
            locale: {
                format: 'DD-MM-YYYY'
            },
            showCustomRangeLabel: false,
            alwaysShowCalendars: true,
            ranges: {
               'Today': [moment(), moment()],
               'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
               'Last 7 Days': [moment().subtract(6, 'days'), moment()],
               'This Week': [moment().startOf('week'), moment().endOf('week')],
               'This Month': [moment().startOf('month'), moment().endOf('month')],
            }
        }, function(start, end) {
            // Update input value
            $('#search_by_date').val(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            // Reload table when date changes
            if (cashierTable) {
                cashierTable.ajax.reload();
            }
            // Update summary
            updateSummary();
        });

        // Initialize DataTable
        cashierTable = $('#cashier_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '<?php echo e(route('load_order_booker_cashier')); ?>',
                type: 'POST',
                data: function(d) {
                    var dateRange = $('#search_by_date').val();
                    if (dateRange) {
                        var dates = dateRange.split(' - ');
                        d.startdate = dates[0];
                        d.enddate = dates[1] || dates[0];
                    } else {
                        d.startdate = todayFormatted;
                        d.enddate = todayFormatted;
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                dataSrc: function(json) {
                    // Update summary from server response
                    if (json.summary) {
                        $('#total_orders').text(json.summary.total_order_amount);
                        $('#total_credit').text(json.summary.total_credit);
                        $('#total_balance').text(json.summary.total_balance);
                    }
                    return json.data;
                },
                error: function(xhr, error, code) {
                    console.log('DataTable Error:', xhr, error, code);
                }
            },
            columns: [
                { data: 'id' },
                { data: 'date' },
                { data: 'detail' },
                { data: 'order_amount', className: 'text-right' },
                { data: 'paid_amount', className: 'text-right text-success' },
                { data: 'expense', className: 'text-right text-danger' },
                { data: 'credit', className: 'text-right text-primary' },
                { data: 'balance', className: 'text-right text-warning' },
                { data: 'status', className: 'text-center' },
                { data: 'action', className: 'text-center', orderable: false }
            ],
            order: [[0, 'asc']],
            pageLength: 25,
            language: {
                emptyTable: "No transactions found for the selected date range"
            }
        });

        // Update summary function
        function updateSummary() {
            var dateRange = $('#search_by_date').val();
            var startDate = '';
            var endDate = '';

            if (dateRange) {
                var dates = dateRange.split(' - ');
                startDate = dates[0] || '';
                endDate = dates[1] || startDate;
            } else {
                startDate = todayFormatted;
                endDate = todayFormatted;
            }

            $.ajax({
                url: '<?php echo e(route('get_pending_order_booker_balances')); ?>',
                method: 'GET',
                data: {
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    if (response.status === 200) {
                        $('#total_orders').text(response.total_order_amount);
                        $('#total_credit').text(response.total_credit);
                        $('#total_expense').text(response.total_expense);
                        $('#net_amount').text(response.net_amount);
                        $('#total_balance').text(response.total_balance);
                    }
                }
            });
        }

        // Check if user can send to cashier today
        function checkCanSendToCashier() {
            $.ajax({
                url: '<?php echo e(route('check_can_send_to_cashier')); ?>',
                method: 'GET',
                success: function(response) {
                    if (response.status === 200) {
                        if (!response.can_send) {
                            // Disable button and show message
                            $('#send_to_cashier_btn').prop('disabled', true)
                                .removeClass('btn-success')
                                .addClass('btn-secondary')
                                .attr('title', response.message)
                                .html('<i class="fa-duotone fa-lock"></i> Already Sent Today');
                        } else {
                            // Enable button
                            $('#send_to_cashier_btn').prop('disabled', false)
                                .removeClass('btn-secondary')
                                .addClass('btn-success')
                                .attr('title', 'Send to Cashier')
                                .html('<i class="fa-duotone fa-paper-plane"></i> Send to Cashier');
                        }
                    }
                },
                error: function(xhr) {
                    console.log('Error checking send status:', xhr);
                    // On error, keep button enabled as fallback
                }
            });
        }

        // Initial summary load
        updateSummary();

        // Check button state on page load
        <?php if(Auth::user()->hasRole('Order Booker')): ?>
            checkCanSendToCashier();
        <?php endif; ?>

        // Refresh button
        $('#refresh_cashier_btn').click(function() {
            cashierTable.ajax.reload();
            updateSummary();
        });

        // Send to Cashier button
        $('#send_to_cashier_btn').click(function() {
            var selectedDateRange = $('#search_by_date').val();
            var startDate = '';
            var endDate = '';
            var displayDateRange = '';

            if (selectedDateRange) {
                var dates = selectedDateRange.split(' - ');
                startDate = dates[0] || '';
                endDate = dates[1] || startDate;
                displayDateRange = startDate + ' - ' + endDate;
            } else {
                var today = new Date();
                var d = String(today.getDate()).padStart(2, '0');
                var m = String(today.getMonth() + 1).padStart(2, '0');
                var y = today.getFullYear();
                startDate = d + '-' + m + '-' + y;
                endDate = d + '-' + m + '-' + y;
                displayDateRange = startDate + ' - ' + endDate;
            }

            $('#cashier_date').val(displayDateRange);
            $('#hidden_start_date').val(startDate);
            $('#hidden_end_date').val(endDate);

            // Load pending balances for summary
            $.ajax({
                url: '<?php echo e(route('get_pending_order_booker_balances')); ?>',
                method: 'GET',
                data: {
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    if (response.status === 200) {
                        $('#summary_order_amount').text(response.total_order_amount);
                        $('#summary_credit').text(response.total_credit);
                        $('#summary_expense').text(response.total_expense);
                        $('#summary_net').text(response.net_amount);
                        $('#summary_balance').text(response.total_balance);
                    }
                }
            });

            // Show modal
            $('#sendToCashierModal').modal('show');
        });

        // Submit to cashier form
        $('#send_cashier_form').submit(function(e) {
            e.preventDefault();

            $.ajax({
                url: '<?php echo e(route('send_order_booker_to_cashier')); ?>',
                method: 'POST',
                data: {
                    start_date: $('#hidden_start_date').val(),
                    end_date: $('#hidden_end_date').val(),
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    if (response.status === 200) {
                        toastr.success(response.message);
                        $('#sendToCashierModal').modal('hide');
                        cashierTable.ajax.reload();
                        updateSummary();

                        // Disable the button after successful submission
                        $('#send_to_cashier_btn').prop('disabled', true)
                            .removeClass('btn-success')
                            .addClass('btn-secondary')
                            .attr('title', 'Already sent today')
                            .html('<i class="fa-duotone fa-lock"></i> Already Sent Today');
                    }
                },
                error: function(xhr) {
                    var errorMessage = 'Error sending to cashier';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    toastr.error(errorMessage);

                    // If error is "already sent today", update button state
                    if (xhr.status === 400) {
                        $('#sendToCashierModal').modal('hide');
                        checkCanSendToCashier();
                    }
                }
            });
        });

        // Receive button handler (for Cashier)
        $(document).on('click', '.receive-btn', function() {
            var submissionId = $(this).data('id');
            var btn = $(this);

            if (confirm('Are you sure you want to receive this submission?')) {
                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Receiving...');

                $.ajax({
                    url: '<?php echo e(route('receive_order_booker_submission')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        submission_id: submissionId
                    },
                    success: function(response) {
                        if (response.status === 200) {
                            toastr.success(response.message, 'Success!');
                            cashierTable.ajax.reload();
                        } else {
                            toastr.error(response.message || 'Failed to receive submission');
                            btn.prop('disabled', false).html('<i class="fa fa-check"></i> Receive');
                        }
                    },
                    error: function(xhr) {
                        var errorMsg = xhr.responseJSON?.message || 'Error receiving submission';
                        toastr.error(errorMsg, 'Error');
                        btn.prop('disabled', false).html('<i class="fa fa-check"></i> Receive');
                    }
                });
            }
        });

        // Approve button handler (for Admin)
        $(document).on('click', '.approve-btn', function() {
            var submissionId = $(this).data('id');
            var btn = $(this);

            if (confirm('Are you sure you want to approve this submission? This will add the amount to hand cash.')) {
                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Approving...');

                $.ajax({
                    url: '<?php echo e(route('approve_order_booker_submission')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        submission_id: submissionId
                    },
                    success: function(response) {
                        if (response.status === 200) {
                            toastr.success(response.message, 'Success!');
                            cashierTable.ajax.reload();
                        } else {
                            toastr.error(response.message || 'Failed to approve submission');
                            btn.prop('disabled', false).html('<i class="fa fa-thumbs-up"></i> Approve');
                        }
                    },
                    error: function(xhr) {
                        var errorMsg = xhr.responseJSON?.message || 'Error approving submission';
                        toastr.error(errorMsg, 'Error');
                        btn.prop('disabled', false).html('<i class="fa fa-thumbs-up"></i> Approve');
                    }
                });
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/order_booker_cashier.blade.php ENDPATH**/ ?>