

<?php $__env->startSection('css_code'); ?>
<style>
    .panel-summary {
        text-align: center;
        padding: 20px;
        color: white;
        border-radius: 5px;
        margin-bottom: 20px;
    }
    .bg-profit { background-color: #26a69a; } /* Green/Teal */
    .bg-loss { background-color: #ef5350; } /* Red */
    .bg-info-custom { background-color: #42a5f5; }
    .bg-warning-custom { background-color: #ffa726; }
    
    .summary-title { font-size: 14px; text-transform: uppercase; font-weight: 600; opacity: 0.9; }
    .summary-value { font-size: 24px; font-weight: bold; margin-top: 5px; }

    .table-detail th { background-color: #f5f5f5; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_head'); ?>
    <div id="page-title">
        <h1 class="page-header text-overflow">Cash Flow & Profit/Loss Report</h1>
    </div>
    <ol class="breadcrumb">
        <li><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
        <li>Reports</li>
        <li class="active">Cash Flow & P&L</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>
<div class="panel">
    <div class="panel-body">
        
        <div class="row mar-btm">
            <div class="col-md-4">
                <div class="input-group">
                    <input type="text" class="form-control" id="start_date" name="start_date" placeholder="Start Date" autocomplete="off">
                    <span class="input-group-addon">to</span>
                    <input type="text" class="form-control" id="end_date" name="end_date" placeholder="End Date" autocomplete="off">
                </div>
            </div>
            <div class="col-md-4">
                <button class="btn btn-primary" id="btn-filter">Filter Report</button>
                <button class="btn btn-dark" id="btn-print" style="margin-left: 10px;"><i class="fa fa-print"></i> Print / PDF</button>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-3">
                <div class="panel-summary bg-info-custom">
                    <div class="summary-title">Total Sales Revenue</div>
                    <div class="summary-value" id="val_sales">0.00</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-warning-custom">
                    <div class="summary-title">Total Expenses & Cost</div>
                    <div class="summary-value" id="val_expenses">0.00</div>
                    <small>Purchases, Salaries, Ops</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-profit" id="profit_panel">
                    <div class="summary-title">Net Profit / Loss</div>
                    <div class="summary-value" id="val_profit">0.00</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="panel-summary bg-primary">
                    <div class="summary-title">Net Cash Flow</div>
                    <div class="summary-value" id="val_cash_flow">0.00</div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-bordered panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title">Income & Inflow Details</h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-striped table-detail">
                            <tbody>
                                <tr>
                                    <td>Total Sales</td>
                                    <td class="text-right text-bold" id="d_sales">0.00</td>
                                </tr>
                                <tr>
                                    <td>Investments Received</td>
                                    <td class="text-right text-bold" id="d_investments">0.00</td>
                                </tr>
                                <tr>
                                    <td>Purchase Returns (Refunds)</td>
                                    <td class="text-right text-bold" id="d_purch_ret">0.00</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-bordered panel-danger">
                    <div class="panel-heading">
                        <h3 class="panel-title">Expenses & Outflow Details</h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-striped table-detail">
                            <tbody>
                                <tr>
                                    <td>Purchases (Accrual)</td>
                                    <td class="text-right text-bold" id="d_purchases">0.00</td>
                                </tr>
                                <tr>
                                    <td>Production Labour Cost</td>
                                    <td class="text-right text-bold" id="d_labour">0.00</td>
                                </tr>
                                <tr>
                                    <td>Employee Salaries</td>
                                    <td class="text-right text-bold" id="d_salaries">0.00</td>
                                </tr>
                                <tr>
                                    <td>General Expenses</td>
                                    <td class="text-right text-bold" id="d_gen_expenses">0.00</td>
                                </tr>
                                <tr>
                                    <td>Salesman Expenses</td>
                                    <td class="text-right text-bold" id="d_sales_expenses">0.00</td>
                                </tr>
                                <tr>
                                    <td>Sale Returns (Refunds)</td>
                                    <td class="text-right text-bold" id="d_sale_ret">0.00</td>
                                </tr>
                                <tr>
                                    <td>Investment Withdrawals</td>
                                    <td class="text-right text-bold" id="d_withdrawals">0.00</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tab-base">
                    <ul class="nav nav-tabs">
                        <li class="active"><a data-toggle="tab" href="#tab-banks">Bank Transactions</a></li>
                        <li><a data-toggle="tab" href="#tab-expenses">Expense Breakdown</a></li>
                        <li><a data-toggle="tab" href="#tab-salesmen">Salesman Performance</a></li>
                    </ul>
        
                    <div class="tab-content">
                        <div id="tab-banks" class="tab-pane fade active in">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Bank Name</th>
                                        <th class="text-right">Total Deposits</th>
                                        <th class="text-right">Total Withdrawals</th>
                                        <th class="text-right">Net Movement</th>
                                    </tr>
                                </thead>
                                <tbody id="table_banks"></tbody>
                            </table>
                        </div>
                        <div id="tab-expenses" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Category Name</th>
                                        <th class="text-right">Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="table_expenses"></tbody>
                            </table>
                        </div>
                        <div id="tab-salesmen" class="tab-pane fade">
                            <table class="table table-hover table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Salesman Name</th>
                                        <th class="text-center">Total Sales</th>
                                        <th class="text-center">Sale Count</th>
                                        <th class="text-right">Expenses Incurred</th>
                                    </tr>
                                </thead>
                                <tbody id="table_salesmen"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript_code'); ?>
<script>
$(document).ready(function() {
    
    // Store report data globally for printing
    var currentReportData = null;

    // Set default date (This Month)
    var date = new Date();
    var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
    
    // Initialize Daterangepicker using the library from main_layout
    $('#start_date').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        startDate: firstDay,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });

    $('#end_date').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        startDate: lastDay,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });

    // Load initial data
    loadReportData();

    $('#btn-filter').click(function() {
        loadReportData();
    });

    $('#btn-print').click(function() {
        printReport();
    });

    function loadReportData() {
        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();

        $.ajax({
            url: "<?php echo e(route('cash_flow_data')); ?>",
            type: "POST",
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                start_date: start_date,
                end_date: end_date
            },
            success: function(response) {
                if(response.status == 200) {
                    currentReportData = response; // Store data for print
                    updateDashboard(response.summary);
                    updateTables(response.breakdowns);
                }
            },
            error: function(xhr) {
                console.log(xhr.responseText);
            }
        });
    }

    function updateDashboard(summary) {
        // Update Summary Cards
        $('#val_sales').text(summary.total_sales);
        
        // Calculate total expenses for display
        var total_exp_display = parseFloat(summary.total_purchases.replace(/,/g, '')) + 
                                parseFloat(summary.total_salaries.replace(/,/g, '')) +
                                parseFloat(summary.total_expenses.replace(/,/g, ''));
        
        $('#val_expenses').text(number_format(total_exp_display, 2));
        $('#val_profit').text(summary.net_profit);
        $('#val_cash_flow').text(summary.net_cash_flow);

        // Color Logic for Profit
        var profitVal = parseFloat(summary.net_profit.replace(/,/g, ''));
        if(profitVal < 0) {
            $('#profit_panel').removeClass('bg-profit').addClass('bg-loss');
        } else {
            $('#profit_panel').removeClass('bg-loss').addClass('bg-profit');
        }

        // Update Detail Tables
        $('#d_sales').text(summary.total_sales);
        $('#d_investments').text(summary.total_investments);
        $('#d_purch_ret').text(summary.total_purchases_accrual); // Assuming refund amount logic matches

        $('#d_purchases').text(summary.total_purchases);
        $('#d_labour').text(summary.total_labour_cost);
        $('#d_salaries').text(summary.total_salaries);
        $('#d_gen_expenses').text(summary.total_expenses);
        $('#d_sales_expenses').text(summary.total_salesman_expenses);
        $('#d_sale_ret').text(summary.total_sale_returns);
        $('#d_withdrawals').text(summary.total_withdrawals);
    }

    function updateTables(data) {
        // Banks
        var bankHtml = '';
        if(data.banks.length > 0) {
            $.each(data.banks, function(i, item){
                var net = parseFloat(item.total_in) - parseFloat(item.total_out);
                bankHtml += '<tr><td>'+item.bank_name+'</td><td class="text-right">'+number_format(item.total_in,2)+'</td><td class="text-right">'+number_format(item.total_out,2)+'</td><td class="text-right text-bold">'+number_format(net,2)+'</td></tr>';
            });
        } else {
            bankHtml = '<tr><td colspan="4" class="text-center">No bank transactions found.</td></tr>';
        }
        $('#table_banks').html(bankHtml);

        // Expenses
        var expHtml = '';
        if(data.expenses.length > 0) {
            $.each(data.expenses, function(i, item){
                expHtml += '<tr><td>'+item.name+'</td><td class="text-right">'+number_format(item.total,2)+'</td></tr>';
            });
        } else {
            expHtml = '<tr><td colspan="2" class="text-center">No expenses found.</td></tr>';
        }
        $('#table_expenses').html(expHtml);

        // Salesmen
        var salesManHtml = '';
        if(data.salesmen.length > 0) {
            $.each(data.salesmen, function(i, item){
                salesManHtml += '<tr><td>'+item.name+'</td><td class="text-center">'+number_format(item.total_sales,2)+'</td><td class="text-center">'+item.sale_count+'</td><td class="text-right">'+number_format(item.total_expenses,2)+'</td></tr>';
            });
        } else {
            salesManHtml = '<tr><td colspan="4" class="text-center">No data found.</td></tr>';
        }
        $('#table_salesmen').html(salesManHtml);
    }

    function printReport() {
        if(!currentReportData) {
            alert('Please filter data first to print.');
            return;
        }

        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();
        var summary = currentReportData.summary;
        var breakdowns = currentReportData.breakdowns;

        // Calculate total expenses for display logic (same as dashboard)
        var total_exp_display = parseFloat(summary.total_purchases.replace(/,/g, '')) + 
                                parseFloat(summary.total_salaries.replace(/,/g, '')) +
                                parseFloat(summary.total_expenses.replace(/,/g, ''));

        // Determine Profit/Loss Label
        var profitVal = parseFloat(summary.net_profit.replace(/,/g, ''));
        var profitClass = profitVal < 0 ? 'text-danger' : 'text-success';

        var printWindow = window.open('', 'PRINT', 'height=800,width=1000');

        var html = '<html><head><title>Cash Flow & P/L Report</title>';
        html += '<style>';
        html += 'body { font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; padding: 30px; color: #333; }';
        html += '.header { text-align: center; margin-bottom: 40px; border-bottom: 2px solid #333; padding-bottom: 20px; }';
        html += '.header h1 { margin: 0; font-size: 24px; text-transform: uppercase; }';
        html += '.header p { margin: 5px 0 0; font-size: 14px; color: #666; }';
        
        html += '.summary-container { display: flex; justify-content: space-between; margin-bottom: 30px; gap: 10px; }';
        html += '.summary-box { flex: 1; border: 1px solid #ddd; border-radius: 4px; padding: 15px; text-align: center; background: #f9f9f9; }';
        html += '.summary-box h3 { margin: 0 0 10px; font-size: 12px; text-transform: uppercase; color: #777; }';
        html += '.summary-box .value { font-size: 18px; font-weight: bold; color: #333; }';
        html += '.text-success { color: #28a745 !important; }';
        html += '.text-danger { color: #dc3545 !important; }';

        html += '.row { display: flex; margin-bottom: 30px; gap: 20px; }';
        html += '.col { flex: 1; }';
        html += '.section-title { font-size: 14px; font-weight: bold; border-bottom: 1px solid #ccc; padding-bottom: 5px; margin-bottom: 10px; text-transform: uppercase; }';

        html += 'table { width: 100%; border-collapse: collapse; font-size: 12px; margin-bottom: 20px; }';
        html += 'th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }';
        html += 'th { background-color: #f2f2f2; font-weight: bold; }';
        html += '.text-right { text-align: right; }';
        html += '.text-center { text-align: center; }';
        html += '.text-bold { font-weight: bold; }';
        
        html += '.footer { margin-top: 50px; text-align: center; font-size: 10px; color: #999; border-top: 1px solid #eee; padding-top: 10px; }';
        html += '@media print { body { -webkit-print-color-adjust: exact; } }';
        html += '</style></head><body>';

        // Header
        html += '<div class="header">';
        html += '<h1>Cash Flow & Profit/Loss Report</h1>';
        html += '<p>Report Period: ' + start_date + ' to ' + end_date + '</p>';
        html += '</div>';

        // Summary Boxes
        html += '<div class="summary-container">';
        html += '<div class="summary-box"><h3>Sales Revenue</h3><div class="value">' + summary.total_sales + '</div></div>';
        html += '<div class="summary-box"><h3>Expenses & Cost</h3><div class="value">' + number_format(total_exp_display, 2) + '</div></div>';
        html += '<div class="summary-box"><h3>Net Profit/Loss</h3><div class="value ' + profitClass + '">' + summary.net_profit + '</div></div>';
        html += '<div class="summary-box"><h3>Net Cash Flow</h3><div class="value" style="color:#007bff;">' + summary.net_cash_flow + '</div></div>';
        html += '</div>';

        // Income & Expense Details
        html += '<div class="row">';
        
        // Income Table
        html += '<div class="col">';
        html += '<div class="section-title">Income & Inflow</div>';
        html += '<table>';
        html += '<tr><td>Total Sales</td><td class="text-right text-bold">' + summary.total_sales + '</td></tr>';
        html += '<tr><td>Investments Received</td><td class="text-right text-bold">' + summary.total_investments + '</td></tr>';
        html += '<tr><td>Purchase Returns (Refunds)</td><td class="text-right text-bold">' + summary.total_purchases_accrual + '</td></tr>'; // Mapping verified from updateDashboard
        html += '</table>';
        html += '</div>';

        // Expense Table
        html += '<div class="col">';
        html += '<div class="section-title">Expenses & Outflow</div>';
        html += '<table>';
        html += '<tr><td>Purchases (Accrual)</td><td class="text-right text-bold">' + summary.total_purchases + '</td></tr>';
        html += '<tr><td>Production Labour</td><td class="text-right text-bold">' + summary.total_labour_cost + '</td></tr>';
        html += '<tr><td>Salaries</td><td class="text-right text-bold">' + summary.total_salaries + '</td></tr>';
        html += '<tr><td>General Expenses</td><td class="text-right text-bold">' + summary.total_expenses + '</td></tr>';
        html += '<tr><td>Salesman Expenses</td><td class="text-right text-bold">' + summary.total_salesman_expenses + '</td></tr>';
        html += '<tr><td>Sale Returns</td><td class="text-right text-bold">' + summary.total_sale_returns + '</td></tr>';
        html += '<tr><td>Withdrawals</td><td class="text-right text-bold">' + summary.total_withdrawals + '</td></tr>';
        html += '</table>';
        html += '</div>';
        
        html += '</div>'; // End Row

        // Detailed Breakdowns - Stacked for print
        
        // Banks
        html += '<div class="section-title">Bank Transactions</div>';
        html += '<table><thead><tr><th>Bank Name</th><th class="text-right">Deposits</th><th class="text-right">Withdrawals</th><th class="text-right">Net Movement</th></tr></thead><tbody>';
        if(breakdowns.banks.length > 0) {
            $.each(breakdowns.banks, function(i, item){
                var net = parseFloat(item.total_in) - parseFloat(item.total_out);
                html += '<tr><td>'+item.bank_name+'</td><td class="text-right">'+number_format(item.total_in,2)+'</td><td class="text-right">'+number_format(item.total_out,2)+'</td><td class="text-right text-bold">'+number_format(net,2)+'</td></tr>';
            });
        } else {
            html += '<tr><td colspan="4" class="text-center">No transactions found.</td></tr>';
        }
        html += '</tbody></table>';

        // Expenses Breakdown
        html += '<div class="section-title" style="margin-top: 20px;">Expense Breakdown</div>';
        html += '<table><thead><tr><th>Category</th><th class="text-right">Total Amount</th></tr></thead><tbody>';
        if(breakdowns.expenses.length > 0) {
            $.each(breakdowns.expenses, function(i, item){
                html += '<tr><td>'+item.name+'</td><td class="text-right">'+number_format(item.total,2)+'</td></tr>';
            });
        } else {
            html += '<tr><td colspan="2" class="text-center">No expenses found.</td></tr>';
        }
        html += '</tbody></table>';

        // Salesman
        html += '<div class="section-title" style="margin-top: 20px;">Salesman Performance</div>';
        html += '<table><thead><tr><th>Salesman Name</th><th class="text-center">Total Sales</th><th class="text-center">Count</th><th class="text-right">Expenses</th></tr></thead><tbody>';
        if(breakdowns.salesmen.length > 0) {
            $.each(breakdowns.salesmen, function(i, item){
                html += '<tr><td>'+item.name+'</td><td class="text-center">'+number_format(item.total_sales,2)+'</td><td class="text-center">'+item.sale_count+'</td><td class="text-right">'+number_format(item.total_expenses,2)+'</td></tr>';
            });
        } else {
            html += '<tr><td colspan="4" class="text-center">No data found.</td></tr>';
        }
        html += '</tbody></table>';

        // Footer
        var now = new Date();
        html += '<div class="footer">Generated on: ' + now.toLocaleString() + '</div>';

        html += '</body></html>';

        printWindow.document.write(html);
        printWindow.document.close();
        printWindow.focus();
        
        // Wait for content to load then print
        setTimeout(function() {
            printWindow.print();
            printWindow.close();
        }, 500);
    }

    function number_format(number, decimals) {
        number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
        var n = !isFinite(+number) ? 0 : +number,
            prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
            sep = ',',
            dec = '.',
            s = '',
            toFixedFix = function (n, prec) {
                var k = Math.pow(10, prec);
                return '' + Math.round(n * k) / k;
            };
        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
        if (s[0].length > 3) {
            s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
        return s.join(dec);
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/reports/cash_flow_report.blade.php ENDPATH**/ ?>