<?php $__env->startSection('css_code'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_head'); ?>
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Expenses</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Expenses ( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                <div class="page-header counting round-corner-right">TOTAL EXPENSE <br> <b id="total_expense_amount">0</b></div>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>
    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                        
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New Expense</button>
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Exp Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Detail</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Total</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Buttons</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Exp Date</th>
                            <th width="10%">User Name</th>
                            <th width="50%">Detail</th>
                            <th width="10%">Total</th>
                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New Expense</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="add_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="hidden" id="total_amt_input" name="total_amt">
                                        <input type="text" id="exp_date" name="exp_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Expense Date:</label>
                                    </div>
                                </div>
                                
                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <input type="text" name="other_detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Detail:</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="expense_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 20%">Expense Category</th>
                                                <th style="width: 20%">Sub Category</th>

                                                <th style="width: 40%" class="text-center">Expense Detail</th>
                                                <th style="width: 10%" class="text-center">Total</th>
                                                <th style="width: 10%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <select id="categories" name="cat_id[]" class="demo_select2 form-control categories" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select id="sub_categories" name="sub_cat_id[]" class="demo_select2 form-control sub_categories" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="exp_detail[]" class="form-control exp_detail" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    <input type="text" name="total[]" id="total" class="form-control text-center total" placeholder=" ">
                                                </td>
                                                <td class="text-center">
                                                    
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Total:
                                                </td>
                                                <td class="text-center" id="total_amt" style="font-weight: bold">
                                                    
                                                </td>
                                                <td class="text-center">
                                                    <button id="add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save Expense</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Expense</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12 plr-0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <input type="hidden" id="u_exp_id" name="exp_id">
                                        
                                        <input type="text" id="u_exp_date" name="exp_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Expense Date:</label>
                                    </div>
                                </div>
                                
                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <input type="text" id="other_detail" name="other_detail" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel">Other Detail:</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table id="update_expense_table" class="table table-striped table-hover custom-table mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width: 20%">Expense Category</th>
                                                <th style="width: 20%">Sub Expense Category</th>

                                                <th style="width: 40%" class="text-center">Expense Detail</th>
                                                <th style="width: 10%" class="text-center">Total</th>
                                                <th style="width: 10%" class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-right" style="font-weight: bold">
                                                    
                                                </td>
                                                <td></td>
                                                <td class="text-right" style="font-weight: bold">
                                                    Total:
                                                </td>
                                                <td class="text-center" id="update_total_amt" style="font-weight: bold">
                                                    
                                                </td>
                                                <input type="hidden" id="u_total_amt_input" name="total_amt">
                                                <td class="text-center">
                                                    <button id="update_add_row" class="btn btn-success btn-icon" data-toggle="tooltip" title="Add New"><i class="fa-solid fa-plus"></i></button>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update Expense</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: 0px;
                top: -550px;
            }
        }
    </style>


    <!--Start View Modal-->
    <!--===================================================-->
    <div class="modal fade" id="view_modal" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content">
                <!--begin::Modal body-->
                <div class="modal-body print_invoice">
                    <!--begin::Scroll-->

                    <div style="padding: 10px; margin: 0 auto; background: #fff;">
                        <center>
                            <div class="info"> 
                                <h3 style="margin: 0px 0 10px 0; font-size: 24px"><strong>Expense Detail</strong></h3>
                                
                            </div>
                        </center><!--End InvoiceTop-->
                        <div class="row">
                            <div style="display: flex; justify-content: space-between;">
                                <h2 style="font-size: 1.0em; margin: 0;"><strong>Expense Date: <span id="view_exp_date"></span></strong></h2>
                            </div>
                            <hr style="margin: 5px 0 5px 0; border-top: 1px solid #4d627b">
                        </div>
                        <div class="row">
                            <div style="display: flex; justify-content: space-between;">
                                <h2 style="font-size: 1.0em; margin: 0;"><strong>Other Detail: <span id="view_other_detail"></span></strong></h2>
                            </div>
                            <hr style="margin: 5px 0 5px 0; border-top: 1px solid #4d627b">
                        </div>
                        <div class="row">
                            <table id="view_expense_table" class="table mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 20%">Category</th>
                                        <th style="width: 50%">Detail</th>
                                        <th style="width: 15%" class="text-center">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td class="text-center">
                                            <h1 id="total_exp" style="font-size: 20px; margin-top: 0"></h1>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                    </div><!--End Invoice-->
                        
                    </div>
                    <!--end::Scroll-->
                    <!--begin::Actions-->
                    <div class="text-center no-print" style="padding-bottom: 20px">
                        <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i></a>
                        <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
                    </div>
                    <!--end::Actions-->
                
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--===================================================-->
    <!--End View Modal-->




<?php $__env->stopSection(); ?>



<?php $__env->startSection('javascript_code'); ?>

<script>
    $(document).ready(function(){

        $('#exp_date').daterangepicker({
            // autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#exp_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_exp_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_exp_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });


        //=========== Insert Data Ajax Request ===========//
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="cat_id[]" class="demo_select2 form-control categories" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td>'+
                                '<select name="sub_cat_id[]" class="demo_select2 form-control sub_categories" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="exp_detail[]" class="form-control exp_detail" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#expense_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            get_categories(newRow.find('.categories'), '#add_modal');
            get_sub_categories(newRow.find('.sub_categories'), '#add_modal', null);

        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#update_add_row").click(function(e) {
            e.preventDefault();

            var html = '<tr>'+
                            '<td>'+
                                '<select name="cat_id[]" class="demo_select2 form-control categories" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td>'+
                                '<select name="sub_cat_id[]" class="demo_select2 form-control sub_categories" style="width: 100%"><option></option></select>'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="exp_detail[]" class="form-control exp_detail" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<input type="text" name="total[]" class="form-control text-center total" placeholder=" ">'+
                            '</td>'+
                            '<td class="text-center">'+
                                '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                            '</td>'+
                        '</tr>';

            var newRow = $(html);

            $("#update_expense_table > tbody:last").append(newRow);

            // Initialize Select2 on the new row
            get_categories(newRow.find('.categories'), '#update_modal');
            get_sub_categories(newRow.find('.sub_categories'), '#update_modal', null);

        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Remove Row Button ===========//
        // Delegate event to remove row
        $(document).on('click', '.remove_row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            calculateTotalRate();
            updatecalculateTotalRate();
        });
        //=========== End Remove Row Button ===========//

        //=========== Get Lab Tests On Load ===========//
        get_categories($('#categories'), '#add_modal');
        get_categories($('#update_categories'), '#update_modal');

        get_sub_categories($('#sub_categories'), '#add_modal', null);
        get_sub_categories($('#update_sub_categories'), '#update_modal', null);

        // Function to initialize Select2 on dynamically added elements
        function get_categories(element, modal_id) {
            element.select2({
                placeholder: 'Select Category',
                allowClear: true,
                minimumInputLength: 0,
                dropdownParent: $(modal_id),
                ajax: {
                    url: '<?php echo e(route("get_expense_categories")); ?>',
                    method: 'GET',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            query: params.term || '',
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    id: item.id,
                                    text: item.exp_cat_name
                                };
                            })
                        };
                    },
                    cache: true
                }
            });
        }

        function get_sub_categories(element, modal_id, cat_id) {
            element.select2({
                placeholder: 'Select Sub Category',
                allowClear: true,
                minimumInputLength: 0,
                dropdownParent: $(modal_id),
                ajax: {
                    url: '<?php echo e(route("get_expense_sub_categories")); ?>',
                    method: 'GET',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        // If cat_id is not provided, try to get it from the same row's category dropdown
                        var categoryId = cat_id;
                        if (!categoryId) {
                            categoryId = element.closest('tr').find('.categories').val();
                        }
                        return {
                            query: params.term || '',
                            cat_id: categoryId || null,
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    id: item.id,
                                    text: item.exp_sub_cat_name
                                };
                            })
                        };
                    },
                    cache: false
                }
            });
        }
        //=========== End Get Patients On Load ===========//

        //=========== Cascade Sub Category on Category Change ===========//
        $(document).on('change', '.categories', function() {
            var catId = $(this).val();
            var row = $(this).closest('tr');
            var subCategorySelect = row.find('.sub_categories');
            var modalId = $(this).closest('.modal').attr('id');

            // Clear the sub-category dropdown
            subCategorySelect.empty().trigger('change');

            // Destroy and reinitialize with the selected category
            if (subCategorySelect.hasClass("select2-hidden-accessible")) {
                subCategorySelect.select2('destroy');
            }

            if (catId) {
                get_sub_categories(subCategorySelect, '#' + modalId, catId);
            } else {
                get_sub_categories(subCategorySelect, '#' + modalId, null);
            }
        });
        //=========== End Cascade Sub Category ===========//

        //=========== Start Qty Change ===========//
        $(document).on('keyup change paste click', '.total', function() {

            calculateTotalRate();
            updatecalculateTotalRate();

        });
        //=========== End Qty Change ===========//


        function calculateTotalRate() {
            var total = 0;

            $('#expense_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    total += rate;
                }
            });
            $('#total_amt').text(total.toFixed(0));
            $('#total_amt_input').val(total.toFixed(0));

        }

        
        function updatecalculateTotalRate() {
            var update_total = 0;
            $('#update_expense_table .total').each(function() {
                var rate = parseFloat($(this).val());
                if (!isNaN(rate)) {
                    update_total += rate;
                }
            });

            $('#update_total_amt').text(update_total.toFixed(0));
            $('#update_total_amt_input').val(update_total.toFixed(0));
            $('#u_total_amt_input').val(update_total.toFixed(0));


        }


        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    exp_date: {
                        required: true,
                    },
                    cat_id: {
                        required: true,
                    },
                    sub_cat_id: {
                        required: true,
                    },
                },
                messages: {
                    exp_date: {
                        required: "Please enter Expense Date",
                    },
                    cat_id: {
                        required: "Please enter    ",
                    },
                    sub_cat_id: {
                        required: "Please enter    ",
                    },
                },

                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/delete.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/apply.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("insert_expense")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Expense Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save Expense');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wronge Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save Expense');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_expense/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#u_exp_id').val(data.expense.id);
                    $('#u_exp_date').val(data.expense.exp_date);
                    $('#u_other_detail').val(data.expense.exp_detail);
                    $('#u_total_amt_input').val(data.expense.total_amt);
                    $('#u_total_amt').text(data.expense.total_amt);

                    var html = '';

                    $.each(data.exp_detail, function(i, item) {
                        
                        html += '<tr>'+
                                    '<td>'+
                                        '<select name="cat_id[]" class="demo_select2 form-control categories" style="width: 100%"><option value="'+data.exp_detail[i].cat_id+'">'+data.exp_detail[i].exp_cat_name+'</option></select>'+
                                    '</td>'+
                                    '<td>'+
                                        '<select name="sub_cat_id[]" class="demo_select2 form-control sub_categories" style="width: 100%"><option value="'+data.exp_detail[i].sub_cat_id+'">'+data.exp_detail[i].exp_sub_cat_name+'</option></select>'+
                                    '</td>'+
             
                                    '<td class="text-center">'+
                                        '<input type="text" name="exp_detail[]" class="form-control exp_detail" value="'+data.exp_detail[i].exp_detail+'">'+
                                    '</td>'+
                                    '<td class="text-center">'+
                                        '<input type="text" name="total[]" class="form-control text-center total" value="'+data.exp_detail[i].total+'">'+
                                    '</td>'+
                                    '<td class="text-center">'+
                                        '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark-large"></i></button>'+
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#update_expense_table > tbody").empty();
                    $("#update_expense_table > tbody:last").append(newRow);

                    // Initialize Select2 on the new row
                    get_categories(newRow.find('.categories'), '#update_modal');

                    // Initialize sub-categories with the corresponding category IDs
                    newRow.find('.categories').each(function(index) {
                        var catSelect = $(this);
                        var catId = catSelect.val();
                        var subCatSelect = catSelect.closest('tr').find('.sub_categories');
                        get_sub_categories(subCatSelect, '#update_modal', catId);
                    });

                    updatecalculateTotalRate();
                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    exp_date: {
                        required: true,
                    },
                },
                messages: {
                    exp_date: {
                        required: "Please enter Expense Date",
                    },
                },


                //Called when the element is invalid:
                highlight: function(element) {
                    // $(element).css('background', '#ffdddd');
                    // $(element).css('border', '1px solid red');
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/delete.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                // Called when the element is valid:
                unhighlight: function(element) {
                    // $(element).css('background', '#ffffff');
                    // $(element).css('border', '1px solid green');
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/apply.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("update_expense")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Expense Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Expense');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wronge Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Expense');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
            $.ajax({
                url: '/view_expense/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data)
                {
                    console.log(data);
                    $('#view_exp_date').text(data.expense.exp_date);
                    $('#view_other_detail').text(data.expense.exp_detail);
                    $('#total_exp').text(data.expense.total_amt);

                    var html = '';

                    $.each(data.exp_detail, function(i, item) {
                        
                        html += '<tr>'+
                                    '<td>'+
                                        data.exp_detail[i].exp_cat_name +
                                    '</td>'+
                                    '<td>'+
                                        data.exp_detail[i].exp_detail +
                                    '</td>'+
                                    '<td class="text-center">'+
                                        data.exp_detail[i].total +
                                    '</td>'+
                                '</tr>';
                    });

                    var newRow = $(html);
                    $("#view_expense_table > tbody").empty();
                    $("#view_expense_table > tbody:last").append(newRow);

                }
            });
        });
        //=========== End Lounch View Modal On Click View Btn ===========//


        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_expense/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Expense Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                            title: "Somthing Wrong!",
                                            text: "Sonthing Went Wrong Please Try Again!",
                                            type: "error",
                                            customClass: "sweet-alert",
                                        });
                            }
                        }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '<?php echo e(route("load_expenses")); ?>',
                type: 'post',
                data: { _token: csrf._token, startdate: "", enddate: "", search: "", type: "" }
            },
            columns: [
                { data: "id" },
                { data: "exp_date" },
                { data: "user_name" },
                { data: "exp_detail" },
                { data: "total" },
                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 4] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 3, 4],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
            
            // Calculate and display total expense
            calculateTotalExpense();
        }

        // Function to calculate total expense
        function calculateTotalExpense() {
            $.ajax({
                url: '<?php echo e(route("get_total_expense")); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#total_expense_amount').text(data.total_expense || '0');
                },
                error: function() {
                    $('#total_expense_amount').text('0');
                }
            });
        }

    
        // Example usage: Call the function with updated dates
        loadData("", "", "", );
        
        // Calculate total expense on page load
        calculateTotalExpense();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val());
        });
        //=========== End Custom Search Box ===========//

        $("#status").select2({
            placeholder: "Filter By Status",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });


        //=========== Start Custom Status Dropdown ===========//
        $('#status').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }
            
        });
        //=========== End Custom Status Dropdown ===========//


        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            //=========== Start Date Range Picker ===========//
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: false,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
            //=========== End Date Range Picker ===========//



            //=========== Start Date Range On Apply ===========//
            //Filter the datatable on the datepicker apply event
            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);
            
                // alert(startdate+" "+enddate);

                // $('#main_table').DataTable().destroy();

                // load_users("#main_table", startdate+" 00:00:00", enddate+" 23:59:59", company_name, company_s_name);
                loadData($('#search').val(), startdate, enddate);

            
            });

            //Click on cancel Button
            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
            //do something, like clearing an input
            $(datepickerid).val('');
            });
            //=========== End Date Range On Apply ===========//

            //Click on Refresh Data
            $('#refresh_data').on('click', function() {
            //do something, like clearing an input
            $(datepickerid).val('');
            loadData();
            });
            //=========== End Date Range On Apply ===========//
        }
        //=========== End Search By Date ===========//





    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/expenses.blade.php ENDPATH**/ ?>