<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/dropify/css/dropify.min.css')); ?>">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
    .custom-dropify .dropify-wrapper {
        max-width: 200px;  
        height: 70px;  
    }

     
    .custom-dropify .dropify-wrapper .dropify-message p {
        font-size: 12px;  
    }
    
    </style>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_head'); ?>
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> Stock</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Stock  </li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Product </a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">SKU </a></li>

                                <li><a href="#" class="toggle-vis" data-column="3">Purchase qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Issue qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Production Issue qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Production Complete qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Order Return qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="8">Sale Return qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="9">Repair qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="10">Repair Used qty</a></li>

                                <li><a href="#" class="toggle-vis" data-column="11">Balance</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="5%">Id</th>
                            <th width="10%">Product Name</th>
                            <th width="10%">Purchase qty</th>
                            
                            <th width="10%">Production  qty</th>
                            <th width="10%">Repair qty</th>
                            <th width="10%">Sale Return qty</th>
                            <th width="10%">Order Return qty</th>
                            <th width="10%">Issue qty</th>
                            <th width="10%">Use In Production qty</th>
                            <th width="10%">Use In Repairing qty</th>
                            <th width="15%">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   
    
   


<?php $__env->stopSection(); ?>



<?php $__env->startSection('javascript_code'); ?>

<script src="<?php echo e(asset('backend/my_plugins/dropify/js/dropify.min.js')); ?>"></script>


<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        document.getElementById("pur_date").value = formattedDate;
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>

<script>


    $(document).ready(function(){

        $('.select2').select2();


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '<?php echo e(route("load_stock")); ?>',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "pro_name" },
                // { data: "sku" },
                { data: "total_purchase_qty" },
                { data: "total_production_complete_qty" },
                { data: "total_repair_qty" },
                { data: "total_sale_return_qty" },
                { data: "total_return_qty" },
                { data: "total_issue_order_qty" },
                { data: "total_production_issue_qty" },
                { data: "total_repair_used_qty" },

                { data: "balance" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                // { className: 'text-center td-30', targets: [3, 5] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });

        
        //=========== End Custom Search Box ===========//



    });



</script>






<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/stock.blade.php ENDPATH**/ ?>