<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <style>
        .totals-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .totals-card .total-item {
            text-align: center;
            padding: 10px;
        }
        .totals-card .total-label {
            font-size: 12px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        .totals-card .total-value {
            font-size: 20px;
            font-weight: bold;
        }
        .filter-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        @media print {
            .no-print {
                display: none !important;
            }
            .signature-box {
                border: 1px solid #000;
                height: 50px;
                margin-top: 5px;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_head'); ?>
    <div class="row">
        <div class="col-md-12 table-toolbar-left" style="padding-bottom: 5px;">
            <div id="page-title">
                <h1 class="page-header text-overflow">Salaries Report</h1>
            </div>
            <ol class="breadcrumb">
                <li>Reports</li>
                <li class="active">Salaries Report</li>
            </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>
    <div class="panel">
        <div class="panel-body">
            <!-- Filter Card -->
            <div class="filter-card no-print">
                <div class="row">
                    <?php if(!Auth::user()->hasRole('Employee')): ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Employee</label>
                            <select id="employee_filter" class="form-control">
                                <option value="all">All Employees</option>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->emp_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Month</label>
                            <input type="month" id="start_month" class="form-control" placeholder="From Month">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Month</label>
                            <input type="month" id="end_month" class="form-control" placeholder="To Month">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button id="filter_btn" class="btn btn-primary btn-block">
                                    <i class="fa fa-filter"></i> Apply Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Totals Card -->
            <div class="totals-card no-print" id="totals_card" style="display: none;">
                <div class="row">
                    <div class="col-md-6 total-item">
                        <div class="total-label">Total Advance</div>
                        <div class="total-value" id="total_advance">Rs. 0</div>
                    </div>
                    <div class="col-md-6 total-item">
                        <div class="total-label">Total Salary</div>
                        <div class="total-value" id="total_salary">Rs. 0</div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row no-print" style="margin-bottom: 15px;">
                <div class="col-md-12 text-right">
                    <button id="print_btn" class="btn btn-info" title="Print">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button id="excel_btn" class="btn btn-success" title="Export to Excel">
                        <i class="fa fa-file-excel-o"></i> Excel
                    </button>
                    <button id="pdf_btn" class="btn btn-danger" title="Export to PDF">
                        <i class="fa fa-file-pdf-o"></i> PDF
                    </button>
                </div>
            </div>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered" id="salaries_report_table">
                    <thead>
                        <tr style="background-color: #f5f5f5;">
                            <th width="5%">S.No</th>
                            <th width="15%">Employee Name</th>
                            <th width="8%">Employee ID</th>
                            <th width="10%">Salary Month</th>
                            <th width="15%">Description</th>
                            <th width="8%">Advance</th>
                            <th width="8%">Attendance</th>
                            <th width="10%">Total Salary</th>
                            <th width="8%">Received</th>
                            <th width="13%" class="signature-col">Signature</th>
                        </tr>
                    </thead>
                    <tbody id="report_tbody">
                        <tr>
                            <td colspan="10" class="text-center">
                                <p style="padding: 50px 0;"><i class="fa fa-spinner fa-spin"></i> Loading report...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript_code'); ?>
<script src="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.js')); ?>"></script>

<script>
    $(document).ready(function() {
        // Filter button click
        $('#filter_btn').on('click', function() {
            loadReport();
        });

        // Load report on page load
        loadReport();

        // Function to load report
        function loadReport() {
            var startMonth = $('#start_month').val();
            var endMonth = $('#end_month').val();
            var employeeId = $('#employee_filter').val();

            $.ajax({
                url: '<?php echo e(route("salaries_report_data")); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    start_date: startMonth,
                    end_date: endMonth,
                    employee_id: employeeId
                },
                beforeSend: function() {
                    $('#report_tbody').html('<tr><td colspan="10" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                },
                success: function(response) {
                    if (response.status === 200) {
                        var data = response.data;
                        var totals = response.totals;
                        var html = '';

                        if (data.length === 0) {
                            html = '<tr><td colspan="10" class="text-center">No records found</td></tr>';
                        } else {
                            $.each(data, function(index, item) {
                                html += '<tr>';
                                html += '<td>' + item.sno + '</td>';
                                html += '<td>' + item.emp_name + '</td>';
                                html += '<td>' + item.employee_id + '</td>';
                                html += '<td>' + item.month + '</td>';
                                html += '<td>' + item.description + '</td>';
                                html += '<td>Rs. ' + item.advance + '</td>';
                                html += '<td>' + item.attendance + '</td>';
                                html += '<td>Rs. ' + item.total_salary + '</td>';
                                html += '<td>Rs. ' + item.received + '</td>';
                                html += '<td class="signature-col"><div class="signature-box"></div></td>';
                                html += '</tr>';
                            });
                        }

                        $('#report_tbody').html(html);

                        // Update totals
                        $('#total_advance').text('Rs. ' + totals.total_advance);
                        $('#total_salary').text('Rs. ' + totals.total_salary);
                        $('#totals_card').fadeIn();
                    }
                },
                error: function() {
                    swal('Error', 'Failed to load report', 'error');
                }
            });
        }

        // Print functionality
        $('#print_btn').on('click', function() {
            window.print();
        });

        // Excel export
        $('#excel_btn').on('click', function() {
            var table = document.getElementById('salaries_report_table');
            var html = table.outerHTML;
            var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
            var downloadLink = document.createElement("a");
            downloadLink.href = url;
            downloadLink.download = 'salaries_report_' + new Date().getTime() + '.xls';
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });

        // PDF export placeholder
        $('#pdf_btn').on('click', function() {
            swal('Info', 'PDF export feature will be implemented with a PDF library', 'info');
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/reports/salaries_report.blade.php ENDPATH**/ ?>