
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="icon" type="image/x-icon" href="<?php echo e($settings->favicon ? asset('uploads/'.$settings->favicon) : asset('uploads/no_image.jpg')); ?>" />

    <title><?php echo e($settings->school_name); ?></title>


    <!--STYLESHEET-->
    <!--=================================================-->

    <!--Open Sans Font [ OPTIONAL ]-->
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700' rel='stylesheet' type='text/css'>

    <!--Bootstrap Stylesheet [ REQUIRED ]-->
    <link href="<?php echo e(asset('backend/css/bootstrap.min.css')); ?>" rel="stylesheet">


    <!--Nifty Stylesheet [ REQUIRED ]-->
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet">

    <!--Nifty Premium Icon [ DEMONSTRATION ]-->
    <link href="<?php echo e(asset('backend/css/demo/nifty-demo-icons.min.css')); ?>" rel="stylesheet">


    <!--Font Awesome-->
    <link href="<?php echo e(asset('backend/my_plugins/FontAwesome.Pro.6.5.2/css/all.css')); ?>" rel="stylesheet">
    <!--Toastr-->
    <link href="<?php echo e(asset('backend/my_plugins/toastr/toastr.css')); ?>" rel="stylesheet">
    <!--Sweet Alert-->
    <link href="<?php echo e(asset('backend/my_plugins/sweet_alert_11.11/sweetalert2.min.css')); ?>" rel="stylesheet">

    <!--Date Range Picker-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('backend/my_plugins/daterangepicker/daterangepicker.css')); ?>" />

    <!--Bootstrap Select [ OPTIONAL ]-->
    <link href="<?php echo e(asset('backend/plugins/bootstrap-select/bootstrap-select.min.css')); ?>" rel="stylesheet">

    <!--Select2 [ OPTIONAL ]-->
    <link href="<?php echo e(asset('backend/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">

    <!--Data Table-->
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/datatable/datatable_fixed_header/fixed_header.css')); ?>">


    <!--=================================================-->

    <?php echo $__env->yieldContent('css_code', " "); ?>

    <style>
        table.fixedHeader-floating {
            margin-top: 0px !important;
        }
    </style>
</head>

<!--TIPS-->
<!--You may remove all ID or Class names which contain "demo-", they are only used for demonstration. -->
<body>
    <div id="container" class="effect aside-float aside-bright mainnav-lg">
        
        <?php echo $__env->make('admin.layout.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="boxed">

            <!--CONTENT CONTAINER-->
            <!--===================================================-->
            <div id="content-container">
                <div id="page-head">

                    <?php echo $__env->yieldContent('page_head'); ?>

                </div>

                
                <!--Page content-->
                <!--===================================================-->
                <div id="page-content">

                    <?php echo $__env->yieldContent('page_content'); ?>             
                                   
                </div>
                <!--===================================================-->
                <!--End page content-->

            </div>
            <!--===================================================-->
            <!--END CONTENT CONTAINER-->


            
            <!--ASIDE-->
            <!--===================================================-->
            <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--===================================================-->
            <!--END ASIDE-->

            
            <!--MAIN NAVIGATION-->
            <!--===================================================-->
            <?php echo $__env->make('admin.layout.side_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--===================================================-->
            <!--END MAIN NAVIGATION-->


        </div>

        

        <!-- FOOTER -->
        <!--===================================================-->
        <footer id="footer">

            <!-- Visible when footer positions are fixed -->
            <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
            <div class="show-fixed pad-rgt pull-right">
                You have <a href="#" class="text-main"><span class="badge badge-danger">3</span> pending action.</a>
            </div>



            <!-- Visible when footer positions are static -->
            <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
            <div class="hide-fixed pull-right pad-rgt">
                <strong>Phone</strong> 0322-0622406.
            </div>



            <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
            <!-- Remove the class "show-fixed" and "hide-fixed" to make the content always appears. -->
            <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

            <p class="pad-lft">&#0169; 2025 <a href="https://hammadblog.com/">Hammad </a></p>



        </footer>
        <!--===================================================-->
        <!-- END FOOTER -->


        <!-- SCROLL PAGE BUTTON -->
        <!--===================================================-->
        <button class="scroll-top btn">
            <i class="pci-chevron chevron-up"></i>
        </button>
        <!--===================================================-->
    </div>
    <!--===================================================-->
    <!-- END OF CONTAINER -->

    
    
    
    
    <!--JAVASCRIPT-->
    <!--=================================================-->

    <!--jQuery [ REQUIRED ]-->
    <script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>


    <!--BootstrapJS [ RECOMMENDED ]-->
    <script src="<?php echo e(asset('backend/js/bootstrap.min.js')); ?>"></script>


    <!--NiftyJS [ RECOMMENDED ]-->
    <script src="<?php echo e(asset('backend/js/nifty.min.js')); ?>"></script>

    <!--Custom Sidebar Fix-->
    <script src="<?php echo e(asset('backend/js/custom-sidebar.js')); ?>"></script>

    <!--Font Awesome-->
    <script src="<?php echo e(asset('backend/my_plugins/FontAwesome.Pro.6.5.2/js/all.js')); ?>"></script>
    <!--Toastr-->
    <script src="<?php echo e(asset('backend/my_plugins/toastr/toastr.js')); ?>"></script>
    <!--Sweet Alert-->
    <script src="<?php echo e(asset('backend/my_plugins/sweet_alert_11.11/sweetalert2.min.js')); ?>"></script>
    <!--Form Validation-->
    <script src="<?php echo e(asset('backend/my_plugins/validate/jquery.validate.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/validate/additional_method.js')); ?>"></script>
    
    <script src="<?php echo e(asset('backend/my_plugins/daterangepicker/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/daterangepicker/daterangepicker.js')); ?>"></script>

    <!--Bootstrap Select [ OPTIONAL ]-->
    <script src="<?php echo e(asset('backend/plugins/bootstrap-select/bootstrap-select.min.js')); ?>"></script>

    <!--Select2 [ OPTIONAL ]-->
    <script src="<?php echo e(asset('backend/plugins/select2\js/select2.min.js')); ?>"></script>

    <!--Sparkline [ OPTIONAL ]-->
    <script src="<?php echo e(asset('backend/plugins/sparkline/jquery.sparkline.min.js')); ?>"></script>


    <!--Data Table-->
    <script src="<?php echo e(asset('backend/my_plugins/datatable/datatablescripts.bundle.js')); ?>"></script>

    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/buttons.flash.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/my_plugins/datatable/buttons/vfs_fonts.js')); ?>"></script>

    <script src="<?php echo e(asset('backend/my_plugins/datatable/datatable_fixed_header/fixed_header.min.js')); ?>"></script>


    <script>

        
        function number_format(number, locale = 'en-US', options = {}) {
            // Merge provided options with default options
            const defaultOptions = {
                style: 'decimal', // Default style is decimal
                minimumFractionDigits: 0,
                maximumFractionDigits: 2,
            };

            // Format the number using toLocaleString() method
            return number.toLocaleString(locale, defaultOptions);
        }

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });


        let csrf = {
            '_token': $('meta[name="csrf-token"]').attr('content'),
            // other data
        };


        function load_data(options = {}) {

            // Default options for DataTables
            var defaults = {
                tablename: "#main_table",
                order: [0, 'DESC'],
                ajax: [],
                columns: [],
                columnDefs: [],
                centeredColumnsOnPrintPdf: [],
                footerCallback: null,
                title: "",
                filename: "file",
            };

            // Merge default options with user-provided options
            var settings = $.extend({}, defaults, options);

            // Define DataTable options
            var datatableOptions ={
            bDestroy: true,
            stateSave: !0,
            // lengthChange: !1,
            order: settings.order,
            pageLength: 25,
            lengthMenu: [ [10, 25, 50, 100, -1], [10, 25, 50, 100, "All"] ],
            dom: "<'row d-none'<'col-sm-12 col-md-3'><'col-sm-12 col-md-4 text-right'><'col-sm-12 col-md-5 text-right exportbtn'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-2'l><'col-sm-12 col-md-4'i><'col-sm-12 col-md-2 goto-container text-right'><'col-sm-12 col-md-4 text-right'p>>",
            pagingType: 'full_numbers',
            language: {
                paginate: {
                    first: "<i class='fa-solid fa-angles-left'></i>", // First button icon
                    previous: "<i class='fa-solid fa-angle-left'></i>", // Previous button icon
                    next: "<i class='fa-solid fa-angle-right'></i>", // Next button icon
                    last: "<i class='fa-solid fa-angles-right'></i>" // Last button icon
                },
                loadingRecords: "<span class='fa-stack fa-lg'>\n\
                                <i class='fa fa-spinner fa-spin fa-fw fs-2'></i>\n\
                            </span>&emsp;Please Wait ...",
                zeroRecords: "Cannot find any record related to your search.",
                emptyTable: "No data available in table."
            },
            "processing": true,
            "serverSide": true,
            ajax: settings.ajax,
            columns: settings.columns,
            columnDefs: settings.columnDefs,
            fnInitComplete: function(oSettings, json) {
                $('[data-toggle="tooltip"]').tooltip();
            },
            drawCallback: function() {
                // $(".dataTables_paginate > .pagination").addClass("pagination-rounded");


                // Add custom Go To Page input field
                $('.goto-container').html(`
                    <div style="display: flex;">
                        <input id="gotoPage" class="form-control form-control-sm" type="number" placeholder="Page" min="1" style="width: 80px;" />
                        <button id="goPageBtn" class="btn btn-info btn-icon btn-sm" style="margin-left: 5px;">Go</button>
                    </div>
                `);

                // Add functionality for the Go To Page button
                $('#goPageBtn').on('click', function() {
                    const table = $('#datatable').DataTable();
                    const pageNumber = parseInt($('#gotoPage').val(), 10) - 1; // Convert to zero-based index
                    if (!isNaN(pageNumber) && pageNumber >= 0 && pageNumber < table.page.info().pages) {
                        table.page(pageNumber).draw('page');
                    } else {
                        alert('Invalid page number');
                    }
                });
                
            },
            stateLoadParams: function (settings, data) {
                // On state load, check column visibility and update classes
                data.columns.forEach(function (col, index) {
                    var $button = $(`.toggle-vis[data-column="${index}"]`);
                    if (col.visible) {
                        $button.removeClass('colvischecked'); // Column is visible
                    } else {
                        $button.addClass('colvischecked'); // Column is hidden
                    }
                });
            },
            buttons: [
                    {
                        extend: 'excelHtml5',
                        className: 'btn-default', 
                        filename: settings.filename,
                        title: settings.title,
                        messageTop: "",
                        exportOptions: {
                            columns: ':visible:not(:last-child)',
                        },
                    },
                    {
                        extend: 'pdfHtml5', 
                        className: 'btn-default', 
                        filename: settings.filename, 
                        title: settings.title,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        footer: true,
                        exportOptions: {
                            columns: ':visible:not(:last-child)',
                        },
                        customize: function (doc) {
                                // Adjust the page margins
                                doc.pageMargins = [20, 20, 20, 20]; // left, top, right, bottom

                                // Add the image to the top
                                // doc.content.splice(0, 0, {
                                //     margin: [0, 0, 0, 12],
                                //     alignment: 'center',
                                //     image: pdf_image,
                                //     width: 830, // Set width of the image
                                //     // height: 50  // Set height of the image
                                // });

                                // Adjust the table layout to use 100% width
                                var tableNode = doc.content.find(function (node) {
                                    return node.table !== undefined;
                                });

                                if (tableNode) {
                                    // Set table widths to 100%
                                    tableNode.table.widths = Array(tableNode.table.body[0].length + 1).join('*').split('');

                                    // Customize table layout
                                    tableNode.layout = {
                                        hLineWidth: function (i) {
                                            return i === 0 || i === tableNode.table.body.length ? 0.5 : 0.25;
                                        },
                                        vLineWidth: function (i) {
                                            return 0;
                                        },
                                        hLineColor: function (i) {
                                            return i === 0 || i === tableNode.table.body.length ? '#000000' : '#aaaaaa';
                                        },
                                        paddingLeft: function (i) {
                                            return i === 0 ? 0 : 8;
                                        },
                                        paddingRight: function (i, node) {
                                            return i === node.table.widths.length - 1 ? 0 : 8;
                                        },
                                        paddingTop: function (i) {
                                            return 8;
                                        },
                                        paddingBottom: function (i) {
                                            return 8;
                                        }
                                    };

                                    // Center align specific columns
                                    var body = tableNode.table.body;
                                    var columnIndicesToCenter = settings.centeredColumnsOnPrintPdf; // Example column indices to center

                                    for (var i = 0; i < body.length; i++) {
                                        columnIndicesToCenter.forEach(function (index) {
                                            if (body[i][index]) {
                                                body[i][index].alignment = 'center';
                                            }
                                        });
                                    }
                                }

                                // Center align the message
                                if (doc.styles.message) {
                                    doc.styles.message.alignment = "center";
                                }

                                // Left align the table header
                                if (doc.styles.tableHeader) {
                                    doc.styles.tableHeader.alignment = "left";
                                }
                            }
                    },
                    {
                        extend: 'print', 
                        className: 'btn-default', 
                        title: settings.title,
                        messageTop: "",
                        autoPrint: false,
                        footer: true,
                        exportOptions: {
                            columns: ':visible:not(:last-child)',
                        },
                        customize: function ( win ) {
                                    $(win.document.body).find('h1').css('text-align', 'center');
                                    $(win.document.body).find('h4').css('text-align', 'center');
                                    $(win.document.body).css( 'font-size', '14-px' );
                                    $(win.document.body).css( 'background-color', 'transparent' );
                                    $(win.document.body).find( 'table' )
                                        .addClass( 'compact' )
                                        .css( 'font-size', 'inherit' );
                                    $(win.document.body).find( 'td' )
                                    .css( 'border-bottom', '1px solid #ddd' );

                                    // Center specific columns
                                    $(win.document.body).find('table').find('tr').each(function () {
                                        var columnIndicesToCenter = settings.centeredColumnsOnPrintPdf;
                                        columnIndicesToCenter.forEach(function (index) {
                                            $(this).find('td:eq(' + index + '), th:eq(' + index + ')').css('text-align', 'center');
                                        }, this);
                                    });
                            }
                    },
                    {
                        extend: 'colvis',
                        className: 'btn-default',
                        text: 'Show/Hide',
                        exportOptions: {
                            columns: ':visible',
                        }
                    },
                ],
                footerCallback: settings.footerCallback,
                
                };

                // Initialize DataTable with options
                $(settings.tablename).DataTable(datatableOptions);
            }


            //=========== Start Search By Date ===========//
            function search_by_date(datepickerid){
                //=========== Start Date Range Picker ===========//
                var start = moment().subtract(29, 'days');
                var end = moment();

                function cb(start, end) {
                    $(datepickerid+' span').html(start.format('DD-MM-YYYY') + ' - ' + end.format('DD-MM-YYYY'));
                }

                $(datepickerid).daterangepicker({
                    autoUpdateInput: false,
                    format: 'DD-MM-YYYY',
                    startDate: start,
                    endDate: end,
                    showCustomRangeLabel: false,
                    alwaysShowCalendars: true,
                    ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    }
                }, cb);

                cb(start, end);
                //=========== End Date Range Picker ===========//

                //=========== Start Date Range On Apply ===========//
                //Filter the datatable on the datepicker apply event
                $(datepickerid).on('apply.daterangepicker', function(ev, picker)
                {
                    startdate=picker.startDate.format('DD-MM-YYYY');
                    enddate=picker.endDate.format('DD-MM-YYYY');
                    $(datepickerid).val(startdate + ' To ' + enddate);
                
                    loadData($('#search').val(), startdate, enddate);

                
                });

                //Click on cancel Button
                $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
                    //do something, like clearing an input
                    $(datepickerid).val('');
                });
                //=========== End Date Range On Apply ===========//

                //Click on Refresh Data
                $('#refresh_data').on('click', function() {
                    //do something, like clearing an input
                    $(datepickerid).val('');
                    loadData($('#search').val() );
                });
                //=========== End Date Range On Apply ===========//
            }
            //=========== End Search By Date ===========//




            $(document).ready(function() {

                //=========== Start Custom PDF Export Btn ===========//
                $("#datatable_pdf").on("click", function() {
                    $(".buttons-pdf").trigger("click");
                });
                //=========== End Custom PDF Export Btn ===========//

                //=========== Start Custom Excel Export Btn ===========//
                $("#datatable_excel").on("click", function() {
                    $(".buttons-excel").trigger("click");
                });
                //=========== End Custom Excel Export Btn ===========//

                //=========== Start Custom CSV Export Btn ===========//
                $("#datatable_csv").on("click", function() {
                    $(".buttons-csv").trigger("click");
                });
                //=========== End Custom CSV Export Btn ===========//

                //=========== Start Custom Print Export Btn ===========//
                $("#datatable_print").on("click", function() {
                    $(".buttons-print").trigger("click");
                });
                //=========== End Custom Print Export Btn ===========//

                // Start Colvis Show Active on Click ===========//
                $(".toggle-vis").click(function(){
                    $(this).toggleClass("colvischecked");
                });
                // End Colvis Show Active on Click ===========//


                $('a.toggle-vis').on('click', function (e) {
                    e.preventDefault();

                    var column = $('#main_table').DataTable().column($(this).attr('data-column'));

                    // Toggle the visibility
                    column.visible(!column.visible());

                    // Toggle the colvischecked class
                    $(this).toggleClass('colvischecked', !column.visible());
                });
                //=========== End Custom Colvis ===========//

                $('[data-toggle="tooltip"]').tooltip();
            
                $('.textboxlabel').click(function() {
                    $(this).prev('.textbox').focus();
                });

                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": false,
                    "progressBar": true,
                    "positionClass": "toast-top-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                }


                
            });


    </script>



    <?php echo $__env->yieldPushContent('script'); ?>

    


</body>
</html>
<?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/layout/layout.blade.php ENDPATH**/ ?>