<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/dropify/css/dropify.min.css')); ?>">

    <style>
        /* Dropify text size control */
        .dropify-wrapper .dropify-message p {
            font-size: 12px !important;  /* text chhota karne ke liye */
            color: #555 !important;      /* text color change karne ke liye */
            line-height: 16px;           /* line height adjust */
        }

        /* Heading jo "Drag and drop a file" hota hai */
        .dropify-wrapper .dropify-message span.file-icon {
            font-size: 20px !important;  /* icon ka size */
            color: #333 !important;
        }

    </style>

<?php $__env->stopSection(); ?>

   


<?php $__env->startSection('page_head'); ?>
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Production</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Production ( Add - Update - Delete )</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div  class="col-md-6">
            

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>

    <div class="panel">
        <!-- <div class="panel-heading">
            <h3 class="panel-title">Sample Toolbar</h3>
        </div> -->

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        <?php if(Auth::user()->can('create_production')): ?>
                        <button data-target="#add_modal" data-toggle="modal" class="btn btn-purple"><i class="demo-pli-add"></i> Add New production</button>
                        <?php endif; ?>
                        
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1"> Product Name</a></li>
                                
                                <li><a href="#" class="toggle-vis" data-column="2">SKU</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Required Qty</a></li>


                                <li><a href="#" class="toggle-vis" data-column="4">Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Buttons</a></li>
                            </ul>
                        </div>
                        

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="10px">Id</th>
                            <th width="100px">Product Name</th>
                            <th width="100px">SKU</th>
                            <th width="100px">Required Qty</th>
                            <th width="50px">Status</th>
                            <th width="100px">Date</th> 

                            <th width="100px" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add New production</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_form" type="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">

                                    <div class="col-md-12" style="padding: 0px">

                                        <input type="hidden"  name="start_date" value="<?php echo e(date('d-m-Y')); ?>">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <select id="contractor" name="contractor_id" class="select2 form-control" style="width: 100%">
                                                    <option></option>
                                                </select>
                                            </div>
                                        </div> 

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <select id="bom" name="bom_id" class="select2 form-control" style="width: 100%">
                                                    <option></option>
                                                </select>
                                            </div>
                                        </div> 

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="number" id="bom_price" name="bom_price" class="form-control textbox bom_price" placeholder="Bom Price" readonly> 
                                            </div>
                                        </div> 

                                        
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <div style="display: flex">
                                                <input type="number" name="batch_no" id="batch_no" class="form-control textbox" placeholder="">
                                                <label class="control-label textboxlabel">Batch No</label>
                                                <button id="add_batch" data-toggle="tooltip" title="Batch" style="margin-left: 5px;" class="btn btn-success btn-icon"><i class="fa-duotone fa-circle-plus"></i></button>
                                                </div>
                                            </div>
                                        </div> 

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="number" id="add_pro_qty" name="pro_qty" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Required Qty</label>
                                            </div>
                                        </div> 

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" id="single_product_price" name="single_product_price" class="form-control textbox" placeholder=" "readonly>
                                                <label class="control-label textboxlabel">Single Product Price</label>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" id="total_price" name="total_amount" class="form-control textbox" placeholder=" " readonly>
                                                <label class="control-label textboxlabel">Total Price</label>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <select id="bom_product" name="bom_product_id" class="select2 form-control" style="width: 100%">
                                                    <option></option>
                                                </select>
                                                <label class="control-label textboxlabel">Select Product (BOM)</label>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="number" id="product_balance" name="product_balance" class="form-control textbox" placeholder=" " readonly>
                                                <label class="control-label textboxlabel">Qty</label>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <select id="product" name="pro_id" class="select2 form-control" style="width: 100%">
                                                    <option></option>
                                                </select>
                                                <label class="control-label textboxlabel">Select Product</label>
                                            </div>
                                        </div> 
                                        
                                       
                                      
                                      
                                    </div>
 

                                    
                                       
                                    

                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" type="button" id="add_btn">Save </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Data</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">

                                    <div class="col-md-12">

                                        <div class="col-md-12" style="padding: 0px">

                                             
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Contractor</label>
                                                    <input type="hidden" id="production_id" name="production_id" class="form-control textbox" placeholder=" ">
                                                    <select id="u_contractor" name="contractor_id" class="select2 form-control" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </div>
                                            </div> 

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">BOM</label>
                                                    <select id="u_bom" name="bom_id" class="select2 form-control" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </div>
                                            </div> 


                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Product</label>
                                                    <select id="u_product" name="pro_id" class="select2 form-control" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </div>
                                            </div> 

                                             <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="payment_type">Payment Type</label>
                                                    <select id="payment_type" name="payment_type" class="form-control selectpicker">
                                                        <option value="Cash" selected>Cash</option>
                                                        <option value="Bank">Bank</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-6" id="bank_area">
                                                <div class="form-group">
                                                    <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                                        <option></option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">

                                                    <input type="number" id="u_batch_no" name="batch_no" class="form-control textbox" placeholder="Batch No" readonly>
                                                    <label class="control-label textboxlabel">Batch No </label>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    
                                                    <input type="text" id="u_pro_qty" name="pro_qty" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Required Qty  </label>
                                                </div>
                                            </div>

                                            
                                            <div class="col-sm-6">
                                                <div class="form-group">

                                                    <input type="number" id="u_bom_price" name="bom_price" class="form-control textbox" placeholder="BOM Price" readonly>
                                                    <label class="control-label textboxlabel">BOM Price </label>
                                                </div>
                                            </div>


                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="total_cost" name="total_cost" class="form-control textbox" placeholder=" " >
                                                    <label class="control-label textboxlabel">Cost Of Labour</label>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="u_single_product_price" name="single_product_price" class="form-control textbox" placeholder=" "readonly>
                                                    <label class="control-label textboxlabel">Single Product Price</label>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="text" id="u_total_price" name="total_amount" class="form-control textbox" placeholder=" " readonly>
                                                    <label class="control-label textboxlabel">Total Price</label>
                                                </div>
                                            </div>

                                              <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input type="number" id="sale_price" name="sale_price" class="form-control textbox" placeholder=" ">
                                                    <label class="control-label textboxlabel">Sale Price</label>
                                                </div>
                                            </div>

                                           
                                            <div id="status_wrap">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <select id="status" name="status" class="form-control selectpicker">
                                                            <option value="pending">Pending</option>
                                                            <?php if(Auth::user()->can('issue')): ?>
                                                            <option value="issue">Item Issue</option>
                                                            <?php endif; ?>
                                                            <?php if(Auth::user()->can('complete')): ?>
                                                            <option value="completed">Completed</option>
                                                            <?php endif; ?>
                                                            <?php if(Auth::user()->can('production')): ?>
                                                            <option value="production">Production</option>
                                                            <?php endif; ?>
                                                            <option value="cancelled">Cancel</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                         
                                        

                                        </div>
 
                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->


    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }

            .print_invoice, .print_invoice * {
                visibility: visible !important;
            }

            .print_invoice {
                position: absolute !important;
                left: -83px;
                top: -500px;
                width: 800px;
            }
        }
        .center{
            text-align: center;
        }
        .mb{
            margin-bottom: 10px;
        }
        #std_table>tbody>tr>td{
            height: 35px;
            text-align: center;
        }
        #std_table>thead>tr>th{
            height: 35px;
            text-align: center;
        }
    </style>

    <!--Start View Modal-->
    <!--===================================================-->
    <div  class="modal fade" id="view_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true" style="padding-top: 10px;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Form</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body p-0" >
                    <div class="panel print_invoice">
					    <div class="panel-body p-0">
                            <div class="invoice-brand" style="white-space:nowrap">
                                <div class="invoice-logo">
                                    <img src="<?php echo e(asset('uploads/letterhead.jpg')); ?>" width="100%">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h2 class="center">JOINING FORM</h2>
                                            <h5 class="center">Joining in which department is sought________</h5>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="invoice-bill row" style="padding: 0 20px; margin: 5px 0">
                                <h6>For Office Use Only</h6>
                                <div class="row">
                                    <div class="col-md-10">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Registration No______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Date Of Joning ______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="" class="form-control textbox" placeholder=" ">
                                                <label class="control-label textboxlabel">Joning in Department ______</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="">Teacher's Name</label>
                                            <input class="form-control mb" type="text">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="gender" class="form-label">Gender</label>
                                            <select id="gender" name="gender" class="form-control">
                                                <option value="male" selected>Male</option>
                                                <option value="female">Female</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="center" style="border: 1px solid #7a878e;">
                                            <img src="uploads/test.jpg" alt="" height="100px" width="100px">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Date Of Birth:</label>
                                        <input class="form-control mb" type="date" id="day" name="day" size="2">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Cast:</label>
                                        <input class="form-control mb" type="text" id="" name="">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="date">Nationality:</label>
                                        <input class="form-control mb" type="text"  id="" name="">
                                    </div> 
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's Name:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's Profession:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Father's / Guardian's CNIC NO:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Qualification</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Work Shift</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Mobile NO.</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Home (Tel.)</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Present Address:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="">Previous School (If Any):</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                    <h5 style="margin-left: 10px;">I have read the scool prospectus and agree to abide by the School rules.</h5>
                                    <h5 style="margin-left: 10px;">Attached Documents:</h5>
                                    <ul>
                                        <li>Degree's</li>
                                        <li>Birth Certificate / B Form</li>
                                        <li>Copy Of Father's / Guardian's CNIC</li>
                                        <li>2 Photographs (Passport Size)</li>
                                    </ul>
                                    <div class="col-md-12">
                                        <label for="">Reference:</label>
                                        <input class="form-control mb" type="text" size="60">
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>

                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <div class="text-center no-print">
                        <a href="javascript:window.print()" class="btn btn-default"><i class="demo-pli-printer icon-lg"></i> Print</a>
                        <button class="btn btn-primary" data-dismiss="modal" id="close_bill_modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End View Modal-->


    
<?php $__env->stopSection(); ?>



<?php $__env->startSection('javascript_code'); ?>

    <script src="<?php echo e(asset('backend/my_plugins/dropify/js/dropify.min.js')); ?>"></script>

    <script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });
    }); 
    </script>

    <script>
        $(document).ready(function() {
            $('#add_batch').on('click', function(e) {
                e.preventDefault(); // stop form submission if inside form
                var randomNumber = Math.floor(10000000 + Math.random() * 90000000); // 8 digit random
                $('#batch_no').val(randomNumber);
            });

        
            function calculate() {
                let qty = parseFloat($("#add_pro_qty").val()) || 0;
                let bomPrice = parseFloat($("#bom_price").val()) || 0;  // per unit BOM price
                let labourCost = parseFloat($("#total_cost").val()) || 0;

                if (qty > 0) {
                    // Total cost = (per unit BOM × qty) + labour
                    let totalCost = (bomPrice * qty) + labourCost;

                    // Single product price
                    let singlePrice = totalCost / qty;
                    $("#single_product_price").val(singlePrice.toFixed(2));

                    // Total price
                    $("#total_price").val(totalCost.toFixed(2));
                } else {
                    $("#single_product_price").val("");
                    $("#total_price").val("");
                }
            }

            // Trigger on input change
            $("#add_pro_qty, #bom_price, #total_cost").on("input", function () {
                calculate();
            });

            function update_calculate() {
                let qty = parseFloat($("#u_pro_qty").val()) || 0;
                let bomPrice = parseFloat($("#u_bom_price").val()) || 0;  // per unit BOM price
                let labourCost = parseFloat($("#total_cost").val()) || 0; // full labour cost add per unit

                if (qty > 0) {
                    // 👇 Labour cost add directly in single product price
                    let singlePrice = bomPrice + labourCost;

                    // 👇 Total price = single price × qty
                    let totalCost = singlePrice * qty;

                    $("#u_single_product_price").val(singlePrice.toFixed(2));
                    $("#u_total_price").val(totalCost.toFixed(2));
                } else {
                    $("#u_single_product_price").val("");
                    $("#u_total_price").val("");
                }
            }


            // Trigger on input change
            $("#u_pro_qty, #u_bom_price, #total_cost").on("input", function () {
                update_calculate();
            });




        });

    </script>

<script>
    $(document).ready(function(){

        $('.dropify').dropify();
        $('.select2').select2();

        

        //=========== Start Date Picker ===========//
        $('#dob').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#dob').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== Start Date Picker ===========//
        $('#joining_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            // startDate: start,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#joining_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });
        //=========== Start Date Picker ===========//

        //=========== add row  Ajax Request ===========//
       
        $("#add_row").click(function(e) {
            e.preventDefault();

            var html = 
                '<div class="row appended-row">' +
                    '<div class="col-sm-3 " >' +
                        '<div class="form-group">' +
                            '<select name="day[]" class="form-control selectpicker">' +
                                '<option value="Monday">Monday</option>' +
                                '<option value="Tuesday">Tuesday</option>' +
                                '<option value="Wednesday">Wednesday</option>' +
                                '<option value="Thursday">Thursday</option>' +
                                '<option value="Friday">Friday</option>' +
                                '<option value="Saturday">Saturday</option>' +
                                '<option value="Sunday">Sunday</option>' +
                            '</select>' +
                        '</div>' +
                    '</div>' +

                    '<div class="city-area-group">' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="city_id[]" class="select2 form-control cities" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                        '<div class="col-sm-4">' +
                            '<div class="form-group">' +
                                '<select name="area_id[]" class="select2 form-control areas" style="width: 100%">' +
                                    '<option></option>' +
                                '</select>' +
                            '</div>' +
                        '</div>' +

                    '</div>' +


                    '<div class="col-sm-1">' +
                        '<button class="btn btn-danger btn-icon remove_row" data-toggle="tooltip" title="Remove"><i class="fa-solid fa-xmark"></i></button>' +
                    '</div>' +
            '</div>';

            var newRow = $(html);

            $("#append_area").append(newRow);

            // Initialize select2 for new row
            newRow.find('.select2').select2({
                width: '100%',
                placeholder: 'Select Option',
                allowClear: true,
                dropdownParent: newRow
            });

            // Get cities for new row
            get_cities(newRow.find('.cities'));
            get_areas(newRow.find('.areas'));


            // bootstrap-selectpicker refresh
            newRow.find('.selectpicker').selectpicker('refresh');
        });


        // Remove row
        $(document).on("click", ".remove_row", function(e) {
            e.preventDefault();
            $(this).closest(".appended-row").remove();
        });


        //=========== End add   row Ajax Request ===========//

        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    
                    contractor_id: {
                        required: true,
                    },
                    bom_id: {
                        required: true
                    },
                    pro_id: {
                        required: true
                    },
                    pro_qty: {
                        required: true
                    },
                    batch_no: {
                        required: true
                    },
                },
                messages: {
                    contractor_id: {
                        required: "Please Select Contractor",
                    },
                    bom_id: {
                        required: "Please Select BOM",
                    },
                    pro_id: {
                        required: "Please Select Product",
                    },
                    pro_qty: {
                        required: "Please Enter Product Quantity",
                    },
                    batch_no: {
                        required: "Please Enter Batch Number",
                    },
                }


        });
        //=========== End Insert Form Validation ===========//

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e){
            e.preventDefault();
            if($("#add_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Saving..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("insert_production")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Data Saved Successfully!', 'Successfull!');
                            $('#add_modal').find('form')[0].reset();
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                            $('#add_modal').modal('hide');
                            loadData();
                        }else if (response.status == "cnic_Exist") {
                            Swal.fire({ 
                                    title: "Data Exist!",
                                    text: "This Data Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#add_btn').text('Save ');
                            $('#add_btn').prop('disabled', false);
                        }
                    }

                });
            }
        });
        //=========== End Insert Data Ajax Request ===========//

        //=========== Restore Item Issue option when modal closes ===========//
        $('#update_modal').on('hidden.bs.modal', function () {
            // Restore the 'Item Issue' option if it was removed
            <?php if(Auth::user()->can('issue')): ?>
            if ($('#status option[value="issue"]').length === 0) {
                $('#status option[value="pending"]').after('<option value="issue">Item Issue</option>');
            }
            <?php endif; ?>
        });
        //=========== End Restore Item Issue option ===========//

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: 'edit_production/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#production_id').val(response.data.id);
                    $('#u_pro_qty').val(response.data.pro_qty);
                    $('#total_cost').val(response.data.total_cost);
                    $('#u_batch_no').val(response.data.batch_no);
                    $('#u_bom_price').val(response.data.bom_price);
                    $('#u_single_product_price').val(response.data.single_product_price);
                    $('#u_total_price').val(response.data.total_amount);
                    $('#sale_price').val(response.data.sale_price);


                    $('#u_contractor').val(response.data.contractor_id).trigger('change');
                    $('#u_product').val(response.data.pro_id).trigger('change');
                    $('#u_bom').val(response.data.bom_id).trigger('change');
                    $('#payment_type').val(response.data.payment_type).trigger('change');
                    $('#banks').val(response.data.bank_id).trigger('change');
                    $('#status').val(response.data.status).trigger('change');


                    // status div area
                    if (response.data.status === 'completed') {
                        // $('#status_wrap').hide();
                        $('#update_btn').hide();
                        // $('#status').prop('disabled', true);
                    } else {
                        // $('#status_wrap').show();
                        $('#update_btn').show();

                        // $('#status').prop('disabled', false).val(response.data.status).trigger('change');
                    }

                    // If status is 'issue', remove the 'Item Issue' option from dropdown
                    if (response.data.status === 'issue') {
                        $('#status option[value="issue"]').remove();
                    }



                }
            });
        });
        //=========== End Lounch Update Modal On Click Edit Btn ===========//

        //=========== Update Form Validation ===========//
        $.validator.addMethod("greaterThan", function(value, element, param) {
            let target = $(param);
            if (this.settings.onfocusout) {
                target.off(".validate-greaterThan").on("blur.validate-greaterThan", function() {
                    $(element).valid();
                });
            }
            return parseFloat(value) > parseFloat(target.val());
        }, "Sale Price must be greater than Purchase Price");
        
        $("#update_form").validate({
            rules: {
                    
                    pro_id: {
                        required: true,
                    },
                    contractor_id: {
                        required: true
                    },
                    bom_id: {
                        required: true
                    },
                    pro_qty: {
                        required: true
                    },
                     sale_price: {
                        required: true,
                        number: true,
                        min: 1,
                        greaterThan: "#u_single_product_price"   // 👈 compare with purchase price input
                    },
                },
                messages: {
                    pro_id: {
                        required: "Please Enter Product ID",
                    },
                    contractor_id: {
                        required: "Please Enter Contractor ID",
                    },
                    bom_id: {
                        required: "Please Enter BOM ID",
                    },
                    pro_qty: {
                        required: "Please Enter Product Quantity",
                    },
                    sale_price: {
                        required: "Please enter Sale Price",
                        min: "Sale Price must be greater than 0",
                        greaterThan: "Sale Price must be greater than Purchase Price"
                    },
                    
                },


        });
        //=========== End Update Form Validation ===========//

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("update_production")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Data Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else if (response.status == "cnic_Exist") {
                            Swal.fire({ 
                                    title: "Data Exist!",
                                    text: "This Data Already Exist!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Data');
                            
                        } else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Update  Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update ');
                        }
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: 'delete_production/'+id,
                            type : "GET",
                            success : function(response){
                                if (response.status == 200)
                                {
                                    toastr.success('Data Has Been Deleted Seccussfully!', 'Successfull!');
                                    loadData();
                                }else {
                                    Swal.fire({
                                                title: "Somthing Wrong!",
                                                text: "Sonthing Went Wrong Please Try Again!",
                                                type: "error",
                                                customClass: "sweet-alert",
                                            });
                                }
                            }
                        });
                    }

                })


        });
        //=========== End Delete Data Ajax Request ===========//

        //=========== Lounch View Modal On Click View Btn ===========//
        $(document).on("click", '#view_btn', function(event){
            event.preventDefault();
            $("#view_modal").modal('show');

            var id = $(this).data("vid");
        });
        //=========== End Lounch View Modal On Click View Btn ===========//


        // contractor 
        $('#contractor').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Contractor',
            allowClear: true,
            dropdownParent: $('#contractor').parent() // Set to the parent element of the select box
        });
        $('#u_contractor').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Contractor',
            allowClear: true,
            dropdownParent: $('#u_contractor').parent() // Set to the parent element of the select box
        });
        get_contractor();
        // =======================get ===============================
        function get_contractor(){
            $.ajax({
            url:'/get_contractor',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#contractor option[value="' + data[i].id + '"]').length == 0){
                        $('#contractor').append($('<option>',{
                        value:data[i].id,
                        text:data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_contractor option[value="' + data[i].id + '"]').length == 0){
                        $('#u_contractor').append($('<option>',{
                        value: data[i].id,
                        text: data[i].name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================

        // bom 
        $('#bom').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select BOM',
            allowClear: true,
            dropdownParent: $('#bom').parent() // Set to the parent element of the select box
        });
        $('#u_bom').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select BOM',
            allowClear: true,
            dropdownParent: $('#u_bom').parent() // Set to the parent element of the select box
        });
        get_bom();
        // =======================get ===============================
        function get_bom(){
            $.ajax({
            url:'/get_bom',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#bom option[value="' + data[i].id + '"]').length == 0){
                        $('#bom').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bom_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_bom option[value="' + data[i].id + '"]').length == 0){
                        $('#u_bom').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bom_name,
                        }));
                    }
                    });
                    
                }
            });
        };

        $('#bom').on('change', function() {
            var bom_id = $(this).val();
            if (bom_id) {
                // Get BOM price
                $.ajax({
                    url: '/get_bom_price/' + bom_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log(data); // Debug check
                        $('.bom_price').val(data.total_price);
                    }
                });
                
                // Get BOM products and populate BOM product dropdown (first field)
                $.ajax({
                    url: '/get_bom_products/' + bom_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log('BOM Products:', data);
                        // Clear existing options except the first empty option
                        $('#bom_product').empty().append('<option></option>');
                        
                        // Populate with BOM products
                        $.each(data, function(i, item) {
                            $('#bom_product').append($('<option>', {
                                value: item.pro_id,
                                text: item.pro_name + ' (SKU: ' + item.sku + ')'
                            }));
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error loading BOM products:', error);
                        $('#bom_product').empty().append('<option></option>');
                    }
                });
            } else {
                $('.bom_price').val('');
                // Clear BOM product dropdown when no BOM is selected
                $('#bom_product').empty().append('<option></option>');
                $('#product_balance').val('');
            }
        });


        // =======================get ===============================

        // BOM Product dropdown (first field - shows BOM products)
        $('#bom_product').select2({
            width: '100%',
            placeholder: '',
            allowClear: true,
            dropdownParent: $('#bom_product').parent()
        });

        // Regular Product dropdown (second field - shows all products)
        $('#product').select2({
            width: '100%',
            placeholder: '',
            allowClear: true,
            dropdownParent: $('#product').parent()
        });
        $('#u_product').select2({
            width: '100%',
            placeholder: 'Select Product',
            allowClear: true,
            dropdownParent: $('#u_product').parent()
        });
        
        // Load products excluding SDK and CDK for regular product dropdown (second field)
        get_products_excluding_sdk_cdk();
        // Load all products for update modal
        get_products();
        
        // =======================get ===============================
        function get_products(){
            $.ajax({
            url:'/get_products',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log(data);
                    // Populate update modal product dropdown (all products)
                    $.each(data,function(i,item){
                    if($('#u_product option[value="' + data[i].id + '"]').length == 0){
                        $('#u_product').append($('<option>',{
                        value: data[i].id,
                        text: data[i].pro_name,
                        }));
                    }
                    });
                    
                }
            });
        };

        function get_products_excluding_sdk_cdk(){
            $.ajax({
            url:'/get_products_excluding_sdk_cdk',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log('Products excluding SDK and CDK:', data);
                    // Populate regular product dropdown (second field) excluding SDK and CDK categories
                    $.each(data,function(i,item){
                    if($('#product option[value="' + data[i].id + '"]').length == 0){
                        $('#product').append($('<option>',{
                        value: data[i].id,
                        text: data[i].pro_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        
        // When BOM product is selected, fetch and display balance from main store
        $('#bom_product').on('change', function() {
            var product_id = $(this).val();
            if (product_id) {
                $.ajax({
                    url: '/get_product_balance/' + product_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log('BOM Product Balance:', data.balance);
                        $('#product_balance').val(data.balance);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error loading product balance:', error);
                        $('#product_balance').val('0');
                    }
                });
            } else {
                $('#product_balance').val('');
            }
        });
        // =======================get ===============================

        // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================

        






        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '<?php echo e(route("load_production")); ?>',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "pro_name" },
                { data: "sku" },
                { data: "pro_qty" },
                { data: "status" },
                { data: "start_date" }, 

                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1,5] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [1, 4, 7, 9],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                // $(api.column(0).footer()).html(subtotal);
            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();
        //==========For Add===========//
        $('#image-input').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#uploaded-photo').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //==========For Update===========//
        $('#up_image').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('#upload_teacher_image').attr('src', event.target.result).show();
                }
                reader.readAsDataURL(file);
            }
        });

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#status').val());
        });
        //=========== End Custom Search Box ===========//




    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/production.blade.php ENDPATH**/ ?>