<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/dropify/css/dropify.min.css')); ?>">

    <!-- CSS -->

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }
    
         
        .custom-dropify .dropify-wrapper {
            max-width: 200px;  
            height: 70px;  
        }

        
        .custom-dropify .dropify-wrapper .dropify-message p {
            font-size: 12px;  
        }

        .order-summary {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .order-summary .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed #dee2e6;
        }
        .order-summary .summary-row:last-child {
            border-bottom: none;
        }
        .order-summary .summary-row.highlight {
            font-weight: bold;
            color: #dc3545;
            background-color: #fff3f3;
            padding: 10px;
            margin: 5px -15px;
            border-radius: 5px;
        }
    
    </style>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_head'); ?>
    <div class="row">
        <div class="col-md-6 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow"> Contractor Orders (Labour Cost Payment)</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li>Manage All Contractor Orders - Pay Labour Cost for Repair Orders</li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-6">
            <div id="page-title">
                <h4 class="text-overflow"> These Orders Come From Completed Repair Orders</h4>
            </div> 
            
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>

    <div class="panel">
       
        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        <div class="form-group">
                            <select id="payment_status_filter" class="form-control">
                                <option value="">All Status</option>
                                <option value="Pending">Pending</option>
                                <option value="Paid">Paid</option>
                            </select>
                        </div>
                 
                        
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">Contractor</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2">Product</a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Batch Number</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Production Price</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Qty</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Labour Cost</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Material Cost</a></li>
                                <li><a href="#" class="toggle-vis" data-column="8">Total Price</a></li>
                                <li><a href="#" class="toggle-vis" data-column="9">Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="10">Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="11">Payment Status</a></li>
                                <li><a href="#" class="toggle-vis" data-column="12">Action</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="4%">ID</th>
                            <th width="10%">Contractor</th>
                            <th width="10%">Product</th>
                            <th width="8%">Batch #</th>
                            <th width="8%">Prod. Price</th>
                            <th width="5%">Qty</th>
                            <th width="8%">Labour Cost</th>
                            <th width="8%">Material Cost</th>
                            <th width="8%">Total Price</th>
                            <th width="8%">Date</th>
                            <th width="8%">Status</th>
                            <th width="8%">Payment</th>

                            <th width="10%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>   

    <!--Start Update Modal-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal">
        <div class="modal-dialog modal-md">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title"><i class="fa-duotone fa-money-bill"></i> Pay Labour Cost</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">

 
                            <input type="hidden" id="order_id" name="order_id">

                            <!-- Order Summary -->
                            <div class="col-sm-12">
                                <div class="order-summary">
                                    <h5 style="margin-bottom: 15px; color: #333;"><i class="fa-duotone fa-receipt"></i> Order Summary</h5>
                                    <div class="summary-row">
                                        <span>Contractor:</span>
                                        <span id="summary_contractor">-</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Product:</span>
                                        <span id="summary_product">-</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Batch Number:</span>
                                        <span id="summary_batch">-</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Production Price:</span>
                                        <span id="summary_price">Rs. 0.00</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Material Cost:</span>
                                        <span id="summary_material">Rs. 0.00</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Total Price:</span>
                                        <span id="summary_total">Rs. 0.00</span>
                                    </div>
                                    <div class="summary-row highlight">
                                        <span>Labour Cost to Pay:</span>
                                        <span id="summary_labour">Rs. 0.00</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="text" id="date" name="date" class="form-control textbox" placeholder=" ">
                                    <label class="control-label textboxlabel"> Payment Date  :</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="labour_cost_display" class="form-control textbox" readonly style="background-color: #f0f0f0;">
                                    <label class="control-label textboxlabel">Labour Cost:</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input type="number" id="receive_amount" name="receive_amount" class="form-control textbox" >
                                    <label class="control-label textboxlabel">Amount to Pay:</label>
                                </div>
                            </div>

                             <div class="col-sm-6">
                                <div class="form-group">
                                    <select id="payment_type" name="payment_type" class="form-control selectpicker">
                                        <option value="Cash">Cash</option>
                                        <option value="Bank">Bank</option>
                                    </select>
                                </div>
                            </div>

                            
                            <div class="col-sm-6" id="bank_area">
                                <div class="form-group">
                                    <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                        <option></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <select id="payment_status" name="payment_status" class="form-control selectpicker">
                                        <option value="Pending">Pending</option>
                                        <option value="Paid">Paid</option>
                                    </select>
                                </div>
                            </div>
                          
                        

                            


                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn"><i class="fa-duotone fa-check"></i> Pay & Update</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->
    
   


<?php $__env->stopSection(); ?>



<?php $__env->startSection('javascript_code'); ?>

<script src="<?php echo e(asset('backend/my_plugins/dropify/js/dropify.min.js')); ?>"></script>


<script>
    // Function to set today's date in the input field
    function setTodayDate() {
        const today = new Date();
        const formattedDate = today.toISOString().split('T')[0]; // Format date as yyyy-mm-dd
        if(document.getElementById("date")) {
            document.getElementById("date").value = formattedDate;
        }
    }

    // Call the function to set the date when the page loads
    window.onload = setTodayDate;
</script>

<script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
            }
        });
    }); 
</script>

<script>


    $(document).ready(function(){

        $('.select2').select2();


        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');
            
            // Reset the form
            setTodayDate();

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_contracter_order/'+id,
                method: 'GET',
                // data: { doctor_id: updateId },
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(data) {
                    console.log(data);

                    // Set basic data
                    $('#order_id').val(data.data.id);
                    $('#date').val(data.data.date);
                    $('#labour_cost_display').val(data.data.labour_cost);
                    $('#receive_amount').val(data.data.labour_cost); // Default to labour cost

                    $('#payment_type').val(data.data.Payment_type || 'Cash').trigger('change');
                    $('#banks').val(data.data.bank_id).trigger('change');
                    $('#payment_status').val(data.data.payment_status || 'Pending').trigger('change');

                    // Update summary
                    $('#summary_contractor').text(data.data.contractor_name || '-');
                    $('#summary_product').text(data.data.pro_name || '-');
                    $('#summary_batch').text(data.data.batch_number || '-');
                    $('#summary_price').text('Rs. ' + parseFloat(data.data.price || 0).toFixed(2));
                    $('#summary_material').text('Rs. ' + parseFloat(data.data.material_cost || 0).toFixed(2));
                    $('#summary_total').text('Rs. ' + parseFloat(data.data.total_price || 0).toFixed(2));
                    $('#summary_labour').text('Rs. ' + parseFloat(data.data.labour_cost || 0).toFixed(2));


                    if (data.data.payment_status === 'Paid') {
                        // Hide update button
                        $("#update_btn").hide();
                    } else {
                        // Show update button
                        $("#update_btn").show();
                    }

            

                
                }

            });
        });
        //=========== Launch Update Modal On Click Edit Btn ===========//


        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                payment_status: {
                    required: true,
                    equalToPaid: true // custom rule
                },
                receive_amount: {
                    required: true,
                    min: 0
                }
                
                
            },
            messages: {
                payment_status: {
                    required: "Please select payment status",
                    equalToPaid: "You must select 'Paid' to complete payment."
                }, 
                receive_amount: {
                    required: "Please enter amount to pay",
                    min: "Amount must be greater than 0"
                }
              
            },


            //Called when the element is invalid:
            highlight: function(element) {
                // $(element).css('background', '#ffdddd');
                // $(element).css('border', '1px solid red');
                $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/delete.png")); ?>)');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            },

            // Called when the element is valid:
            unhighlight: function(element) {
                // $(element).css('background', '#ffffff');
                // $(element).css('border', '1px solid green');
                $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/apply.png")); ?>)');
                $(element).css('background-repeat', 'no-repeat');
                $(element).css('background-position', '97%');
            }

        });
         $.validator.addMethod("equalToPaid", function(value, element) {
            return value === "Paid";
        }, "You must select 'Paid' to update.");
     
        //=========== End Update Form Validation ===========//


        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', true);
                $(this).text('Processing..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("update_contracter_order")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success('Payment Processed Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').html('<i class="fa-duotone fa-check"></i> Pay & Update');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something Error Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').html('<i class="fa-duotone fa-check"></i> Pay & Update');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error:', xhr.responseText);
                        Swal.fire({
                            title: "Error!",
                            text: "Server Error: " + (xhr.responseJSON ? xhr.responseJSON.message : error),
                            icon: "error",
                            buttonsStyling: !1,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-success"
                            }
                        });
                        $('#update_btn').prop('disabled', false);
                        $('#update_btn').html('<i class="fa-duotone fa-check"></i> Pay & Update');
                    }

                });
            }
        });
        //=========== End Update Data Ajax Request ===========//

        // banks 
        $('#banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent() // Set to the parent element of the select box
        });
        $('#u_banks').select2({
            width: '100%', // Adjust width as needed
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent() // Set to the parent element of the select box
        });
        get_banks();
        // =======================get ===============================
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                //   data:{action:'get_categories'},
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };
        // =======================get ===============================


        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '<?php echo e(route("load_contracter_order")); ?>',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", _token: csrf._token }
            },
            columns: [
                { data: "id" },
                { data: "contracter_name" },
                { data: "pro_name" },
                { data: "batch_number" },
                { data: "price" },
                { data: "pro_qty" },
                { data: "labour_cost" },
                { data: "material_cost" },
                { data: "total_price" },
                { data: "date" },
                { data: "status" },
                { data: "payment_status" },


                { data: "btn" },
                // Add more column definitions as needed
            ],
            columnDefs: [
                { className: 'text-center', targets: [3,4,5,6,7,8,9,10,11] },
                // Add more column definitions as needed
            ],
            centeredColumnsOnPrintPdf: [3, 5],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

             


            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { _token: csrf._token, startdate: startDate, enddate: endDate, search: search, type: type }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Example usage: Call the function with updated dates
        loadData();

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            loadData($(this).val(), "", "", $('#payment_status_filter').val());
        });

        //=========== Start Payment Status Filter ===========//
        $('#payment_status_filter').change(function(){
            loadData($('#search').val(), "", "", $(this).val());
        });

        
        //=========== End Custom Search Box ===========//



    });



</script>






<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/contracter_orders.blade.php ENDPATH**/ ?>