<?php $__env->startSection('page_head'); ?>

<?php $__env->startSection('css_code'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/my_plugins/timepicker/timepicker.min.css')); ?>">
    <style>
        .pending-summary-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .pending-summary-card h5 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 15px;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 8px;
        }
        .pending-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed #dee2e6;
        }
        .pending-item:last-child {
            border-bottom: none;
        }
        .pending-item .label {
            color: #6c757d;
            font-weight: 500;
        }
        .pending-item .value {
            font-weight: 600;
            color: #212529;
        }
        .pending-item .value.positive {
            color: #28a745;
        }
        .pending-item .value.negative {
            color: #dc3545;
        }
        .total-row {
            background: #e9ecef;
            padding: 12px;
            border-radius: 5px;
            margin-top: 10px;
        }
        .total-row .label {
            font-size: 16px;
            font-weight: 700;
        }
        .total-row .value {
            font-size: 18px;
            font-weight: 700;
            color: #007bff;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_head'); ?>

    <div class="row">
        <div class="col-md-2 table-toolbar-left" style="padding-bottom: 5px;">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="page-title">
                <h1 class="page-header text-overflow">Sale Man Ledger</h1>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->


            <!--Breadcrumb-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <ol class="breadcrumb">
            <li id="saleman_name"></li>
            </ol>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End breadcrumb-->
        </div>
        <div class="col-md-10">
            <!--Page Title-->
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div id="counting_panel">
                <div class="page-header counting round-corner-left">Total Sale <br> <b id="total_amount">0</b></div>
                <div class="page-header counting">  Cash<br> <b id="cash">0</b></div>
                <div class="page-header counting">EasyPaisa  <br> <b id="easypaisa">0</b></div>
                <div class="page-header counting">JazzCash  <br> <b id="jazzcash">0</b></div>
                <div class="page-header counting">Meezan  <br> <b id="meezan">0</b></div>
                <div class="page-header counting">U Paisa  <br> <b id="u_paisa">0</b></div>
                <div class="page-header counting"> Expense <br> <b id="total_expense">0</b></div>
                <div class="page-header counting"> Return Paid <br> <b id="return_paid">0</b></div>
                <div class="page-header counting round-corner-right"> Balance <br> <b id="total_balance">0</b></div>
            </div>
            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <!--End page title-->
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_content'); ?>

    <div class="panel">
         

        <!--Data Table-->
        <!--===================================================-->
        <div class="panel-body" style="padding-top: 15px; padding-bottom: 10px;">
            <div class="form-inline">
                <div class="row">
                    <div class="col-sm-6 table-toolbar-left" style="padding-bottom: 2px;">
                        <div class="form-group">
                            <input id="search" type="text" placeholder="Search" class="form-control" autocomplete="off">
                        </div>
                        <div class="form-group">
                            <input id="search_by_date" type="text" placeholder="Search By Date" class="form-control" autocomplete="off" style="width: 200px">
                            <button id="refresh_data" data-toggle="tooltip" title="Reload Data" class="btn btn-success"><i class="fa-duotone fa-rotate"></i></button>
                        </div>
                    </div>
                    <div class="col-sm-6 table-toolbar-right" style="padding-bottom: 2px;">
                        <?php if(Auth::user()->hasRole('Sales Man')): ?>
                            <button id="send_cashier_btn" class="btn btn-purple"><i class="demo-pli-add"></i>Send to Cashier</button>
                            <button id="add_modal_btn" class="btn btn-purple"><i class="demo-pli-add"></i> Add Payment</button>
                        <?php endif; ?>
                        <?php if(Auth::user()->hasRole('Cashier')): ?>
                            <button id="view_received_btn" class="btn btn-success"><i class="fa-duotone fa-inbox-in"></i> View Pending Payments</button>
                        <?php endif; ?>
                        <?php if(Auth::user()->hasRole(['Super Admin', 'Admin'])): ?>
                            <button id="view_received_btn" class="btn btn-primary"><i class="fa-duotone fa-eye"></i> View Received Payments</button>
                        <?php endif; ?>
                        <button id="print" data-toggle="tooltip" title="Print" class="btn btn-info btn-icon"><i class="fa-duotone fa-print"></i></button>
                        <button id="excel" data-toggle="tooltip" title="Export in Excel" class="btn btn-success btn-icon"><i class="fa-duotone fa-file-xls"></i></button>
                        <button id="pdf" data-toggle="tooltip" title="Export in Pdf" class="btn btn-danger btn-icon"><i class="fa-duotone fa-file-pdf"></i></button>
                        <div class="btn-group dropdown">
                            <button data-toggle="dropdown" class="btn btn-mint dropdown-toggle">
                                Columns
                                <span class="caret"></span>
                            </button>
                            <ul role="menu" class="dropdown-menu dropdown-menu-right">
                                <li><a href="#" class="toggle-vis" data-column="0">ID</a></li>
                                <li><a href="#" class="toggle-vis" data-column="1">  Date</a></li>
                                <li><a href="#" class="toggle-vis" data-column="2"> Customer  </a></li>
                                <li><a href="#" class="toggle-vis" data-column="3">Transaction Details</a></li>
                                <li><a href="#" class="toggle-vis" data-column="4">Transaction Type</a></li>
                                <li><a href="#" class="toggle-vis" data-column="5">Total</a></li>
                                <li><a href="#" class="toggle-vis" data-column="6">Debit</a></li>
                                <li><a href="#" class="toggle-vis" data-column="7">Credit</a></li>
                                <li><a href="#" class="toggle-vis" data-column="8">Balance</a></li>
                            </ul>
                        </div>

                        <button id="return_back_btn" onclick="window.history.back();" class="btn btn-success"><i class="fa-duotone fa-chevrons-left"></i> Back</button>

                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover custom-table" id="main_table">
                    <thead>
                        <tr>
                            <th width="10px">S.No</th>
                            <th width="75px">Date</th>
                            <th width="120px">Customer Business Name</th>
                            <th width="60px">Sale ID</th>
                            <th width="80px">Total</th>
                            <th width="100px">Type</th>
                            <th width="80px">Cash Amount</th>
                            <th width="80px">Bank Amount</th>
                            <th width="80px">Return Paid</th>
                            <th width="80px">Status</th>
                            <th width="80px">Balance</th>
                            <th width="75px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!--===================================================-->
        <!--End Data Table-->
    </div>  
    
    <!--Start Add Modal-->
    <!--===================================================-->
    <div class="modal fade" id="add_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Add Payment</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" style="padding-bottom: 0px">
                    <!--===================================================-->
                    <form id="add_form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="salesman_id" id="cus_pay_id" value="">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="transaction_date" id="transaction_date" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Payment Date</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <select id="cus_id" name="cus_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Customer Balance Display Section -->
                                <div class="col-sm-12" id="customer_balance_section" style="display: none;">
                                    <div class="alert alert-warning" style="padding: 12px 15px; margin-bottom: 15px; background-color: #fff3cd; border: 1px solid #ffc107;">
                                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                                            <strong style="color: #856404; font-size: 15px;">Customer Old Balance (Due):</strong>
                                            <span id="customer_old_balance" style="color: #dc3545; font-size: 18px; font-weight: bold;">0</span>
                                        </div>
                                        <small style="color: #856404; font-size: 12px; display: block;">
                                            <i class="fa fa-info-circle"></i> This is the customer's existing outstanding balance
                                        </small>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label style="font-weight: bold; font-size: 14px; margin-bottom: 8px; display: block;">Payment Amount</label>
                                        <input type="text" name="amount" id="payment_amount" class="form-control" placeholder="Enter payment amount received" autocomplete="off">
                                        <small class="text-muted">Enter the amount customer is paying now</small>
                                    </div>
                                </div>

                                <!-- New Balance Calculation Display -->
                                <div class="col-sm-12" id="balance_calculation_display" style="display: none;">
                                    <div class="panel panel-info" style="margin-bottom: 15px; border: 2px solid #17a2b8;">
                                        <div class="panel-body" style="padding: 15px; background-color: #e7f6f8;">
                                            <h5 style="margin-top: 0; margin-bottom: 12px; color: #0c5460; font-weight: 600;">
                                                <i class="fa fa-calculator"></i> Balance Calculation
                                            </h5>
                                            <div style="display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #bee5eb;">
                                                <span style="color: #0c5460;">Old Balance:</span>
                                                <strong id="calc_old_balance" style="color: #dc3545;">0</strong>
                                            </div>
                                            <div style="display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #bee5eb;">
                                                <span style="color: #0c5460;">Payment Amount:</span>
                                                <strong id="calc_payment_amount" style="color: #28a745;">0</strong>
                                            </div>
                                            <div style="display: flex; justify-content: space-between; padding: 12px 0; margin-top: 8px; border-top: 2px solid #17a2b8;">
                                                <span style="color: #0c5460; font-weight: 600; font-size: 15px;">New Balance:</span>
                                                <strong id="calc_new_balance" style="color: #007bff; font-size: 18px;">0</strong>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <input type="hidden" id="customer_balance_value" name="customer_balance_value" value="0">
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="transaction_type" data-style="custom-select-style" id="payment_type">
                                        <option value="" selected disabled>Select Payment Type</option>
                                        <option value="credit">Credit</option>
                                        <option value="bank">Bank</option>
                                    </select>
                                </div>
                                <div class="col-sm-12" id="bank_area">
                                    <div class="form-group">
                                        <select id="banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="transaction_details" class="form-control textbox" placeholder=" " cols="30" rows="3"></textarea>
                                        <label class="control-label textboxlabel" >Detail</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="add_btn">Save Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Add Modal-->

    <!--Start Send to Cashier Modal-->
    <!--===================================================-->
    <div class="modal fade" id="sendToCashierModal" role="dialog" tabindex="-1" aria-labelledby="sendToCashierModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <!--Modal header-->
                <div class="modal-header bg-primary">
                    <button type="button" class="close" data-dismiss="modal" style="color: white;"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title" style="color: white;"><i class="fa-duotone fa-money-bill-transfer"></i> Send to Cashier</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!-- Date field -->
                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="control-label"><strong>Date Range</strong></label>
                                <input type="text" id="cashier_date" name="cashier_date" class="form-control" placeholder="Select Date Range" readonly>
                            </div>
                        </div>
                    </div>

                    <!-- Pending Balances Summary -->
                    <div class="pending-summary-card">
                        <h5><i class="fa-duotone fa-clock"></i> Pending Balances</h5>
                        
                        <!-- Cash & Bank Section -->
                        <div class="pending-item">
                            <span class="label"><i class="fa-duotone fa-money-bill"></i> Cash:</span>
                            <span class="value positive" id="pendingCash">0</span>
                        </div>
                        <!-- Dynamic Bank Items (populated by JavaScript) -->
                        <div id="pendingBanksContainer"></div>
                    </div>

                    <!-- Deductions Section -->
                    <div class="pending-summary-card">
                        <h5><i class="fa-duotone fa-minus-circle"></i> Deductions</h5>
                        
                        <div class="pending-item">
                            <span class="label"><i class="fa-duotone fa-receipt"></i> Expenses:</span>
                            <span class="value negative" id="pendingExpenses">0</span>
                        </div>
                        <div class="pending-item">
                            <span class="label"><i class="fa-duotone fa-rotate-left"></i> Return Paid (from Credit):</span>
                            <span class="value negative" id="pendingReturnCredit">0</span>
                        </div>
                        <div class="pending-item">
                            <span class="label"><i class="fa-duotone fa-rotate-left"></i> Return (from Balance):</span>
                            <span class="value" id="pendingReturnBalance" style="color: #6c757d;">0</span>
                            <small style="color: #999; font-size: 10px;">(Does not affect total)</small>
                        </div>
                    </div>

                    <!-- Total Section -->
                    <div class="pending-summary-card">
                        <div class="total-row">
                            <div class="pending-item" style="border: none; padding: 0;">
                                <span class="label"><i class="fa-duotone fa-calculator"></i> Total Amount to Send:</span>
                                <span class="value" id="total_amounts">0</span>
                            </div>
                        </div>
                        <small style="color: #6c757d; margin-top: 10px; display: block;">
                            <i class="fa-duotone fa-info-circle"></i> 
                            Formula: (Cash + Banks) - Expenses - Return Paid from Credit
                        </small>
                    </div>

                    <form id="sendToCashierForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="pending_cash" id="inputPendingCash">
                        <!-- Dynamic Bank Hidden Inputs (populated by JavaScript) -->
                        <div id="hiddenBankInputsContainer"></div>
                        <input type="hidden" name="pending_expenses" id="inputPendingExpenses">
                        <input type="hidden" name="pending_return_credit" id="inputPendingReturnCredit">
                        <input type="hidden" name="pending_return_balance" id="inputPendingReturnBalance">
                    </form>
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button type="submit" id="sendto_cashier_btn" class="btn btn-success btn-lg">
                        <i class="fa-duotone fa-paper-plane"></i> Send to Cashier
                    </button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Send to Cashier Modal-->

    <!--Start Update Modal for Cashier-->
    <!--===================================================-->
    <div class="modal fade" id="update_modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">Update Status</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <!--===================================================-->
                    <form id="update_form">
                        <div class="row">
                            <div class="col-sm-12">
                                <input type="hidden" name="pay_id" id="u_pay_id" class="form-control textbox" placeholder=" ">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="amount" id="u_amount" class="form-control textbox" placeholder=" ">
                                        <label class="control-label textboxlabel" >Amount</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <select class="selectpicker" name="status" id="uu_status" data-style="custom-select-style">
                                        <option value="pending">Pending</option> 
                                        <?php if(Auth::user()->hasRole('Super Admin')): ?>
                                            <option value="received">Received</option>
                                            <option value="approved">Approved</option>
                                        <?php elseif(Auth::user()->hasRole('Cashier')): ?>
                                            <option value="received">Received</option>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <div class="col-sm-12">
                                    <select class="selectpicker" name="transaction_type" id="uu_transaction_type" data-style="custom-select-style">
                                        <option value="Cash">Cash</option> 
                                        <option value="Bank">Bank</option>
                                        <option value="expense">Expense</option>
                                    </select>
                                </div>

                                <div class="col-sm-12" id="uu_bank_area">
                                    <div class="form-group">
                                        <select id="uu_banks" name="bank_id" class="select2 form-control" style="width: 100%">
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!--===================================================-->
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button class="btn btn-primary" id="update_btn">Update Payment</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End Update Modal-->

    <!--Start View Received Payments Modal-->
    <!--===================================================-->
    <div class="modal fade" id="viewReceivedModal" role="dialog" tabindex="-1" aria-labelledby="viewReceivedModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" style="max-width: 90%;">
            <div class="modal-content">
                <!--Modal header-->
                <div class="modal-header <?php if(Auth::user()->hasRole('Cashier')): ?> bg-success <?php else: ?> bg-primary <?php endif; ?>">
                    <button type="button" class="close" data-dismiss="modal" style="color: white;"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title" style="color: white;">
                        <i class="fa-duotone fa-inbox"></i>
                        <?php if(Auth::user()->hasRole('Cashier')): ?>
                            Pending Payments from Salesmen
                        <?php else: ?>
                            Received Payments (Awaiting Approval)
                        <?php endif; ?>
                    </h4>
                </div>

                <!--Modal body-->
                <div class="modal-body">
                    <table id="received_payments_table" class="table table-striped table-bordered" style="width: 100%;">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Source</th>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Cash</th>
                                <th>EasyPaisa</th>
                                <th>JazzCash</th>
                                <th>Meezan</th>
                                <th>UPaisa</th>
                                <th>Expenses</th>
                                <th>Return (Credit)</th>
                                <th>Return (Balance)</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th class="text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End View Received Payments Modal-->

    <!--Start View Details Modal-->
    <!--===================================================-->
    <div class="modal fade" id="viewDetailsModal" role="dialog" tabindex="-1" aria-labelledby="viewDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <!--Modal header-->
                <div class="modal-header bg-info">
                    <button type="button" class="close" data-dismiss="modal" style="color: white;"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title" style="color: white;"><i class="fa-duotone fa-file-invoice"></i> Payment Details</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body" id="printableArea">
                    <div style="text-align: center; margin-bottom: 20px;">
                        <h3>Payment Receipt</h3>
                        <p><strong>Salesman:</strong> <span id="detail_salesman_name"></span></p>
                        <p><strong>Date:</strong> <span id="detail_date"></span></p>
                    </div>

                    <table class="table table-bordered">
                        <thead class="bg-mint">
                            <tr>
                                <th>Payment Type</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr id="row_cash">
                                <td><i class="fa-duotone fa-money-bill"></i> Cash</td>
                                <td class="text-right"><strong id="detail_cash">0</strong></td>
                            </tr>
                            <tr id="row_easypaisa">
                                <td><i class="fa-duotone fa-mobile"></i> EasyPaisa</td>
                                <td class="text-right"><strong id="detail_easypaisa">0</strong></td>
                            </tr>
                            <tr id="row_jazzcash">
                                <td><i class="fa-duotone fa-mobile"></i> JazzCash</td>
                                <td class="text-right"><strong id="detail_jazzcash">0</strong></td>
                            </tr>
                            <tr id="row_meezan">
                                <td><i class="fa-duotone fa-building-columns"></i> Meezan Bank</td>
                                <td class="text-right"><strong id="detail_meezan">0</strong></td>
                            </tr>
                            <tr id="row_upaisa">
                                <td><i class="fa-duotone fa-mobile"></i> UPaisa</td>
                                <td class="text-right"><strong id="detail_upaisa">0</strong></td>
                            </tr>
                            <tr id="row_expenses" class="danger">
                                <td><i class="fa-duotone fa-receipt"></i> Expenses (Deduction)</td>
                                <td class="text-right"><strong id="detail_expenses">0</strong></td>
                            </tr>
                            <tr id="row_return_credit" class="warning">
                                <td><i class="fa-duotone fa-rotate-left"></i> Return Paid (Credit)</td>
                                <td class="text-right"><strong id="detail_return_credit">0</strong></td>
                            </tr>
                            <tr id="row_return_balance" class="warning">
                                <td><i class="fa-duotone fa-rotate-left"></i> Return (Balance Adjustment)</td>
                                <td class="text-right"><strong id="detail_return_balance">0</strong></td>
                            </tr>
                            <tr class="success">
                                <td><strong>TOTAL AMOUNT</strong></td>
                                <td class="text-right"><strong id="detail_total" style="font-size: 18px;">0</strong></td>
                            </tr>
                        </tbody>
                    </table>

                    <div style="margin-top: 30px;">
                        <p><strong>Status:</strong> <span id="detail_status" class="label"></span></p>
                    </div>
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <?php if(Auth::user()->hasRole('Cashier')): ?>
                        <button type="button" id="receive_payment_btn" class="btn btn-success"><i class="fa-duotone fa-inbox-in"></i> Receive Payment</button>
                    <?php else: ?>
                        <button type="button" id="approve_payment_btn" class="btn btn-primary"><i class="fa-duotone fa-check"></i> Approve Payment</button>
                    <?php endif; ?>
                    <button type="button" id="print_details_btn" class="btn btn-info"><i class="fa-duotone fa-print"></i> Print</button>
                    <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!--===================================================-->
    <!--End View Details Modal-->

<?php $__env->stopSection(); ?>

   

<?php $__env->startPush('script'); ?>


    <script>
    $(document).ready(function() {
        // By default hide bank area
        $('#bank_area').hide();
        $('#u_bank_area').hide();
        $('#uu_bank_area').hide();

        // Check if salesman can send to cashier today (only for Sales Man role)
        <?php if(Auth::user()->hasRole('Sales Man')): ?>
        function checkCanSendToCashier() {
            $.ajax({
                url: '<?php echo e(route("check_salesman_can_send_to_cashier")); ?>',
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status === 200) {
                        if (!response.can_send) {
                            // Disable the button and add tooltip
                            $('#send_cashier_btn')
                                .prop('disabled', true)
                                .attr('data-toggle', 'tooltip')
                                .attr('data-placement', 'top')
                                .attr('title', response.message)
                                .tooltip();
                        } else {
                            // Enable the button
                            $('#send_cashier_btn').prop('disabled', false);
                        }
                    }
                },
                error: function() {
                    // On error, keep button enabled to avoid blocking user
                    $('#send_cashier_btn').prop('disabled', false);
                }
            });
        }

        // Check on page load
        checkCanSendToCashier();
        <?php endif; ?>

        // On payment type change
        $('#payment_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#bank_area').show();
            } else {
                $('#bank_area').hide();
                // Clear bank selection when switching to credit
                $('#banks').val(null).trigger('change');
            }
        });

        $('#u_transaction_type').on('change', function() {
            if ($(this).val() === 'bank') {
                $('#u_bank_area').show();
            } else {
                $('#u_bank_area').hide();
            }
        });

        $('#uu_transaction_type').on('change', function() {
            if ($(this).val() === 'Bank') {
                $('#uu_bank_area').show();
            } else {
                $('#uu_bank_area').hide();
            }
        });


        $("#send_cashier_btn").click(function(e) {
            e.preventDefault();

            // Check if button is disabled
            if ($(this).prop('disabled')) {
                toastr.warning('You have already sent to cashier today. Please try again tomorrow.', 'Not Allowed');
                return false;
            }

            // Modal show karna
            $("#sendToCashierModal").modal('show');

            // Get selected date from search_by_date field
            var selectedDateRange = $('#search_by_date').val();
            var startDate = '';
            var endDate = '';
            var displayDateRange = '';

            if (selectedDateRange) {
                // If a date range is selected, split it
                var dates = selectedDateRange.split(' To ');
                startDate = dates[0] || '';
                endDate = dates[1] || '';
                // Display the full range in the modal
                displayDateRange = startDate + ' To ' + endDate;
            } else {
                // If no date selected, use today's date
                var today = new Date();
                var d = String(today.getDate()).padStart(2,'0');
                var m = String(today.getMonth()+1).padStart(2,'0');
                var y = today.getFullYear();
                startDate = d+'-'+m+'-'+y;
                endDate = d+'-'+m+'-'+y;
                displayDateRange = startDate + ' To ' + endDate;
            }

            // Set the date range in the modal field
            $('#cashier_date').val(displayDateRange);

            // Initialize daterangepicker with the selected range
            try {
                if ($('#cashier_date').data('daterangepicker')) {
                    $('#cashier_date').data('daterangepicker').remove();
                }
            } catch(err){}

            // Parse dates for daterangepicker
            var startMoment = moment(startDate, 'DD-MM-YYYY');
            var endMoment = moment(endDate, 'DD-MM-YYYY');

            $('#cashier_date').daterangepicker({
                autoApply: true,
                startDate: startMoment,
                endDate: endMoment,
                locale: {format: 'DD-MM-YYYY'},
                showCustomRangeLabel: false,
                alwaysShowCalendars: true
            });

            // Function to fetch pending balances
            function fetchPendingBalances(start, end) {
                $.ajax({
                    url: '/get-pending-balances',
                    method: 'GET',
                    data: {
                        startdate: start,
                        enddate: end
                    },
                    success: function(res) {
                        // Format numbers with commas
                        function formatNumber(num) {
                            return Number(num || 0).toLocaleString();
                        }

                        // Display values
                        $("#pendingCash").text(formatNumber(res.cash));

                        // Dynamically populate banks
                        var banksContainer = $("#pendingBanksContainer");
                        var hiddenBanksContainer = $("#hiddenBankInputsContainer");
                        banksContainer.empty();
                        hiddenBanksContainer.empty();

                        if (res.banks && res.banks.length > 0) {
                            $.each(res.banks, function(index, bank) {
                                // Create display item for each bank
                                banksContainer.append(
                                    '<div class="pending-item">' +
                                        '<span class="label"><i class="fa-duotone fa-building-columns"></i> ' + bank.bank_name + ':</span>' +
                                        '<span class="value positive">' + formatNumber(bank.pending) + '</span>' +
                                    '</div>'
                                );

                                // Create hidden input for each bank
                                hiddenBanksContainer.append(
                                    '<input type="hidden" name="pending_bank_' + bank.bank_id + '" value="' + (bank.pending || 0) + '">' +
                                    '<input type="hidden" name="bank_name_' + bank.bank_id + '" value="' + bank.bank_name + '">'
                                );
                            });
                        }

                        $("#pendingExpenses").text(formatNumber(res.expenses));
                        $("#pendingReturnCredit").text(formatNumber(res.return_credit));
                        $("#pendingReturnBalance").text(formatNumber(res.return_balance));
                        $("#total_amounts").text(formatNumber(res.total_amounts));

                        // Hidden inputs update
                        $("#inputPendingCash").val(res.cash || 0);
                        $("#inputPendingExpenses").val(res.expenses || 0);
                        $("#inputPendingReturnCredit").val(res.return_credit || 0);
                        $("#inputPendingReturnBalance").val(res.return_balance || 0);
                    }
                });
            }

            $('#cashier_date').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('DD-MM-YYYY') + ' To ' + picker.endDate.format('DD-MM-YYYY'));
                // Update the date range variables when user changes the date
                startDate = picker.startDate.format('DD-MM-YYYY');
                endDate = picker.endDate.format('DD-MM-YYYY');

                // Reload pending balances with new date range
                fetchPendingBalances(startDate, endDate);
            });

            // Initial fetch of pending balances with selected date range
            fetchPendingBalances(startDate, endDate);
        });

        $("#sendto_cashier_btn").click(function(e) {
            e.preventDefault();
             
            $(this).prop('disabled', true).html('<i class="fa-duotone fa-spinner fa-spin"></i> Sending...');

            // Get Data From Modal Form On Click Save Button
            var formData = new FormData($('#sendToCashierForm')[0]);

            $.ajax({
                url: '<?php echo e(route("send_to_cashier")); ?>',
                method: 'post',
                data: formData,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(response) {
                    console.log(response);
                    if (response.status == 200) {
                        toastr.success('Payment Sent to Cashier Successfully!', 'Successful!');

                        $('#sendto_cashier_btn').html('<i class="fa-duotone fa-paper-plane"></i> Send to Cashier').prop('disabled', false);
                        $('#sendToCashierModal').modal('hide');
                        loadData();

                        // Re-check if salesman can send to cashier (will disable button after today's submission)
                        <?php if(Auth::user()->hasRole('Sales Man')): ?>
                        if (typeof checkCanSendToCashier === 'function') {
                            checkCanSendToCashier();
                        }
                        <?php endif; ?>
                    } else {
                        Swal.fire({
                            title: "Error!",
                            text: response.message || "Something went wrong!",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-success"
                            }
                        });
                        $('#sendto_cashier_btn').html('<i class="fa-duotone fa-paper-plane"></i> Send to Cashier').prop('disabled', false);
                    }
                },
                error: function(err) {
                    console.error(err);
                    var errorMessage = "An unexpected error occurred.";
                    if (err.responseJSON && err.responseJSON.message) {
                        errorMessage = err.responseJSON.message;
                    }
                    Swal.fire({
                        title: "Error!",
                        text: errorMessage,
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn fw-bold btn-success"
                        }
                    });
                    $('#sendto_cashier_btn').html('<i class="fa-duotone fa-paper-plane"></i> Send to Cashier').prop('disabled', false);
                }
            }); 
        });

        // banks 
        $('#banks').select2({
            width: '100%',
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#banks').parent()
        });
        $('#u_banks').select2({
            width: '100%',
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#u_banks').parent()
        });
        $('#uu_banks').select2({
            width: '100%',
            placeholder: 'Select Bank',
            allowClear: true,
            dropdownParent: $('#uu_banks').parent()
        });
        get_banks();
        
        function get_banks(){
            $.ajax({
            url:'/get_banks',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#banks option[value="' + data[i].id + '"]').length == 0){
                        $('#banks').append($('<option>',{
                        value:data[i].id,
                        text:data[i].bank_name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#u_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });

                    
                    $.each(data,function(i,item){
                    if($('#uu_banks option[value="' + data[i].id + '"]').length == 0){
                        $('#uu_banks').append($('<option>',{
                        value: data[i].id,
                        text: data[i].bank_name,
                        }));
                    }
                    });
                    
                }
            });
        };

        // customers 
        $('#cus_id').select2({
            width: '100%',
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#cus_id').parent()
        });
        $('#u_cus_id').select2({
            width: '100%',
            placeholder: 'Select Customer',
            allowClear: true,
            dropdownParent: $('#u_cus_id').parent()
        });
        get_customers();
        
        function get_customers(){
            $.ajax({
            url:'/get_customers',
            type:'GET',
            dataType:'json',
                success:function(data){
                console.log(data);
                    $.each(data,function(i,item){
                    if($('#cus_id option[value="' + data[i].id + '"]').length == 0){
                        $('#cus_id').append($('<option>',{
                        value:data[i].id,
                        text:data[i].shop_name ? data[i].shop_name : data[i].name,
                        }));
                    }
                    });

                    $.each(data,function(i,item){
                    if($('#u_cus_id option[value="' + data[i].id + '"]').length == 0){
                        $('#u_cus_id').append($('<option>',{
                        value: data[i].id,
                        text: data[i].shop_name ? data[i].shop_name : data[i].name,
                        }));
                    }
                    });

                }
            });
        };

        // Fetch customer balance when customer is selected
        $('#cus_id').on('change', function() {
            var customerId = $(this).val();

            if (customerId) {
                // Fetch and display customer balance
                fetchCustomerBalance(customerId);
            } else {
                // Hide balance sections if no customer selected
                $('#customer_balance_section').hide();
                $('#balance_calculation_display').hide();
                $('#customer_balance_value').val('0');
                $('#customer_old_balance').text('0');
                $('#calc_old_balance').text('0');
            }

            // Reset payment amount
            $('#payment_amount').val('');
        });

        // Calculate new balance when payment amount is entered
        $('#payment_amount').on('keyup change', function() {
            calculateNewBalance();
        });

        // Function to fetch customer balance
        function fetchCustomerBalance(customerId) {
            $.ajax({
                url: '/get_customer_balance/' + customerId,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status === 200) {
                        var balance = parseFloat(response.balance) || 0;

                        // Store balance in hidden field
                        $('#customer_balance_value').val(balance);

                        // Display balance with proper formatting
                        var formattedBalance = Number(balance).toLocaleString();
                        $('#customer_old_balance').text(formattedBalance);
                        $('#calc_old_balance').text(formattedBalance);

                        // Show customer balance section
                        $('#customer_balance_section').show();

                        // Calculate new balance if payment amount exists
                        calculateNewBalance();
                    } else {
                        toastr.error('Failed to fetch customer balance', 'Error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching balance:', error);
                    toastr.error('Error fetching customer balance', 'Error');
                }
            });
        }

        // Function to calculate and display new balance
        function calculateNewBalance() {
            var oldBalance = parseFloat($('#customer_balance_value').val()) || 0;
            var paymentAmount = parseFloat($('#payment_amount').val()) || 0;

            if (paymentAmount > 0) {
                // Calculate new balance = old balance - payment
                var newBalance = oldBalance - paymentAmount;

                // Update calculation display
                $('#calc_old_balance').text(Number(oldBalance).toLocaleString());
                $('#calc_payment_amount').text(Number(paymentAmount).toLocaleString());
                $('#calc_new_balance').text(Number(newBalance).toLocaleString());

                // Color code the new balance
                if (newBalance > 0) {
                    $('#calc_new_balance').css('color', '#dc3545'); // Red for outstanding balance
                } else if (newBalance < 0) {
                    $('#calc_new_balance').css('color', '#28a745'); // Green for overpayment
                } else {
                    $('#calc_new_balance').css('color', '#007bff'); // Blue for zero balance
                }

                // Show calculation display
                $('#balance_calculation_display').show();
            } else {
                // Hide calculation if no payment amount
                $('#balance_calculation_display').hide();
            }
        }

    });
    </script>


    <script>
    $(document).ready(function(){

        function getIdFromUrl() {
            var pathArray = window.location.pathname.split('/');
            return pathArray[pathArray.length - 1];
        }

        // Get the ID from the URL
        var saleman_id = getIdFromUrl();


        $('#transaction_date').daterangepicker({
            autoApply: true,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#transaction_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });

        $('#u_transaction_date').daterangepicker({
            autoUpdateInput: false,
            autoApply: true,
            singleDatePicker: true,
            locale: {
            format: 'DD-MM-YYYY'
            }
        });
        $('#u_transaction_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY'));
        });



        $("#add_modal_btn").click(function(e){
            e.preventDefault();

            $("#add_modal").modal('show');

            $('#cus_pay_id').val(saleman_id);

            // Set default payment type to "credit"
            $('#payment_type').val('credit').selectpicker('refresh');
            $('#bank_area').hide();

        });

   
        

        //=========== Insert Form Validation ===========//
        $("#add_form").validate({
                rules: {
                    cus_id: {
                        required: true,
                    },
                    amount: {
                        required: true,
                    },
                    transaction_type : {
                        required: true,
                    }
                    
                },
                messages: {
                    cus_id: {
                        required: "Please select Customer",
                    },
                    amount: {
                        required: "Please enter Amount",
                    },
                    transaction_type: {
                        required: "Please select Transaction Type",
                    },
                },

                highlight: function(element) {
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/delete.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                unhighlight: function(element) {
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/apply.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });

        //=========== Insert Data Ajax Request ===========//
        $("#add_btn").click(function(e) {
            e.preventDefault();

            if ($("#add_form").valid()) {
                $(this).prop('disabled', true).text('Saving..');

                // Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#add_form')[0]);

                // If payment type is 'credit' (cash), remove bank_id from formData
                if ($('#payment_type').val() === 'credit') {
                    formData.delete('bank_id');
                }

                // Log form data for debugging
                console.log('Submitting payment with data:');
                for (var pair of formData.entries()) {
                    console.log(pair[0] + ': ' + pair[1]);
                }

                $.ajax({
                    url: '<?php echo e(route("insert_salesman_payment")); ?>',
                    method: 'post',
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function(response) {
                        console.log('Success Response:', response);
                        if (response.status == 200) {
                            toastr.success('Payment Saved Successfully!', 'Successful!');

                            // Reset form
                            $('#add_modal').find('form')[0].reset();

                            // Reset all balance displays
                            $('#customer_balance_section').hide();
                            $('#balance_calculation_display').hide();
                            $('#customer_balance_value').val('0');
                            $('#customer_old_balance').text('0');
                            $('#calc_old_balance').text('0');
                            $('#calc_payment_amount').text('0');
                            $('#calc_new_balance').text('0');

                            // Reset select fields
                            $('#payment_type').val('credit').selectpicker('refresh');
                            $('#cus_id').val(null).trigger('change');
                            $('#banks').val(null).trigger('change');

                            // Reset button state
                            $('#add_btn').text('Save Payment').prop('disabled', false);

                            // Close modal
                            $('#add_modal').modal('hide');

                            // Reload data
                            loadData();
                        } else {
                            Swal.fire({
                                title: "Error!",
                                text: "Something went wrong!",
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn fw-bold btn-success"
                                }
                            });
                            $('#add_btn').text('Save Payment').prop('disabled', false);
                        }
                    },
                    error: function(err) {
                        console.error('Full Error:', err);

                        var errorMessage = "An unexpected error occurred.";

                        if (err.status === 419) {
                            errorMessage = "Your session has expired. Please refresh the page and try again.";
                        } else if (err.status === 422) {
                            // Validation error
                            var errors = err.responseJSON?.errors || err.responseJSON?.message;
                            if (typeof errors === 'object') {
                                errorMessage = Object.values(errors).flat().join('\n');
                            } else if (typeof errors === 'string') {
                                errorMessage = errors;
                            }
                        } else if (err.status === 500) {
                            errorMessage = "Server error. Please check the logs or contact administrator.";
                            if (err.responseJSON?.message) {
                                errorMessage += "\n\nDetails: " + err.responseJSON.message;
                            }
                        } else if (err.responseJSON?.message) {
                            errorMessage = err.responseJSON.message;
                        }

                        Swal.fire({
                            title: "Error!",
                            text: errorMessage,
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-success"
                            }
                        });
                        $('#add_btn').text('Save Payment').prop('disabled', false);
                    }
                });
            }
        });

        //=========== Lounch Update Modal On Click Edit Btn ===========//
        $(document).on("click", '#edit_btn', function(event){
            event.preventDefault();
            $("#update_modal").modal('show');

            var id = $(this).data("eid");
            $.ajax({
                url: '/edit_salesman_payment/'+id,
                method: 'GET',
                contentType : false,
                processData : false,
                dataType: "json",
                success: function(response)
                {
                    console.log(response);
                    $('#u_pay_id').val(response.data.id);
                    $('#u_transaction_date').val(response.data.transaction_date);
                  
                    $('#u_amount').val(response.data.saleman_cash);
                    $('#uu_status').val(response.data.status).trigger('change');
                    $('#uu_transaction_type').val(response.data.transaction_type).trigger('change');
                    $('#uu_banks').val(response.data.bank_id).trigger('change');
                    $('#u_transaction_details').val(response.data.detail);
                    
                    if (response.data.status === 'approved') {
                        $('#update_btn').hide();
                    } else {
                        $('#update_btn').show();
                    }

                }
            });
        });

        //=========== Update Form Validation ===========//
        $("#update_form").validate({
            rules: {
                    sup_name: {
                        required: true,
                    },
                    phone_no: {
                        required: true,
                    },
                    
                },
                messages: {
                    sup_name: {
                        required: "Please enter Supplier Name",
                    },
                    phone_no: {
                        required: "Please enter Supplier Name",
                    },
                },

                highlight: function(element) {
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/delete.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                },

                unhighlight: function(element) {
                    $(element).css('background-image', 'url(<?php echo e(asset("backend/my_plugins/validate/apply.png")); ?>)');
                    $(element).css('background-repeat', 'no-repeat');
                    $(element).css('background-position', '97%');
                }

        });

        //=========== Update Data Ajax Request ===========//
        $("#update_btn").click(function(e){
            e.preventDefault();
            if($("#update_form").valid()){
                $(this).prop('disabled', false);
                $(this).text('Updating..');
                //Get Data From Modal Form On Click Save Button
                var formData = new FormData($('#update_form')[0]);

                $.ajax({
                    url: '<?php echo e(route("update_salesman_payment")); ?>',
                    method: 'post',
                    data : formData,
                    contentType : false,
                    processData : false,
                    dataType: "json",
                    success:function(response){
                        console.log(response);
                        if (response.status == 200) {
                            toastr.success(' Payment Updated Successfully!', 'Successfull!');
                            $('#update_modal').find('input').val('');
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                            $('#update_modal').modal('hide');
                            loadData();
                            
                        }else {
                            
                            Swal.fire({ 
                                    title: "Error!",
                                    text: "Something went wrong Try Again!",
                                    icon: "error", 
                                    buttonsStyling: !1,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: { 
                                        confirmButton: "btn fw-bold btn-success"
                                        } 
                                    });
                            $('#update_btn').prop('disabled', false);
                            $('#update_btn').text('Update Payment');
                        }
                    }

                });
            }
        });

        //=========== Delete Data Ajax Request ===========//
        $(document).on("click", '#delete_btn', function(event){
            event.preventDefault();

            Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Delete',
                    customClass: "sweet-alert"
                }).then((result) => {
                    if (result.value) {
                        var id = $(this).data("did");
                        var element = this;
                        $.ajax({
                            url: '/delete_salesman_payment/'+id,
                            type : "GET",
                        success : function(response){
                            if (response.status == 200)
                            {
                                toastr.success('Customer Payment Has Been Deleted Seccussfully!', 'Successfull!');
                                loadData();
                            }else {
                                Swal.fire({
                                    title: "Somthing Wrong!",
                                    text: "Sonthing Went Wrong Please Try Again!",
                                    type: "error",
                                    customClass: "sweet-alert",
                                });
                            }
                        }
                        });
                    }

                })


        });

        // Define the default options
        var defaultOptions = {
            ajax: {
                url: '<?php echo e(route("load_salesman_ledger")); ?>',
                type: 'post',
                data: { search: "", startdate: "", enddate: "",  type: "", saleman_id: saleman_id, _token: '<?php echo e(csrf_token()); ?>' }
            },
            columns: [
                { data: "id" },
                { data: "invoice_date" },
                { data: "shop_name" },
                { data: "sale_id" },
                { data: "total" }, 
                { data: "transaction_type" },
                { data: "credit" },
                { data: "bank" },
                { data: "return_paid" },
                { data: "status" },
                { data: "balance" },
                { data: "btn" },
            ],
            columnDefs: [
                { className: 'text-center td-30', targets: [1, 3, 4, 5, 6, 7, 8, 9, 10] },
            ],
            centeredColumnsOnPrintPdf: [1, 3, 4, 5, 6, 7, 8, 9, 10],
            order: [1, 'ASC'],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();

                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };

                var subtotal = api
                    .column(0)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var totals = api.ajax.json().totals;

                $('#total_amount').text(totals.total_amount);
                $('#total_debit').text(totals.total_debit);
                $('#total_credit').text(totals.total_credit);
                $('#total_expense').text(Number(totals.total_expense).toLocaleString());
                $('#cash').text(Number(totals.cash).toLocaleString());

                $('#easypaisa').text(Number(totals.easypaisa).toLocaleString());
                $('#jazzcash').text(Number(totals.jazzcash).toLocaleString());
                $('#meezan').text(Number(totals.meezan).toLocaleString());
                $('#u_paisa').text(Number(totals.u_paisa).toLocaleString());

                $('#return_paid').text(totals.return_paid);

                $('#total_balance').text(totals.total_balance);
                $('#saleman_name').text(totals.saleman_name);

            }
        };

        // Function to load data with updated dates
        function loadData(search = "", startDate= "", endDate= "", type = "") {
            // Merge the default options with the updated dates
            var options = $.extend(true, {}, defaultOptions, {
                ajax: {
                    data: { search: search, startdate: startDate, enddate: endDate, type: type, saleman_id: saleman_id, _token: '<?php echo e(csrf_token()); ?>' }
                }
            });

            // Call the load_data function with the updated options
            load_data(options);
        }

        // Load today's data by default
        var today = moment().format('DD-MM-YYYY');
        loadData("", today, today);

        //=========== Start Custom Search Box ===========//
        $('#search').keyup(function(){
            // Get current date values from the date picker
            var currentDateRange = $('#search_by_date').val();
            var dates = currentDateRange.split(' To ');
            var startDate = dates[0] || '';
            var endDate = dates[1] || '';
            loadData($(this).val(), startDate, endDate, $('#status').val());
        });

        $("#payment_type_filter").select2({
            placeholder: "Search By Type",
            allowClear: true,
            minimumResultsForSearch: Infinity
        });

        //=========== Start Custom Status Dropdown ===========//
        $('#payment_type_filter').on('change', function(){

            var type = $(this).val();

            if(type == "all"){

                loadData($('#search').val());
            }else{

                loadData($('#search').val(), "", "", type);
            }

        });

        search_by_date("#search_by_date");
        //=========== Start Search By Date ===========//
        function search_by_date(datepickerid){
            var start = moment();
            var end = moment();

            function cb(start, end) {
                // Set the input field value with the selected date range
                $(datepickerid).val(start.format('DD-MM-YYYY') + ' To ' + end.format('DD-MM-YYYY'));
            }

            $(datepickerid).daterangepicker({
                autoUpdateInput: true,
                format: 'DD-MM-YYYY',
                startDate: start,
                endDate: end,
                showCustomRangeLabel: false,
                alwaysShowCalendars: true,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            $(datepickerid).on('apply.daterangepicker', function(ev, picker)
            {
                startdate=picker.startDate.format('DD-MM-YYYY');
                enddate=picker.endDate.format('DD-MM-YYYY');
                $(datepickerid).val(startdate + ' To ' + enddate);

                loadData($('#search').val(), startdate, enddate);

            
            });

            $(datepickerid).on('cancel.daterangepicker', function(ev, picker) {
            $(datepickerid).val('');
            });

            $('#refresh_data').on('click', function() {
                $(datepickerid).val('');
                loadData();
            });
        }

        //=========== View Received Payments Button ===========//
        var receivedPaymentsTable;
        $("#view_received_btn").click(function(e) {
            e.preventDefault();
            $("#viewReceivedModal").modal('show');

            // Initialize or reload DataTable
            if ($.fn.DataTable.isDataTable('#received_payments_table')) {
                receivedPaymentsTable.ajax.reload();
            } else {
                receivedPaymentsTable = $('#received_payments_table').DataTable({
                    processing: true,
                    serverSide: false,
                    ajax: {
                        url: '/get-received-payments',
                        type: 'GET',
                        dataSrc: 'data'
                    },
                    columns: [
                        { data: 'batch_id' },
                        { data: 'source_type' },
                        { data: 'source_name' },
                        { data: 'date' },
                        { data: 'cash', className: 'text-right' },
                        { data: 'easypaisa', className: 'text-right' },
                        { data: 'jazzcash', className: 'text-right' },
                        { data: 'meezan', className: 'text-right' },
                        { data: 'upaisa', className: 'text-right' },
                        { data: 'expenses', className: 'text-right' },
                        { data: 'return_credit', className: 'text-right' },
                        { data: 'return_balance', className: 'text-right' },
                        { data: 'total', className: 'text-right' },
                        { data: 'status' },
                        { data: 'btn', orderable: false, searchable: false }
                    ],
                    order: [[3, 'desc']],
                    pageLength: 10
                });
            }
        });

        //=========== View Details Button ===========//
        var currentSourceType, currentSourceId, currentSubmissionDate;
        $(document).on('click', '.view_details_btn', function() {
            currentSourceType = $(this).data('source-type') || 'salesman';
            currentSourceId = $(this).data('source-id') || $(this).data('salesman');
            currentSubmissionDate = $(this).data('date');

            $.ajax({
                url: '/get-submission-details/' + currentSourceType + '/' + currentSourceId + '/' + currentSubmissionDate,
                method: 'GET',
                success: function(response) {
                    if (response.status === 200) {
                        var details = response.details;

                        // Format numbers with commas
                        function formatNumber(num) {
                            return Number(num || 0).toLocaleString();
                        }

                        // Populate details modal
                        $('#detail_salesman_name').text(details.source_name + ' (' + details.source_type + ')');
                        $('#detail_date').text(details.date);
                        $('#detail_cash').text(formatNumber(details.cash));
                        $('#detail_easypaisa').text(formatNumber(details.easypaisa));
                        $('#detail_jazzcash').text(formatNumber(details.jazzcash));
                        $('#detail_meezan').text(formatNumber(details.meezan));
                        $('#detail_upaisa').text(formatNumber(details.upaisa));
                        $('#detail_expenses').text(formatNumber(details.expenses));
                        $('#detail_return_credit').text(formatNumber(details.return_credit));
                        $('#detail_return_balance').text(formatNumber(details.return_balance));
                        $('#detail_total').text(formatNumber(details.total));

                        // Hide rows with zero values
                        details.cash == 0 ? $('#row_cash').hide() : $('#row_cash').show();
                        details.easypaisa == 0 ? $('#row_easypaisa').hide() : $('#row_easypaisa').show();
                        details.jazzcash == 0 ? $('#row_jazzcash').hide() : $('#row_jazzcash').show();
                        details.meezan == 0 ? $('#row_meezan').hide() : $('#row_meezan').show();
                        details.upaisa == 0 ? $('#row_upaisa').hide() : $('#row_upaisa').show();
                        details.expenses == 0 ? $('#row_expenses').hide() : $('#row_expenses').show();
                        details.return_credit == 0 ? $('#row_return_credit').hide() : $('#row_return_credit').show();
                        details.return_balance == 0 ? $('#row_return_balance').hide() : $('#row_return_balance').show();

                        // Update status badge and show/hide action buttons
                        if (details.status === 'pending') {
                            $('#detail_status').removeClass().addClass('label label-warning').text('Pending (Salesman)');
                            $('#receive_payment_btn').show(); // Cashier can receive
                            $('#approve_payment_btn').hide();
                        } else if (details.status === 'received') {
                            $('#detail_status').removeClass().addClass('label label-info').text('Received (Cashier)');
                            $('#receive_payment_btn').hide();
                            $('#approve_payment_btn').show(); // Admin can approve
                        } else {
                            $('#detail_status').removeClass().addClass('label label-success').text('Approved (Admin)');
                            $('#receive_payment_btn').hide();
                            $('#approve_payment_btn').hide(); // Already approved
                        }

                        // Show details modal
                        $('#viewDetailsModal').modal('show');
                    }
                },
                error: function(err) {
                    console.error(err);
                    toastr.error('Error fetching submission details');
                }
            });
        });

        //=========== Print Button ===========//
        $("#print_details_btn").click(function() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
            location.reload();
        });

        //=========== Receive Button (Cashier) ===========//
        $("#receive_payment_btn").click(function(e) {
            e.preventDefault();

            Swal.fire({
                title: 'Receive Payment?',
                text: "This will send the payment to Admin for approval. Continue?",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, receive it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '/receive-submission',
                        method: 'POST',
                        data: {
                            source_type: currentSourceType,
                            source_id: currentSourceId,
                            salesman_id: currentSourceId,
                            date: currentSubmissionDate,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.status === 200) {
                                toastr.success(response.message);
                                $('#viewDetailsModal').modal('hide');
                                if (receivedPaymentsTable) {
                                    receivedPaymentsTable.ajax.reload();
                                }
                            }
                        },
                        error: function(err) {
                            console.error(err);
                            toastr.error('Error receiving payment');
                        }
                    });
                }
            });
        });

        //=========== Approve Button (Admin) ===========//
        $("#approve_payment_btn").click(function(e) {
            e.preventDefault();

            Swal.fire({
                title: 'Approve Payment?',
                text: "Are you sure you want to approve this payment submission?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, approve it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '/approve-submission',
                        method: 'POST',
                        data: {
                            source_type: currentSourceType,
                            source_id: currentSourceId,
                            salesman_id: currentSourceId,
                            date: currentSubmissionDate,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.status === 200) {
                                toastr.success(response.message);
                                $('#viewDetailsModal').modal('hide');
                                if (receivedPaymentsTable) {
                                    receivedPaymentsTable.ajax.reload();
                                }
                            }
                        },
                        error: function(err) {
                            console.error(err);
                            toastr.error('Error approving payment');
                        }
                    });
                }
            });
        });

    });
    </script>



    <script>
        $(document).ready(function(){

            $('[data-toggle="tooltip"]').tooltip();
            
            $('.textboxlabel').click(function() {
                $(this).prev('.textbox').focus();
            });

            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            };


            // Start Colvis Show Active on Click ===========//
            $(".toggle-vis").click(function(){
            $(this).toggleClass("colvischecked");
            });

            $('a.toggle-vis').on('click', function (e) {
                e.preventDefault();

                var column = $('#main_table').DataTable().column($(this).attr('data-column'));
        
                // Toggle the visibility
                column.visible(!column.visible());
            });

            //=========== Start Custom PDF Export Btn ===========//
            $("#pdf").on("click", function() {
            $(".buttons-pdf").trigger("click");
            });

            //=========== Start Custom Excel Export Btn ===========//
            $("#excel").on("click", function() {
            $(".buttons-excel").trigger("click");
            });

            //=========== Start Custom CSV Export Btn ===========//
            $("#csv").on("click", function() {
            $(".buttons-csv").trigger("click");
            });

            //=========== Start Custom Print Export Btn ===========//
            $("#print").on("click", function() {
            $(".buttons-print").trigger("click");
            });


        });
    </script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/admin/salesman_ledger.blade.php ENDPATH**/ ?>